/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.compat.StringPropertiesEditor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class LanguageUtilities {
    public static String OPENOPTIONSYNTAX = "(";
    public static String CLOSEOPTIONSYNTAX = ")";
    protected static StringBuffer debugbuf = null;
    protected static String staticText = null;
    private static TraceComponent tc = Tr.register(LanguageUtilities.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private ResourceBundle bundle = null;
    protected String nl = System.getProperty("line.separator");

    public LanguageUtilities(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    protected Properties stringToProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToProperties");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
            return new Properties();
        }
        StringPropertiesEditor stringPropertiesEditor = new StringPropertiesEditor();
        try {
            stringPropertiesEditor.setAsText(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stringToProperties");
            }
        }
        return (Properties)stringPropertiesEditor.getValue();
    }

    public String propertiesToString(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (properties == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringPropertiesEditor stringPropertiesEditor = new StringPropertiesEditor();
        stringPropertiesEditor.setValue(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return stringPropertiesEditor.getAsText();
    }

    public String attributeListToString(AttributeList attributeList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size of list is " + attributeList.size());
        }
        for (int i = 0; i < attributeList.size(); ++i) {
            stringBuffer.append("\"");
            stringBuffer.append(((Attribute)attributeList.get(i)).getName());
            stringBuffer.append("=");
            stringBuffer.append(((Attribute)attributeList.get(i)).getValue());
            stringBuffer.append("\"");
            if (i >= attributeList.size() - 1) continue;
            stringBuffer.append(", ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString -- returning " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String setToString(Collection collection) {
        return this.setToString(collection, true);
    }

    public String setToString(Collection collection, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setToString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (collection == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setToString");
            }
            return new String();
        }
        Object[] objectArray = collection.toArray();
        if (bl) {
            this.sortArray(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            stringBuffer.append("\"" + string + "\"");
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setToString");
        }
        return stringBuffer.toString();
    }

    public String[] stringToStringArray(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToStringArray - input " + string);
        }
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken().trim();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "found token: \"" + stringArray[i] + "\"");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToStringArray");
        }
        return stringArray;
    }

    public Hashtable optionsToHashtable(String string) {
        String string2;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            if (string.toLowerCase().indexOf("password") == -1 && string.toLowerCase().indexOf("pwd") == -1) {
                Tr.entry(tc, "optionsToHashtable -- " + string);
            } else {
                object2 = string.split(" ");
                object = new StringBuffer();
                boolean bl = false;
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    string2 = object2[i];
                    if (!(string2.toLowerCase().indexOf("password") == -1 && string2.toLowerCase().indexOf("pwd") == -1 || bl)) {
                        bl = true;
                        ((StringBuffer)object).append(string2);
                    } else if (bl) {
                        ((StringBuffer)object).append("*****");
                        bl = false;
                    } else {
                        ((StringBuffer)object).append(string2);
                    }
                    ((StringBuffer)object).append(" ");
                }
                Tr.entry(tc, "optionsToHashtable -- " + ((StringBuffer)object).toString());
            }
        }
        debugbuf = new StringBuffer();
        staticText = string;
        object2 = new Hashtable();
        string = this.cleanAttributeString(string);
        object = new StringTokenizer(string, this.getTokenizerString(), true);
        String string3 = "";
        String string4 = null;
        string2 = null;
        try {
            if (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken();
                debugbuf.append(string3);
            }
            do {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Top: next: \"" + string3 + "\"");
                }
                if (string3.trim().equals("")) {
                    try {
                        string3 = this.skipSpaces((StringTokenizer)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break;
                    }
                }
                if (!string3.startsWith("-")) {
                    this.throwIllegalArgException("WASX7122E", "-", string4, string2, string);
                }
                while (string3.startsWith("-")) {
                    string4 = string3.substring(1);
                    string3 = this.addOptionValue((StringTokenizer)object, string4, (Hashtable)object2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "added option value...");
                }
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string3 = ((StringTokenizer)object).nextToken(this.getTokenizerString());
                debugbuf.append(string3);
                if (!string3.equals(" ")) continue;
                try {
                    string3 = this.skipSpaces((StringTokenizer)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break;
                }
                debugbuf.append(string3);
            } while (((StringTokenizer)object).hasMoreTokens());
            if (string3.startsWith("-")) {
                string4 = string3.substring(1);
                ((Hashtable)object2).put(string4, new String());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        finally {
            debugbuf = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "optionsToHashtable");
        }
        return object2;
    }

    protected String addOptionValue(StringTokenizer stringTokenizer, String string, Hashtable hashtable) {
        Vector<String> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOptionValue: " + string);
        }
        Object object = new String();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = new String();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                debugbuf.append(string2);
                if (string2.equals(" ")) {
                    try {
                        string2 = this.skipSpaces(stringTokenizer);
                        debugbuf.append(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break;
                    }
                }
                if (!string2.startsWith("-") || string.equals("target")) {
                    if (string.equals("target") && string2.startsWith("-")) {
                        if (string2.toLowerCase().startsWith("-websphere")) {
                            object = vector = this.getString(stringTokenizer, string2);
                            string2 = ((String)((Object)vector)).substring(1);
                            continue;
                        }
                    } else if (!string2.equals("{")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "value not a list");
                        }
                        object = vector = this.getString(stringTokenizer, string2);
                    } else {
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                        }
                        debugbuf.append(string2);
                        if (string2.equals(" ")) {
                            string2 = this.skipSpaces(stringTokenizer);
                            debugbuf.append(string2);
                        }
                        if (!string2.equals("{")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is not a list but starts with a {");
                            }
                            vector = this.getString(stringTokenizer, "{", false);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is " + (String)((Object)vector));
                            }
                            object = string2 + (String)((Object)vector);
                            if (string.equals("delete") && tc.isDebugEnabled()) {
                                Tr.debug(tc, "delete option is provided");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "result is " + object);
                            }
                            string2 = "}";
                        } else {
                            while (string2.equals("{")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "value a list");
                                }
                                vector = this.getList(stringTokenizer);
                                arrayList.add(vector);
                                if (!stringTokenizer.hasMoreTokens()) break;
                                string2 = stringTokenizer.nextToken(this.getTokenizerString());
                                debugbuf.append(string2);
                                if (string2.equals(" ")) {
                                    string2 = this.skipSpaces(stringTokenizer);
                                    debugbuf.append(string2);
                                }
                                if (!string2.equals("}")) continue;
                                break;
                            }
                            object = arrayList;
                        }
                    }
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        if (string.equals("custom")) {
            Object v = hashtable.get(string);
            vector = v == null ? new Vector<String>() : (Vector<String>)v;
            vector.addElement((String)object);
            hashtable.put(string, vector);
        } else {
            hashtable.put(string, object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "next: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOptionValue: " + object);
        }
        return string2;
    }

    public List getList(StringTokenizer stringTokenizer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getList");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                string = stringTokenizer.nextToken(this.getTokenizerString());
                debugbuf.append(string);
                if (string.equals(" ")) {
                    string = this.skipSpaces(stringTokenizer);
                    debugbuf.append(string);
                }
                if (string.equals(this.getOpenNestedAttribute())) {
                    string2 = this.getString(stringTokenizer, string);
                    arrayList.add(string2);
                    continue;
                }
                if (!string.equals(this.getCloseNestedAttribute())) {
                    string2 = this.getString(stringTokenizer, string);
                    arrayList.add(string2);
                    continue;
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getList - next is " + string);
        }
        return arrayList;
    }

    public Hashtable stringToHashtable(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToHashtable string: " + string);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        boolean bl = false;
        if (debugbuf == null) {
            bl = true;
            debugbuf = new StringBuffer();
            staticText = string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{} ", true);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken(this.getTokenizerString());
                debugbuf.append(string2);
                if (string2.equals("{")) {
                    String string3 = this.getString(stringTokenizer, " ");
                    String string4 = this.getString(stringTokenizer, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        debugbuf.append(string2);
                        if (string2.equals(" ")) continue;
                    }
                    if (!string2.equals("}")) {
                        Tr.event(tc, "Expected '}' not found");
                        this.throwIllegalArgException("WASX7122E", string2, string3, string4, string);
                    }
                    if (string4.startsWith("{")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New key: " + string3 + " (table)");
                        }
                        Hashtable hashtable2 = this.stringToHashtable(string4);
                        hashtable.put(string3, hashtable2);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of table is now " + hashtable.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New key: " + string3 + " = " + string4);
                    }
                    hashtable.put(string3, string4);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of table is now " + hashtable.size());
                    continue;
                }
                if (string2.equals(" ")) continue;
                this.throwIllegalArgException("WASX7121E", string2, "", "", string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        finally {
            if (bl) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToHashtable");
        }
        return hashtable;
    }

    public AttributeList stringToAttributeList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttributeList string: " + string);
        }
        boolean bl = false;
        if (debugbuf == null) {
            bl = true;
            debugbuf = new StringBuffer();
            staticText = string;
        }
        AttributeList attributeList = new AttributeList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{} ", true);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken(this.getTokenizerString());
                debugbuf.append(string2);
                if (string2.equals("{")) {
                    ArrayList arrayList;
                    String string3 = this.getString(stringTokenizer, " ");
                    String string4 = this.getString(stringTokenizer, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        debugbuf.append(string2);
                        if (string2.equals(" ")) continue;
                    }
                    if (!string2.equals("}")) {
                        Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                        this.throwIllegalArgException("WASX7122E", "}", string3, string4, string);
                    }
                    if (string4.startsWith("{{") && string4.endsWith("}}")) {
                        arrayList = this.createArrayList(string4);
                        attributeList.add(new Attribute(string3, arrayList));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + attributeList.size());
                        continue;
                    }
                    if (string4.startsWith("{") && string4.endsWith("}")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New attribute: " + string3 + " (list)");
                        }
                        arrayList = this.stringToAttributeList(string4);
                        attributeList.add(new Attribute(string3, arrayList));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + attributeList.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New attribute: " + string3 + " = " + string4);
                    }
                    attributeList.add(new Attribute(string3, string4));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of list is now " + attributeList.size());
                    continue;
                }
                if (string2.equals(" ")) continue;
                Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                this.throwIllegalArgException("WASX7121E", string2, "", "", string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (bl) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttributeList");
        }
        return attributeList;
    }

    public String[] createArgSettingCommands(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArgSettingCommands");
        }
        String string = this.setToString(collection, false);
        String[] stringArray = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("argv = '");
        stringBuffer.append(string);
        stringBuffer.append("';");
        stringArray[0] = stringBuffer.toString();
        stringArray[1] = new String("argc = " + collection.size() + ";");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArgSettingCommands");
        }
        return stringArray;
    }

    public String getOpenNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpenNestedAttribute");
        }
        return "\"";
    }

    public String getCloseNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloseNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloseNestedAttribute");
        }
        return "\"";
    }

    public String getTokenizerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenizerString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenizerString");
        }
        return "{}\" ";
    }

    public String addQuotes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQuotes");
        }
        return "\"";
    }

    public String removeQuotes(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQuotes");
        }
        if ((string2 = new String(string)).startsWith("\"") && string2.endsWith("\"")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing quotes from \"" + string2 + "\"");
            }
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeQuotes");
        }
        return string2;
    }

    public boolean isStringWithQuotes(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStringWithQuote");
        }
        boolean bl2 = bl = string.startsWith("\"") && string.endsWith("\"");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStringWithQuote - " + bl);
        }
        return bl;
    }

    public String attributeToString(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{string, string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        stringBuffer.append("\"");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String arrayListToString(ArrayList arrayList, ConfigHelper configHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToString ");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + e.getClass().getName());
                }
                if (e instanceof ObjectName) {
                    stringBuffer.append(configHelper.getListingName((ObjectName)e));
                } else {
                    stringBuffer.append(e.toString());
                }
            } else {
                stringBuffer.append("\"\"");
            }
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append("\"");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToString " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String stringArrayToString(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringArrayToString");
        }
        String string = null;
        if (object == null) {
            string = "\"\"";
        } else if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i).toString());
                if (i >= list.size() - 1) continue;
                stringBuffer.append(";");
            }
            stringBuffer.append("\"");
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + string);
        }
        return string;
    }

    public String integerArrayToString(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integerArrayToString");
        }
        String string = null;
        if (object == null) {
            string = "\"\"";
        } else if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i).toString());
                if (i >= list.size() - 1) continue;
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + string);
        }
        return string;
    }

    public String cleanAttributeString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanAttributeString");
        }
        if (tc.isEntryEnabled()) {
            if (string.toLowerCase().indexOf("password") == -1 && string.toLowerCase().indexOf("pwd") == -1) {
                Tr.exit(tc, "cleanAttributeString -- " + string);
            } else {
                String[] stringArray = string.split(" ");
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!(string2.toLowerCase().indexOf("password") == -1 && string2.toLowerCase().indexOf("pwd") == -1 || bl)) {
                        bl = true;
                        stringBuffer.append(string2);
                    } else if (bl) {
                        stringBuffer.append("*****");
                        bl = false;
                    } else {
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(" ");
                }
                Tr.exit(tc, "cleanAttributeString -- " + stringBuffer.toString());
            }
        }
        return string;
    }

    protected ArrayList createArrayList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArrayList string: " + string);
        }
        ArrayList<AttributeList> arrayList = new ArrayList<AttributeList>();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.getOpenNestedAttribute() + this.getCloseNestedAttribute() + " ", true);
        while (true) {
            int n = 0;
            if (!stringTokenizer.hasMoreTokens()) break;
            String string2 = stringTokenizer.nextToken();
            debugbuf.append(string2);
            if (string2.equals(" ")) {
                string2 = this.skipSpaces(stringTokenizer);
                debugbuf.append(string2);
            }
            if (string2.equals(this.getOpenNestedAttribute())) {
                ++n;
            } else {
                Tr.warning(tc, "TBD - do something here!");
            }
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                debugbuf.append(string2);
                stringBuffer.append(string2);
                if (string2.equals(this.getOpenNestedAttribute())) {
                    ++n;
                    continue;
                }
                if (!string2.equals(this.getCloseNestedAttribute()) || --n != 0) continue;
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                bl = true;
                break;
            }
            if (!bl) break;
            AttributeList attributeList = this.stringToAttributeList(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            arrayList.add(attributeList);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "size of ArrayList is now " + arrayList.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArrayList");
        }
        return arrayList;
    }

    protected String getString(StringTokenizer stringTokenizer, String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString next: \"" + string + "\"");
        }
        String string2 = this.getString(stringTokenizer, string, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString -> " + string2);
        }
        return string2;
    }

    protected String getString(StringTokenizer stringTokenizer, String string, boolean bl) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString next: \"" + string + "\"");
        }
        String string2 = null;
        try {
            if (string.equals(" ")) {
                string = this.skipSpaces(stringTokenizer);
                debugbuf.append(string);
            }
            if (string.equals("{")) {
                string2 = "";
                int n = 1;
                while (n > 0) {
                    string = stringTokenizer.nextToken("{}");
                    debugbuf.append(string);
                    if (string.equals("{")) {
                        ++n;
                    } else if (string.equals("}")) {
                        --n;
                    }
                    if (n <= 0) continue;
                    string2 = string2 + string;
                }
            } else if (string.equals("}")) {
                Tr.event(tc, "Unexpected '}' found");
                this.throwIllegalArgException("WASX7123E", "}", "", "", string);
            } else if (string.equals("\"")) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl2 = false;
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    debugbuf.append(string);
                    if (string.equals("\"")) {
                        bl2 = true;
                        break;
                    }
                    stringBuffer.append(string);
                }
                if (!bl2) {
                    this.throwIllegalArgException("WASX7122E", "\"", "", "", string);
                }
                string2 = stringBuffer.toString();
            } else {
                string2 = string;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        if (bl) {
            string2 = string2.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString -> " + string2);
        }
        return string2;
    }

    protected String skipSpaces(StringTokenizer stringTokenizer) throws IllegalArgumentException {
        String string;
        try {
            while ((string = stringTokenizer.nextToken()) != null && string.equals(" ")) {
                debugbuf.append(string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        return string;
    }

    protected void throwIllegalArgException(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        String string7 = this.bundle.getString(string);
        Object[] objectArray = null;
        if (debugbuf != null) {
            int n = debugbuf.length();
            StringBuffer stringBuffer = new StringBuffer();
            if (staticText != null) {
                for (int i = 0; i < n - 1; ++i) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append("^");
            } else {
                staticText = "Attribute=" + string3 + " had invalid value=" + string4 + " for input parameter=" + string5;
            }
            objectArray = new Object[]{string2, this.nl + staticText + this.nl + stringBuffer.toString()};
        }
        string6 = MessageFormat.format(string7, objectArray);
        debugbuf = null;
        throw new IllegalArgumentException(string6);
    }

    protected void sortArray(Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sortArray");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                if (objectArray[j].toString().compareTo(objectArray[i].toString()) >= 0) continue;
                Object object = objectArray[j];
                objectArray[j] = objectArray[i];
                objectArray[i] = object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sortArray");
        }
    }

    public String objectArrayToString(Object[] objectArray) {
        return objectArray.toString();
    }

    public String buildAdminCmdString(String string, String string2, String string3, String string4, String string5) {
        return string + " " + string3 + " " + OPENOPTIONSYNTAX + string4 + " " + string5 + CLOSEOPTIONSYNTAX;
    }

    public Object stringToObjectArray(String string, Class clazz) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectArray");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectArray");
        }
        return new Object();
    }

    public String hashtableToString(Hashtable hashtable, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hashtableToString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                stringBuffer.append(string);
                stringBuffer.append(this.nl);
                if (!bl) continue;
                stringBuffer.append(string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hashtableToString");
        }
        return stringBuffer.toString();
    }
}

