/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.ConfigHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ScriptingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class JythonUtilities
extends LanguageUtilities {
    public static String OPENOPTIONSYNTAX = "[";
    public static String CLOSEOPTIONSYNTAX = "]";
    private static TraceComponent tc = Tr.register(JythonUtilities.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String IS_A_NULL = "$$WebSphere_Null_Value$$";
    private static final String openAttributeListSyntax = "[";
    private static final String closeAttributeListSyntax = "]";
    private static final String emptyAttributeListSyntax = "[]";
    private static final String tokenizerString = "[]\"' ";

    public JythonUtilities(ResourceBundle resourceBundle) {
        super(resourceBundle);
    }

    public String setToString(Collection collection) {
        return this.setToString(collection, true);
    }

    public String setToString(Collection collection, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setToString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (collection == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setToString");
            }
            return new String();
        }
        Object[] objectArray = collection.toArray();
        if (bl) {
            this.sortArray(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            stringBuffer.append(string);
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setToString");
        }
        return stringBuffer.toString();
    }

    public String getOpenNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOpenNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOpenNestedAttribute");
        }
        return openAttributeListSyntax;
    }

    public String getCloseNestedAttribute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCloseNestedAttribute");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCloseNestedAttribute");
        }
        return closeAttributeListSyntax;
    }

    public String getTokenizerString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenizerString");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenizerString");
        }
        return tokenizerString;
    }

    public String addQuotes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getQuotes");
        }
        return "'";
    }

    public String removeQuotes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQuotes");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeQuotes");
        }
        return string;
    }

    public boolean isStringWithQuotes(String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStringWithQuote");
        }
        boolean bl2 = bl = string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStringWithQuote - " + bl);
        }
        return bl;
    }

    public String attributeToString(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeToString", new Object[]{string, string2});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(openAttributeListSyntax);
        stringBuffer.append(string);
        stringBuffer.append(" ");
        if (string2 == null || string2.equals("")) {
            stringBuffer.append(emptyAttributeListSyntax);
        } else {
            if (string2.indexOf(" ") > 0 && !string2.startsWith("\"") && !string2.endsWith("\"")) {
                string2 = "\"" + string2 + "\"";
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeToString " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String arrayListToString(ArrayList arrayList, ConfigHelper configHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayListToString ");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(openAttributeListSyntax);
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Type of value is " + e.getClass().getName());
                }
                if (e instanceof ObjectName) {
                    stringBuffer.append(configHelper.getListingName((ObjectName)e));
                } else {
                    stringBuffer.append(e.toString());
                }
            } else {
                stringBuffer.append(emptyAttributeListSyntax);
            }
            if (i + 1 >= arrayList.size()) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayListToString " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String stringArrayToString(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringArrayToString");
        }
        String string = null;
        if (object == null) {
            string = emptyAttributeListSyntax;
        } else if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i).toString());
                if (i >= list.size() - 1) continue;
                stringBuffer.append(";");
            }
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringArrayToString " + string);
        }
        return string;
    }

    public String integerArrayToString(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integerArrayToString");
        }
        String string = null;
        if (object == null) {
            string = emptyAttributeListSyntax;
        } else if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)object;
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i).toString());
                if (i >= list.size() - 1) continue;
                stringBuffer.append(" ");
            }
            string = stringBuffer.toString();
        } else {
            string = object.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integerArrayToString " + string);
        }
        return string;
    }

    public AttributeList stringToAttributeList(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToAttributeList string: " + string);
        }
        boolean bl = false;
        String string2 = null;
        if (string != null) {
            string2 = string.trim();
        }
        if (debugbuf == null) {
            bl = true;
            debugbuf = new StringBuffer();
        }
        AttributeList attributeList = new AttributeList();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "[] \"'", true);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken("[] \"'");
                debugbuf.append(string3);
                if (string3.equals(openAttributeListSyntax)) {
                    ArrayList arrayList;
                    String string4 = this.getString(stringTokenizer, " ");
                    String string5 = this.getString(stringTokenizer, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        debugbuf.append(string3);
                        if (string3.equals(" ")) continue;
                    }
                    if (!string3.equals(closeAttributeListSyntax)) {
                        Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                        this.throwIllegalArgException("WASX7122E", closeAttributeListSyntax, string4, string5, string);
                    }
                    if (string5.startsWith("[[") && string5.endsWith("]]")) {
                        arrayList = this.createArrayList(string5);
                        attributeList.add(new Attribute(string4, arrayList));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + attributeList.size());
                        continue;
                    }
                    if (string5.startsWith(openAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New attribute: " + string4 + " (list)");
                        }
                        arrayList = this.stringToAttributeList(string5);
                        attributeList.add(new Attribute(string4, arrayList));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "size of list is now " + attributeList.size());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New attribute: " + string4 + " = " + string5);
                    }
                    attributeList.add(new Attribute(string4, string5));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "size of list is now " + attributeList.size());
                    continue;
                }
                if (string3.equals(" ")) continue;
                Tr.event(tc, "debugbuf is \"" + debugbuf.toString() + "\"");
                this.throwIllegalArgException("WASX7121E", string3, "", "", string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException();
        }
        finally {
            if (bl) {
                debugbuf = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToAttributeList");
        }
        return attributeList;
    }

    public String[] stringToStringArray(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToStringArray");
        }
        String[] stringArray = null;
        if (string != null) {
            int n;
            Object object;
            String string2 = string.trim();
            if (string2.startsWith(openAttributeListSyntax) && string2.endsWith(closeAttributeListSyntax)) {
                string2 = string2.substring(1, string.length() - 1);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[] ", true);
            String string3 = null;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals(openAttributeListSyntax)) {
                    ++n2;
                } else if (string3.equals(closeAttributeListSyntax)) {
                    --n2;
                }
                stringBuffer.append(string3);
                if (stringBuffer.toString().startsWith("\"") && !string3.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + stringBuffer.toString());
                }
                if (n2 != 0) continue;
                object = stringBuffer.toString().trim();
                if (!((String)object).equals("")) {
                    if (((String)object).startsWith("\"") && ((String)object).endsWith("\"") || ((String)object).startsWith(openAttributeListSyntax) && ((String)object).endsWith(closeAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing quotes from \"" + (String)object + "\"");
                        }
                        object = ((String)object).substring(1, ((String)object).length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding " + (String)object);
                    }
                    arrayList.add(object);
                }
                stringBuffer = new StringBuffer();
            }
            object = new ArrayList<String>();
            for (n = 0; n < arrayList.size(); ++n) {
                String string4 = (String)arrayList.get(n);
                if (string4.indexOf(";") >= 0) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ";", false);
                    while (stringTokenizer2.hasMoreTokens()) {
                        string3 = stringTokenizer2.nextToken();
                        ((ArrayList)object).add(string3);
                    }
                    continue;
                }
                ((ArrayList)object).add((String)arrayList.get(n));
            }
            stringArray = new String[((ArrayList)object).size()];
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                stringArray[n] = (String)((ArrayList)object).get(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToStringArray");
        }
        return stringArray;
    }

    public String attributeListToString(AttributeList attributeList) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListToString");
        }
        Properties properties = new Properties();
        for (int i = 0; i < attributeList.size(); ++i) {
            Object object;
            if (tc.isDebugEnabled()) {
                try {
                    object = attributeList.get(i);
                    Tr.debug(tc, "Class of Attribute " + i + " is " + object.getClass().getName());
                    Tr.debug(tc, "name of attr is " + ((Attribute)attributeList.get(i)).getName());
                    Object object2 = ((Attribute)attributeList.get(i)).getValue();
                    if (object2 != null) {
                        Tr.debug(tc, "Class of value is " + object2.getClass().getName());
                    }
                }
                catch (Exception exception) {
                    Tr.debug(tc, "caught " + exception);
                }
            }
            if ((object = ((Attribute)attributeList.get(i)).getValue()) != null) {
                properties.setProperty(((Attribute)attributeList.get(i)).getName(), object.toString());
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Attribute null; skipping: " + ((Attribute)attributeList.get(i)).getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListToString");
        }
        return this.propertiesToString(properties);
    }

    public String cleanAttributeString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanAttributeString");
        }
        if (string != null && string.startsWith(openAttributeListSyntax) && string.endsWith(closeAttributeListSyntax)) {
            string = string.substring(1, string.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            if (string.toLowerCase().indexOf("password") == -1 && string.toLowerCase().indexOf("pwd") == -1) {
                Tr.exit(tc, "cleanAttributeString -- " + string);
            } else {
                String[] stringArray = string.split(" ");
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (!(string2.toLowerCase().indexOf("password") == -1 && string2.toLowerCase().indexOf("pwd") == -1 || bl)) {
                        bl = true;
                        stringBuffer.append(string2);
                    } else if (bl) {
                        stringBuffer.append("*****");
                        bl = false;
                    } else {
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(" ");
                }
                Tr.exit(tc, "cleanAttributeString -- " + stringBuffer.toString());
            }
        }
        return string;
    }

    protected String getString(StringTokenizer stringTokenizer, String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString next: \"" + string + "\"");
        }
        String string2 = null;
        try {
            if (string.equals(" ")) {
                string = this.skipSpaces(stringTokenizer);
                debugbuf.append(string);
            }
            if (string.equals(openAttributeListSyntax)) {
                string2 = "";
                int n = 1;
                while (n > 0) {
                    string = stringTokenizer.nextToken(emptyAttributeListSyntax);
                    debugbuf.append(string);
                    if (string.equals(openAttributeListSyntax)) {
                        ++n;
                    } else if (string.equals(closeAttributeListSyntax)) {
                        --n;
                    }
                    if (n <= 0) continue;
                    string2 = string2 + string;
                }
            } else if (string.equals(closeAttributeListSyntax)) {
                Tr.event(tc, "Unexpected ']' found");
                this.throwIllegalArgException("WASX7123E", closeAttributeListSyntax, "", "", string);
            } else if (string.equals("\"") || string.equals("'")) {
                String string3 = string;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    debugbuf.append(string);
                    if (string.equals(string3)) {
                        bl = true;
                        break;
                    }
                    stringBuffer.append(string);
                }
                if (!bl) {
                    this.throwIllegalArgException("WASX7122E", "\"", "", "", string);
                }
                string2 = stringBuffer.toString();
            } else {
                string2 = string;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getString -> " + string2.trim());
        }
        return string2.trim();
    }

    protected String addOptionValue(StringTokenizer stringTokenizer, String string, Hashtable hashtable) {
        Vector<String> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOptionValue: " + string);
        }
        Object object = new String();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = new String();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                debugbuf.append(string2);
                if (string2.equals(" ")) {
                    try {
                        string2 = this.skipSpaces(stringTokenizer);
                        debugbuf.append(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        break;
                    }
                }
                if (!string2.startsWith("-") || string.equals("target")) {
                    if (string.equals("target") && string2.startsWith("-")) {
                        if (string2.toLowerCase().startsWith("-websphere")) {
                            object = vector = this.getString(stringTokenizer, string2);
                            string2 = ((String)((Object)vector)).substring(1);
                            continue;
                        }
                    } else if (!string2.equals(openAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "value not a list");
                        }
                        object = vector = this.getString(stringTokenizer, string2);
                    } else {
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                        }
                        debugbuf.append(string2);
                        if (string2.equals(" ")) {
                            string2 = this.skipSpaces(stringTokenizer);
                            debugbuf.append(string2);
                        }
                        if (!string2.equals(openAttributeListSyntax)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is not a list but starts with a [");
                            }
                            vector = this.getString(stringTokenizer, openAttributeListSyntax);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "val is " + (String)((Object)vector));
                            }
                            object = string2.startsWith("-") && vector != null ? string2 + " " + (String)((Object)vector) : string2 + (String)((Object)vector);
                            if (string.equals("delete") && tc.isDebugEnabled()) {
                                Tr.debug(tc, "delete option is provided");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "result is " + object);
                            }
                            string2 = closeAttributeListSyntax;
                        } else {
                            while (string2.equals(openAttributeListSyntax)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "value a list");
                                }
                                vector = this.getList(stringTokenizer);
                                arrayList.add(vector);
                                if (!stringTokenizer.hasMoreTokens()) break;
                                string2 = stringTokenizer.nextToken(tokenizerString);
                                debugbuf.append(string2);
                                if (string2.equals(" ")) {
                                    string2 = this.skipSpaces(stringTokenizer);
                                    debugbuf.append(string2);
                                }
                                if (!string2.equals(closeAttributeListSyntax)) continue;
                                break;
                            }
                            object = arrayList;
                        }
                    }
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new IllegalArgumentException(noSuchElementException.getMessage());
        }
        if (string.equals("custom")) {
            Object v = hashtable.get(string);
            vector = v == null ? new Vector<String>() : (Vector<String>)v;
            vector.addElement((String)object);
            hashtable.put(string, vector);
        } else {
            hashtable.put(string, object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "next: " + string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOptionValue: " + object);
        }
        return string2;
    }

    public String propertiesToString(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesToString");
        }
        if (properties == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "propertiesToString");
            }
            return new String();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (properties.size() > 1) {
            stringBuffer.append(openAttributeListSyntax);
            stringBuffer.append(" ");
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(openAttributeListSyntax);
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append(closeAttributeListSyntax);
            if (properties.size() <= 1) continue;
            stringBuffer.append(" ");
        }
        if (properties.size() > 1) {
            stringBuffer.append(closeAttributeListSyntax);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesToString");
        }
        return stringBuffer.toString();
    }

    public String objectArrayToString(Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectArrayToString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(openAttributeListSyntax);
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].toString();
            if (string.trim().startsWith(openAttributeListSyntax) && string.trim().endsWith(closeAttributeListSyntax)) {
                StringTokenizer stringTokenizer;
                if (bl) {
                    stringTokenizer = new StringTokenizer(string, "][ ,", true);
                    bl = false;
                } else {
                    stringTokenizer = new StringTokenizer(string, "] ,", true);
                }
                boolean bl2 = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if ((string2.trim().startsWith("\"") || string2.trim().startsWith("'")) && (string2.trim().endsWith("\"") || string2.trim().endsWith("'")) && string2.trim().indexOf("-") != -1) {
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "next: " + string2);
                    }
                    if (string2.trim().equals(",")) {
                        while ((string2 = stringTokenizer.nextToken()) != null && string2.equals(" ")) {
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "next: " + string2);
                        }
                        if (string2.trim().startsWith(openAttributeListSyntax)) {
                            stringBuffer.append(" ");
                            bl2 = false;
                        } else if (string2.trim().startsWith("\"") || string2.trim().startsWith("'")) {
                            bl2 = true;
                            stringBuffer.append(" ");
                        } else {
                            try {
                                if (bl2) {
                                    stringBuffer.append(",");
                                } else {
                                    Integer.parseInt(string2.trim());
                                    stringBuffer.append(" ");
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                stringBuffer.append(",");
                            }
                        }
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append(" ");
                continue;
            }
            if (string.equals("-delete")) {
                bl = true;
            }
            try {
                Integer.parseInt(string.trim());
                stringBuffer.append(string);
                stringBuffer.append(" ");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (!string.trim().startsWith("-")) {
                    stringBuffer.append("\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                    stringBuffer.append(" ");
                    continue;
                }
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(closeAttributeListSyntax);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectArrayToString - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String[] createArgSettingCommands(Collection collection) {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createArgSettingCommands");
        }
        Object[] objectArray = collection.toArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            charSequence = objectArray[i].toString();
            stringBuffer.append("'");
            stringBuffer.append((String)charSequence);
            stringBuffer.append("'");
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        String[] stringArray = new String[2];
        charSequence = new StringBuffer();
        stringArray[0] = "import sys";
        ((StringBuffer)charSequence).append("sys.argv = [");
        ((StringBuffer)charSequence).append(stringBuffer.toString());
        ((StringBuffer)charSequence).append(closeAttributeListSyntax);
        stringArray[1] = ((StringBuffer)charSequence).toString();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createArgSettingCommands");
        }
        return stringArray;
    }

    public String buildAdminCmdString(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildAdminCmdString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        stringBuffer.append("(");
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append("'");
            stringBuffer.append(string3);
            stringBuffer.append("'");
        }
        if (string4 != null && string4.length() > 0 || string5 != null && string5.length() > 0) {
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("'");
            stringBuffer.append(OPENOPTIONSYNTAX);
        }
        if (string4 != null && string4.length() > 0) {
            stringBuffer.append(string4);
            if (string5 != null) {
                stringBuffer.append(" ");
            }
        }
        if (string5 != null && string5.length() > 0) {
            stringBuffer.append(string5);
        }
        if (string4 != null && string4.length() > 0 || string5 != null && string5.length() > 0) {
            stringBuffer.append(CLOSEOPTIONSYNTAX);
            stringBuffer.append("'");
        }
        stringBuffer.append(")");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildAdminCmdString - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public Object stringToObjectArray(String string, Class clazz) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectArray");
        }
        Object object = null;
        if (string != null) {
            Object object2;
            String string2 = string.trim();
            if (string2.startsWith(openAttributeListSyntax) && string2.endsWith(closeAttributeListSyntax)) {
                string2 = string2.substring(1, string.length() - 1);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Class<?> clazz2 = null;
            if (!clazz.isArray()) {
                return new Object();
            }
            clazz2 = clazz.getComponentType();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "[] ", true);
            String string3 = null;
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals(openAttributeListSyntax)) {
                    ++n;
                } else if (string3.equals(closeAttributeListSyntax)) {
                    --n;
                }
                stringBuffer.append(string3);
                if (stringBuffer.toString().startsWith("\"") && !string3.endsWith("\"")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "buf to string:" + stringBuffer.toString());
                }
                if (n != 0) continue;
                object2 = stringBuffer.toString().trim();
                if (!((String)object2).equals("")) {
                    if (((String)object2).startsWith("\"") && ((String)object2).endsWith("\"") || ((String)object2).startsWith(openAttributeListSyntax) && ((String)object2).endsWith(closeAttributeListSyntax)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removing quotes from \"" + (String)object2 + "\"");
                        }
                        object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding " + (String)object2);
                    }
                    arrayList.add(object2);
                }
                stringBuffer = new StringBuffer();
            }
            object2 = HandlerRegistry.getHandler(clazz2);
            if (object2 != null) {
                object = Array.newInstance(clazz2, arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        Array.set(object, i, object2.formValidObject((String)arrayList.get(i), clazz2, "jython"));
                        continue;
                    }
                    catch (com.ibm.websphere.scripting.ScriptingException scriptingException) {
                        throw new ScriptingException(scriptingException.toString());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectArray");
        }
        return object;
    }
}

