/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.util.UtilsClient;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.JaclUtilities;
import com.ibm.ws.scripting.JythonUtilities;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ReconnectSupport;
import com.ibm.ws.scripting.ScriptingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AbstractShell {
    private static TraceComponent tc = Tr.register(AbstractShell.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String CONN_TYPE_PROP = "com.ibm.ws.scripting.connectionType";
    private static final String HOST_PROP = "com.ibm.ws.scripting.host";
    private static final String PORT_PROP = "com.ibm.ws.scripting.port";
    private static final String DEFAULT_LANG_PROP = "com.ibm.ws.scripting.defaultLang";
    private static final String CLASSPATH_PROP = "com.ibm.ws.scripting.classpath";
    protected static int returnCode = 0;
    protected ArrayList commands = new ArrayList(3);
    protected ArrayList propfiles = new ArrayList(3);
    protected ArrayList loadedPropfiles = new ArrayList();
    protected ArrayList scriptParms = new ArrayList();
    protected String lang = null;
    protected ArrayList profiles = new ArrayList(3);
    protected String targetScript = null;
    protected String connectionType = null;
    protected String argHost = null;
    protected String argPort = null;
    protected String argUser = null;
    protected String argPassword = null;
    protected String argClasspath = null;
    protected String saveClasspath = null;
    protected boolean inScript = false;
    protected boolean zos = false;
    protected String jobid = null;
    protected String logfile = null;
    protected String appendtrace = null;
    protected ResourceBundle bundle = null;
    protected String prompt = null;
    protected LanguageUtilities langUtils = null;
    protected Vector reconnectors = new Vector();
    Properties connProps = null;
    protected Exception _lastException = null;
    protected BSFManager mgr = null;

    public AbstractShell() {
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.zos = true;
        }
    }

    public static AbstractShell getShell() {
        return null;
    }

    protected abstract boolean parseAndValidateInput(String[] var1);

    protected abstract boolean declareBeans(Object var1);

    protected abstract void executeProfiles();

    protected abstract void showHelp();

    protected abstract String getTargetScript();

    protected abstract void initializePropFileSet();

    protected abstract int retcodeFromMessage(String var1);

    protected abstract void setTrace();

    protected abstract void welcome();

    public abstract Object executeCommand(String var1);

    protected abstract boolean timeToGo();

    protected abstract void leaving(boolean var1);

    public String getUser() {
        return this.argUser;
    }

    public void registerForReconnect(ReconnectSupport reconnectSupport) {
        this.reconnectors.add(reconnectSupport);
    }

    public void manageReconnect() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "manageReconnect");
        }
        Enumeration enumeration = this.reconnectors.elements();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        WsException wsException = null;
        while (enumeration.hasMoreElements()) {
            object = (ReconnectSupport)enumeration.nextElement();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "about to request reconnect for object with class: " + object.getClass().getName());
            }
            try {
                object.doReconnect();
            }
            catch (ConnectorException connectorException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught ConnectorException for reconnect; object: " + object.getClass().getName());
                }
                bl = true;
                wsException = connectorException;
                vector.add(object.getClass().getName());
            }
            catch (AdminException adminException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught AdminException for reconnect; object: " + object.getClass().getName());
                }
                bl = true;
                wsException = adminException;
                vector.add(object.getClass().getName());
            }
        }
        if (bl) {
            object = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                ((StringBuffer)object).append((String)vector.get(i));
                if (i >= vector.size() - 1) continue;
                ((StringBuffer)object).append(", ");
            }
            returnCode = this.logAndIssueMessage(new Object[]{((StringBuffer)object).toString()}, "RECONNECT_FAILED", "Attempt to reconnect to the server failed for the following objects: " + ((StringBuffer)object).toString() + "; server may no longer be running.", wsException);
        } else {
            object = this.connProps.getProperty("type");
            String string = this.connProps.getProperty("host");
            this.issueMessage(new Object[]{object, string}, "RECONNECT_COMPLETE", "Reconnect of " + (String)object + " connector to host " + string + " completed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "manageReconnect");
        }
    }

    public LanguageUtilities getLangUtils() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLangUtils");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLangUtils");
        }
        return this.langUtils;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getLang() {
        return this.lang;
    }

    protected void determineLanguage() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineLanguage");
        }
        if (this.lang == null) {
            String string2 = this.getTargetScript();
            try {
                if (string2 != null) {
                    this.lang = BSFManager.getLangFromFilename(string2);
                }
            }
            catch (BSFException bSFException) {
                returnCode = this.issueMessage(new Object[]{string2}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string2 + "\" -- please specify \"-lang\" option on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "determineLanguage -- lang not found");
                }
                return;
            }
        }
        if (this.lang == null && this.profiles.size() > 0) {
            for (int i = 0; i < this.profiles.size(); ++i) {
                String string3 = (String)this.profiles.get(i);
                try {
                    this.lang = BSFManager.getLangFromFilename(string3);
                    continue;
                }
                catch (BSFException bSFException) {
                    returnCode = this.issueMessage(new Object[]{string3}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string3 + "\" -- please specify \"-lang\" option on the command line.");
                    return;
                }
            }
        }
        if (this.lang == null && (string = System.getProperty(DEFAULT_LANG_PROP)) != null) {
            if (!string.equalsIgnoreCase("jacl") && !string.equalsIgnoreCase("jython")) {
                returnCode = this.issueMessage(new Object[]{string}, "LANGUAGE_NOT_SUPPORTED", "Language \"" + string + "\" is not supported.");
            } else if (BSFManager.isLanguageRegistered(string)) {
                this.lang = string;
            } else {
                returnCode = this.issueMessage(new Object[]{string}, "LANGUAGE_NOT_REGISTERED", "Language \"" + string + "\" is not registered to BSF.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineLanguage");
        }
    }

    protected LanguageUtilities getUtilitiesForLanguage() {
        if (this.lang == null) {
            return new LanguageUtilities(this.bundle);
        }
        if (this.lang.equalsIgnoreCase("jacl")) {
            return new JaclUtilities(this.bundle);
        }
        if (this.lang.equalsIgnoreCase("jython")) {
            return new JythonUtilities(this.bundle);
        }
        return new LanguageUtilities(this.bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPropertiesFiles() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFiles");
        }
        this.initializePropFileSet();
        if (this.propfiles.size() > 0) {
            for (int i = 0; i < this.propfiles.size(); ++i) {
                String string = (String)this.propfiles.get(i);
                try {
                    File file = new File(string);
                    System.getProperties().load(new FileInputStream(file));
                    this.loadedPropfiles.add(string);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    returnCode = this.issueMessage(new Object[]{string}, "FILE_NOT_FOUND", "Cannot find file " + string);
                    continue;
                }
                catch (Exception exception) {
                    returnCode = this.issueMessage(new Object[]{string, exception}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file " + string + "; exception information: " + exception);
                    continue;
                }
                finally {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadPropertiesFiles");
                    }
                }
            }
        }
    }

    protected void logPropertiesFilesLoaded() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logPropertiesFilesLoaded");
        }
        if (this.loadedPropfiles.size() > 0) {
            for (int i = 0; i < this.loadedPropfiles.size(); ++i) {
                String string = (String)this.loadedPropfiles.get(i);
                Tr.audit(tc, "WASX7326I", new Object[]{string});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logPropertiesFilesLoaded");
        }
    }

    protected void setupTempDir() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTempDir");
        }
        if ((string = System.getProperty("com.ibm.ws.scripting.tempdir")) != null && !string.equals("")) {
            System.setProperty("java.io.tempdir", string);
        } else {
            Tr.debug(tc, "Property com.ibm.ws.scripting was invalid: " + string);
        }
        Tr.debug(tc, "Property java.io.tempdir is: " + System.getProperty("java.io.tempdir"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTempDir");
        }
    }

    protected void setClasspath() {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClasspath");
        }
        if (this.argClasspath == null) {
            this.argClasspath = System.getProperty(CLASSPATH_PROP);
        }
        if (this.lang != null && this.lang.equalsIgnoreCase("jython")) {
            if (System.getProperty("python.cachedir") == null) {
                object2 = null;
                if (System.getProperty("python.home") == null) {
                    object2 = this.getDefaultCacheDir();
                } else {
                    object = System.getProperty("python.home");
                    object2 = (String)object + File.separator + "cachedir";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting jython cachedir: " + (String)object2);
                }
                System.setProperty("python.cachedir", (String)object2);
            }
            this.saveClasspath = System.getProperty("java.class.path");
            object2 = this.getPluginPath();
            System.setProperty("was.plugin.path", (String)object2);
            System.setProperty("python.packages.directories", "java.ext.dirs,ws.ext.dirs,was.plugin.path");
            object = System.getProperty("ws.ext.dirs");
            String string = this.saveClasspath + System.getProperty("path.separator") + (String)object + System.getProperty("path.separator") + (String)object2;
            System.setProperty("java.class.path", string);
            if (this.argClasspath != null) {
                this.saveClasspath = System.getProperty("java.class.path");
                String string2 = this.saveClasspath + System.getProperty("path.separator") + this.argClasspath;
                System.setProperty("java.class.path", string2);
            }
        }
        if (this.argClasspath != null) {
            this.argClasspath = this.normalizeFQPathName(this.argClasspath);
            object2 = Thread.currentThread().getContextClassLoader();
            if (object2 instanceof ExtClassLoader) {
                object = (ExtClassLoader)object2;
                ((ExtClassLoader)object).addPath(this.argClasspath);
            } else {
                System.out.println("Context classloader is not ExtClassloader");
                System.out.println("Ignoring argument class_path: " + this.argClasspath);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClasspath");
        }
    }

    protected String getDefaultCacheDir() {
        String string = System.getProperty("user.install.root");
        String string2 = string + File.separator + "temp" + File.separator + "cachedir";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default jython cachedir: " + string2);
        }
        return string2;
    }

    protected void setupConnectionType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupConnectionType");
        }
        if (this.connectionType == null) {
            this.connectionType = System.getProperty(CONN_TYPE_PROP);
        }
        if (this.connectionType == null) {
            this.connectionType = "SOAP";
        }
        if (this.connectionType.equalsIgnoreCase("NONE")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setupConnectionType - NONE");
            }
            System.out.println(this.getString("WASX7357I", "The scripting client is not connected to any server. Operations will be available in local mode"));
            Tr.audit(tc, "WASX7357I");
        }
        if (this.connectionType.equalsIgnoreCase("SOAP")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"SOAP"}, "CONN_REQUIRES_HOST", "The \"SOAP\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"SOAP"}, "CONN_REQUIRES_PORT", "The \"SOAP\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            try {
                this.connProps = new Properties();
                int n = Integer.parseInt(this.argPort);
                this.connProps.setProperty("type", "SOAP");
                this.connProps.setProperty("host", this.argHost);
                this.connProps.setProperty("port", Integer.toString(n));
            }
            catch (NumberFormatException numberFormatException) {
                returnCode = this.logAndIssueMessage(new Object[]{"SOAP", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "SOAP connection type requires an integer port; found: \"" + this.argPort + "\"", numberFormatException);
            }
            if (this.argUser != null) {
                this.connProps.setProperty("username", this.argUser);
            }
            if (this.argPassword != null) {
                this.connProps.setProperty("password", this.argPassword);
            }
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
            }
        } else if (this.connectionType.equalsIgnoreCase("RMI")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"RMI"}, "CONN_REQUIRES_HOST", "The \"RMI\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"RMI"}, "CONN_REQUIRES_PORT", "The \"RMI\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(this.argPort);
            }
            catch (NumberFormatException numberFormatException) {
                returnCode = this.logAndIssueMessage(new Object[]{"RMI", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "RMI connection type requires an integer port; found: \"" + this.argPort + "\"", numberFormatException);
            }
            this.connProps = new Properties();
            this.connProps.setProperty("type", "RMI");
            this.connProps.setProperty("host", this.argHost);
            this.connProps.setProperty("port", Integer.toString(n));
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
                this.connProps.setProperty("username", this.argUser);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user: " + this.argUser);
                }
                if (this.argPassword == null) {
                    this.argPassword = "";
                }
                this.connProps.setProperty("password", this.argPassword);
            }
        } else if (this.connectionType.equalsIgnoreCase("JMS")) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupConnectionType");
        }
    }

    protected void executeCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCommands");
        }
        if (this.commands.size() == 0) {
            return;
        }
        if (this.lang == null) {
            returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_FOR_COMMANDS", "Cannot determine scripting language for command invocation -- please specify \"-lang\" option on the command line.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeCommands -- lang not found");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using language: " + this.lang);
        }
        if (this.scriptParms.size() > 0) {
            String string = this.getFormattedMessage("WASX7411W", new Object[]{this.scriptParms}, "Ignoring the following provided option: ." + this.scriptParms);
            System.out.println(string);
            Tr.audit(tc, "WASX7411W", new Object[]{this.scriptParms});
        }
        boolean bl = false;
        if (this.commands.size() > 0) {
            for (int i = 0; i < this.commands.size(); ++i) {
                String string = (String)this.commands.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing command: " + string);
                }
                try {
                    if (string.toLowerCase().indexOf("password") >= 0 || string.toLowerCase().indexOf("pwd") >= 0) {
                        Tr.audit(tc, "WASX7092I");
                    } else {
                        Tr.audit(tc, "WASX7090I", new Object[]{string});
                    }
                    if (string.startsWith("source")) {
                        if (this.lang != null && !this.lang.equalsIgnoreCase("jacl")) {
                            this.lang = "jacl";
                            this.inScript = true;
                        }
                    } else if (string.startsWith("execfile") && this.lang != null && !this.lang.equalsIgnoreCase("jython")) {
                        this.lang = "jython";
                    }
                    this._lastException = null;
                    if (this.lang.equalsIgnoreCase("jython")) {
                        this.SystemExitCheck(string);
                        this.mgr.iexec(this.lang, string, 0, 0, string);
                    } else {
                        Object object = this.mgr.eval(this.lang, string, 0, 0, string);
                        if (object != null) {
                            System.out.println(object.toString());
                        }
                    }
                    this.inScript = false;
                    continue;
                }
                catch (BSFException bSFException) {
                    bl = true;
                    this.checkException(string, bSFException);
                }
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not do auto save because something wrong");
            }
            this.leaving(false);
        } else {
            this.leaving(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCommands");
        }
    }

    protected void executeScript(String string) {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeScript");
            }
            InputStreamReader inputStreamReader = null;
            String string2 = null;
            try {
                string2 = BSFManager.getLangFromFilename(string);
            }
            catch (BSFException bSFException) {
                if (this.lang == null) {
                    String string3 = this.getStringFromException(bSFException);
                    this.logException(bSFException, string3);
                    returnCode = this.issueMessage(new Object[]{string}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string + "\" -- please specify \"-lang\" option on the command line.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "executeScript -- lang not found");
                    }
                    return;
                }
                string2 = this.lang;
            }
            if (this.lang == null) {
                this.lang = string2;
            } else if (!this.lang.equalsIgnoreCase(string2)) {
                returnCode = this.issueMessage(new Object[]{string, this.lang}, "WASX7227E", "Script file " + string + " is in the wrong language and will not be executed; language used is " + this.lang);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            try {
                String string4;
                String string5 = System.getProperty("com.ibm.ws.scripting.echoparams");
                if (string5 == null || string5.trim().equalsIgnoreCase("true")) {
                    if (this.scriptParms.size() > 0) {
                        string4 = this.getFormattedMessage("WASX7303I", new Object[]{this.scriptParms}, "The following options are passed to the scripting environment and are available as argv: ." + this.scriptParms);
                        System.out.println(string4);
                        Tr.audit(tc, "WASX7303I", new Object[]{this.scriptParms});
                    }
                } else {
                    Tr.debug(tc, "Not output parameters");
                }
                inputStreamReader = this.zos ? ((string4 = System.getProperty("script.encoding")) != null ? new InputStreamReader((InputStream)new FileInputStream(string), string4) : new FileReader(string)) : new FileReader(string);
                this._lastException = null;
                Tr.audit(tc, "WASX7091I", new Object[]{string});
                string4 = this.getSanitizedScriptString(inputStreamReader);
                this.mgr.exec(this.lang, string, 0, 0, string4);
                this.leaving(false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{string}, "FILE_NOT_FOUND", "Cannot find file \"" + string + "\"", fileNotFoundException);
            }
            catch (IOException iOException) {
                returnCode = this.logAndIssueMessage(new Object[]{string, iOException}, "ERROR_READING_FILE", "Cannot read file \"" + string + "\"", iOException);
            }
            catch (BSFException bSFException) {
                String string6 = this.getStringFromException(bSFException);
                returnCode = this.issueMessage(new Object[]{string, string6}, "ERROR_RUNNING_FILE", "Problem running file \"" + string + "\"");
                int n = this.retcodeFromMessage(string6);
                if (n <= 0) break block17;
                returnCode = n;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeScript");
        }
    }

    protected String getSanitizedScriptString(Reader reader) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSanitizedScriptString");
        }
        String string = IOUtils.getStringFromReader(reader);
        String string2 = System.getProperty("os.name");
        if (this.lang.equalsIgnoreCase("jacl") && string2 != null && string2.startsWith("Windows")) {
            int n;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "fixing up Windows CRLF");
            }
            while ((n = string.indexOf("\r\n")) != -1) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.replace(n, n + 2, "\n");
                string = stringBuffer.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSanitizedScriptString");
        }
        return string;
    }

    protected AdminControlClient createControlClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createControlClient");
        }
        AdminControlClient adminControlClient = null;
        adminControlClient = new AdminControlClient(this, this.connProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createControlClient");
        }
        return adminControlClient;
    }

    protected void interactive() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interactive");
        }
        InputStreamReader inputStreamReader = null;
        if (this.zos) {
            object = System.getProperty("ws.input.encoding");
            if (object != null) {
                try {
                    inputStreamReader = new InputStreamReader(System.in, (String)object);
                }
                catch (IOException iOException) {
                    this.issueMessage(new Object[]{iOException}, "ERROR_RUNNING_COMMAND", "Unsupported System.in encoding \"" + (String)object + "\"");
                }
            } else {
                inputStreamReader = new InputStreamReader(System.in);
            }
        } else {
            inputStreamReader = new InputStreamReader(System.in);
        }
        object = new BufferedReader(inputStreamReader);
        String string = null;
        if (this.lang == null) {
            returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_INTERACTIVE", "Cannot determine scripting language to use in interactive mode -- please specify \"-lang\" option on the command line.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "interactive -- no language");
            }
            return;
        }
        String string2 = null;
        while (true) {
            Object object2;
            if (string2 == null) {
                string = this.getCommand((BufferedReader)object, System.out);
            } else {
                string = string2;
                string2 = null;
            }
            if (string == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "interactive -- null");
                }
                return;
            }
            if (!string.equals("quit")) {
                try {
                    if (string.length() > 0 || string.length() == 0 && this.lang.equalsIgnoreCase("jython")) {
                        this._lastException = null;
                        if (string.toLowerCase().indexOf("password") >= 0 || string.toLowerCase().indexOf("pwd") >= 0) {
                            Tr.audit(tc, "WASX7092I");
                        } else {
                            Tr.audit(tc, "WASX7090I", new Object[]{string});
                        }
                        if (string.startsWith("source ")) {
                            if (!this.lang.equalsIgnoreCase("jacl")) {
                                this.lang = "jacl";
                            }
                        } else if (string.startsWith("execfile") && !this.lang.equalsIgnoreCase("jython")) {
                            this.lang = "jython";
                        }
                        if (string.startsWith("source ") || string.startsWith("execfile")) {
                            this.inScript = true;
                            string = this.convertWindowsPath(string);
                        }
                        if (this.lang.equalsIgnoreCase("jython")) {
                            this.mgr.iexec(this.lang, string, 0, 0, string);
                        } else {
                            object2 = this.mgr.eval(this.lang, string, 0, 0, string);
                            if (object2 != null) {
                                System.out.println(object2.toString());
                            }
                        }
                        this.inScript = false;
                    }
                }
                catch (BSFException bSFException) {
                    this.checkException(string, bSFException);
                }
                catch (Exception exception) {
                    returnCode = this.issueMessage(new Object[]{string, exception}, "EXCEPTION_RUNNING_COMMAND", "Exception running command: " + string + "; exception information: " + exception);
                }
                string = null;
                continue;
            }
            if (this.timeToGo()) break;
            object2 = this.getFormattedMessage("WASX7118I", new Object[0], "Unsaved changes exist: enter \"quit\" or \"exit\" to quit without save.");
            System.out.println((String)object2);
            string = this.getCommand((BufferedReader)object, System.out);
            if (string.equals("quit")) break;
            string2 = new String(string);
        }
        this.leaving(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interactive");
        }
    }

    protected String convertWindowsPath(String string) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertWindowsPath " + string);
        }
        String string2 = System.getProperty("os.name");
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = null;
        if (string2 != null && string2.startsWith("Windows")) {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                if (stringTokenizer.countTokens() > 1) {
                    if (stringTokenizer.nextToken().startsWith("source")) {
                        string4 = stringTokenizer.nextToken();
                    } else {
                        string4 = stringTokenizer.nextToken();
                        string4 = string4.substring(2, string4.length() - 2);
                    }
                } else {
                    string4 = string.substring(10, string.length() - 2);
                }
                if (File.separatorChar != '/') {
                    string4 = string4.replace(File.separatorChar, '/');
                    Tr.debug(tc, "new path " + string4);
                }
                if (string.startsWith("source")) {
                    stringBuffer.append("source ");
                    stringBuffer.append(string4);
                } else if (string.startsWith("execfile")) {
                    stringBuffer.append("execfile('");
                    stringBuffer.append(string4);
                    stringBuffer.append("')");
                }
                string3 = stringBuffer.toString();
                Tr.debug(tc, "newcommand " + string3);
            }
        } else {
            string3 = string;
        }
        Tr.exit(tc, "convertWindowsPath");
        return string3;
    }

    protected String getCommand(BufferedReader bufferedReader, PrintStream printStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommand");
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        if (printStream != null) {
            printStream.print(this.prompt);
        }
        try {
            string = bufferedReader.readLine();
            if (string != null) {
                stringBuffer.append(string + string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string == null) {
            stringBuffer.setLength(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommand -- null");
            }
            return null;
        }
        if (this.lang.equalsIgnoreCase("jython")) {
            this.SystemExitCheck(string);
        }
        if (string.equals("exit") || string.equals("quit")) {
            stringBuffer.setLength(0);
            if (tc.isEntryEnabled()) {
                if (string.toLowerCase().indexOf("password") == -1 && string.toLowerCase().indexOf("pwd") == -1) {
                    Tr.exit(tc, "getCommand -- " + string);
                } else {
                    String[] stringArray = string.split(" ");
                    StringBuffer stringBuffer2 = new StringBuffer();
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3 = stringArray[i];
                        if (!(string3.toLowerCase().indexOf("password") == -1 && string3.toLowerCase().indexOf("pwd") == -1 || bl)) {
                            bl = true;
                            stringBuffer2.append(string3);
                        } else if (bl) {
                            stringBuffer2.append("*****");
                            bl = false;
                        } else {
                            stringBuffer2.append(string3);
                        }
                        stringBuffer2.append(" ");
                    }
                    Tr.exit(tc, "getCommand -- " + stringBuffer2.toString());
                }
            }
            return "quit";
        }
        string = stringBuffer.toString();
        if (this.lang.equalsIgnoreCase("jython")) {
            while (string.endsWith(" ") || string.endsWith("\n") || string.endsWith("\r")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            string = string.trim();
        }
        if (tc.isEntryEnabled()) {
            if (string.toLowerCase().indexOf("password") == -1 && string.toLowerCase().indexOf("pwd") == -1) {
                Tr.exit(tc, "getCommand -- " + string);
            } else {
                String[] stringArray = string.split(" ");
                StringBuffer stringBuffer3 = new StringBuffer();
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    if (!(string4.toLowerCase().indexOf("password") == -1 && string4.toLowerCase().indexOf("pwd") == -1 || bl)) {
                        bl = true;
                        stringBuffer3.append(string4);
                    } else if (bl) {
                        stringBuffer3.append("*****");
                        bl = false;
                    } else {
                        stringBuffer3.append(string4);
                    }
                    stringBuffer3.append(" ");
                }
                Tr.exit(tc, "getCommand -- " + stringBuffer3.toString());
            }
        }
        return string;
    }

    public String getFormattedMessage(String string, Object[] objectArray, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return string2;
        }
        try {
            String string3 = this.bundle.getString(string);
            string3 = this.escapeSingleQuotes(string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage");
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return string2;
        }
    }

    protected String escapeSingleQuotes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "escapeSingleQuotes");
        }
        if (string == null || string.indexOf(39) < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "escapeSingleQuotes");
            }
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(c);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "escapeSingleQuotes");
        }
        return stringBuffer.toString();
    }

    public String getString(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString");
        }
        try {
            String string3 = this.bundle.getString(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString");
            }
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString - default");
            }
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString - default");
            }
            return string2;
        }
    }

    protected int issueMessage(Object[] objectArray, String string, String string2) {
        String string3 = this.getFormattedMessage(string, objectArray, string2);
        System.out.println(string3);
        Tr.audit(tc, "WASX7093I", new Object[]{string3});
        return this.retcodeFromMessage(string3);
    }

    protected int logAndIssueMessage(Object[] objectArray, String string, String string2, Exception exception) {
        int n = this.issueMessage(objectArray, string, string2);
        this.logException(exception);
        return n;
    }

    protected int processConnType(String[] stringArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConnType");
        }
        if (stringArray[n].regionMatches(true, 0, "SOAP", 0, stringArray[n].length())) {
            Tr.event(tc, "Processing SOAP connection type.");
            this.connectionType = "SOAP";
        } else if (stringArray[n].regionMatches(true, 0, "RMI", 0, stringArray[n].length())) {
            Tr.event(tc, "Processing RMI connection type.");
            this.connectionType = "RMI";
        } else if (stringArray[n].regionMatches(true, 0, "NONE", 0, stringArray[n].length())) {
            Tr.event(tc, "Processing no connection type.");
            this.connectionType = "NONE";
        } else {
            returnCode = this.issueMessage(new Object[]{stringArray[n]}, "INVALID_CONNECTION_TYPE", "Invalid connection type " + stringArray[n]);
            n = -1;
        }
        return n;
    }

    public void setLastException(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLastException");
        }
        if (this.inScript) {
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "in script mode; not saving exception");
            }
            if (exception == null) {
                return;
            }
            String string2 = ExceptionSupport.getMessage(exception, "WASX");
            if (string2 == null) {
                string2 = exception.toString();
            }
            if ((string = ExceptionSupport.getDiagnosticInfo(exception)) == null) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                string = stringWriter.toString();
            }
            this._lastException = exception;
            Tr.error(tc, "WASX7120E", new Object[]{string2, string});
        } else {
            this._lastException = exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLastException");
        }
    }

    public void setAndThrowScriptingException(String string, String string2, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAndThrowScriptingException", new Object[]{string, string2});
        }
        String string3 = this.getFormattedMessage(string, objectArray, string2);
        ScriptingException scriptingException = new ScriptingException(string3);
        this.setLastException(scriptingException);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAndThrowScriptingException");
        }
        throw scriptingException;
    }

    protected String getStringFromException(BSFException bSFException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringFromException");
        }
        String string = null;
        string = ExceptionSupport.getMessage(this._lastException, "WASX");
        try {
            if (string == null && bSFException != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using message from BSFException");
                }
                string = bSFException.toString();
                Throwable throwable = bSFException.getTargetException();
                if (throwable != null && string != null && throwable.getMessage() != null) {
                    if (string.indexOf(throwable.getMessage()) >= 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "target exception redundant");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "using message from BSFException.getTargetException()");
                        }
                        string = string + "; " + throwable.getMessage();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringFromException");
        }
        return string;
    }

    protected void logException(BSFException bSFException, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logException");
        }
        String string2 = null;
        string2 = ExceptionSupport.getDiagnosticInfo(this._lastException);
        if (string2 == null && bSFException != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using message from BSFException");
            }
            StringWriter stringWriter = new StringWriter();
            bSFException.printStackTrace(new PrintWriter(stringWriter));
            string2 = stringWriter.toString();
        }
        Tr.error(tc, "WASX7120E", new Object[]{string, string2});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logException");
        }
    }

    public void logException(Exception exception) {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logException");
        }
        if ((string2 = ExceptionSupport.getMessage(exception, "WASX")) == null) {
            string2 = exception.toString();
        }
        if ((string = ExceptionSupport.getDiagnosticInfo(this._lastException)) == null) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            string = stringWriter.toString();
        }
        Tr.error(tc, "WASX7120E", new Object[]{string2, string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logException");
        }
    }

    protected void setupCmdLineArgs() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupCmdLineArgs");
            }
            if (this.lang == null) {
                returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_FOR_COMMANDS", "Cannot determine scripting language for command invocation -- please specify \"-lang\" option on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupCmdLineArgs -- lang not found");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            String[] stringArray = this.langUtils.createArgSettingCommands(this.scriptParms);
            int n = 0;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this._lastException = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing command: " + stringArray[i]);
                    }
                    n = i;
                    this.mgr.exec(this.lang, stringArray[i], 0, 0, stringArray[i]);
                }
            }
            catch (BSFException bSFException) {
                String string = this.getStringFromException(bSFException);
                this.logException(bSFException, string);
                returnCode = this.issueMessage(new Object[]{stringArray[n], string}, "ERROR_RUNNING_COMMAND", "Problem running command \"" + stringArray[n] + "\" -- exception information: " + bSFException);
                int n2 = this.retcodeFromMessage(string);
                if (n2 <= 0) break block9;
                returnCode = n2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupCmdLineArgs");
        }
    }

    public String normalizeFQPathName(String string) {
        char c;
        char c2;
        char c3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeFQPathName - " + string);
        }
        String string2 = string;
        char c4 = File.separatorChar;
        char c5 = c3 = c4 == '/' ? (char)'\\' : '/';
        if (string.indexOf(c3) >= 0) {
            string2 = string.replace(c3, c4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "path after converting separator: " + string2);
        }
        char c6 = c2 = (c = File.pathSeparatorChar) == ';' ? (char)':' : ';';
        if (string2.indexOf(c2) >= 0) {
            String string3;
            if (c == ';') {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n != -1) {
                    int n2 = string2.indexOf(c2, n);
                    if (n2 > -1) {
                        if (n2 + 2 < string.length() && string2.substring(n2, n2 + 2).equals(":\\")) {
                            if (n2 - 2 < 0 || string2.substring(n2 - 2, n2 - 1).equals(":") || string2.substring(n2 - 2, n2 - 1).equals(";")) {
                                stringBuffer.append(string2.substring(n, n2 + 2));
                                n = n2 + 2;
                            } else {
                                stringBuffer.append(string2.substring(n, n2));
                                stringBuffer.append(c);
                                n = n2 + 1;
                            }
                        } else {
                            stringBuffer.append(string2.substring(n, n2));
                            stringBuffer.append(c);
                            n = n2 + 1;
                        }
                        if (n < string2.length()) continue;
                        n = -1;
                        continue;
                    }
                    stringBuffer.append(string2.substring(n, string2.length()));
                    n = -1;
                }
                string3 = stringBuffer.toString();
            } else {
                string3 = string2.replace(c2, c);
            }
            string2 = string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeFQPathName - " + string2);
        }
        return string2;
    }

    public void run(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run", stringArray);
        }
        returnCode = 0;
        ExceptionSupport.setBundle(this.bundle);
        if (this.parseAndValidateInput(stringArray)) {
            AdminControlClient adminControlClient;
            this.loadPropertiesFiles();
            this.setTrace();
            if (this.jobid != null) {
                Tr.audit(tc, "JobID=" + this.jobid);
            }
            if (returnCode == 0) {
                this.determineLanguage();
            }
            if (returnCode == 0) {
                this.setClasspath();
            }
            if (returnCode == 0) {
                this.setupConnectionType();
            }
            if (returnCode == 0 && this.zos) {
                this.setupTempDir();
            }
            if (returnCode != 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            this.langUtils = this.getUtilitiesForLanguage();
            this.logPropertiesFilesLoaded();
            this.mgr = new BSFManager();
            this.mgr.setClassLoader(ExtClassLoader.getInstance());
            String string = System.getProperty("jython.debug");
            if (string != null) {
                Tr.debug(tc, "jython debug is enabled");
                try {
                    this.mgr.exec("jython", "", -1, -1, "from org.python.core import imp");
                    this.mgr.exec("jython", "", -1, -1, "main = imp.addModule('__main__')");
                    this.mgr.exec("jython", "", -1, -1, "main.__dict__ = globals()");
                    this.mgr.exec("jython", "", -1, -1, "__name__ = '__main__'");
                }
                catch (Exception exception) {
                    Tr.debug(tc, "fail to load _main_ module");
                }
            }
            if (!this.declareBeans(adminControlClient = this.createControlClient())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            try {
                this.checkVersionCompatibility(adminControlClient);
            }
            catch (ScriptingException scriptingException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            this.setupCmdLineArgs();
            this.executeProfiles();
            this.executeCommands();
            if (this.targetScript != null) {
                this.inScript = true;
                Tr.debug(tc, "executeScript " + this.targetScript);
                this.executeScript(this.targetScript);
            } else if (this.commands.isEmpty()) {
                if (this.scriptParms.size() > 0) {
                    String string2 = this.getFormattedMessage("WASX7411W", new Object[]{this.scriptParms}, "Ignoring the following provided option: ." + this.scriptParms);
                    System.out.println(string2);
                    Tr.audit(tc, "WASX7411W", new Object[]{this.scriptParms});
                }
                this.welcome();
                this.interactive();
            }
            this.commands.clear();
            this.propfiles.clear();
            this.profiles.clear();
            this.scriptParms.clear();
            this.loadedPropfiles.clear();
            this.targetScript = null;
        } else if (returnCode == 0) {
            returnCode = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run -> " + returnCode);
        }
    }

    public int getReturnCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReturnCode");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReturnCode - " + returnCode);
        }
        return returnCode;
    }

    public void checkException(String string, BSFException bSFException) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkException");
        }
        String string2 = null;
        boolean bl = false;
        string.trim();
        if (this.lang.equalsIgnoreCase("jython")) {
            n = string.indexOf("print");
            if (n >= 0) {
                string = string.substring(n + 6, string.length());
                string.trim();
            }
            if (string.equals("AdminConfig()") || string.equals("AdminControl()") || string.equals("AdminApp()") || string.equals("AdminTask()") || string.equals("Help()")) {
                bl = true;
                String string3 = string.substring(0, string.length() - 2);
                this.printHelp(string3);
            }
        } else if (this.lang.equalsIgnoreCase("jacl") && (string.equals("$AdminConfig") || string.equals("$AdminControl") || string.equals("$AdminApp") || string.equals("$AdminTask") || string.equals("$Help"))) {
            bl = true;
            String string4 = string.substring(1, string.length());
            this.printHelp(string4);
        }
        if (!bl) {
            string2 = this.getStringFromException(bSFException);
            this.logException(bSFException, string2);
            returnCode = this.issueMessage(new Object[]{string, string2}, "EXCEPTION_RUNNING_COMMAND", "Exception running command: " + string + "; exception information: " + bSFException);
            n = this.retcodeFromMessage(string2);
            if (n > 0) {
                returnCode = n;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnCode - " + returnCode);
        }
    }

    private String getPluginPath() {
        String string = "";
        String string2 = System.getProperty("was.install.root");
        if (string2 != null) {
            File file = new File(string2 + File.separator + "plugins");
            string = AbstractShell.searchPlugins(file);
        } else {
            System.out.println("WARNING: system property was.install.root is not set.  Websphere classes may not be found.");
        }
        return string;
    }

    private static String searchPlugins(File file) {
        String string = new String();
        if (file == null || !file.exists() || !file.isDirectory()) {
            return string;
        }
        File[] fileArray = file.listFiles(new JarZipFilter());
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].toString();
                if (string2.indexOf("runtime") == -1) continue;
                string = !string.equals("") ? string + File.pathSeparator + string2 : string2;
            }
        }
        return string;
    }

    public void printHelp(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printHelp - " + string);
        }
        if (string.equals("AdminConfig")) {
            System.out.println(this.getFormattedMessage("ADMINCONFIG_GENERAL_HELP", new Object[0], "no help available"));
        } else if (string.equals("AdminControl")) {
            System.out.println(this.getFormattedMessage("ADMINCONTROL_GENERAL_HELP", new Object[0], "no help available"));
        } else if (string.equals("AdminApp")) {
            System.out.println(this.getFormattedMessage("WASX7095I", new Object[0], "no help available"));
        } else if (string.equals("Help")) {
            System.out.println(this.getFormattedMessage("HELP_GENERAL_HELP", new Object[0], "no help available"));
        } else if (string.equals("AdminTask")) {
            System.out.println(this.getFormattedMessage("WASX8001I", new Object[0], "no help available"));
        }
    }

    private void SystemExitCheck(String string) {
        Tr.entry(tc, "SystemExitCheck " + string);
        String string2 = null;
        if (string.indexOf("sys.exit(") >= 0 || string.indexOf("SystemExit(") >= 0) {
            if (string.indexOf("\"") < 0 && string.indexOf("'") < 0) {
                if (string.indexOf("sys.exit()") >= 0 || string.indexOf("SystemExit()") >= 0) {
                    returnCode = this.getReturnCode();
                } else {
                    string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
                    if (string2 != null && !string2.equals("")) {
                        returnCode = Integer.parseInt(string2);
                    }
                }
                System.exit(returnCode);
            } else {
                String string3 = string.indexOf("\"") >= 0 ? string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")) : string.substring(string.indexOf("'") + 1, string.lastIndexOf("'"));
                string = "print \"" + string3 + "\"";
                try {
                    this.mgr.iexec(this.lang, string, 0, 0, string);
                    System.exit(1);
                }
                catch (BSFException bSFException) {
                    this.checkException(string, bSFException);
                }
            }
        }
    }

    private void checkVersionCompatibility(AdminControlClient adminControlClient) throws ScriptingException {
        String string = null;
        String string2 = null;
        Tr.entry(tc, "checkVersionCompatibility ");
        try {
            if (!this.connectionType.equalsIgnoreCase("NONE")) {
                string2 = UtilsClient.getProductVersion();
                Tr.debug(tc, "clientVersion " + string2);
                Session session = adminControlClient.isAlive();
                AdminClient adminClient = adminControlClient.getAdminClient();
                String string3 = adminControlClient.getNode();
                Tr.debug(tc, "node " + string3);
                CommandMgr commandMgr = CommandMgr.getClientCommandMgr(adminClient);
                AdminCommand adminCommand = commandMgr.createCommand("getNodeBaseProductVersion");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("nodeName", string3);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                string = commandResult.getResult().toString();
                Tr.debug(tc, "serverNodeversion " + string);
                if (string != null && string2 != null && string.compareTo(string2) < 0) {
                    this.setAndThrowScriptingException("WASX8021E", "The wsadmin with version " + string2 + " connected to an incompatible server or deployment manager with node version " + string + " , which is not supported. ", new Object[]{string2, string});
                }
            }
        }
        catch (ScriptingException scriptingException) {
            if (scriptingException.toString().indexOf("WASX8021E") > 0) {
                returnCode = this.issueMessage(new Object[]{scriptingException}, "INCOMPATIBLE_NODE", "Incompatible node version; Exception Information: " + scriptingException);
                return;
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "e " + exception);
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private static class JarZipFilter
    implements FileFilter {
        private JarZipFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
        }
    }
}

