/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSTimeStatistic;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class TimeStatisticImpl
extends AverageStatisticImpl
implements SPITimeStatistic,
WSTimeStatistic {
    private static final long serialVersionUID = 3480487189513289050L;

    public TimeStatisticImpl(int n) {
        super(n);
    }

    public TimeStatisticImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(0);
        this.set(n, n2, n3, n4, n5, n6, n7);
    }

    public TimeStatisticImpl(int n, long l, long l2, long l3, long l4, double d, long l5, long l6) {
        super(n);
        this.set(l, l2, l3, l4, d, l5, l6);
    }

    public TimeStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public int getStatisticType() {
        return 4;
    }

    public WSStatistic copy() {
        TimeStatisticImpl timeStatisticImpl = new TimeStatisticImpl(this.id, this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
        timeStatisticImpl.baseValue = this.baseValue;
        return timeStatisticImpl;
    }

    public long getTotalTime() {
        return this.total;
    }

    public long getMinTime() {
        return this.min;
    }

    public long getMaxTime() {
        return this.max;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(""));
        stringBuffer.append(", type=").append("TimeStatistic");
        stringBuffer.append(", avg=").append(this.getMean());
        stringBuffer.append(", min=").append(this.min);
        stringBuffer.append(", max=").append(this.max);
        stringBuffer.append(", total=").append(this.total);
        stringBuffer.append(", count=").append(this.count);
        stringBuffer.append(", sumSq=").append(this.sumOfSquares);
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TS");
        stringBuffer.append(" id=\"");
        stringBuffer.append(this.id);
        stringBuffer.append("\" sT=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\" lST=\"");
        stringBuffer.append(this.lastSampleTime);
        stringBuffer.append("\" ct=\"");
        stringBuffer.append(this.count);
        stringBuffer.append("\" max=\"");
        stringBuffer.append(this.max);
        stringBuffer.append("\" min=\"");
        stringBuffer.append(this.min);
        stringBuffer.append("\" sOS=\"");
        stringBuffer.append(this.sumOfSquares);
        stringBuffer.append("\" tot=\"");
        stringBuffer.append(this.total);
        stringBuffer.append("\">\n");
        stringBuffer.append("</TS>");
        return stringBuffer.toString();
    }

    private boolean validate(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            return false;
        }
        if (!(wSStatistic instanceof TimeStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be TimeStatisticImpl");
            return false;
        }
        if (wSStatistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + wSStatistic.getId());
            return false;
        }
        return true;
    }

    public WSStatistic rateOfChange(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)wSStatistic;
        TimeStatisticImpl timeStatisticImpl2 = new TimeStatisticImpl(this.id);
        long l = this.lastSampleTime - timeStatisticImpl.lastSampleTime;
        if (l == 0L) {
            return null;
        }
        timeStatisticImpl2.count = (this.count - timeStatisticImpl.getCount()) / l;
        timeStatisticImpl2.sumOfSquares = (this.sumOfSquares - timeStatisticImpl.sumOfSquares) / (double)l;
        timeStatisticImpl2.total = (this.total - timeStatisticImpl.getTotal()) / l;
        timeStatisticImpl2.startTime = this.startTime;
        timeStatisticImpl2.lastSampleTime = this.lastSampleTime;
        timeStatisticImpl2.max = this.max;
        timeStatisticImpl2.min = this.min;
        return timeStatisticImpl2;
    }

    public WSStatistic delta(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)wSStatistic;
        TimeStatisticImpl timeStatisticImpl2 = new TimeStatisticImpl(this.id);
        timeStatisticImpl2.min = this.min;
        timeStatisticImpl2.max = this.max;
        timeStatisticImpl2.count = this.count - timeStatisticImpl.getCount();
        timeStatisticImpl2.total = this.total - timeStatisticImpl.getTotal();
        timeStatisticImpl2.sumOfSquares = this.sumOfSquares - timeStatisticImpl.sumOfSquares;
        timeStatisticImpl2.startTime = this.startTime;
        timeStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return timeStatisticImpl2;
    }
}

