/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.wsspi.pmi.stat.SPIStats;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class StatsImpl
implements SPIStats,
WpdCollection,
PmiConstants,
Serializable {
    private static final long serialVersionUID = -5812710047173154854L;
    protected String statsType;
    protected String name;
    protected int type;
    protected int instrumentationLevel = -1;
    protected ArrayList dataMembers;
    protected ArrayList subCollections;
    protected long time = PmiUtil.currentTime();
    private transient boolean bTextInfoInited = false;
    private static transient boolean bTextInfoEnabled = true;
    private static transient boolean bTextInfoTranslationEnabled = true;
    private static transient Locale _locale = null;

    public StatsImpl(String string, int n) {
        this(string, n, -1, null, null);
    }

    public StatsImpl(String string, int n, int n2) {
        this(string, n, n2, null, null);
    }

    public StatsImpl(String string, int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        if (string == null) {
            string = "Undefined";
        }
        this.name = string;
        this.type = n == 11 || n == 12 || n == 13 ? n : 17;
        this.instrumentationLevel = n2;
        this.dataMembers = arrayList;
        this.subCollections = arrayList2;
    }

    public StatsImpl(String string, String string2, int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        this(string2, n, n2, arrayList, arrayList2);
        this.statsType = string;
    }

    public String getName() {
        return this.name;
    }

    public int numStatistics() {
        if (this.dataMembers == null) {
            return 0;
        }
        return this.dataMembers.size();
    }

    public String getStatsType() {
        return this.statsType;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStatsType(String string) {
        this.statsType = string;
    }

    public int getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public synchronized void setTime(long l) {
        this.time = l;
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public void setLevel(int n) {
        this.instrumentationLevel = n;
    }

    public static void setEnableTextInfo(boolean bl) {
        bTextInfoEnabled = bl;
    }

    public static boolean getEnableTextInfo() {
        return bTextInfoEnabled;
    }

    public static void setEnableNLS(boolean bl, Locale locale) {
        _locale = locale;
        bTextInfoTranslationEnabled = bl;
    }

    public static boolean getEnableNLS() {
        return bTextInfoTranslationEnabled;
    }

    public static Locale getNLSLocale() {
        return _locale;
    }

    public void setStatistics(ArrayList arrayList) {
        this.dataMembers = arrayList;
    }

    public void setSubStats(ArrayList arrayList) {
        this.subCollections = arrayList;
    }

    public WSStatistic getStatistic(int n) {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null || arrayList.size() <= 0) {
            return null;
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            StatisticImpl statisticImpl = (StatisticImpl)arrayList.get(i);
            if (statisticImpl == null || statisticImpl.getId() != n) continue;
            return statisticImpl;
        }
        return null;
    }

    public WSStatistic getStatistic(String string) {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null) {
            return null;
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StatisticImpl statisticImpl = (StatisticImpl)arrayList.get(i);
            if (statisticImpl == null || !statisticImpl.getName().equals(string)) continue;
            return statisticImpl;
        }
        return null;
    }

    public WSStatistic[] getStatistics() {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null || arrayList.size() == 0) {
            return new StatisticImpl[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        WSStatistic[] wSStatisticArray = new StatisticImpl[arrayList.size()];
        for (int i = 0; i < wSStatisticArray.length; ++i) {
            wSStatisticArray[i] = (StatisticImpl)arrayList.get(i);
        }
        return wSStatisticArray;
    }

    public WSStatistic[] listStatistics() {
        return this.getStatistics();
    }

    public String[] listStatisticNames() {
        return this.getStatisticNames();
    }

    public String[] getStatisticNames() {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null) {
            return new String[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.get(i) == null) continue;
            stringArray[i] = ((StatisticImpl)arrayList.get(i)).getName();
        }
        return stringArray;
    }

    public StatisticImpl getJ2EEStatistic(String string) {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null) {
            return null;
        }
        if (!this.bTextInfoInited) {
            this.bindTextForJ2EECall();
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            StatisticImpl statisticImpl = (StatisticImpl)arrayList.get(i);
            if (statisticImpl == null || !statisticImpl.getName().equals(string)) continue;
            return statisticImpl;
        }
        return null;
    }

    public StatisticImpl[] getJ2EEStatistics() {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null || arrayList.size() == 0) {
            return new StatisticImpl[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForJ2EECall();
        }
        StatisticImpl[] statisticImplArray = new StatisticImpl[arrayList.size()];
        for (int i = 0; i < statisticImplArray.length; ++i) {
            statisticImplArray[i] = (StatisticImpl)arrayList.get(i);
        }
        return statisticImplArray;
    }

    public String[] getJ2EEStatisticNames() {
        ArrayList arrayList = this.copyStatistics();
        if (arrayList == null) {
            return new String[0];
        }
        if (!this.bTextInfoInited) {
            this.bindTextForJ2EECall();
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.get(i) == null) continue;
            stringArray[i] = ((StatisticImpl)arrayList.get(i)).getName();
        }
        return stringArray;
    }

    public WSStats getStats(String string) {
        ArrayList arrayList = this.copyStats();
        if (arrayList == null) {
            return null;
        }
        StatsImpl statsImpl = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            statsImpl = (StatsImpl)arrayList.get(i);
            if (!statsImpl.getName().equals(string)) continue;
            return statsImpl;
        }
        return null;
    }

    public WSStats[] getSubStats() {
        ArrayList arrayList = this.copyStats();
        if (arrayList == null || arrayList.size() == 0) {
            return new StatsImpl[0];
        }
        WSStats[] wSStatsArray = new StatsImpl[arrayList.size()];
        for (int i = 0; i < wSStatsArray.length; ++i) {
            wSStatsArray[i] = (StatsImpl)arrayList.get(i);
        }
        return wSStatsArray;
    }

    public WSStats[] listSubStats() {
        return this.getSubStats();
    }

    public synchronized boolean add(StatisticImpl statisticImpl) {
        if (this.dataMembers == null) {
            this.dataMembers = new ArrayList();
        }
        if (statisticImpl == null) {
            return false;
        }
        this.dataMembers.add(statisticImpl);
        return true;
    }

    public synchronized boolean add(StatsImpl statsImpl) {
        if (this.subCollections == null) {
            this.subCollections = new ArrayList();
        }
        if (statsImpl == null) {
            return false;
        }
        this.subCollections.add(statsImpl);
        return true;
    }

    public synchronized boolean remove(int n) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return false;
        }
        for (int i = this.dataMembers.size() - 1; i >= 0; --i) {
            if (((StatisticImpl)this.dataMembers.get(i)).getId() != n) continue;
            this.dataMembers.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String string) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return false;
        }
        for (int i = this.subCollections.size() - 1; i >= 0; --i) {
            StatsImpl statsImpl = (StatsImpl)this.subCollections.get(i);
            if (!statsImpl.getName().equals(string)) continue;
            this.subCollections.remove(i);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        ArrayList arrayList;
        if (!this.bTextInfoInited) {
            this.bindTextForWSCall();
        }
        String string2 = string;
        String string3 = null;
        switch (this.type) {
            case 10: {
                string3 = "PMIROOT";
                break;
            }
            case 11: {
                string3 = "NODE";
                break;
            }
            case 12: {
                string3 = "SERVER";
                break;
            }
            case 13: {
                string3 = "MODULE";
                break;
            }
            case 15: {
                string3 = "SUBMODULE";
                break;
            }
            case 14: {
                string3 = "INSTANCE";
                break;
            }
            case 16: {
                string3 = "SUBINSTANCE";
                break;
            }
            case 17: {
                string3 = "COLLECTION";
                break;
            }
            default: {
                string3 = "WRONG_TYPE";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Stats name=").append(this.name);
        stringBuffer.append(", type=").append(this.getStatsType());
        stringBuffer.append("\n{");
        ArrayList arrayList2 = this.copyStatistics();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                StatisticImpl statisticImpl = (StatisticImpl)arrayList2.get(i);
                if (statisticImpl == null) continue;
                stringBuffer.append("\n").append(string2);
                stringBuffer.append(statisticImpl.toString());
                stringBuffer.append("\n");
            }
        }
        if ((arrayList = this.copyStats()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                StatsImpl statsImpl = (StatsImpl)arrayList.get(i);
                if (statsImpl == null) continue;
                stringBuffer.append(statsImpl.toString(string2));
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void setConfig(PmiModuleConfig pmiModuleConfig) {
        if (pmiModuleConfig == null) {
            return;
        }
        this.bTextInfoInited = true;
        ArrayList arrayList = this.copyStatistics();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                StatisticImpl statisticImpl = (StatisticImpl)arrayList.get(i);
                if (statisticImpl == null) continue;
                statisticImpl.setDataInfo(pmiModuleConfig);
            }
        }
    }

    public boolean add(WpdData wpdData) {
        return false;
    }

    public boolean add(WpdCollection wpdCollection) {
        if (wpdCollection instanceof StatsImpl) {
            return this.add((StatsImpl)wpdCollection);
        }
        return false;
    }

    public String toXML() {
        ArrayList arrayList;
        String string = null;
        switch (this.type) {
            case 11: {
                string = "NODE";
                break;
            }
            case 12: {
                string = "SERVER";
                break;
            }
            case 13: {
                string = "MODULE";
                break;
            }
            case 17: {
                string = "COLLECTION";
                break;
            }
            default: {
                string = "WRONG_TYPE";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Stats name=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\" statType=\"");
        stringBuffer.append(this.getStatsType());
        stringBuffer.append("\" il=\"");
        stringBuffer.append(this.instrumentationLevel);
        stringBuffer.append("\" type=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">\n");
        ArrayList arrayList2 = this.copyStatistics();
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                StatisticImpl statisticImpl = (StatisticImpl)arrayList2.get(i);
                if (statisticImpl == null) continue;
                stringBuffer.append(statisticImpl.toXML());
                stringBuffer.append("\n");
            }
        }
        if ((arrayList = this.copyStats()) != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                StatsImpl statsImpl = (StatsImpl)arrayList.get(i);
                if (statsImpl == null) continue;
                stringBuffer.append(statsImpl.toXML());
            }
        }
        stringBuffer.append("</Stats>");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void setDataMembers(ArrayList arrayList) {
        this.setStatistics(arrayList);
    }

    public void setSubcollections(ArrayList arrayList) {
        this.setSubStats(arrayList);
    }

    public ArrayList dataMembers() {
        return this.dataMembers;
    }

    public synchronized ArrayList copyStatistics() {
        if (this.dataMembers != null) {
            return new ArrayList(this.dataMembers);
        }
        return null;
    }

    public ArrayList subCollections() {
        return this.subCollections;
    }

    public synchronized ArrayList copyStats() {
        if (this.subCollections != null) {
            return new ArrayList(this.subCollections);
        }
        return null;
    }

    public WpdData getData(int n) {
        System.err.println("Warning: this method is defunc'ed - call getStatistic(dataId) instead");
        return null;
    }

    public WpdCollection getSubcollection(String string) {
        System.err.println("Warning: this method is defunc'ed - call getStats(name) instead");
        return null;
    }

    public synchronized void update(WSStats wSStats, boolean bl, boolean bl2) {
        if (wSStats == null) {
            return;
        }
        StatsImpl statsImpl = (StatsImpl)wSStats;
        if (!this.name.equals(statsImpl.getName()) || this.type != statsImpl.getType()) {
            return;
        }
        this.myupdate(statsImpl, bl, bl2);
    }

    private synchronized void myupdate(WSStats wSStats, boolean bl, boolean bl2) {
        if (wSStats == null) {
            return;
        }
        StatsImpl statsImpl = (StatsImpl)wSStats;
        this.instrumentationLevel = statsImpl.getLevel();
        this.updateMembers(wSStats, bl);
        if (bl2) {
            this.updateSubcollection(wSStats, bl, bl2);
        }
    }

    private synchronized void updateMembers(WSStats wSStats, boolean bl) {
        if (!bl) {
            this.dataMembers = null;
        }
        if (wSStats == null) {
            return;
        }
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            this.dataMembers = ((StatsImpl)wSStats).dataMembers;
        } else {
            WSStatistic[] wSStatisticArray = wSStats.getStatistics();
            if (wSStatisticArray == null || wSStatisticArray.length == 0) {
                return;
            }
            for (int i = 0; i < wSStatisticArray.length; ++i) {
                boolean bl2 = false;
                StatisticImpl statisticImpl = null;
                for (int j = 0; j < this.dataMembers.size(); ++j) {
                    statisticImpl = (StatisticImpl)this.dataMembers.get(j);
                    if (wSStatisticArray[i].getId() != statisticImpl.getId()) continue;
                    bl2 = true;
                    statisticImpl.update(wSStatisticArray[i]);
                    break;
                }
                if (bl2) continue;
                this.dataMembers.add(wSStatisticArray[i]);
            }
        }
    }

    private synchronized void updateSubcollection(WSStats wSStats, boolean bl, boolean bl2) {
        if (!bl) {
            this.subCollections = null;
        }
        if (wSStats == null) {
            return;
        }
        if (this.subCollections == null || this.subCollections.size() == 0) {
            this.subCollections = ((StatsImpl)wSStats).subCollections;
        } else {
            WSStats[] wSStatsArray = wSStats.getSubStats();
            if (wSStatsArray == null || wSStatsArray.length == 0) {
                return;
            }
            StatsImpl statsImpl = null;
            for (int i = 0; i < wSStatsArray.length; ++i) {
                boolean bl3 = false;
                int n = 0;
                int n2 = -1;
                for (int j = 0; j < this.subCollections.size(); ++j) {
                    statsImpl = (StatsImpl)this.subCollections.get(j);
                    n = wSStatsArray[i].getName().compareTo(statsImpl.getName());
                    if (n == 0) {
                        bl3 = true;
                        statsImpl.update(wSStatsArray[i], bl, bl2);
                        break;
                    }
                    if (n >= 0) continue;
                    n2 = i;
                    break;
                }
                if (!bl3 && n2 > 0) {
                    this.subCollections.add(n2, wSStatsArray[i]);
                    continue;
                }
                if (bl3 || n2 != -1) continue;
                this.subCollections.add(wSStatsArray[i]);
            }
        }
    }

    public void resetOnClient(boolean bl) {
        int n;
        Serializable serializable;
        if (this.dataMembers != null) {
            serializable = null;
            for (n = 0; n < this.dataMembers.size(); ++n) {
                serializable = (StatisticImpl)this.dataMembers.get(n);
                ((StatisticImpl)serializable).resetOnClient(null);
            }
        }
        if (!bl) {
            return;
        }
        if (this.subCollections != null) {
            serializable = null;
            for (n = 0; n < this.subCollections.size(); ++n) {
                serializable = (StatsImpl)this.subCollections.get(n);
                ((StatsImpl)serializable).resetOnClient(bl);
            }
        }
    }

    private void bindTextForJ2EECall() {
        PmiModuleConfig pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(this.getStatsType(), Locale.ENGLISH);
        if (pmiModuleConfig != null) {
            this.setConfig(pmiModuleConfig);
        }
    }

    private void bindTextForWSCall() {
        if (!bTextInfoEnabled) {
            return;
        }
        PmiModuleConfig pmiModuleConfig = null;
        pmiModuleConfig = bTextInfoTranslationEnabled ? StatsConfigHelper.getTranslatedStatsConfig(this.getStatsType(), _locale) : StatsConfigHelper.getStatsConfig(this.getStatsType());
        if (pmiModuleConfig != null) {
            this.setConfig(pmiModuleConfig);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

