/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class StatsConfigHelper
implements PmiConstants {
    private static HashMap rawConfigMap = new HashMap();
    private static HashMap localeMap = new HashMap();
    private static HashMap nlsMap = new HashMap();
    private static boolean debug = false;
    private static final String PMI_RESOURCE_BUNDLE = "com.ibm.ws.pmi.properties.PMIText";
    private static final String PMI_RESOURCE_BUNDLE_PREFIX_50 = "com.ibm.websphere.pmi.property.";
    private static final TraceComponent tc = Tr.register(StatsConfigHelper.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    private static final String getNlsKey(String string, Locale locale) {
        return string + "#" + locale.toString();
    }

    private static HashMap getConfigMap(Locale locale) {
        HashMap hashMap;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((hashMap = (HashMap)localeMap.get(locale.toString())) == null) {
            hashMap = new HashMap();
            localeMap.put(locale.toString(), hashMap);
        }
        return hashMap;
    }

    private static PmiModuleConfig getConfig(Locale locale, String string) {
        PmiModuleConfig pmiModuleConfig = (PmiModuleConfig)StatsConfigHelper.getConfigMap(locale).get(string);
        if (debug && pmiModuleConfig != null) {
            System.out.println("[StatsConfigHelper] getConfig cache hit for: " + string);
        }
        return pmiModuleConfig;
    }

    private static NLS getNLS(Locale locale, String string, String string2) {
        boolean bl = false;
        if (locale == null || locale == Locale.getDefault()) {
            bl = true;
            locale = Locale.getDefault();
        }
        NLS nLS = null;
        if (string == null) {
            int n = 1;
            do {
                if (n == 1) {
                    string = PMI_RESOURCE_BUNDLE_PREFIX_50 + string2;
                } else if (n == 2) {
                    string = PMI_RESOURCE_BUNDLE;
                }
                nLS = (NLS)nlsMap.get(StatsConfigHelper.getNlsKey(string, locale));
                if (nLS == null) continue;
                return nLS;
            } while (!(nLS = new NLS(string, locale, true, false)).isResourceLoaded() && ++n <= 2);
        } else {
            nLS = (NLS)nlsMap.get(StatsConfigHelper.getNlsKey(string, locale));
            if (nLS != null) {
                return nLS;
            }
            nLS = new NLS(string, locale, true, false);
            if (!nLS.isResourceLoaded()) {
                block14: {
                    final String string3 = string;
                    final Locale locale2 = locale;
                    try {
                        nLS = (NLS)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new NLS(string3, locale2, Thread.currentThread().getContextClassLoader());
                            }
                        });
                    }
                    catch (Exception exception) {
                        Tr.warning(tc, "PMI0030W", string);
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Error loading custom resource bundle using context classloader: " + exception.getMessage());
                    }
                }
                if (nLS == null || !nLS.isResourceLoaded()) {
                    nLS = null;
                }
            }
        }
        if (nLS != null && nLS.isResourceLoaded()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caching resource bundle: " + string + " locale: " + locale);
            }
            nlsMap.put(StatsConfigHelper.getNlsKey(string, locale), nLS);
        }
        return nLS;
    }

    public static String getTranslatedStatsName(String string, String string2, Locale locale) {
        String[] stringArray = StatsConfigHelper.parseStatsType(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            NLS nLS;
            PmiModuleConfig pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(stringArray[i], locale);
            if (pmiModuleConfig == null || (nLS = StatsConfigHelper.getNLS(locale, pmiModuleConfig.getResourceBundle(), string2)) == null) continue;
            try {
                string3 = nLS.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                string3 = string;
            }
            if (string3 == null) continue;
            return string3;
        }
        return string;
    }

    public static String getTranslatedStatsName(String string, String string2) {
        return StatsConfigHelper.getTranslatedStatsName(string, string2, Locale.getDefault());
    }

    public static PmiModuleConfig getStatsConfig(String string) {
        PmiModuleConfig pmiModuleConfig = (PmiModuleConfig)rawConfigMap.get(string);
        if (pmiModuleConfig == null) {
            pmiModuleConfig = StatsConfigHelper._getStatsConfig(string, false, null);
        }
        return pmiModuleConfig;
    }

    public static PmiModuleConfig getTranslatedStatsConfig(String string) {
        return StatsConfigHelper.getTranslatedStatsConfig(string, Locale.getDefault());
    }

    public static PmiModuleConfig getTranslatedStatsConfig(String string, Locale locale) {
        PmiModuleConfig pmiModuleConfig = StatsConfigHelper.getConfig(locale, string);
        if (pmiModuleConfig == null) {
            pmiModuleConfig = StatsConfigHelper._getStatsConfig(string, true, locale);
        }
        return pmiModuleConfig;
    }

    private static PmiModuleConfig _getStatsConfig(String string, boolean bl, Locale locale) {
        Object object;
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getStatsConfig for {statType, locale}:  " + string + ", " + locale.getLanguage());
        }
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = string.indexOf(35);
        if (n > 0) {
            stringArray = new String[]{string.substring(0, n)};
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1, string.length());
            }
            if (string2 == null) {
                bl2 = true;
            } else if (string2.startsWith("ejb.")) {
                bl3 = true;
            } else {
                bl2 = true;
            }
        } else {
            stringArray = StatsConfigHelper.parseStatsType(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        PmiModuleConfig[] pmiModuleConfigArray = new PmiModuleConfig[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            PmiModuleConfig pmiModuleConfig;
            if (bl) {
                pmiModuleConfig = StatsConfigHelper.getConfig(locale, stringArray[i]);
                if (pmiModuleConfig != null) {
                    pmiModuleConfigArray[i] = pmiModuleConfig;
                    continue;
                }
            } else {
                pmiModuleConfig = (PmiModuleConfig)rawConfigMap.get(stringArray[i]);
                if (pmiModuleConfig != null) {
                    pmiModuleConfigArray[i] = pmiModuleConfig;
                    continue;
                }
            }
            if ((n2 = stringArray[i].indexOf(46)) == -1) {
                object = "/com/ibm/websphere/pmi/xml/" + stringArray[i] + ".xml";
                pmiModuleConfigArray[i] = PerfModules.getConfigFromXMLFile((String)object, false, false);
            }
            if (pmiModuleConfigArray[i] == null) {
                pmiModuleConfigArray[i] = PerfModules.getConfigFromXMLFile(PerfModules.getXmlFileName(stringArray[i]), false, true);
            }
            if (pmiModuleConfigArray[i] == null || !bl) continue;
            StatsConfigHelper.translate(pmiModuleConfigArray[i], locale);
        }
        PmiModuleConfig pmiModuleConfig = new PmiModuleConfig(string);
        if (stringArray.length >= 1 && pmiModuleConfigArray[0] != null) {
            pmiModuleConfig.setResourceBundle(pmiModuleConfigArray[0].getResourceBundle());
            pmiModuleConfig.setDescription(pmiModuleConfigArray[0].getDescription());
        }
        if (bl2) {
            if (pmiModuleConfigArray[0] != null) {
                PmiDataInfo[] pmiDataInfoArray = pmiModuleConfigArray[0].listData(null);
                for (int i = 0; i < pmiDataInfoArray.length; ++i) {
                    if (pmiDataInfoArray[i].getType() == 15) continue;
                    if (pmiDataInfoArray[i].getSubmoduleName() == null) {
                        if (string2 != null) continue;
                        pmiModuleConfig.addData(pmiDataInfoArray[i]);
                        continue;
                    }
                    if (!pmiDataInfoArray[i].getSubmoduleName().equals(string2)) continue;
                    pmiModuleConfig.addData(pmiDataInfoArray[i]);
                }
            }
        } else if (bl3) {
            if (pmiModuleConfigArray[0] != null) {
                PmiDataInfo[] pmiDataInfoArray = pmiModuleConfigArray[0].listData(string2);
                for (int i = 0; i < pmiDataInfoArray.length; ++i) {
                    if (pmiDataInfoArray[i].getSubmoduleName() != null) continue;
                    pmiModuleConfig.addData(pmiDataInfoArray[i]);
                }
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (pmiModuleConfigArray[i] == null) continue;
                if (debug) {
                    System.out.println("[StatsConfigHelper] adding config for: " + pmiModuleConfigArray[i].getUID());
                }
                object = pmiModuleConfigArray[i].listData(null);
                for (int j = 0; j < ((PmiDataInfo[])object).length; ++j) {
                    if (i != 0) {
                        if (!object[j].isAggregatable() || object[j].getType() == 15) continue;
                        pmiModuleConfig.addData(object[j]);
                        continue;
                    }
                    if (object[j].getType() == 15) continue;
                    pmiModuleConfig.addData(object[j]);
                }
            }
        }
        if (bl) {
            StatsConfigHelper.getConfigMap(locale).put(pmiModuleConfig.getUID(), pmiModuleConfig);
        } else {
            rawConfigMap.put(pmiModuleConfig.getUID(), pmiModuleConfig);
        }
        return pmiModuleConfig;
    }

    private static String _getStringFromRB(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static PmiModuleConfig translate(PmiModuleConfig pmiModuleConfig, Locale locale) {
        NLS nLS = StatsConfigHelper.getNLS(locale, pmiModuleConfig.getResourceBundle(), pmiModuleConfig.getUID());
        if (nLS != null) {
            try {
                pmiModuleConfig.setDescription(nLS.getString(pmiModuleConfig.getDescription()));
            }
            catch (MissingResourceException missingResourceException) {
                pmiModuleConfig.setDescription(pmiModuleConfig.getDescription());
            }
            PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig.listAllData();
            for (int i = 0; i < pmiDataInfoArray.length; ++i) {
                try {
                    pmiDataInfoArray[i].setName(nLS.getString(pmiDataInfoArray[i].getName(), pmiDataInfoArray[i].getName()));
                }
                catch (MissingResourceException missingResourceException) {
                    pmiDataInfoArray[i].setName(pmiDataInfoArray[i].getName());
                }
                try {
                    pmiDataInfoArray[i].setDescription(nLS.getString(pmiDataInfoArray[i].getDescription(), pmiDataInfoArray[i].getDescription()));
                }
                catch (MissingResourceException missingResourceException) {
                    pmiDataInfoArray[i].setDescription(pmiDataInfoArray[i].getDescription());
                }
                try {
                    pmiDataInfoArray[i].setUnit(nLS.getString(pmiDataInfoArray[i].getUnit()));
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    pmiDataInfoArray[i].setUnit(pmiDataInfoArray[i].getUnit());
                }
            }
        }
        return pmiModuleConfig;
    }

    public static void translateAndCache(PmiModuleConfig pmiModuleConfig, Locale locale) {
        PmiModuleConfig pmiModuleConfig2 = StatsConfigHelper.getConfig(locale, pmiModuleConfig.getUID());
        if (pmiModuleConfig2 == null) {
            pmiModuleConfig2 = pmiModuleConfig.copy();
            if (pmiModuleConfig2 != null) {
                PmiDataInfo[] pmiDataInfoArray = pmiModuleConfig2.listData(null);
                for (int i = pmiDataInfoArray.length - 1; i >= 0; --i) {
                    if (pmiDataInfoArray[i].getType() != 15) continue;
                    pmiModuleConfig2.removeData(pmiDataInfoArray[i]);
                }
            }
            pmiModuleConfig2 = StatsConfigHelper.translate(pmiModuleConfig2, locale);
            StatsConfigHelper.getConfigMap(locale).put(pmiModuleConfig2.getUID(), pmiModuleConfig2);
        }
    }

    public static PmiModuleConfig[] getAllConfigs(Locale locale) {
        HashMap hashMap = StatsConfigHelper.getConfigMap(locale);
        Iterator iterator = hashMap.values().iterator();
        PmiModuleConfig[] pmiModuleConfigArray = new PmiModuleConfig[hashMap.size()];
        int n = 0;
        while (iterator.hasNext()) {
            pmiModuleConfigArray[n++] = (PmiModuleConfig)iterator.next();
        }
        return pmiModuleConfigArray;
    }

    public static void initConfig(PmiModuleConfig[] pmiModuleConfigArray, Locale locale) {
        if (pmiModuleConfigArray == null) {
            return;
        }
        HashMap hashMap = StatsConfigHelper.getConfigMap(locale);
        for (int i = 0; i < pmiModuleConfigArray.length; ++i) {
            hashMap.put(pmiModuleConfigArray[i].getUID(), pmiModuleConfigArray[i]);
        }
    }

    private static String[] parseStatsType(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String getStatsType(int n) {
        switch (n) {
            case 2: {
                return "CountStatistic";
            }
            case 3: {
                return "DoubleStatistic";
            }
            case 4: {
                return "TimeStatistic";
            }
            case 5: {
                return "BoundedRangeStatistic";
            }
            case 6: {
                return "AverageStatistic";
            }
            case 7: {
                return "RangeStatistic";
            }
        }
        return "undefined";
    }

    public static String getLevelString(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "low";
            }
            case 3: {
                return "medium";
            }
            case 7: {
                return "high";
            }
            case 15: {
                return "maximum";
            }
        }
        return "undefined";
    }

    public static void main(String[] stringArray) {
        System.out.println(StatsConfigHelper.getTranslatedStatsName("root.MyStats", "com.ibm.websphere.fvt.pmi.custom.CustomStats1,com.ibm.websphere.fvt.pmi.custom.EmptyStats"));
        if (stringArray == null || stringArray.length < 2) {
            System.out.println("Usage: StatsConfigHelper <statsType> <r, e, t>");
            return;
        }
        debug = true;
        PmiModuleConfig pmiModuleConfig = null;
        if (stringArray[1].equals("r")) {
            pmiModuleConfig = StatsConfigHelper.getStatsConfig(stringArray[0]);
        } else if (stringArray[1].equals("e")) {
            pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(stringArray[0], null);
        } else if (stringArray[1].equals("t")) {
            pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(stringArray[0], new Locale(stringArray[2]));
        }
        if (pmiModuleConfig != null) {
            System.out.println(pmiModuleConfig.toString());
        } else {
            System.out.println("Config is null");
        }
        if (stringArray[1].equals("r")) {
            pmiModuleConfig = StatsConfigHelper.getStatsConfig(stringArray[0]);
        } else if (stringArray[1].equals("e")) {
            pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(stringArray[0], null);
        } else if (stringArray[1].equals("t")) {
            pmiModuleConfig = StatsConfigHelper.getTranslatedStatsConfig(stringArray[0], new Locale(stringArray[2]));
        }
        if (pmiModuleConfig != null) {
            System.out.println(pmiModuleConfig.toString());
        } else {
            System.out.println("Config is null");
        }
    }
}

