/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.dynamicproxy.StatsUtil;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class PmiStateObject {
    private static HashMap activeServerStats = new HashMap();
    private static HashMap idleServerStats = new HashMap();
    private static StatsImpl terminatedServerStats = null;
    private static TraceComponent tc = Tr.register(PmiStateObject.class, "PMI", null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(String string) {
        StatsImpl statsImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", string);
        }
        StatsImpl statsImpl2 = statsImpl = PerfPrivateLocal.get().getServerStats();
        synchronized (statsImpl2) {
            activeServerStats.put(string, statsImpl);
            Stack<StatsImpl> stack = new Stack<StatsImpl>();
            stack.push(statsImpl);
            while (!stack.empty()) {
                StatsImpl statsImpl3 = (StatsImpl)stack.pop();
                statsImpl3.setDataMembers(new ArrayList(0));
                StatsImpl[] statsImplArray = (StatsImpl[])statsImpl3.getSubStats();
                if (statsImplArray == null) continue;
                for (int i = 0; i < statsImplArray.length; ++i) {
                    stack.push(statsImplArray[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private static boolean isInitialized(String string) {
        return activeServerStats.containsKey(string);
    }

    public static void setActiveServerStats(String string, DataDescriptor dataDescriptor, StatsImpl statsImpl) {
        String string2;
        StatsImpl statsImpl2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStats", new Object[]{string, dataDescriptor, PmiStateObject.getStatsName(statsImpl)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStats - StatsImpl param", statsImpl);
        }
        if ((statsImpl2 = (StatsImpl)idleServerStats.get(string)) != null) {
            if (statsImpl2.getTime() >= statsImpl.getTime()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setStats - idle StatsImpl is newer, not storing");
                }
                return;
            }
            idleServerStats.remove(string);
        }
        if (dataDescriptor == null) {
            activeServerStats.put(string, statsImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setStats - Server StatsImpl (null DataDescriptor)");
            }
            return;
        }
        String[] stringArray = dataDescriptor.getPath();
        if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("pmi")) {
            activeServerStats.put(string, statsImpl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setStats - Server StatsImpl (null Path)");
            }
            return;
        }
        if (!PmiStateObject.isInitialized(string)) {
            PmiStateObject.initialize(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setStats - path", stringArray[0]);
        }
        StatsImpl statsImpl3 = (StatsImpl)activeServerStats.get(string);
        StatsImpl statsImpl4 = null;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string2 = stringArray[i];
            statsImpl4 = (StatsImpl)statsImpl3.getStats(string2);
            if (statsImpl4 == null) {
                statsImpl4 = new StatsImpl(string2, 0, 0, null, new ArrayList());
                statsImpl3.add(statsImpl4);
            }
            statsImpl3 = statsImpl4;
        }
        ArrayList<StatsImpl> arrayList = statsImpl3.subCollections();
        if (arrayList == null) {
            arrayList = new ArrayList<StatsImpl>();
            arrayList.add(statsImpl);
            statsImpl3.setSubcollections(arrayList);
        } else {
            string2 = statsImpl.getName();
            boolean bl = false;
            for (int i = 0; i < arrayList.size() && !bl; ++i) {
                if (!((StatsImpl)arrayList.get(i)).getName().equals(string2)) continue;
                arrayList.set(i, statsImpl);
                bl = true;
            }
            if (!bl) {
                arrayList.add(statsImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStats");
        }
    }

    public static StatsImpl getActiveServerStats(DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveServerStats", dataDescriptor);
        }
        StatsImpl statsImpl = PmiStateObject.combineFromHashMap(activeServerStats, dataDescriptor);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getActiveServerStats - return value", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveServerStats", PmiStateObject.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static StatsImpl getActiveServerStats(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getActiveServerStats", string);
        }
        if (!PmiStateObject.isInitialized(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getActiveServerStats - non existent server", null);
            }
            return null;
        }
        StatsImpl statsImpl = (StatsImpl)activeServerStats.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getActiveServerStats - return value", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getActiveServerStats", PmiStateObject.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static void addIdleServerStats(String string, StatsImpl statsImpl) {
        StatsImpl statsImpl2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addIdleServerStats", new Object[]{string, PmiStateObject.getStatsName(statsImpl)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdleServerStats - StatsImpl param", statsImpl);
        }
        if ((statsImpl2 = (StatsImpl)activeServerStats.get(string)) != null) {
            if (statsImpl2.getTime() > statsImpl.getTime()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addIdleServerStats - active StatsImpl is newer, not storing");
                }
                return;
            }
            activeServerStats.remove(string);
        }
        idleServerStats.put(string, statsImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addIdleServerStats");
        }
    }

    public static StatsImpl getIdleServerStats(DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdleServerStats(dd)", dataDescriptor);
        }
        StatsImpl statsImpl = PmiStateObject.combineFromHashMap(idleServerStats, dataDescriptor);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdleServerStats(dd) - return value", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdleServerStats(dd)", PmiStateObject.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static StatsImpl getIdleServerStats(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdleServerStats(stoken)", string);
        }
        StatsImpl statsImpl = (StatsImpl)activeServerStats.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getIdleServerStats(stoken) - return value", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdleServerStats(stoken)", PmiStateObject.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    public static void addTerminatedServerStats(String string, StatsImpl statsImpl) {
        WSStats[] wSStatsArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTerminatedStats", PmiStateObject.getStatsName(statsImpl));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addTerminatedStats - StatsImpl param", statsImpl);
        }
        if ((wSStatsArray = statsImpl.listSubStats()) != null) {
            for (int i = 0; i < wSStatsArray.length; ++i) {
                PmiStateObject.updateStatistics(wSStatsArray[i]);
            }
        }
        if (terminatedServerStats == null) {
            terminatedServerStats = statsImpl;
        } else {
            StatsUtil.aggregate(terminatedServerStats, statsImpl);
        }
        activeServerStats.remove(string);
        idleServerStats.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTerminatedStats");
        }
    }

    private static void updateStatistics(WSStats wSStats) {
        StatsImpl statsImpl;
        WSStatistic[] wSStatisticArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateStatistics", wSStats);
        }
        if ((wSStatisticArray = (statsImpl = (StatsImpl)wSStats).getStatistics()) != null) {
            ArrayList<WSStatistic> arrayList = new ArrayList<WSStatistic>();
            boolean bl = false;
            for (int i = 0; i < wSStatisticArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "statistics[" + i + "]", wSStatisticArray[i]);
                }
                if (wSStatisticArray[i].getDataInfo().isZosAggregatable()) {
                    arrayList.add(wSStatisticArray[i]);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "statistics[" + i + "] added to new list");
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "statistics[" + i + "] not added to new list");
                }
                bl = true;
            }
            if (bl) {
                statsImpl.setStatistics(arrayList);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stats updated", wSStats);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateStatistics");
        }
    }

    public static StatsImpl getTerminatedServerStats(DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTerminatedStats", dataDescriptor);
        }
        StatsImpl statsImpl = null;
        if (terminatedServerStats != null) {
            statsImpl = StatsUtil.findStats(terminatedServerStats, dataDescriptor);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTerminatedStats - return value", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTerminatedStats", PmiStateObject.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    private static synchronized StatsImpl combineFromHashMap(HashMap hashMap, DataDescriptor dataDescriptor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "combineFromHashMap", dataDescriptor);
        }
        StatsImpl statsImpl = null;
        StatsImpl statsImpl2 = null;
        String string = null;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            statsImpl2 = StatsUtil.findStats((StatsImpl)hashMap.get(string), dataDescriptor);
            if (statsImpl2 == null) continue;
            if (statsImpl == null) {
                statsImpl = StatsUtil.copyStats(statsImpl2);
                continue;
            }
            statsImpl = StatsUtil.combineAll(statsImpl, statsImpl2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "combineFromHashMap", statsImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "combineFromHashMap", PmiStateObject.getStatsName(statsImpl));
        }
        return statsImpl;
    }

    private static String getStatsName(StatsImpl statsImpl) {
        if (statsImpl == null) {
            return "null";
        }
        return statsImpl.getName();
    }
}

