/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.HostnameNormalizer;
import com.ibm.ws.ffdc.FFDCFilter;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.naming.NamingException;

public class DefaultHostnameNormalizer
implements HostnameNormalizer {
    private static final TraceComponent _tc = Tr.register(DefaultHostnameNormalizer.class, "Naming");
    private static Hashtable _cachedNormalizedHostname;

    public DefaultHostnameNormalizer() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHostnameNormalizer constructor ");
        }
    }

    public String normalizeHostname(boolean bl) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "normalizeHostname(boolean)");
        }
        return this.normalizeHostname(bl, "localhost");
    }

    public String normalizeHostname(boolean bl, String string) throws NamingException {
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname(boolean, String)", new String[]{"escapeDots=" + bl, "hostname=" + string});
        }
        if ((string2 = (String)_cachedNormalizedHostname.get(string)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Got cached host name: " + string2);
            }
            if (bl) {
                string2 = this.doEscapeDots(string2);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeHostname(boolean, String)", "returnHostname=" + string2);
            }
            return string2;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = string.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.util.DefaultHostnameNormalizer.normalizeHostname", "146", this);
            NamingException namingException = new NamingException("The normalizeHostname operation failed.  Please get the root cause contained in this NamingException for more information.");
            namingException.setRootCause(exception);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeHostname(boolean, String): Exception: ", namingException);
            }
            throw namingException;
        }
        string2 = this.normalizeHostname(bl, inetAddress, string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname(boolean, String)", "returnHostname=" + string2);
        }
        return string2;
    }

    public String normalizeHostname(boolean bl, InetAddress inetAddress) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "normalizeHostname(boolean, InetAddress");
        }
        return this.normalizeHostname(bl, inetAddress, null);
    }

    private String normalizeHostname(boolean bl, InetAddress inetAddress, String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname(boolean, InetAddress, String)", new String[]{"ipAddr=" + inetAddress, "hostname=" + string});
        }
        String string2 = string;
        String string3 = (String)_cachedNormalizedHostname.get(inetAddress);
        if (string3 == null) {
            try {
                String string4 = inetAddress.getHostAddress();
                string = InetAddress.getByName(string4).getHostName();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.util.DefaultHostnameNormalizer.normalizeHostname", "226", this);
                NamingException namingException = new NamingException("The normalizeHostname operation failed. Please get the root cause contained in this NamingException for more information.");
                namingException.setRootCause(exception);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "normalizeHostname(boolean, InetAddress, String)", namingException);
                }
                throw namingException;
            }
            string3 = string.toLowerCase();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caching hostname", new String[]{"ipAddr=" + inetAddress, "hostname=" + string3});
            }
            _cachedNormalizedHostname.put(inetAddress, string3);
            if (string2 != null) {
                _cachedNormalizedHostname.put(string2, string3);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Got cached host name: " + string3);
        }
        if (bl) {
            string3 = this.doEscapeDots(string3);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname(boolean, InetAddress, String)", "returnHostname=" + string3);
        }
        return string3;
    }

    private String doEscapeDots(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doescapeDots(String), hostname=" + string);
        }
        String string2 = "";
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n)) != -1) {
            string2 = string2 + string.substring(n, n2) + "\\.";
            n = n2 + 1;
        }
        if (n < string.length()) {
            string2 = string2 + string.substring(n);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doescapeDots(String), returnHostname=" + string2);
        }
        return string2;
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/DefaultHostnameNormalizer.java, WAS.naming.client, WAS61.SERV1, cf130745.06, ver. 1.12");
        }
        _cachedNormalizedHostname = new Hashtable();
    }
}

