/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.ldap.WsnLdapContextImpl;
import com.ibm.ws.naming.ldap.WsnLdapContextPerTreeInfo;
import com.ibm.ws.naming.ldap.WsnLdapHelpers;
import com.ibm.ws.naming.util.Helpers;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.spi.InitialContextFactory;
import org.omg.CORBA.ORB;

public class WsnLdapInitCtxFactory
implements InitialContextFactory {
    private static final TraceComponent tc = Tr.register(WsnLdapInitCtxFactory.class, "Naming");

    public WsnLdapInitCtxFactory() {
        Tr.entry(tc, "WsnLdapInitCtxFactory");
        Tr.exit(tc, "WsnLdapInitCtxFactory");
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        String string;
        Tr.entry(tc, "getInitialContext");
        if (hashtable.get("com.ibm.ws.naming.ldap.masterurl") == null) {
            throw new ConfigurationException("Url of Master LDAP Server not specified in property com.ibm.ws.naming.ldap.masterurl");
        }
        String string2 = (String)hashtable.get("com.ibm.ws.naming.ldap.masterurl");
        if (hashtable.get("com.ibm.ws.naming.ldap.noderootrdn") == null) {
            throw new ConfigurationException("LDAP DN of Host Root Context not specified in property com.ibm.ws.naming.ldap.noderootrdn");
        }
        String string3 = (String)hashtable.get("com.ibm.ws.naming.ldap.noderootrdn");
        if (hashtable.get("com.ibm.ws.naming.ldap.containerdn") == null) {
            throw new ConfigurationException("LDAP DN of Name Tree Container not specified in property com.ibm.ws.naming.ldap.containerdn");
        }
        String string4 = (String)hashtable.get("com.ibm.ws.naming.ldap.containerdn");
        String string5 = hashtable.get("com.ibm.ws.naming.ldap.ldapinitctxfactory") != null ? (String)hashtable.get("com.ibm.ws.naming.ldap.ldapinitctxfactory") : "com.sun.jndi.ldap.LdapCtxFactory";
        if (hashtable.get("com.ibm.websphere.naming.namespaceroot") != null) {
            string = (String)hashtable.get("com.ibm.websphere.naming.namespaceroot");
            if (!(string.equals("legacydomainroot") || string.equals("bootstraphostroot") || string.equals("treeinfrastructureroot"))) {
                throw new ConfigurationException("Property com.ibm.websphere.naming.namespaceroot=" + string + " is not a valid value");
            }
        } else {
            string = "legacydomainroot";
        }
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        hashtable2.put("java.naming.factory.initial", string5);
        hashtable2.put("java.naming.provider.url", string2);
        hashtable2.put("java.naming.ldap.derefAliases", "finding");
        WsnLdapHelpers.setupLdapProtocolTracing(hashtable2);
        InitialDirContext initialDirContext = null;
        DirContext dirContext = null;
        try {
            initialDirContext = new InitialDirContext(hashtable2);
            dirContext = (DirContext)initialDirContext.lookup("");
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ldap.WsnLdapInitCtxFactory.getInitialContext", "180", this);
            Helpers.closeIfContext(initialDirContext);
            Helpers.closeIfContext(dirContext);
            Tr.exit(tc, "Exception creating InitialDirContext for LDAP plug-in: " + namingException);
            throw namingException;
        }
        String string6 = null;
        string6 = string.equals("treeinfrastructureroot") ? WsnLdapHelpers.doubleEscapeEscapes(string4) : WsnLdapHelpers.doubleEscapeEscapes(string3 + "," + string4);
        DirContext dirContext2 = null;
        try {
            dirContext2 = (DirContext)dirContext.lookup(string6);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ldap.WsnLdapInitCtxFactory.getInitialContext", "202", this);
            Helpers.closeIfContext(dirContext);
            Tr.exit(tc, "lookup failed for WebSphere Name Tree at: " + string6 + " -- Exception: " + namingException);
            throw namingException;
        }
        ORB oRB = Helpers.getOrb(hashtable);
        WsnLdapContextPerTreeInfo wsnLdapContextPerTreeInfo = new WsnLdapContextPerTreeInfo(dirContext, dirContext2, string6, string2, string4, string3, "", "", oRB);
        Context context = new WsnLdapContextImpl(hashtable, dirContext2, wsnLdapContextPerTreeInfo);
        if (string.equals("legacydomainroot")) {
            WsnLdapContextImpl wsnLdapContextImpl = context;
            context = null;
            String string7 = null;
            try {
                string7 = "ibm-wsnName=domain," + string6;
                Context context2 = (Context)wsnLdapContextImpl.lookup("domain");
                string7 = "ibm-wsnName=legacyRoot," + string7;
                context = (Context)context2.lookup("legacyRoot");
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.ldap.WsnLdapInitCtxFactory.getInitialContext", "250", this);
                Helpers.closeIfContext(dirContext);
                Helpers.closeIfContext(dirContext2);
                Tr.exit(tc, "lookup failed for WebSphere Name Tree at: " + string7 + " -- Exception: " + namingException);
                throw namingException;
            }
        }
        Tr.exit(tc, "getInitialContext");
        return context;
    }
}

