/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jcache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.jcache.Cache;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.jcache.CacheKey;
import com.ibm.ws.naming.jcache.JavaNameSpaceCacheContainer;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class CacheManager {
    private static final String kIBMCopyright = "(c) Copyright IBM Corporation 2000, 2005";
    private static final TraceComponent _tc = Tr.register(CacheManager.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static HashMap _caches;
    private static HashMap _javaNameSpaceCaches;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCache(Hashtable hashtable) throws CacheInvalidPropertyValueException {
        String string = Cache.cacheObjectPropertyValue(hashtable);
        boolean bl = false;
        if (string.equals("none")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCache: caching disabled");
            }
            return null;
        }
        String string2 = Cache.cacheNameFromPropertyValue(hashtable);
        CacheKey cacheKey = new CacheKey(string2);
        Cache cache = null;
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            cache = (Cache)_caches.get(cacheKey);
            if (cache == null) {
                cache = new Cache(string2, cacheKey.getClassLoader(), hashtable);
                _caches.put(cacheKey, cache);
                bl = true;
            }
        }
        if (!bl) {
            cache.setLifetimeProperties(hashtable);
            if (string.equals("cleared")) {
                cache.clear();
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCache: returning cache", cacheKey.toString());
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cache getCacheUsingName(String string, Hashtable hashtable) throws CacheInvalidPropertyValueException {
        String string2 = Cache.cacheObjectPropertyValue(hashtable);
        boolean bl = false;
        if (string2.equals("none")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCacheUsingName: caching disabled");
            }
            return null;
        }
        Cache cache = null;
        CacheKey cacheKey = new CacheKey(string);
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            cache = (Cache)_caches.get(cacheKey);
            if (cache == null) {
                cache = new Cache(string, cacheKey.getClassLoader(), hashtable);
                _caches.put(cacheKey, cache);
                bl = true;
            }
        }
        if (!bl) {
            cache.setLifetimeProperties(hashtable);
            if (string2.equals("cleared")) {
                cache.clear();
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCacheUsingName: returning cache", cacheKey.toString());
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getJavaNameSpaceCache(Integer n, Hashtable hashtable) throws CacheInvalidPropertyValueException {
        String string = Cache.cacheObjectPropertyValue(hashtable);
        if (string.equals("none")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getJavaNameSpaceCache: caching disabled");
            }
            return null;
        }
        Hashtable hashtable2 = null;
        JavaNameSpaceCacheContainer javaNameSpaceCacheContainer = null;
        boolean bl = false;
        HashMap hashMap = _javaNameSpaceCaches;
        synchronized (hashMap) {
            javaNameSpaceCacheContainer = (JavaNameSpaceCacheContainer)_javaNameSpaceCaches.get(n);
            if (javaNameSpaceCacheContainer == null) {
                hashtable2 = new Hashtable();
                ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                javaNameSpaceCacheContainer = new JavaNameSpaceCacheContainer(hashtable2, n, classLoader);
                _javaNameSpaceCaches.put(n, javaNameSpaceCacheContainer);
                bl = true;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getJavaNameSpaceCache: created new cache", "associatedClassLoader=" + classLoader);
                }
            } else {
                hashtable2 = javaNameSpaceCacheContainer.getCache();
            }
        }
        if (!bl && string.equals("cleared")) {
            hashtable2.clear();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getJavaNameSpaceCache: cache cleared");
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getJavaNameSpaceCache: returning java name space cache", n.toString());
        }
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllCaches() {
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            Iterator iterator = _caches.values().iterator();
            while (iterator.hasNext()) {
                Cache cache = (Cache)iterator.next();
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJavaNameSpaceCaches(ClassLoader classLoader) {
        HashMap hashMap = _javaNameSpaceCaches;
        synchronized (hashMap) {
            Iterator iterator = _javaNameSpaceCaches.values().iterator();
            while (iterator.hasNext()) {
                JavaNameSpaceCacheContainer javaNameSpaceCacheContainer = (JavaNameSpaceCacheContainer)iterator.next();
                if (!javaNameSpaceCacheContainer.getAssociatedClassLoader().equals(classLoader)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Clearing java name space cache.", "cacheKey=" + javaNameSpaceCacheContainer.getCacheKey().toString());
                }
                javaNameSpaceCacheContainer.getCache().clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCaches(ClassLoader classLoader) {
        ClassLoader classLoader2;
        Object object;
        Iterator<Object> iterator;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeCaches", "searchClassLoader=" + classLoader);
        }
        HashMap hashMap = _caches;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Number of JNDI / CosNaming caches: " + _caches.size());
            }
            iterator = _caches.keySet().iterator();
            while (iterator.hasNext()) {
                object = (CacheKey)iterator.next();
                classLoader2 = ((CacheKey)object).getClassLoader();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cacheClassLoader=" + classLoader2);
                }
                if (!classLoader2.equals(classLoader)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Removing cache.", "cacheKey=" + ((CacheKey)object).toString());
                }
                iterator.remove();
            }
        }
        hashMap = _javaNameSpaceCaches;
        synchronized (hashMap) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Number of Java name space caches: " + _javaNameSpaceCaches.size());
            }
            iterator = _javaNameSpaceCaches.values().iterator();
            while (iterator.hasNext()) {
                object = (JavaNameSpaceCacheContainer)iterator.next();
                classLoader2 = ((JavaNameSpaceCacheContainer)object).getAssociatedClassLoader();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cacheClassLoader=" + classLoader2);
                }
                if (!classLoader2.equals(classLoader)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Removing java name space cache.", "cacheKey=" + ((JavaNameSpaceCacheContainer)object).getCacheKey().toString());
                }
                iterator.remove();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeCaches");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jcache/CacheManager.java, WAS.naming.client, WAS61.SERV1, cf130745.06, ver. 1.14");
        }
        _caches = new HashMap();
        _javaNameSpaceCaches = new HashMap();
    }
}

