/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DocumentDigestImpl
implements DocumentDigest,
Serializable {
    private static final long serialVersionUID = 3015221028590796750L;
    private byte[] digest = null;
    private transient MessageDigest messageDigest = null;
    private transient DigestInputStream inputFilter = null;
    private transient DigestOutputStream outputFilter = null;
    private static TraceComponent tc = Tr.register(DocumentDigestImpl.class, "ConfigRepository", "com.ibm.ws.management.resources.repository");

    DocumentDigestImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DocumentDigestImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DocumentDigestImpl");
        }
    }

    DocumentDigestImpl(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DocumentDigestImpl(data)");
        }
        this.calc(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DocumentDigestImpl(data)");
        }
    }

    DocumentDigestImpl(InputStream inputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DocumentDigestImpl(stream)");
        }
        this.calc(inputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DocumentDigestImpl(stream)");
        }
    }

    DocumentDigestImpl(MessageDigest messageDigest) {
        this.digest = messageDigest.digest();
    }

    protected byte[] getDigest() {
        return this.digest;
    }

    protected void calc(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "calc(byte[])");
        }
        MessageDigest messageDigest = null;
        messageDigest = this.getMessageDigest();
        if (messageDigest != null) {
            messageDigest.update(byArray);
            this.digest = messageDigest.digest();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "calc(byte[])", this.digest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calc(InputStream inputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "calc(stream)");
        }
        byte[] byArray = new byte[4096];
        try {
            MessageDigest messageDigest = null;
            messageDigest = this.getMessageDigest();
            if (messageDigest != null) {
                int n;
                while ((n = inputStream.read(byArray)) > 0) {
                    messageDigest.update(byArray, 0, n);
                }
                this.digest = messageDigest.digest();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.DocumentDigestImpl.calc", "113", this);
            Tr.service(tc, "ADMR0200E", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.DocumentDigestImpl.calc", "114", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "calc(stream)", this.digest);
        }
    }

    public boolean equals(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(digest)");
        }
        boolean bl = false;
        if (object != null && this.getClass().isInstance(object)) {
            DocumentDigestImpl documentDigestImpl = (DocumentDigestImpl)object;
            bl = this.compareDigestBytes(documentDigestImpl.getDigest());
        } else {
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "arg is null");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "arg is of type " + object.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(digest): " + bl);
        }
        return bl;
    }

    public boolean equals(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(byte[])");
        }
        boolean bl = this.equals(new DocumentDigestImpl(byArray));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(byte[]): " + bl);
        }
        return bl;
    }

    public boolean equals(InputStream inputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals(stream)");
        }
        boolean bl = this.equals(new DocumentDigestImpl(inputStream));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "equals(stream): " + bl);
        }
        return bl;
    }

    public String toString() {
        int n = 0;
        String string = new String();
        if (this.digest != null) {
            for (int i = 0; i < this.digest.length; ++i) {
                n = this.digest[i] < 0 ? this.digest[i] + 256 : this.digest[i];
                string = string + Integer.toString(n / 16, 16) + Integer.toString(n % 16, 16);
            }
        }
        return string;
    }

    private boolean compareDigestBytes(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareDigestBytes");
        }
        boolean bl = true;
        if (this.digest != null && byArray != null && this.digest.length == byArray.length) {
            for (int i = 0; i < this.digest.length; ++i) {
                if (this.digest[i] == byArray[i]) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareDigestBytes: " + bl);
        }
        return bl;
    }

    private MessageDigest getMessageDigest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageDigest");
        }
        if (this.messageDigest == null) {
            try {
                this.messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, "com.ibm.ws.management.repository.DocumentDigestImpl.getMessageDigest", "227", this);
                Tr.error(tc, "ADMR0201E");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageDigest");
        }
        return this.messageDigest;
    }

    protected InputStream startInputFilter(InputStream inputStream) {
        this.inputFilter = new DigestInputStream(inputStream, this.getMessageDigest());
        return this.inputFilter;
    }

    protected void stopInputFilter() {
        if (this.messageDigest != null) {
            this.digest = this.messageDigest.digest();
        }
        try {
            if (this.inputFilter != null) {
                this.inputFilter.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.DocumentDigestImpl.calc", "284", this);
        }
    }

    protected OutputStream startOutputFilter(OutputStream outputStream) {
        this.outputFilter = new DigestOutputStream(outputStream, this.getMessageDigest());
        return this.outputFilter;
    }

    protected void stopOutputFilter() {
        if (this.messageDigest != null) {
            this.digest = this.messageDigest.digest();
        }
        try {
            if (this.outputFilter != null) {
                this.outputFilter.close();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.repository.DocumentDigestImpl.calc", "310", this);
        }
    }
}

