/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.filetransfer.client;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.FileTransferConfig;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.FileTransferOptions;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.filetransfer.FileTransferConfigImpl;
import com.ibm.ws.management.filetransfer.FileTransferUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.management.JMException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.net.ssl.HttpsURLConnection;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class FileTransferClientImpl
implements FileTransferClient,
NotificationListener {
    private static TraceComponent tc = Tr.register(FileTransferClientImpl.class, "Admin", "com.ibm.ws.management.resources.fileservice");
    private static String UTF_ENCODING = "UTF-8";
    String transferHost = null;
    int transferPort = 0;
    int transferSecurePort = 0;
    String ftServerName = null;
    boolean securityEnabled = false;
    boolean setAuthHeader = false;
    String protocolToUse = "http";
    int portToUse = 0;
    String serverStagingLocation = null;
    FileTransferConfig ftConfig = null;
    VariableMap vmap = null;
    int defaultBufferSize = 8192;
    private Properties jmxConnProps = null;
    private AdminClient adminClient = null;
    private ObjectName ftServerObjName = null;
    private int retryLimit = FileTransferConfigImpl.DEFAULT_RETRIES;
    private int retryWaitTime = FileTransferConfigImpl.DEFAULT_TIMEOUT;
    private RoleBasedAuthorizer roleBasedAuth = null;
    private String userInstallRoot = null;
    private static String downloadPathsNotRestricted = null;
    private static boolean downloadPathsUnrestricted = false;

    public void uploadFile(InputStream inputStream, String string) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.uploadFile(inputStream, string, fileTransferOptions);
    }

    public void uploadFile(File file, String string) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.uploadFile(file, string, fileTransferOptions);
    }

    public void uploadFile(InputStream inputStream, String string, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        int n = 0;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uploadFile (1) from InputStream, destPath=" + string + "options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("overwrite");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isOverwrite()));
            stringBuffer.append("&");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "upload url=" + uRL);
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("PUT");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
            this.addAuthHeader(httpURLConnection);
            this.connectToServer(httpURLConnection);
            FilterOutputStream filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            if (fileTransferOptions.isCompress()) {
                filterOutputStream = new GZIPOutputStream(filterOutputStream);
            }
            byte[] byArray = new byte[this.defaultBufferSize];
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                ((OutputStream)filterOutputStream).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            inputStream.close();
            ((OutputStream)filterOutputStream).flush();
            ((OutputStream)filterOutputStream).close();
            n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new TransferFailedException("File upload to " + string + " failed with rc = " + n);
            }
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0124", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during upload to: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFile", "245", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0124", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during upload to: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadFile (1) rc=" + n);
            }
        }
    }

    public void uploadFile(File file, String string, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        file = this.mapVariables(file);
        this.uploadFile(file, string, 0L, file.length(), fileTransferOptions);
    }

    public void uploadFile(File file, String string, long l) throws TransferFailedException, IndexOutOfBoundsException {
        file = this.mapVariables(file);
        this.uploadFile(file, string, l, file.length());
    }

    public void uploadFile(File file, String string, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException, IndexOutOfBoundsException {
        file = this.mapVariables(file);
        this.uploadFile(file, string, l, file.length(), fileTransferOptions);
    }

    public void uploadFile(File file, String string, long l, long l2) throws TransferFailedException, IndexOutOfBoundsException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.uploadFile(file, string, l, l2, fileTransferOptions);
    }

    public void uploadFile(File file, String string, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException, IndexOutOfBoundsException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "uploadFile (2) from srcFile=" + file + ", destPath=" + string + "options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (l > l2 || l < 0L) {
                throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "] for " + file.toString() + ".");
            }
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("overwrite");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isOverwrite()));
            stringBuffer.append("&");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "upload url=" + uRL);
            }
            this.uploadFileInternal(uRL, file, l, l2, fileTransferOptions);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0124", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during upload to: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFile", "415", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0124", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during upload to: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadFile (2)");
            }
        }
    }

    private void uploadFileInternal(URL uRL, File file, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException, IOException {
        RandomAccessFile randomAccessFile = null;
        OutputStream outputStream = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uploadInternal");
        }
        try {
            String string = this.mapVariables(file.toString());
            file = new File(string);
            randomAccessFile = new RandomAccessFile(file, "r");
            boolean bl = false;
            if ((l != 0L || randomAccessFile.length() != 0L) && l >= randomAccessFile.length()) {
                randomAccessFile.close();
                throw new IndexOutOfBoundsException("The rangeStart goes past the end of the file. Nothing will be transferred.  rangeStart=[" + l + "] for " + file.toString() + ".");
            }
            long l3 = 0x100000L;
            long l4 = 0L;
            long l5 = 0L;
            int n = (int)Math.min((long)this.defaultBufferSize, l3);
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            while (n2 <= this.retryLimit) {
                try {
                    randomAccessFile.seek(l);
                    l4 = l;
                    l5 = l2 > l && l2 - l < l3 ? l2 : l4 + l3;
                    bl3 = false;
                    while (!bl2) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod("PUT");
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setRequestProperty("file-append", bl3 ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        httpURLConnection.setRequestProperty("file-timestamp", Long.toString(file.lastModified()));
                        httpURLConnection.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
                        this.addAuthHeader(httpURLConnection);
                        this.connectToServer(httpURLConnection);
                        outputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                        if (fileTransferOptions.isCompress()) {
                            outputStream = new GZIPOutputStream(outputStream);
                        }
                        byte[] byArray = new byte[n];
                        int n3 = randomAccessFile.read(byArray);
                        boolean bl4 = false;
                        while (n3 != -1) {
                            outputStream.write(byArray, 0, (int)Math.min((long)n3, l5 - l4));
                            if (randomAccessFile.getFilePointer() < l5) {
                                if (randomAccessFile.getFilePointer() + (long)this.defaultBufferSize > l5) {
                                    n3 = randomAccessFile.read(byArray, 0, (int)(l5 - randomAccessFile.getFilePointer()));
                                    continue;
                                }
                                n3 = randomAccessFile.read(byArray);
                                continue;
                            }
                            n3 = -1;
                        }
                        if (outputStream instanceof GZIPOutputStream) {
                            ((GZIPOutputStream)outputStream).finish();
                        }
                        outputStream.flush();
                        outputStream.close();
                        String string2 = httpURLConnection.getHeaderField(0);
                        if (string2 != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                            String string3 = stringTokenizer.nextToken();
                            String string4 = stringTokenizer.nextToken();
                            int n4 = Integer.parseInt(string4);
                            if (n4 != 200) {
                                String string5 = string2.substring(string2.indexOf(string4));
                                throw new TransferFailedException(string5 + " (for: " + file.toString() + ").");
                            }
                        } else {
                            int n5 = httpURLConnection.getResponseCode();
                            if (n5 != 200) {
                                throw new TransferFailedException(httpURLConnection.getResponseMessage() + " (for: " + file.toString() + ").");
                            }
                        }
                        if (l5 >= l2) {
                            bl2 = true;
                            continue;
                        }
                        bl3 = true;
                        l4 = l5;
                        if (l2 == 0L || (l5 += l3) <= l2) continue;
                        l5 = l2;
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    if (fileTransferOptions.isDeleteSourceOnCompletion()) {
                        file.delete();
                    }
                    break;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFileInternal", "566", this);
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (++n2 > this.retryLimit) {
                        String string6 = "Upload retry limit exceeded for file " + file.toString() + ". Exception: " + iOException.toString();
                        Tr.error(tc, "ADFS0112", string6 + ".");
                        throw new TransferFailedException(string6, iOException);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file upload for: " + file.toString());
                        Tr.debug(tc, "Exception: " + iOException.toString());
                    }
                    try {
                        Thread.sleep(this.retryWaitTime * 1000);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), iOException);
            }
            Tr.service(tc, "ADFS0124", new Object[]{uRL, iOException});
            throw new TransferFailedException("Error occurred during upload to: " + uRL.toString() + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.uploadFileInternal", "601", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), throwable);
            }
            Tr.service(tc, "ADFS0124", new Object[]{uRL, throwable});
            throw new TransferFailedException("Error occurred during upload to: " + uRL.toString() + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "uploadInternal");
            }
        }
    }

    public InputStream downloadFile(String string, long l, long l2) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        return this.downloadFile(string, l, l2, fileTransferOptions);
    }

    public void downloadFile(String string, File file, long l, long l2) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.downloadFile(string, file, l, l2, fileTransferOptions);
    }

    public InputStream downloadFile(String string, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (1) to InputStream. srcPath=" + string + ", rangeStart=" + l + "rangeEnd=" + l2);
            }
            if (l > l2 || l < 0L) {
                throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "] for " + string + ".");
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("rangeStart");
            stringBuffer.append("=");
            stringBuffer.append(l);
            stringBuffer.append("&");
            stringBuffer.append("rangeEnd");
            stringBuffer.append("=");
            stringBuffer.append(l2);
            stringBuffer.append("&");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            stringBuffer.append("&");
            stringBuffer.append("deleteOnCompletion");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            InputStream inputStream = this.download(uRL, fileTransferOptions.isCompress(), null);
            return inputStream;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", "725", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (1)");
            }
        }
    }

    public void downloadFile(String string, File file, long l, long l2, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (2) to file. srcPath=" + string + ", destFile=" + file.toString() + ", rangeStart=" + l + "rangeEnd=" + l2 + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (l > l2 || l < 0L) {
                throw new IndexOutOfBoundsException("The [rangeStart, rangeEnd] values are not valid [" + l + ", " + l2 + "] for " + string + ".");
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("rangeStart");
            stringBuffer.append("=");
            stringBuffer.append(l);
            stringBuffer.append("&");
            stringBuffer.append("rangeEnd");
            stringBuffer.append("=");
            stringBuffer.append(l2);
            stringBuffer.append("&");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            stringBuffer.append("&");
            stringBuffer.append("deleteOnCompletion");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            this.download(uRL, file, fileTransferOptions.isCompress(), l, l2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", "826", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (2)");
            }
        }
    }

    public InputStream downloadFile(String string, long l) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        return this.downloadFile(string, l, fileTransferOptions);
    }

    public void downloadFile(String string, File file, long l) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.downloadFile(string, file, l, fileTransferOptions);
    }

    public InputStream downloadFile(String string, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (3) to InputStream. srcPath=" + string + ", rangeStart=" + l + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (l < 0L) {
                throw new IndexOutOfBoundsException("The rangeStart value is not valid [" + l + "] for " + string + ".");
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("rangeStart");
            stringBuffer.append("=");
            stringBuffer.append(l);
            stringBuffer.append("&");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            stringBuffer.append("&");
            stringBuffer.append("deleteOnCompletion");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            InputStream inputStream = this.download(uRL, fileTransferOptions.isCompress(), null);
            return inputStream;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", "940", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (3)");
            }
        }
    }

    public void downloadFile(String string, File file, long l, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (4) to file. srcPath=" + string + ", destFile=" + file.toString() + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (l < 0L) {
                throw new IndexOutOfBoundsException("The rangeStart value is not valid [" + l + "] for " + string + ".");
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("rangeStart");
            stringBuffer.append("=");
            stringBuffer.append(l);
            stringBuffer.append("&");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            stringBuffer.append("&");
            stringBuffer.append("deleteOnCompletion");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            this.download(uRL, file, fileTransferOptions.isCompress(), l, 0L);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, indexOutOfBoundsException);
            }
            throw indexOutOfBoundsException;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", "1026", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (4)");
            }
        }
    }

    public InputStream downloadFile(String string) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        return this.downloadFile(string, fileTransferOptions);
    }

    public void downloadFile(String string, File file) throws TransferFailedException {
        FileTransferOptions fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
        this.downloadFile(string, file, fileTransferOptions);
    }

    public InputStream downloadFile(String string, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (5) to InputStream. srcPath=" + string + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            if (string.startsWith("\\")) {
                string = string.substring(1);
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            this.checkAccessPermission(string);
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            stringBuffer.append("&");
            stringBuffer.append("deleteOnCompletion");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            InputStream inputStream = this.download(uRL, fileTransferOptions.isCompress(), null);
            return inputStream;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", "1121", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (5)");
            }
        }
    }

    public void downloadFile(String string, File file, FileTransferOptions fileTransferOptions) throws TransferFailedException {
        URL uRL = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadFile (6) to file. srcPath=" + string + ", destFile=" + file.toString() + ", options=" + (fileTransferOptions == null ? "null" : fileTransferOptions.toString()));
            }
            if (fileTransferOptions == null) {
                fileTransferOptions = (FileTransferOptions)ImplFactory.loadImplFromKey(FileTransferOptions.class);
            }
            this.checkAccessPermission(string);
            if (string.startsWith("\\") || string.startsWith("/")) {
                string = string.substring(1);
            }
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("/FileTransfer/transfer/");
            stringBuffer.append(this.encode(string));
            stringBuffer.append("?");
            stringBuffer.append("compress");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isCompress()));
            stringBuffer.append("&");
            stringBuffer.append("deleteOnCompletion");
            stringBuffer.append("=");
            stringBuffer.append(String.valueOf(fileTransferOptions.isDeleteSourceOnCompletion()));
            uRL = new URL(this.protocolToUse, this.transferHost, this.portToUse, stringBuffer.toString());
            this.download(uRL, file, fileTransferOptions.isCompress(), 0L, 0L);
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, transferFailedException);
            }
            throw transferFailedException;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, iOException});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + iOException.toString(), iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.downloadFile", "1195", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string, throwable);
            }
            Tr.service(tc, "ADFS0125", new Object[]{string, throwable});
            throw new TransferFailedException("Error occurred during download from: " + string + ". Exception: " + throwable.toString(), throwable);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadFile (6)");
            }
        }
    }

    protected InputStream download(URL uRL, boolean bl, ResultsObject resultsObject) throws TransferFailedException, IOException {
        try {
            HttpURLConnection httpURLConnection;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "download (7) url=" + uRL + ", compress=" + bl);
            }
            int n = 0;
            while (n <= this.retryLimit) {
                String string;
                Object object;
                block57: {
                    httpURLConnection = null;
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.setRequestProperty("file-transfer-uri-encoding", UTF_ENCODING);
                    httpURLConnection.setDoOutput(false);
                    httpURLConnection.setDoInput(true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling addAuthHeader from download (7)");
                    }
                    this.addAuthHeader(httpURLConnection);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Back from addAuthHeader from download (7) .. connecting to server");
                    }
                    this.connectToServer(httpURLConnection);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connected to server");
                    }
                    try {
                        Object object2;
                        int n2 = 0;
                        object = null;
                        string = httpURLConnection.getHeaderField(0);
                        if (string != null) {
                            object2 = new StringTokenizer(string, " ");
                            String string2 = ((StringTokenizer)object2).nextToken();
                            String string3 = ((StringTokenizer)object2).nextToken();
                            n2 = Integer.parseInt(string3);
                            try {
                                object = string.substring(string.indexOf(string3)) + " for " + uRL.toString() + ".";
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                object = "No such element exception for " + uRL.toString() + ".";
                            }
                        }
                        if (n2 == 401) {
                            if (!this.securityEnabled) {
                                throw new TransferFailedException("Received HTTP_UNAUTHORIZED but security is not enabled for " + uRL.toString() + ".");
                            }
                            this.setAuthHeader = true;
                            if (++n <= this.retryLimit) continue;
                            object2 = "Can not authorize " + uRL.toString() + ".";
                            Tr.error(tc, "ADFS0112", object2);
                            throw new TransferFailedException((String)object2);
                        }
                        object2 = null;
                        try {
                            object2 = httpURLConnection.getHeaderField("file-at-end");
                            if (object2 == null) {
                                object2 = Boolean.FALSE.toString();
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "NoSuchElementException caught!");
                            }
                            object2 = Boolean.FALSE.toString();
                        }
                        if (tc.isDebugEnabled()) {
                            if (object2 == null) {
                                Tr.debug(tc, "eof = null");
                            } else {
                                Tr.debug(tc, "eof = " + (String)object2);
                            }
                        }
                        long l = 0L;
                        String string4 = null;
                        try {
                            string4 = httpURLConnection.getHeaderField("file-timestamp");
                            if (string4 != null) {
                                l = Long.parseLong(string4);
                            }
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception encountered getting time out of file header!");
                            }
                            l = 0L;
                        }
                        if (string4 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "time = " + string4);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "time is null!");
                        }
                        if (resultsObject != null) {
                            resultsObject.eof = ((String)object2).equals(Boolean.TRUE.toString());
                            resultsObject.statusCode = n2;
                            resultsObject.msg = object;
                            resultsObject.lastModified = l;
                        }
                        if (n2 == 416) {
                            throw new IndexOutOfBoundsException("File download failed [" + n2 + "]." + "Message: " + (String)object);
                        }
                        if (n2 > 401) {
                            throw new TransferFailedException("File download failed [" + n2 + "]." + "Message: " + (String)object);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "statusCode = " + n2);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    InputStream inputStream = httpURLConnection.getInputStream();
                    if (inputStream == null) break block57;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Encoding = " + httpURLConnection.getContentEncoding() + "; Content type = " + httpURLConnection.getContentType() + "; Length = " + httpURLConnection.getContentLength());
                    }
                    inputStream = new DataInputStream(inputStream);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "download(7): available bytes = " + inputStream.available() + " in input stream");
                    }
                    if (bl) {
                        inputStream = new GZIPInputStream(inputStream, this.defaultBufferSize);
                    }
                    object = inputStream;
                    return object;
                }
                try {
                    int n3 = httpURLConnection.getResponseCode();
                    string = httpURLConnection.getResponseMessage() + " for " + uRL.toString() + ".";
                    throw new TransferFailedException("File download failed [" + n3 + "]." + "Message: " + string);
                }
                catch (EOFException eOFException) {
                    if (httpURLConnection != null) {
                        int n4 = httpURLConnection.getResponseCode();
                        string = httpURLConnection.getResponseMessage();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "rc = " + n4 + "; msg = " + string);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EOFException encountered!");
                    }
                    InputStream inputStream = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "download (7)");
                    }
                    return inputStream;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.download", "1330", this);
                    if (++n > this.retryLimit) {
                        object = "Download retry limit exceeded for retrieving url " + uRL.toString() + ".";
                        Tr.error(tc, "ADFS0112", object);
                        throw iOException;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file download for: " + uRL.toString());
                        Tr.debug(tc, "RetryCount = " + n + "; Exception: " + iOException.toString());
                    }
                    try {
                        Thread.sleep(this.retryWaitTime * 1000);
                    }
                    catch (Exception exception) {}
                }
            }
            httpURLConnection = null;
            return httpURLConnection;
        }
        catch (TransferFailedException transferFailedException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), transferFailedException);
            }
            throw transferFailedException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), fileNotFoundException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{uRL, fileNotFoundException});
            throw new TransferFailedException("The file to download was not found on the server or the start range is too large =" + uRL, fileNotFoundException);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "download (7)");
            }
        }
    }

    protected void download(URL uRL, File file, boolean bl, long l, long l2) throws TransferFailedException {
        String string = file.toString();
        File file2 = null;
        File file3 = file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "download (8) to file. url=" + uRL + ", destFile=" + string + ", compress=" + bl);
        }
        if (file.exists()) {
            if (file.canWrite()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Destination file already exists: Old Download: " + file.toString());
                }
                file = file2 = this.getTempFile(file);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Destination file already exists: New Download: " + file.toString());
                }
                string = file.toString();
            } else {
                String string2 = "No write access to " + file.toString() + ". File permissions will not allow download to succeed.";
                Tr.error(tc, "ADFS0112", string2);
                throw new TransferFailedException(string2);
            }
        }
        int n = 0;
        boolean bl2 = false;
        URL uRL2 = uRL;
        if (string.startsWith("${REPROOT}")) {
            string = string.substring("${REPROOT}".length());
            string = this.getRepositoryTempDir() + string.substring(1);
        } else {
            string = this.mapVariables(string);
        }
        string = string.replace('/', File.separatorChar);
        string = string.replace('\\', File.separatorChar);
        if (!string.equals(file.toString())) {
            file = new File(string);
        }
        if (downloadPathsNotRestricted == null) {
            downloadPathsNotRestricted = "false";
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService == null) {
                downloadPathsNotRestricted = "true";
                downloadPathsUnrestricted = true;
            } else {
                String string3 = System.getProperty("com.ibm.websphere.management.filetransfer.downloadPathsNotRestricted");
                if (string3 != null && string3.equalsIgnoreCase("true")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.websphere.management.filetransfer.downloadPathsNotRestricted=true!");
                    }
                    downloadPathsNotRestricted = "true";
                    downloadPathsUnrestricted = true;
                }
            }
        }
        if (!downloadPathsUnrestricted) {
            this.verifyDestPathChildOfRootInstallPath(file);
        }
        long l3 = l;
        String string4 = null;
        while (n <= this.retryLimit) {
            try {
                this.downloadInternal(uRL, file, bl, bl2, l3, l2);
                if (file2 == null) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Call writeTempBackToOrig(" + file + ", " + file3 + ");");
                }
                this.writeTempBackToOrig(file, file3);
                if (!file.delete()) {
                    String string5 = "Delete of temporary file, " + file.toString() + ", failed. File should be deleted.";
                    Tr.error(tc, "ADFS0112", string5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string5);
                    }
                    throw new TransferFailedException(string5);
                }
                break;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.download", "1422", this);
                if (string4 == null) {
                    string4 = iOException.toString();
                }
                if (++n > this.retryLimit) {
                    String string6;
                    if (file2 != null) {
                        if (!file.delete()) {
                            string6 = "Delete of temporary file, " + file.toString() + ", failed. File should be deleted.";
                            Tr.error(tc, "ADFS0112", string6);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, string6);
                            }
                        }
                    } else if (!file.delete()) {
                        string6 = "Download retry limit exceeded: Delete of partially downloaded file, " + file.toString() + ", failed (First exception: " + string4 + ").";
                        Tr.error(tc, "ADFS0112", string6);
                    }
                    string6 = "Download retry limit exceeded for file " + file.toString() + ". (First exception: " + string4 + ").";
                    Tr.error(tc, "ADFS0112", string6);
                    throw new TransferFailedException(string6, iOException);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Wait " + this.retryWaitTime + " seconds and retry file download for: " + file.toString());
                    Tr.debug(tc, "Retry count = " + n + "; Exception message: " + iOException.toString());
                }
                try {
                    Thread.sleep(this.retryWaitTime * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!file.exists()) continue;
                bl2 = true;
                l3 = l + file.length();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "download (8)");
        }
    }

    protected void downloadInternal(URL uRL, File file, boolean bl, boolean bl2, long l, long l2) throws TransferFailedException, IOException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "downloadInternal to file. url=" + uRL + ", destFile=" + file.toString() + ", compress=" + bl);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "destFile = " + file.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URL = " + uRL.toString() + "; destFile = " + file.toString());
            }
            long l3 = 0x100000L;
            long l4 = l;
            long l5 = 0L;
            l5 = l2 > l && l2 - l < l3 ? l2 : l4 + l3;
            long l6 = 0L;
            boolean bl3 = false;
            while (!bl3) {
                URL uRL2 = this.adjustStartEndRange(uRL, l4, l5);
                ResultsObject resultsObject = new ResultsObject();
                inputStream = this.download(uRL2, bl, resultsObject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "downloadInternal: newURL = " + uRL2.toString() + "; available bytes = " + inputStream.available());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, resultsObject.msg + " : " + resultsObject.statusCode + " : " + resultsObject.lastModified + " : " + resultsObject.toString());
                }
                l6 = 0L;
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                fileOutputStream = new FileOutputStream(file.getCanonicalPath(), bl2);
                byte[] byArray = new byte[this.defaultBufferSize];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    l6 += (long)n;
                    fileOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                inputStream.close();
                fileOutputStream.flush();
                fileOutputStream.close();
                inputStream = null;
                fileOutputStream = null;
                if (resultsObject.lastModified != 0L) {
                    file.setLastModified(resultsObject.lastModified);
                }
                if (resultsObject.eof || l2 != 0L && l5 == l2) {
                    bl3 = true;
                    continue;
                }
                bl2 = true;
                l4 = l5;
                if (l2 == 0L || (l5 += l3) <= l2) continue;
                l5 = l2;
            }
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, uRL.toString(), iOException);
            }
            Tr.service(tc, "ADFS0125", new Object[]{uRL, iOException});
            throw iOException;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "downloadInternal");
            }
        }
    }

    public String getServerStagingLocation() {
        return this.serverStagingLocation;
    }

    public void setServerStagingLocation(String string) {
        this.serverStagingLocation = string;
    }

    public String getTransferHost() {
        return this.transferHost;
    }

    public void setTransferHost(String string) {
        this.transferHost = string;
    }

    public int getTransferPort() {
        return this.transferPort;
    }

    public void setTransferPort(int n) {
        this.transferPort = n;
        if (!this.isSecurityEnabled()) {
            this.portToUse = n;
        }
    }

    public int getTransferSecurePort() {
        return this.transferSecurePort;
    }

    public void setTransferSecurePort(int n) {
        this.transferSecurePort = n;
        if (this.isSecurityEnabled() && n != 0) {
            this.portToUse = this.transferSecurePort;
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private void setSecurityEnabled(boolean bl) {
        this.securityEnabled = bl;
        if (bl && this.transferSecurePort != 0) {
            try {
                SSLConfigManager.getInstance().initializeClientSSL();
                this.protocolToUse = "https";
                this.portToUse = this.transferSecurePort;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.download", "1757", this);
                Tr.service(tc, "ADFS0128", exception);
            }
        } else {
            this.protocolToUse = "http";
            this.portToUse = this.transferPort;
        }
    }

    private String decriptPassword(String string) {
        String string2 = null;
        try {
            string2 = PasswordUtil.decode(string);
        }
        catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
            string2 = string;
        }
        catch (Exception exception) {
            string2 = string;
            Tr.service(tc, "ADFS0130", new Object[]{string});
        }
        return string2;
    }

    public void initialize(FileTransferConfig fileTransferConfig) {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", fileTransferConfig);
            }
            if (fileTransferConfig.getTransferRequestTimeout() != null && fileTransferConfig.getTransferRetryCount() != null) {
                this.retryWaitTime = fileTransferConfig.getTransferRequestTimeout();
                this.retryLimit = fileTransferConfig.getTransferRetryCount();
            }
            if (fileTransferConfig.getVariableMap() != null) {
                this.vmap = (VariableMap)fileTransferConfig.getVariableMap();
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            Properties properties = fileTransferConfig.getProperties();
            if (properties != null) {
                string = properties.getProperty("jmx.conn.type");
                string2 = properties.getProperty("cellmgr.host");
                string3 = properties.getProperty("jmx.port");
                this.ftServerName = properties.getProperty("server_name");
            }
            if (string != null && string2 != null && string3 != null) {
                this.jmxConnProps = new Properties();
                this.jmxConnProps.setProperty("type", string);
                this.jmxConnProps.setProperty("host", string2);
                this.jmxConnProps.setProperty("port", string3);
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    this.jmxConnProps.setProperty("autoAcceptSignerForThisConnectionOnly", "true");
                }
                this.sendGetServerConfigRequest();
            } else {
                if (this.jmxConnProps == null) {
                    try {
                        AdminService adminService = AdminServiceFactory.getAdminService();
                        String string4 = adminService.getProcessName();
                        String string5 = adminService.getNodeName();
                        if (string4 == null) {
                            string4 = this.ftServerName;
                        }
                        if (string4 != null) {
                            String string6 = "WebSphere:*,type=Discovery,node=" + string5 + ",process=" + string4;
                            ObjectName objectName = new ObjectName(string6);
                            Set set = adminService.queryNames(objectName, null);
                            Iterator iterator = set.iterator();
                            objectName = (ObjectName)iterator.next();
                            adminService.addNotificationListener(objectName, this, null, null);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not register as a listener to DiscoveryMBean");
                        }
                        break block17;
                    }
                    catch (JMException jMException) {
                        FFDCFilter.processException((Throwable)jMException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.initialize", "1851", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "can not register as a listener to DiscoveryMBean", jMException);
                        }
                        break block17;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jmxConnProps was not null!");
                    Tr.debug(tc, "jmxConnProps host = " + this.jmxConnProps.getProperty("host"));
                    Tr.debug(tc, "jmxConnProps port = " + this.jmxConnProps.getProperty("port"));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.jmxConnProps);
        }
    }

    public void initialize(AdminClient adminClient) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", adminClient);
        }
        this.adminClient = adminClient;
        this.sendGetServerConfigRequest();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", adminClient);
        }
    }

    public void setVariableMap(Object object) {
        if (object instanceof VariableMap) {
            this.vmap = (VariableMap)object;
        }
    }

    public Object getVariableMap() {
        return this.vmap;
    }

    private String mapVariables(String string) {
        if (this.vmap != null && string != null) {
            string = this.vmap.expand(string);
        }
        return string;
    }

    private File mapVariables(File file) {
        String string;
        String string2;
        if (this.vmap != null && file != null && (string2 = file.toString()) != (string = this.mapVariables(string2))) {
            file = new File(string);
        }
        return file;
    }

    public void handleNotification(Notification notification, Object object) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        if ((string = notification.getType()).equals("websphere.discovery.agent.found")) {
            ServerInfo serverInfo = (ServerInfo)notification.getUserData();
            this.dmgrAdded(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void dmgrAdded(ServerInfo serverInfo) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "dmgrAdded");
            }
            try {
                this.adminClient = serverInfo.getAdminClient();
                ObjectName objectName = this.adminClient.getServerMBean();
                String string = objectName.getKeyProperty("process");
                Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "hashtable = " + hashtable.toString());
                    Tr.debug(tc, "processName = " + string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.dmgrAdded", "1951", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unable to obtain the admin client to netmgr", exception);
            }
        }
        this.sendGetServerConfigRequest();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dmgrAdded");
        }
    }

    private void sendGetServerConfigRequest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendGetServerConfigRequest");
        }
        boolean bl = false;
        try {
            final AdminClient adminClient = this.getAdminClient();
            final ObjectName objectName = this.getFTServerObjectName();
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return adminClient.invoke(objectName, "getServerConfig", null, null);
                }
            };
            FileTransferConfig fileTransferConfig = (FileTransferConfig)ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
            if (fileTransferConfig != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FileTransferConfig from CellMgr: " + fileTransferConfig.toString());
                }
                this.setFileTransferConfig(fileTransferConfig);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not retrieve file transfer server config.");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.sendGetServerConfigRequest", "1995", this);
            Tr.service(tc, "ADFS0109", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendGetServerConfigRequest", new Boolean(bl));
        }
    }

    public FileTransferConfig getFileTransferConfig() {
        return this.ftConfig;
    }

    public void setFileTransferConfig(FileTransferConfig fileTransferConfig) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFileTransferConfig", fileTransferConfig);
        }
        this.ftConfig = fileTransferConfig;
        String string2 = (String)fileTransferConfig.getProperties().get("host");
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            try {
                string = this.expandVariable(string2);
                this.setTransferHost(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.setFileTransferConfig", "2287", this);
            }
        } else {
            try {
                this.setTransferHost(string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.setFileTransferConfig", "2300", this);
            }
        }
        if (fileTransferConfig.getProperties().get("port") != null) {
            this.setTransferPort(Integer.parseInt((String)fileTransferConfig.getProperties().get("port")));
        } else {
            this.setTransferPort(FileTransferConfigImpl.DEFAULT_PORT_INT_VALUE);
        }
        if (fileTransferConfig.getProperties().get("secure_port") != null) {
            this.setTransferSecurePort(Integer.parseInt((String)fileTransferConfig.getProperties().get("secure_port")));
        }
        this.setSecurityEnabled(fileTransferConfig.isSecurityEnabled());
        this.setServerStagingLocation(fileTransferConfig.getStagingLocation());
        if (fileTransferConfig.getTransferRequestTimeout() != null && fileTransferConfig.getTransferRetryCount() != null && this.retryWaitTime == FileTransferConfigImpl.DEFAULT_TIMEOUT && this.retryLimit == FileTransferConfigImpl.DEFAULT_RETRIES) {
            this.retryWaitTime = fileTransferConfig.getTransferRequestTimeout();
            this.retryLimit = fileTransferConfig.getTransferRetryCount();
        }
        if (fileTransferConfig.getVariableMap() != null) {
            this.vmap = (VariableMap)fileTransferConfig.getVariableMap();
        }
        if (tc.isDebugEnabled()) {
            string = (String)fileTransferConfig.getProperties().get("server_name");
            Tr.service(tc, "ADFS0134", new Object[]{this.getTransferHost(), Integer.toString(this.portToUse), this.securityEnabled ? "true" : "false", string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFileTransferConfig");
        }
    }

    private String expandVariable(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "expandVariable for " + string);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string2 = adminService.getProcessName();
        Set set = adminService.queryNames(new ObjectName("*:*,type=AdminOperations,process=" + string2), null);
        ObjectName objectName = (ObjectName)set.iterator().next();
        String string3 = (String)adminService.invoke(objectName, "expandVariable", new Object[]{string}, new String[]{"java.lang.String"});
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "expanded variable = " + string3);
        }
        return string3;
    }

    private AdminClient getAdminClient() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient");
        }
        if (this.adminClient == null) {
            if (this.jmxConnProps != null) {
                try {
                    this.adminClient = AdminClientFactory.createAdminClient(this.jmxConnProps);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.getAdminClient", "2072", this);
                    Tr.service(tc, "ADFS0113", exception);
                    throw new AdminException(exception, exception.toString());
                }
            } else {
                throw new AdminException("No JMX connection properties!");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return this.adminClient;
    }

    private ObjectName getFTServerObjectName() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFTServerObjectName");
        }
        String string = this.ftServerName;
        if (this.ftServerObjName == null) {
            try {
                Object[] objectArray;
                Object object;
                Object object2;
                String string2 = null;
                if (string == null) {
                    object2 = this.getAdminClient();
                    object = object2.getServerMBean();
                    string2 = ((ObjectName)object).getKeyProperty("node");
                    string = ((ObjectName)object).getKeyProperty("process");
                    objectArray = ((ObjectName)object).getKeyPropertyList();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "hashtable = " + objectArray.toString());
                        Tr.debug(tc, "processName = " + string);
                    }
                }
                if ((object = this.adminClient.queryNames((ObjectName)(object2 = new ObjectName("WebSphere:*,type=FileTransferServer,node=" + string2 + ",process=" + string)), null)) != null && object.size() != 0) {
                    if (object.size() != 1 && tc.isDebugEnabled()) {
                        Tr.debug(tc, "There are " + object.size() + " FileTransferServer objects.");
                    }
                    objectArray = object.toArray();
                    this.ftServerObjName = (ObjectName)objectArray[0];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ftServer name is " + this.ftServerObjName.getCanonicalName());
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.getFTServerObjectName", "2110", this);
                Tr.service(tc, "ADFS0111", exception);
                throw new AdminException(exception, exception.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFTServerObjectName");
        }
        return this.ftServerObjName;
    }

    private String getRepositoryTempDir() {
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Properties properties = configRepository.getConfig();
        return properties.getProperty("was.repository.temp");
    }

    private String getRootURI() {
        ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
        Properties properties = configRepository.getConfig();
        return properties.getProperty("was.repository.root");
    }

    private URL adjustStartEndRange(URL uRL, long l, long l2) {
        String string = uRL.getFile();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&?", true);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith("rangeStart")) {
                stringBuffer.append("rangeStart");
                stringBuffer.append("=");
                stringBuffer.append(new Long(l).toString());
                bl = true;
                continue;
            }
            if (l2 > 0L && string2.startsWith("rangeEnd")) {
                stringBuffer.append("rangeEnd");
                stringBuffer.append("=");
                stringBuffer.append(new Long(l2).toString());
                bl2 = true;
                continue;
            }
            stringBuffer.append(string2);
        }
        if (!bl && l > 0L) {
            stringBuffer.append("&");
            stringBuffer.append("rangeStart");
            stringBuffer.append("=");
            stringBuffer.append(new Long(l).toString());
        }
        if (!bl2 && l2 > 0L) {
            stringBuffer.append("&");
            stringBuffer.append("rangeEnd");
            stringBuffer.append("=");
            stringBuffer.append(new Long(l2).toString());
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), stringBuffer.toString());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "(2315) download url=" + uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL2;
    }

    private void connectToServer(HttpURLConnection httpURLConnection) throws IOException {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "connectToServer(1) URL=" + httpURLConnection.getURL().toString());
        }
        if (this.protocolToUse.equals("https")) {
            object = AdminServiceFactory.getAdminService();
            if (object == null) {
                RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
            } else {
                URL uRL = httpURLConnection.getURL();
                String string = Integer.toString(uRL.getPort());
                String string2 = uRL.getHost();
                final HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.ssl.direction", "outbound");
                hashMap.put("com.ibm.ssl.endPointName", "ADMIN_SOAP");
                if (string2 != null) {
                    hashMap.put("com.ibm.ssl.remoteHost", string2);
                }
                if (string != null) {
                    hashMap.put("com.ibm.ssl.remotePort", string);
                }
                JSSEHelper.getInstance().setOutboundConnectionInfo(hashMap);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Properties properties;
                            String string = SecurityHelper.getHelper().getClientSSLAlias();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "sslAlias for file transfer: " + string);
                            }
                            if ((properties = JSSEHelper.getInstance().getProperties(string, hashMap, null)) != null) {
                                JSSEHelper.getInstance().setSSLPropertiesOnThread(properties);
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing exception trying to get SSL config.", privilegedActionException.getException());
                    }
                    throw new IOException(privilegedActionException.getException().getMessage());
                }
            }
        }
        httpURLConnection.connect();
        if (this.protocolToUse.equals("https")) {
            try {
                object = this.waitForHandshake(httpURLConnection);
                if (object == null) {
                    httpURLConnection.connect();
                    object = this.waitForHandshake(httpURLConnection);
                    if (object == null) {
                        throw new IOException("Cannot connect to server with HttpsURLStreamHandler.");
                    }
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "connectToServer exception.", new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.connectToServer", "2483", this);
                throw new IOException("Exception occurred: " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitForHandshake(HttpURLConnection httpURLConnection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForHandshake");
        }
        int n = 0;
        do {
            String string = null;
            try {
                string = ((HttpsURLConnection)httpURLConnection).getCipherSuite();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (string != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handshake complete.  Cipher suite used: " + string);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitForHandshake");
                }
                return string;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Waiting 20ms for handshake to complete.");
            }
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
            }
            finally {
                ++n;
            }
        } while (n < 5);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForHandshake -> null");
        }
        return null;
    }

    private String encode(String string) {
        String string2 = FileTransferUtils.urlEncodePlus(string);
        try {
            string2 = URLEncoder.encode(string2, UTF_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.encode", "2234", this);
            Tr.service(tc, "ADFS0119", unsupportedEncodingException);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addAuthHeader(HttpURLConnection httpURLConnection) throws TransferFailedException {
        if (!this.securityEnabled) return;
        if (SecurityContext.isServerProcess()) {
            try {
                Cookie cookie;
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                Cookie cookie2 = this.createCookie(subject);
                if (cookie2 != null) {
                    httpURLConnection.setRequestProperty("Cookie", cookie2.getName() + "=" + cookie2.getValue());
                }
                if ((cookie = this.createCookie2(subject)) == null) return;
                String string = cookie.getName() + "=" + cookie.getValue();
                String string2 = httpURLConnection.getRequestProperty("Cookie");
                string = string2 == null ? string : string2 + "; " + string;
                httpURLConnection.setRequestProperty("Cookie", string);
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", "2278", this);
                throw new TransferFailedException("An error occurred trying to create the FileTransfer cookie: " + exception.toString(), exception);
            }
        } else {
            try {
                String string;
                String string3;
                Object object;
                Object object2;
                WSCredential wSCredential;
                Subject subject = this.getSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " addAuthHeader  .. back from getSubject:" + subject);
                }
                if ((wSCredential = SubjectHelper.getWSCredentialFromSubject(subject)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " addAuthHeader  .. back from wsCred:" + wSCredential);
                    }
                    object2 = wSCredential.getSecurityName();
                    object = wSCredential.getCredentialToken();
                    string3 = StringBytesConversion.getConvertedString((byte[])object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " addAuthHeader  .. user:" + (String)object2 + "pw: XXXXXX");
                    }
                    string = Base64Coder.base64Encode((String)object2 + ":" + string3);
                    httpURLConnection.setRequestProperty("Authorization", "Basic " + string);
                }
                object2 = this.getSingleSignonTokens();
                while (object2 != null && object2.hasNext()) {
                    object = this.createClientCookie((TokenHolder)object2.next());
                    string3 = httpURLConnection.getRequestProperty("Cookie");
                    string = ((Cookie)object).getName() + "=" + ((Cookie)object).getValue();
                    string = string3 == null ? string : string3 + "; " + string;
                    httpURLConnection.setRequestProperty("Cookie", string);
                }
                if (wSCredential != null || object2 != null) return;
                throw new TransferFailedException("There are no credentials available to perform the file transfer");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.addAuthHeader", "2295", this);
                if (!tc.isDebugEnabled()) throw new TransferFailedException("There is a problem with the client credential: " + exception.toString(), exception);
                Tr.debug(tc, "Exception in addAuthHeader  .. ");
                throw new TransferFailedException("There is a problem with the client credential: " + exception.toString(), exception);
            }
        }
    }

    private Cookie createCookie(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie");
        }
        String string = null;
        Cookie cookie = null;
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        try {
            Boolean bl;
            Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
            Method method2 = clazz.getMethod("getConfig", null);
            Method method3 = clazz.getMethod("getValue", String.class);
            Object object = method2.invoke(null, new Object[0]);
            String string2 = "security.ltpa.sso.domain";
            string = (String)method3.invoke(object, string2);
            if (string == null) {
                string = "";
            }
            if (string != null && string.length() > 0 && (string = string.trim()).charAt(0) != '.') {
                string = "." + string;
            }
            string2 = "security.ltpa.sso.ssl";
            Boolean bl2 = (Boolean)method3.invoke(object, string2);
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl2 != null) {
                bl4 = bl2;
            }
            if ((bl = (Boolean)method3.invoke(object, string2 = "security.ltpa.setSSODomain")) != null) {
                bl3 = bl;
            }
            if (string.length() < 1) {
                bl3 = false;
            }
            String string3 = "LtpaToken";
            String string4 = "/";
            String string5 = StringUtil.toString(wSCredential.getCredentialToken());
            String string6 = Base64Coder.base64Encode(string5);
            cookie = new Cookie(string3, string6);
            if (bl3) {
                cookie.setDomain(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No domain set for " + string3 + " cookie");
            }
            cookie.setPath(string4);
            cookie.setMaxAge(-1);
            cookie.setSecure(bl4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", "2366", this);
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", "2370", this);
            throw noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", "2373", this);
            throw illegalAccessException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie", "2376", this);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie");
        }
        return cookie;
    }

    private Cookie createCookie2(Subject subject) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCookie2");
        }
        String string = null;
        Cookie cookie = null;
        try {
            Iterator iterator = FileTransferClientImpl.getSingleSignonTokensFromSubject(subject);
            while (iterator.hasNext()) {
                Boolean bl;
                String string2;
                Object object;
                String string3;
                SingleSignonToken singleSignonToken = (SingleSignonToken)iterator.next();
                if (singleSignonToken == null || !(string3 = singleSignonToken.getName()).equals("LtpaToken")) continue;
                byte[] byArray = singleSignonToken.getBytes();
                short s = singleSignonToken.getVersion();
                String string4 = string3 + new Short(s).toString();
                Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                Method method2 = clazz.getMethod("getConfig", null);
                Method method3 = clazz.getMethod("getValue", class$java$lang$String == null ? FileTransferClientImpl.class$("java.lang.String") : class$java$lang$String);
                string = (String)method3.invoke(object = method2.invoke(null, new Object[0]), string2 = "security.ltpa.sso.domain");
                if (string == null) {
                    string = "";
                }
                if (string != null && string.length() > 0 && (string = string.trim()).charAt(0) != '.') {
                    string = "." + string;
                }
                string2 = "security.ltpa.sso.ssl";
                Boolean bl2 = (Boolean)method3.invoke(object, string2);
                boolean bl3 = false;
                boolean bl4 = false;
                if (bl2 != null) {
                    bl4 = bl2;
                }
                if ((bl = (Boolean)method3.invoke(object, string2 = "security.ltpa.setSSODomain")) != null) {
                    bl3 = bl;
                }
                if (string.length() < 1) {
                    bl3 = false;
                }
                String string5 = "/";
                String string6 = StringUtil.toString(byArray);
                String string7 = Base64Coder.base64Encode(string6);
                cookie = new Cookie(string4, string7);
                if (bl3) {
                    cookie.setDomain(string);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No domain set for " + string4 + " cookie");
                }
                cookie.setPath(string5);
                cookie.setMaxAge(-1);
                cookie.setSecure(bl4);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie2", "2366", this);
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie2", "2370", this);
            throw noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie2", "2373", this);
            throw illegalAccessException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.management.filetransfer.client.FileTransferClientImpl.createCookie2", "2376", this);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCookie2");
        }
        return cookie;
    }

    private Cookie createClientCookie(TokenHolder tokenHolder) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClientCookie", tokenHolder);
        }
        String string = StringUtil.toString(tokenHolder.getBytes());
        String string2 = Base64Coder.base64Encode(string);
        String string3 = tokenHolder.getName();
        if (tokenHolder.getVersion() >= 0) {
            string3 = string3 + tokenHolder.getVersion();
        }
        Cookie cookie = new Cookie(string3, string2);
        cookie.setPath("/");
        cookie.setMaxAge(-1);
        cookie.setSecure(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClientCookie", cookie);
        }
        return cookie;
    }

    private static Iterator getSingleSignonTokensFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSingleSignonTokensFromSubject");
        }
        try {
            ArrayList arrayList = new ArrayList();
            if (subject != null) {
                Set set = null;
                Set set2 = null;
                HashSet hashSet = new HashSet();
                try {
                    set = subject.getPrivateCredentials(SingleSignonToken.class);
                    if (set != null && set.size() > 0) {
                        hashSet.addAll(set);
                    }
                    if ((set2 = subject.getPublicCredentials(SingleSignonToken.class)) != null && set2.size() > 0) {
                        hashSet.addAll(set2);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject");
                    }
                    return hashSet.iterator();
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.security.WebAttributes.getSingleSignonToken", "250");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{exception});
                    }
                    return null;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject: (null)");
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.WebAttributes.getDefaultSingleSignonToken", "261");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSingleSignonTokensFromSubject", new Object[]{exception});
            }
            return null;
        }
    }

    private Iterator getSingleSignonTokens() {
        Iterator iterator;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSingleSignonTokens");
            }
            iterator = null;
            try {
                ObjectName objectName;
                Set set;
                ObjectName objectName2;
                TokenHolder[] tokenHolderArray;
                AdminClient adminClient = this.getAdminClient();
                ObjectName objectName3 = adminClient.getServerMBean();
                String string = objectName3.getKeyProperty("node");
                String string2 = objectName3.getKeyProperty("process");
                if (adminClient != null && (tokenHolderArray = (TokenHolder[])adminClient.invoke(objectName2 = (ObjectName)((set = adminClient.queryNames(objectName = new ObjectName("WebSphere:*,type=SecurityAdmin,node=" + string + ",process=" + string2), null)).isEmpty() ? null : set.iterator().next()), "getSingleSignonTokens", new Object[0], new String[0])) != null) {
                    HashSet<TokenHolder> hashSet = new HashSet<TokenHolder>(Arrays.asList(tokenHolderArray));
                    iterator = hashSet.iterator();
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.event(tc, "Unable to acquire SSO tokens", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSingleSignonTokens", iterator);
        }
        return iterator;
    }

    private Subject getSubject() throws TransferFailedException, WSSecurityException {
        Object object = AdminDataHolder.getData("wsSubject");
        Subject subject = null;
        if (object instanceof Subject) {
            subject = (Subject)object;
        }
        if (subject == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The subject is not set up in AdminDataHolder");
            }
            if (!SecurityContext.isServerProcess()) {
                subject = ContextManagerFactory.getInstance().getInvocationSubject();
                if (subject != null) {
                    AdminDataHolder.setData("wsSubject", subject);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Client Code ... The subject is not set up in AdminDataHolder");
                }
            } else {
                throw new TransferFailedException("There is no Subject available from AdminDataHolder");
            }
        }
        return subject;
    }

    private void checkAccessPermission(String string) throws TransferFailedException {
        boolean bl;
        if (this.securityEnabled && SecurityContext.isServerProcess() && (bl = RestrictedAccess.isRestricted(string))) {
            RoleBasedAuthorizer roleBasedAuthorizer;
            try {
                roleBasedAuthorizer = this.getAuthorizer();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.fileTransfer.FileTransferClientImpl.checkAccessPermission", "2401", this);
                throw new TransferFailedException("Unable to get caller's security role: " + throwable.toString(), throwable);
            }
            if (!roleBasedAuthorizer.isCallerInRole("administrator")) {
                throw new TransferFailedException("Caller is not in the required role to access restricted document: " + string);
            }
        }
    }

    private RoleBasedAuthorizer getAuthorizer() throws TransferFailedException {
        if (this.roleBasedAuth == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.management.util.SecurityHelper");
                Method method2 = clazz.getMethod("getHelper", new Class[0]);
                Object object = method2.invoke(null, new Object[0]);
                Method method3 = clazz.getMethod("getConfigurator", new Class[0]);
                Object object2 = method3.invoke(object, new Object[0]);
                this.roleBasedAuth = ((RoleBasedConfigurator)object2).getRoleBasedAuthorizer("admin-authz", "scope");
            }
            catch (Exception exception) {
                throw new TransferFailedException("The security Authorizer can not be resolved: " + exception.toString(), exception);
            }
        }
        return this.roleBasedAuth;
    }

    private void getUserInstallRoot() throws TransferFailedException {
        String string = null;
        String string2 = null;
        if (this.userInstallRoot == null) {
            string = "${USER_INSTALL_ROOT}";
            this.userInstallRoot = System.getProperty("user.install.root");
            if (this.userInstallRoot == null) {
                try {
                    Object object;
                    if (this.ftServerName == null) {
                        object = this.adminClient.getServerMBean();
                        this.ftServerName = ((ObjectName)object).getKeyProperty("process");
                        string2 = ((ObjectName)object).getKeyProperty("node");
                    }
                    object = "*:*,type=AdminOperations,node=" + string2 + ",process=" + this.ftServerName;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Query string = " + (String)object);
                    }
                    ObjectName objectName = (ObjectName)this.adminClient.queryNames(new ObjectName((String)object), null).iterator().next();
                    this.userInstallRoot = (String)this.adminClient.invoke(objectName, "expandVariable", new Object[]{string}, new String[]{"java.lang.String"});
                }
                catch (Exception exception) {
                    throw new TransferFailedException("Unable to resolve USER_INSTALL_ROOT: " + exception.toString(), exception);
                }
            }
        }
    }

    private boolean isDestinationFileChildOfDirectory(File file, String string) throws TransferFailedException {
        String string2 = null;
        String string3 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string2 = file.toString();
        }
        try {
            string3 = new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            string3 = string;
        }
        String string4 = string2.replace('\\', '/').toLowerCase();
        String string5 = string3.replace('\\', '/').toLowerCase();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "path1 = " + string4 + ": path2 = " + string5);
        }
        return string4.startsWith(string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getWebServerInstallRoot() throws TransferFailedException {
        int n = -1;
        String string = null;
        ConfigRoot configRoot = null;
        try {
            Object object;
            Object object2;
            String[] stringArray;
            AdminService adminService;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "GetWebServerInstallRoot");
            }
            if ((adminService = AdminServiceFactory.getAdminService()) == null) {
                String[] stringArray2 = null;
                return stringArray2;
            }
            String string2 = "ws-server";
            String string3 = adminService.getCellName();
            String string4 = adminService.getNodeName();
            Repository repository2 = RepositoryFactory.createRepository(string2, this.getRootURI(), string3, string4, null);
            configRoot = repository2.getConfigRoot();
            String string5 = configRoot.getValue(3);
            ServerEntry[] serverEntryArray = null;
            Resource resource = null;
            try {
                int n2;
                configRoot.setValue(3, string4);
                resource = configRoot.getResource(3, "serverindex.xml");
                stringArray = (String[])resource.getContents().get(0);
                EList eList = stringArray.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found " + eList.size() + " server entries... now see if any are webservers!");
                }
                object2 = new Vector<ServerEntry>();
                for (n2 = 0; n2 < eList.size(); ++n2) {
                    object = (ServerEntry)eList.get(n2);
                    if (!object.getServerType().equals("WEB_SERVER")) continue;
                    ((Vector)object2).add(object);
                }
                serverEntryArray = new ServerEntry[((Vector)object2).size()];
                for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                    serverEntryArray[n2] = (ServerEntry)((Vector)object2).get(n2);
                }
            }
            finally {
                configRoot.setValue(3, string5);
                if (resource != null) {
                    configRoot.remove(resource);
                }
            }
            if (serverEntryArray == null || serverEntryArray.length == 0) {
                n = 0;
                stringArray = null;
                return stringArray;
            }
            stringArray = new String[serverEntryArray.length * 2];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found " + serverEntryArray.length + " webserver entries...");
            }
            n = 0;
            for (int i = 0; i < serverEntryArray.length; ++i) {
                object2 = null;
                try {
                    String string6 = configRoot.setValue(4, serverEntryArray[i].getServerName());
                    if (string == null) {
                        string = string6;
                    }
                    object2 = configRoot.getResource(4, "server.xml");
                    object = object2.getContents();
                    block15: for (int j = 0; j < object.size(); ++j) {
                        Object e = object.get(j);
                        Server server = (Server)e;
                        EList eList = server.getComponents();
                        for (int k = 0; k < eList.size(); ++k) {
                            Object e2 = eList.get(k);
                            if (!(e2 instanceof WebServer)) continue;
                            WebServer webServer = (WebServer)e2;
                            String string7 = webServer.getWebserverInstallRoot();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, webServer.getName() + ": WebServerInstallRoot = " + string7);
                            }
                            if (string7 != null) {
                                stringArray[n++] = string7;
                            }
                            String string8 = webServer.getConfigurationFilename();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, webServer.getName() + ": Config filename = " + string8);
                            }
                            if (string8 == null) continue block15;
                            string8 = File.separatorChar == '\\' ? string8.replace('/', '\\') : string8.replace('\\', '/');
                            String string9 = string8.substring(0, string8.lastIndexOf(File.separatorChar) - 1);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, webServer.getName() + ": Config file path = " + string9);
                            }
                            stringArray[n++] = string9;
                            continue block15;
                        }
                    }
                    if (object2 == null) continue;
                    configRoot.remove((Resource)object2);
                    continue;
                }
                catch (Throwable throwable) {
                    if (object2 != null) {
                        configRoot.remove((Resource)object2);
                    }
                    throw throwable;
                }
            }
            if (string != null) {
                configRoot.setValue(4, string);
                string = null;
            }
            String[] stringArray3 = stringArray;
            return stringArray3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.component.AdminImpl.getWebServerInstallRoot", "377", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred in getWebServerInstallRoot: " + throwable.getMessage());
            }
            new TransferFailedException("getWebServerInstallRoot failed!", throwable);
        }
        finally {
            if (string != null) {
                configRoot.setValue(4, string);
            }
            if (tc.isDebugEnabled()) {
                if (n < 0) {
                    Tr.exit(tc, "GetWebServerInstallRoot: Exception!");
                } else if (n == 0) {
                    Tr.exit(tc, "GetWebServerInstallRoot: No webservers!");
                } else {
                    Tr.exit(tc, "GetWebServerInstallRoot: " + n + " webservers!");
                }
            }
        }
        return null;
    }

    private void verifyDestPathChildOfRootInstallPath(File file) throws TransferFailedException {
        this.getUserInstallRoot();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "(1)Parent path = " + this.userInstallRoot + ": file = " + file);
        }
        String[] stringArray = null;
        int n = this.userInstallRoot.length();
        boolean bl = this.isDestinationFileChildOfDirectory(file, this.userInstallRoot);
        if (!bl && (stringArray = this.getWebServerInstallRoot()) != null) {
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "(" + (i + 2) + ")Parent path = " + stringArray[i] + ": file = " + file);
                }
                if (!this.isDestinationFileChildOfDirectory(file, stringArray[i])) continue;
                n += stringArray[i].length();
                bl = true;
                break;
            }
        }
        if (!bl) {
            if (stringArray != null) {
                StringBuffer stringBuffer = new StringBuffer(n * 2);
                stringBuffer.append(this.userInstallRoot);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(", " + stringArray[i].toString());
                }
                throw new TransferFailedException(file.toString() + " is not a child of: " + stringBuffer.toString());
            }
            throw new TransferFailedException(file.toString() + " is not a child of: " + this.userInstallRoot);
        }
    }

    private File getTempFile(File file) throws TransferFailedException {
        File file2 = null;
        File file3 = null;
        try {
            file3 = new File(file.getParent());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sameDirPath = " + file3.toString());
            }
            file2 = File.createTempFile(file.getName(), null, file3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tempFileDest = " + file2);
            }
        }
        catch (Exception exception) {
            String string = "EXCEPTION trying to create temporary file in: " + file3.toString() + " : " + exception.toString();
            Tr.error(tc, "ADFS0112", string);
            throw new TransferFailedException(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The temp download file is: " + file2.toString());
        }
        if (file2.canWrite()) {
            return file2;
        }
        String string = "No write access to " + file2.toString() + ". File permissions will not allow download to succeed.";
        Tr.error(tc, "ADFS0112", string);
        throw new TransferFailedException(string);
    }

    private void writeTempBackToOrig(File file, File file2) throws TransferFailedException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        if (file.length() < 1L) {
            String string = file.toString() + " contains no data!";
            Tr.error(tc, "ADFS0112", string);
            throw new TransferFailedException(string);
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            String string = "EXCEPTION: " + exception.toString() + "; FILE: " + file.toString() + ".";
            Tr.error(tc, "ADFS0112", string);
            throw new TransferFailedException(string);
        }
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (Exception exception) {
            String string = "EXCEPTION: " + exception.toString() + "; FILE: " + file2.toString() + ".";
            Tr.error(tc, "ADFS0112", string);
            throw new TransferFailedException(string);
        }
        try {
            byte[] byArray = new byte[this.defaultBufferSize];
            int n = fileInputStream.read(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, fileInputStream.toString() + " : numRead = " + n);
            }
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Write to: " + fileOutputStream.toString());
                }
                n = fileInputStream.read(byArray);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, fileInputStream.toString() + " : numRead = " + n);
            }
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            String string = "IOException copying " + file.toString() + " to " + file2.toString() + ".";
            Tr.error(tc, "ADFS0112", string);
            throw new TransferFailedException(string);
        }
    }

    class ResultsObject {
        boolean eof = false;
        int statusCode = 0;
        String msg = null;
        long lastModified = 0L;

        ResultsObject() {
        }
    }
}

