/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.soap.AdminServiceSMR;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import com.ibm.ws.management.connector.soap.SOAPUtils;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PullRemoteReceiver;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SOAPConnectorClient
implements InvocationHandler {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPConnectorClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static final Vector emptyParams = new Vector(1);
    private static final String SOAPActionURI = "urn:AdminService";
    private SOAPMappingRegistry smr = AdminServiceSMR.getInstance();
    private boolean offline = true;
    private boolean secEnabled;
    private boolean isInternal;
    private boolean autoAcceptSigner = false;
    private Properties proxyProps;
    private URL url;
    private String protocol = "http";
    private String host;
    private String port;
    private String user;
    private String password;
    private int requestTimeout;
    private boolean JSSEFIPSProviderEnabled = false;
    private boolean keyStoreWarning = true;
    private boolean trustStoreWarning = true;
    private boolean usingJSSESocketFactory = false;
    private String remoteJMXVersion = "1.0.0";
    private String tested_ipaddr;

    public SOAPConnectorClient(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SOAPConnectorClient");
        }
        this.proxyProps = (Properties)properties.clone();
        this.host = this.proxyProps.getProperty("host");
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.SocketFactory.provider");
            }
        });
        if (string == null || string.equals("com.ibm.websphere.ssl.protocol.SSLSocketFactory")) {
            this.usingJSSESocketFactory = true;
        }
        if (this.host.indexOf(58) > -1 && this.host.indexOf(91) < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = this.proxyProps.getProperty("port");
        this.user = this.proxyProps.getProperty("username");
        this.password = this.proxyProps.getProperty("password");
        String string2 = this.proxyProps.getProperty("com.ibm.SOAP.requestTimeout");
        if (string2 == null) {
            string2 = System.getProperty("com.ibm.SOAP.requestTimeout", "600");
        }
        this.requestTimeout = Integer.parseInt(string2);
        this.secEnabled = new Boolean(this.proxyProps.getProperty("securityEnabled"));
        this.isInternal = new Boolean(this.proxyProps.getProperty("isInternal"));
        this.autoAcceptSigner = new Boolean(this.proxyProps.getProperty("autoAcceptSignerForThisConnectionOnly"));
        Tr.debug(tc, "autoAcceptSigner " + this.autoAcceptSigner);
        if (!this.isInternal) {
            SSLConfigManager sSLConfigManager = SSLConfigManager.getInstance();
            sSLConfigManager.initializeClientSSL();
        }
        this.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SOAPConnectorClient", this);
        }
    }

    public void setUserAndPwd(String string, String string2) {
        this.user = string;
        this.password = string2;
    }

    public String getType() {
        return "SOAP";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy adminServiceProxy) {
        return new PullRemoteReceiver(adminServiceProxy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconnect() throws ConnectorNotAvailableException {
        block22: {
            Object object;
            Object object2;
            Object object3;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "reconnect");
            }
            if (!this.offline) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "reconnect");
                return;
            }
            if (this.secEnabled) {
                try {
                    object3 = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return SOAPConnectorClient.this.setupSslSetting(SOAPConnectorClient.this.isInternal);
                        }
                    });
                    object2 = new HashMap<String, String>();
                    object2.put("com.ibm.ssl.direction", "outbound");
                    object2.put("com.ibm.ssl.endPointName", "ADMIN_SOAP");
                    object2.put("com.ibm.ssl.remoteHost", this.host);
                    object2.put("com.ibm.ssl.remotePort", this.port);
                    JSSEHelper.getInstance().setOutboundConnectionInfo((Map)object2);
                    object = this.proxyProps.getProperty("sslConfig");
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction((Properties)object3, (String)object, (Map)object2){
                            private final /* synthetic */ Properties val$sslProps;
                            private final /* synthetic */ String val$soapSslAlias;
                            private final /* synthetic */ Map val$connectionInfo;
                            {
                                this.val$sslProps = properties;
                                this.val$soapSslAlias = string;
                                this.val$connectionInfo = map;
                            }

                            public Object run() throws Exception {
                                if (this.val$sslProps != null) {
                                    JSSEHelper.getInstance().setSSLPropertiesOnThread(this.val$sslProps);
                                } else {
                                    Properties properties;
                                    String string = this.val$soapSslAlias;
                                    if (string == null) {
                                        string = SecurityHelper.getHelper().getClientSSLAlias();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "soapSslAlias: " + string);
                                    }
                                    if ((properties = JSSEHelper.getInstance().getProperties(string, this.val$connectionInfo, null)) != null) {
                                        JSSEHelper.getInstance().setSSLPropertiesOnThread(properties);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                    if (this.autoAcceptSigner) {
                        Tr.debug(tc, "autoAcceptSignerForThisConnectionOnly");
                        RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting SSL properties.", new Object[]{exception});
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.constructor", "274", this);
                }
                this.protocol = "https";
            }
            object3 = new Call();
            ((Call)object3).setSOAPMappingRegistry(this.smr);
            ((RPCMessage)object3).setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            ((RPCMessage)object3).setTargetObjectURI(SOAPActionURI);
            ((RPCMessage)object3).setMethodName("isAlive");
            ((RPCMessage)object3).setParams(emptyParams);
            ((RPCMessage)object3).setTargetObjectURI(SOAPActionURI);
            ((Call)object3).setTimeout(this.requestTimeout * 1000);
            object2 = ((RPCMessage)object3).getSOAPContext();
            if (object2 != null) {
                ((SOAPContext)object2).setProperty("JMXRemoteVersion", this.remoteJMXVersion);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reconnect setting context " + this.remoteJMXVersion);
                }
            }
            GenericSerializer.setVersion(this.remoteJMXVersion);
            try {
                try {
                    object = (Response)AccessController.doPrivileged(new PrivilegedExceptionAction((Call)object3){
                        private final /* synthetic */ Call val$call;
                        {
                            this.val$call = call;
                        }

                        public Object run() throws SOAPException, ConnectorNotAvailableException {
                            Thread thread2 = Thread.currentThread();
                            ClassLoader classLoader = thread2.getContextClassLoader();
                            GenericSerializer.setContextClassLoader(classLoader);
                            thread2.setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                Response response;
                                Response response2 = response = this.val$call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                                return response2;
                            }
                            catch (SOAPException sOAPException) {
                                if (SOAPConnectorClient.this.protocol.equals("https") && !sOAPException.getMessage().contains("javax.net.ssl.SSLHandshakeException")) {
                                    Response response;
                                    Response response3 = response = this.val$call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                                    return response3;
                                }
                                throw sOAPException;
                            }
                            finally {
                                thread2.setContextClassLoader(classLoader);
                            }
                        }
                    });
                    this.remoteJMXVersion = JMXVersionValidation.getRemoteVersion((RPCMessage)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "reconnect response remoteJMXVersion " + this.remoteJMXVersion);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    throw exception;
                }
                if (!this.secEnabled) break block22;
            }
            catch (Exception exception) {
                try {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.reconnect", "335", this);
                    this.tested_ipaddr = null;
                    if (!tc.isEntryEnabled()) throw new ConnectorNotAvailableException(exception);
                    Tr.exit(tc, "reconnect", exception);
                    throw new ConnectorNotAvailableException(exception);
                }
                catch (Throwable throwable) {
                    if (!this.secEnabled) throw throwable;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                                return null;
                            }
                        });
                        throw throwable;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.reconnect", "358", this);
                        throw new ConnectorNotAvailableException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                }
            }
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.reconnect", "358", this);
                throw new ConnectorNotAvailableException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            }
        }
        this.offline = false;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "reconnect");
    }

    public Object invoke(Object object, Method method2, Object[] objectArray) throws Throwable {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invoke", new Object[]{method2, objectArray});
        }
        String string = method2.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "method name: " + string);
        }
        if (string.equals("invoke")) {
            return this.invoke((ObjectName)objectArray[0], (String)objectArray[1], (Object[])objectArray[2], (String[])objectArray[3]);
        }
        if (string.equals("getAttribute")) {
            return this.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
        }
        if (string.equals("getAttributes")) {
            return this.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
        }
        if (string.equals("setAttribute")) {
            this.setAttribute((ObjectName)objectArray[0], (Attribute)objectArray[1]);
            return null;
        }
        if (string.equals("setAttributes")) {
            return this.setAttributes((ObjectName)objectArray[0], (AttributeList)objectArray[1]);
        }
        if (string.equals("isAlive")) {
            return this.isAlive();
        }
        if (string.equals("reconnect")) {
            this.reconnect();
            return null;
        }
        if (string.equals("getType")) {
            return this.getType();
        }
        if (string.equals("getProxyProperties")) {
            return this.getProxyProperties();
        }
        if (string.equals("queryNames")) {
            return this.queryNames((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
        }
        if (string.equals("getMBeanCount")) {
            return this.getMBeanCount();
        }
        if (string.equals("getDomainName")) {
            return this.getDomainName();
        }
        if (string.equals("getDefaultDomain")) {
            return this.getDefaultDomain();
        }
        if (string.equals("getMBeanInfo")) {
            return this.getMBeanInfo((ObjectName)objectArray[0]);
        }
        if (string.equals("getServerMBean")) {
            return this.getServerMBean();
        }
        if (string.equals("isInstanceOf")) {
            return this.isInstanceOf((ObjectName)objectArray[0], (String)objectArray[1]);
        }
        if (string.equals("isRegistered")) {
            return this.isRegistered((ObjectName)objectArray[0]);
        }
        if (string.equals("openRemoteNotificationChannel")) {
            return this.openRemoteNotificationChannel((AdminServiceProxy)objectArray[0]);
        }
        if (string.equals("addNotificationListener")) {
            return this._addNotficationListener(objectArray);
        }
        if (string.equals("removeNotificationListener")) {
            this._removeNotificationListener(objectArray);
            return null;
        }
        if (string.equals("resetFilter")) {
            this.resetFilter((ListenerIdentifier)objectArray[0], (ConsolidatedFilter)objectArray[1]);
            return null;
        }
        if (string.equals("pullNotifications")) {
            return this.pullNotifications((ListenerIdentifier)objectArray[0], (Integer)objectArray[1]);
        }
        if (string.equals("queryMBeans")) {
            return this.queryMBeans((ObjectName)objectArray[0], (QueryExp)objectArray[1]);
        }
        if (string.equals("getObjectInstance")) {
            return this.getObjectInstance((ObjectName)objectArray[0]);
        }
        if (string.equals("getClassLoaderFor")) {
            return this.getClassLoaderFor((ObjectName)objectArray[0]);
        }
        if (string.equals("getClassLoader")) {
            return this.getClassLoader((ObjectName)objectArray[0]);
        }
        throw new ConnectorException(nls.getFormattedMessage("ADMC0044E", new Object[]{string}, "Unsupported AdminClient operation: {0}"));
    }

    public Session isAlive() throws Throwable {
        return (Session)this.invokeTemplate("isAlive", emptyParams, false);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        if (queryExp != null) {
            vector.addElement(new Parameter("queryexp", queryExp.getClass(), queryExp, null));
        } else {
            vector.addElement(new Parameter("queryexp", QueryExp.class, queryExp, null));
        }
        return (Set)this.invokeTemplate("queryNames", vector, true);
    }

    public Integer getMBeanCount() throws Throwable {
        return (Integer)this.invokeTemplate("getMBeanCount", emptyParams, true);
    }

    public String getDomainName() throws Throwable {
        return (String)this.invokeTemplate("getDomainName", emptyParams, true);
    }

    public String getDefaultDomain() throws Throwable {
        return (String)this.invokeTemplate("getDefaultDomain", emptyParams, true);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        return (MBeanInfo)this.invokeTemplate("getMBeanInfo", vector, true);
    }

    public ObjectName getServerMBean() throws Throwable {
        return (ObjectName)this.invokeTemplate("getServerMBean", emptyParams, true);
    }

    public Boolean isInstanceOf(ObjectName objectName, String string) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("classname", String.class, string, null));
        return (Boolean)this.invokeTemplate("isInstanceOf", vector, true);
    }

    public Boolean isRegistered(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        return (Boolean)this.invokeTemplate("isRegistered", vector, true);
    }

    public Object getAttribute(ObjectName objectName, String string) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("attribute", String.class, string, null));
        return this.invokeTemplate("getAttribute", vector, true);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("attribute", String;.class, stringArray, null));
        return (AttributeList)this.invokeTemplate("getAttributes", vector, true);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("attribute", Attribute.class, attribute, null));
        this.invokeTemplate("setAttribute", vector, true);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("attribute", AttributeList.class, attributeList, null));
        return (AttributeList)this.invokeTemplate("setAttributes", vector, true);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("operationname", String.class, string, null));
        vector.addElement(new Parameter("params", Object;.class, objectArray, null));
        vector.addElement(new Parameter("signature", String;.class, stringArray, null));
        return this.invokeTemplate("invoke", vector, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object invokeTemplate(String string, Vector vector, boolean bl) throws Throwable {
        Object object;
        Object object2;
        block34: {
            Object object3;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "invokeTemplate", string);
            }
            if (this.offline) {
                try {
                    this.reconnect();
                }
                catch (Throwable throwable) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeTemplate - failed", throwable);
                    }
                    if (!(throwable instanceof ConnectorNotAvailableException)) throw new ConnectorNotAvailableException(throwable);
                    throw throwable;
                }
            }
            final Call call = new Call();
            call.setSOAPMappingRegistry(this.smr);
            call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            call.setTargetObjectURI(SOAPActionURI);
            call.setMethodName(string);
            call.setParams(vector);
            call.setTimeout(this.requestTimeout * 1000);
            SOAPContext sOAPContext = call.getSOAPContext();
            if (sOAPContext != null) {
                sOAPContext.setProperty("JMXRemoteVersion", this.remoteJMXVersion);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invokeTemplate setting context " + this.remoteJMXVersion);
                }
            }
            GenericSerializer.setVersion(this.remoteJMXVersion);
            if (this.secEnabled) {
                object2 = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SOAPConnectorClient.this.setupSslSetting(SOAPConnectorClient.this.isInternal);
                    }
                });
                if (bl && (object = this.getSecurityHeader(this.isInternal)) != null) {
                    call.setHeader((Header)object);
                }
                try {
                    object = new HashMap();
                    object.put("com.ibm.ssl.direction", "outbound");
                    object.put("com.ibm.ssl.endPointName", "ADMIN_SOAP");
                    object.put("com.ibm.ssl.remoteHost", this.host);
                    object.put("com.ibm.ssl.remotePort", this.port);
                    object3 = this.proxyProps.getProperty("sslConfig");
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction((Properties)object2, (String)object3, (Map)object){
                            private final /* synthetic */ Properties val$sslProps;
                            private final /* synthetic */ String val$soapSslAlias;
                            private final /* synthetic */ Map val$connectionInfo;
                            {
                                this.val$sslProps = properties;
                                this.val$soapSslAlias = string;
                                this.val$connectionInfo = map;
                            }

                            public Object run() throws Exception {
                                if (this.val$sslProps != null) {
                                    JSSEHelper.getInstance().setSSLPropertiesOnThread(this.val$sslProps);
                                } else {
                                    Properties properties;
                                    String string = this.val$soapSslAlias;
                                    if (string == null) {
                                        string = SecurityHelper.getHelper().getClientSSLAlias();
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "soapSslAlias: " + string);
                                    }
                                    if ((properties = JSSEHelper.getInstance().getProperties(string, this.val$connectionInfo, null)) != null) {
                                        JSSEHelper.getInstance().setSSLPropertiesOnThread(properties);
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                    if (this.autoAcceptSigner) {
                        Tr.debug(tc, "autoAccettSignerForThisConnectionOnly");
                        RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
                    }
                }
                catch (SSLException sSLException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting SSL properties.", new Object[]{sSLException});
                    }
                    FFDCFilter.processException((Throwable)sSLException, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.constructor", "687", this);
                }
            }
            if (!this.remoteJMXVersion.equals("1.0.0")) {
                call.setHeader(JMXVersionValidation.getJmxVersionHeader(call.getHeader(), this.remoteJMXVersion));
            }
            object2 = null;
            try {
                try {
                    object2 = (Response)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws SOAPException, ConnectorNotAvailableException {
                            Thread thread2 = Thread.currentThread();
                            ClassLoader classLoader = thread2.getContextClassLoader();
                            GenericSerializer.setContextClassLoader(classLoader);
                            thread2.setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                Response response;
                                Response response2 = response = call.invoke(SOAPConnectorClient.this.getUrl(), SOAPConnectorClient.SOAPActionURI);
                                return response2;
                            }
                            finally {
                                thread2.setContextClassLoader(classLoader);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    object3 = privilegedActionException.getException();
                    if (!object3.equals(SOAPException.class)) throw object3;
                    SOAPException sOAPException = (SOAPException)object3;
                    throw sOAPException;
                }
                this.remoteJMXVersion = JMXVersionValidation.getRemoteVersion((RPCMessage)object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "invokeTemplate response remoteJMXVersion " + this.remoteJMXVersion);
                }
                if (!this.secEnabled) break block34;
            }
            catch (SOAPException sOAPException) {
                try {
                    FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", "723", this);
                    this.tested_ipaddr = null;
                    try {
                        this.offline = true;
                        this.reconnect();
                    }
                    catch (ConnectorNotAvailableException connectorNotAvailableException) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "invokeTemplate - failed", new Object[]{string, sOAPException});
                    }
                    if (this.offline) {
                        throw new ConnectorNotAvailableException(sOAPException);
                    }
                    object3 = nls.getFormattedMessage("ADMC0009E", new Object[]{string}, "Failed to make a SOAP call: {0}");
                    throw new ConnectorException((String)object3, sOAPException);
                }
                catch (Throwable throwable) {
                    if (!this.secEnabled) throw throwable;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                JSSEHelper.getInstance().setSSLPropertiesOnThread(null);
                                return null;
                            }
                        });
                        throw throwable;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", "764", this);
                        throw new ConnectorException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
                    }
                }
            }
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.management.connector.soap.SOAPConnectorClient.invokeTemplate", "764", this);
                throw new ConnectorException(privilegedActionException.getException().getMessage(), privilegedActionException.getException());
            }
        }
        if (((Response)object2).generatedFault()) {
            this.remoteJMXVersion = JMXVersionValidation.getRemoteVersion((RPCMessage)object2);
            object = ((Response)object2).getFault();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invokeTemplate", string);
            }
            this.handleAdminFault((Fault)object);
            return null;
        }
        object = ((Response)object2).getReturnValue();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeTemplate", string);
        }
        if (object == null) return null;
        return ((Parameter)object).getValue();
    }

    private void handleAdminFault(Fault fault) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleAdminFault");
        }
        String string = fault.getFaultString();
        Throwable throwable = null;
        try {
            throwable = (Throwable)SOAPUtils.convertStringToObject(string, this.remoteJMXVersion);
            throwable = throwable.fillInStackTrace();
        }
        catch (Throwable throwable2) {
            FFDCFilter.processException(throwable2, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", "810", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error occurs while deserializing the received exception", throwable2);
            }
            throwable = new IllegalArgumentException(nls.getString("ADMC0043E"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleAdminFault", throwable);
        }
        throw throwable;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", pushNotificationListener);
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("filter", ConsolidatedFilter.class, consolidatedFilter, null));
        vector.addElement(new Parameter("listener", PushNotificationListener.class, pushNotificationListener, null));
        ListenerIdentifier listenerIdentifier = (ListenerIdentifier)this.invokeTemplate("addNotificationListener", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", listenerIdentifier);
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("listenerId", ListenerIdentifier.class, listenerIdentifier, null));
        this.invokeTemplate("removeNotificationListener", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", new Object[]{listenerIdentifier, consolidatedFilter});
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("listenerId", ListenerIdentifier.class, listenerIdentifier, null));
        vector.addElement(new Parameter("fileter", ConsolidatedFilter.class, consolidatedFilter, null));
        this.invokeTemplate("resetFilter", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", new Object[]{listenerIdentifier, n});
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("listenerId", ListenerIdentifier.class, listenerIdentifier, null));
        vector.addElement(new Parameter("batchSize", Integer.class, n, null));
        Notification[] notificationArray = (Notification[])this.invokeTemplate("pullNotifications", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullNotifications", notificationArray);
        }
        return notificationArray;
    }

    private Header createSOAPSecHeader(String string, String string2) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSOAPSecHeader");
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", "895", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSOAPSecHeader");
            }
            throw new ConnectorException(nls.getString("ADMC0045E"), exception);
        }
        Header header = new Header();
        header.setAttribute(SOAPUtils.securityEnabled, "true");
        Vector<Element> vector = new Vector<Element>();
        Element element = document.createElement("username");
        Text text = document.createTextNode(string);
        element.appendChild(text);
        vector.addElement(element);
        element = document.createElement("password");
        text = document.createTextNode(string2);
        element.appendChild(text);
        vector.addElement(element);
        element = document.createElement("LoginMethod");
        text = document.createTextNode("BasicAuth");
        element.appendChild(text);
        vector.addElement(element);
        header.setHeaderEntries(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSOAPSecHeader");
        }
        return header;
    }

    private Header getSecurityHeader(boolean bl) throws ConnectorException {
        Header header = null;
        header = bl ? this.processInternal() : this.processExternal();
        return header;
    }

    private Header createSOAPSecHeader(String string) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSOAPSecHeader");
        }
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.handleAdminFault", "952", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSOAPSecHeader");
            }
            throw new ConnectorException(nls.getString("ADMC0045E"), exception);
        }
        Header header = new Header();
        header.setAttribute(SOAPUtils.securityEnabled, "true");
        Vector<Element> vector = new Vector<Element>();
        Element element = document.createElement("token");
        Text text = document.createTextNode(string);
        element.appendChild(text);
        vector.addElement(element);
        element = document.createElement("LoginMethod");
        text = document.createTextNode("TokenBased");
        element.appendChild(text);
        vector.addElement(element);
        header.setHeaderEntries(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSOAPSecHeader");
        }
        return header;
    }

    private Header processExternal() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processExternal");
        }
        Header header = null;
        if (this.user == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SOAPConnectorClient - exception");
            }
            throw new ConnectorAuthenticationException(nls.getString("ADMC0035E", "no username specified"));
        }
        if (this.password == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SOAPConnectorClient - exception");
            }
            throw new ConnectorAuthenticationException(nls.getString("ADMC0036E", "no password specified"));
        }
        header = this.createSOAPSecHeader(this.user, this.password);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processExternal");
        }
        return header;
    }

    private Header processInternal() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processInternal");
        }
        Subject subject = null;
        Header header = null;
        subject = SecurityHelper.retrieveSubject();
        if (subject != null) {
            try {
                SecurityHelper.getActualSubject(subject);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processInternal - getActualSubject failed getting token Subject.");
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.processInternal", "1025", this);
                subject = null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processInternal - Subject: ", subject);
        }
        if (subject != null) {
            WSSecurityContext wSSecurityContext = SecurityHelper.getHelper().getWSSecurityContext();
            String string = SecurityHelper.getHelper().getRealm();
            if (wSSecurityContext != null) {
                String string2;
                block13: {
                    string2 = null;
                    try {
                        byte[] byArray = wSSecurityContext.initSecContext(subject, this.host, string);
                        string2 = Base64.encode(byArray);
                    }
                    catch (WSSecurityContextException wSSecurityContextException) {
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug(tc, "fail to initialize the security context", wSSecurityContextException);
                    }
                }
                if (string2 != null) {
                    header = this.createSOAPSecHeader(string2);
                }
            } else {
                Tr.warning(tc, "ADMC0034W");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processInternal");
        }
        return header;
    }

    private URL getUrl() throws ConnectorNotAvailableException {
        if (this.url == null) {
            String string = this.protocol + "://" + this.host + ":" + this.port + "/";
            int n = Integer.parseInt(this.port);
            if (this.tested_ipaddr != null) {
                string = this.protocol + "://" + this.tested_ipaddr + ":" + this.port + "/";
            } else {
                InetAddress[] inetAddressArray = null;
                try {
                    inetAddressArray = InetAddress.getAllByName(this.host);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new ConnectorNotAvailableException(unknownHostException);
                }
                if (inetAddressArray != null) {
                    Exception exception = null;
                    for (int i = 0; i < inetAddressArray.length; ++i) {
                        try {
                            Socket socket = new Socket(inetAddressArray[i], n);
                            socket.close();
                            this.tested_ipaddr = inetAddressArray[i].getHostAddress();
                            if (this.tested_ipaddr.indexOf(58) > -1 && this.tested_ipaddr.indexOf(91) < 0) {
                                this.tested_ipaddr = "[" + this.tested_ipaddr + "]";
                            }
                            string = this.protocol + "://" + this.tested_ipaddr + ":" + this.port + "/";
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "SOAPConnectorClient.getUrl, InetAddress No. " + i + ", url=" + string);
                            break;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            continue;
                        }
                    }
                    if (this.tested_ipaddr == null) {
                        throw new ConnectorNotAvailableException(nls.getFormattedMessage("ADMC0016E", new Object[]{this.host, this.port}, "Could not create SOAP Connector to connect to host {0} at port {1}"), exception);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "soap url: " + string);
            }
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.management.connector.soap.SOAPConnectorClient.SOAPConnectorClient", "1121", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "SOAPConnectorClient - failed", malformedURLException);
                }
                this.tested_ipaddr = null;
                throw new ConnectorNotAvailableException(malformedURLException);
            }
        }
        return this.url;
    }

    private Properties setupSslSetting(boolean bl) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupSslSetting", new Boolean(bl));
        }
        if ((string7 = this.proxyProps.getProperty("javax.net.ssl.trustStore")) == null) {
            string7 = this.proxyProps.getProperty("com.ibm.ssl.trustStore");
        }
        if ((string6 = this.proxyProps.getProperty("javax.net.ssl.trustStoreType")) == null) {
            string6 = this.proxyProps.getProperty("com.ibm.ssl.trustStoreType");
        }
        if ((string5 = this.proxyProps.getProperty("javax.net.ssl.trustStorePassword")) == null) {
            string5 = this.proxyProps.getProperty("com.ibm.ssl.trustStorePassword");
        }
        if ((string4 = this.proxyProps.getProperty("javax.net.ssl.keyStore")) == null) {
            string4 = this.proxyProps.getProperty("com.ibm.ssl.keyStore");
        }
        if ((string3 = this.proxyProps.getProperty("javax.net.ssl.keyStoreType")) == null) {
            string3 = this.proxyProps.getProperty("com.ibm.ssl.keyStoreType");
        }
        if ((string2 = this.proxyProps.getProperty("javax.net.ssl.keyStorePassword")) == null) {
            string2 = this.proxyProps.getProperty("com.ibm.ssl.keyStorePassword");
        }
        if ((string = this.proxyProps.getProperty("com.ibm.ssl.contextProvider")) == null) {
            string = this.proxyProps.getProperty("com.ibm.ssl.contextProvider");
        }
        SSLConfig sSLConfig = null;
        if (string4 != null || string7 != null) {
            sSLConfig = new SSLConfig(this.proxyProps);
            if (string4 != null) {
                sSLConfig.setProperty("com.ibm.ssl.keyStore", string4);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStore", string4);
                }
            }
            if (string2 != null) {
                sSLConfig.setProperty("com.ibm.ssl.keyStorePassword", string2);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStorePassword", string2);
                }
            }
            if (string3 != null) {
                sSLConfig.setProperty("com.ibm.ssl.keyStoreType", string3);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStoreType", string3);
                }
            } else {
                sSLConfig.setProperty("com.ibm.ssl.keyStoreType", "JKS");
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.keyStoreType", "JKS");
                }
            }
            if (string7 != null) {
                sSLConfig.setProperty("com.ibm.ssl.trustStore", string7);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStore", string7);
                }
            }
            if (string5 != null) {
                sSLConfig.setProperty("com.ibm.ssl.trustStorePassword", string5);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStorePassword", string5);
                }
            }
            if (string6 != null) {
                sSLConfig.setProperty("com.ibm.ssl.trustStoreType", string6);
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStoreType", string6);
                }
            } else {
                sSLConfig.setProperty("com.ibm.ssl.trustStoreType", "JKS");
                if (this.usingJSSESocketFactory) {
                    System.setProperty("javax.net.ssl.trustStoreType", "JKS");
                }
            }
            sSLConfig.decodePasswords();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupSslSetting", sSLConfig);
        }
        return sSLConfig;
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        if (queryExp != null) {
            vector.addElement(new Parameter("queryexp", queryExp.getClass(), queryExp, null));
        } else {
            vector.addElement(new Parameter("queryexp", QueryExp.class, queryExp, null));
        }
        return (Set)this.invokeTemplate("queryMBeans", vector, true);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        return (ObjectInstance)this.invokeTemplate("getObjectInstance", vector, true);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        return (ClassLoader)this.invokeTemplate("getClassLoaderFor", vector, true);
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws Throwable {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("objectname", ObjectName.class, objectName, null));
        return (ClassLoader)this.invokeTemplate("getClassLoader", vector, true);
    }

    public void addNotificationListener_1(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener1", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("name", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("listener", ObjectName.class, objectName2, null));
        vector.addElement(new Parameter("filter", NotificationFilter.class, notificationFilter, null));
        vector.addElement(new Parameter("handback", Object.class, object, null));
        this.invokeTemplate("addNotificationListener", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener1");
        }
    }

    public void removeNotificationListener_4(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener4", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("name", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("listener", ObjectName.class, objectName2, null));
        vector.addElement(new Parameter("filter", NotificationFilter.class, notificationFilter, null));
        vector.addElement(new Parameter("handback", Object.class, object, null));
        this.invokeTemplate("removeNotificationListener4", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener_2(ObjectName objectName, ObjectName objectName2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener2", new Object[]{objectName, objectName2});
        }
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("name", ObjectName.class, objectName, null));
        vector.addElement(new Parameter("listener", ObjectName.class, objectName2, null));
        this.invokeTemplate("removeNotificationListener", vector, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener2");
        }
    }

    private Object _addNotficationListener(Object[] objectArray) throws Throwable {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 4 && objectArray[0] instanceof ObjectName) {
            this.addNotificationListener_1((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)objectArray[2], objectArray[3]);
            return null;
        }
        return this.addNotificationListener((ConsolidatedFilter)objectArray[0], (PushNotificationListener)objectArray[1]);
    }

    private void _removeNotificationListener(Object[] objectArray) throws Throwable {
        if (objectArray == null) {
            return;
        }
        if (objectArray.length == 4 && objectArray[0] instanceof ObjectName) {
            this.removeNotificationListener_4((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)objectArray[2], objectArray[3]);
        } else if (objectArray.length == 2 && objectArray[0] instanceof ObjectName && objectArray[1] instanceof ObjectName) {
            this.removeNotificationListener_2((ObjectName)objectArray[0], (ObjectName)objectArray[1]);
        } else {
            this.removeNotificationListener((ListenerIdentifier)objectArray[0]);
        }
    }
}

