/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configarchive;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.management.configarchive.EARFileAccessor;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class EnhancedEarReader {
    public static final int FOLDER = 0;
    public static final int DOCUMENT = 1;
    public static final int BOTH = 2;
    public static final int FULL = -1;
    public static final int SELF = 0;
    public static final int ONE = 1;
    private static TraceComponent tc = Tr.register(EnhancedEarReader.class, "EnhancedEarReader", "com.ibm.ws.management.configarchive");

    public static boolean isEnhancedEar(EARFile eARFile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnhancedEar (" + eARFile + ")");
        }
        boolean bl = false;
        try {
            EARFileAccessor eARFileAccessor = new EARFileAccessor(eARFile);
            List list = eARFileAccessor.listFolders("cells");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell folders = ", list);
            }
            bl = list.size() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnhancedEar", new Boolean(bl));
        }
        return bl;
    }

    public static boolean isEnhancedEar(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEnhancedEar (" + string + ")");
        }
        boolean bl = false;
        try {
            DefaultFileAccessor defaultFileAccessor = new DefaultFileAccessor(new File(string));
            List list = defaultFileAccessor.listFolders("cells");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell folders = ", list);
            }
            if (list.size() > 0) {
                bl = list.size() > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEnhancedEar", new Boolean(bl));
        }
        return bl;
    }

    public static Resource getDeployment(EARFile eARFile) {
        XMIResourceImpl xMIResourceImpl;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDeployment (" + eARFile + ")");
            }
            xMIResourceImpl = null;
            try {
                EARFileAccessor eARFileAccessor = new EARFileAccessor(eARFile);
                String string = EnhancedEarReader.getDepUri(eARFileAccessor);
                if (string == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getDeployment", xMIResourceImpl);
                    }
                    return xMIResourceImpl;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "fa = ", eARFileAccessor);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uri = ", string);
                }
                InputStream inputStream = eARFileAccessor.load(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ins = ", inputStream);
                }
                if (inputStream != null) {
                    ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                    xMIResourceImpl = new XMIResourceImpl();
                    xMIResourceImpl.setURI(URI.createURI("deployment.xml"));
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("DECLARE_XML", Boolean.FALSE);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "loading res = ", xMIResourceImpl);
                    }
                    xMIResourceImpl.load(inputStream, hashMap);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block11;
                exception.printStackTrace();
                Tr.debug(tc, "failed  to get deployment.xml resource", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeployment", xMIResourceImpl);
        }
        return xMIResourceImpl;
    }

    private static String getDepUri(FileAccessor fileAccessor) {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDepUri", fileAccessor);
        }
        String string2 = null;
        List list = EnhancedEarReader.listFiles(fileAccessor, "", 1, -1);
        Object[] objectArray = list.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            String string3;
            string = (String)objectArray[n];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matching", string);
            }
            if (!string.equals(string3 = "cells/defaultCell/applications/defaultApp/deployments/defaultApp/deployment.xml")) continue;
            string2 = string;
            break;
        }
        if (string2 != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDepUri", string2);
            }
            return string2;
        }
        for (n = 0; n < objectArray.length; ++n) {
            string = (String)objectArray[n];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matching", string);
            }
            if (!string.matches("cells/.*/applications/.*/deployments/.*/deployment.xml")) continue;
            string2 = string;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDepUri", string2);
        }
        return string2;
    }

    private static List listFiles(FileAccessor fileAccessor, String string, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + string + " " + n + " " + n2 + ")");
        }
        ArrayList arrayList = new ArrayList();
        EnhancedEarReader.listFiles(fileAccessor, string, n, n2, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles", arrayList);
        }
        return arrayList;
    }

    private static void listFiles(FileAccessor fileAccessor, String string, int n, int n2, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (" + string + " " + n + " " + n2 + ")");
        }
        if (n2 == 0) {
            try {
                if (fileAccessor.exists(string)) {
                    list.add(string);
                }
            }
            catch (Exception exception) {
                String string2 = "";
                if (fileAccessor instanceof DefaultFileAccessor) {
                    DefaultFileAccessor defaultFileAccessor = (DefaultFileAccessor)fileAccessor;
                    string2 = "listFiles (" + defaultFileAccessor.getRootDir().getPath() + File.separator + string + ") failed with unexpected exception, " + exception;
                } else {
                    string2 = "listFiles (" + string + ") failed with unexpected exception, " + exception;
                }
                Tr.warning(tc, string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listFiles");
            }
            return;
        }
        List list2 = null;
        Object[] objectArray = null;
        if (n == 1 || n == 2) {
            try {
                list2 = fileAccessor.listFiles(string);
            }
            catch (Exception exception) {
                list2 = new ArrayList();
            }
            objectArray = list2.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + objectArray[i]);
                }
                list.add(objectArray[i]);
            }
        }
        list2 = null;
        try {
            list2 = fileAccessor.listFolders(string);
        }
        catch (Exception exception) {
            list2 = new ArrayList();
        }
        objectArray = list2.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (n == 2 || n == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + objectArray[i]);
                }
                list.add(objectArray[i]);
            }
            if (n2 == 1) continue;
            EnhancedEarReader.listFiles(fileAccessor, (String)objectArray[i], n, n2 == -1 ? -1 : n2 - 1, list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles");
        }
    }
}

