/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.transform.RepositoryAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class DistributionStatusTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DistributionStatusTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String OPNAME = "_getAppDistributionStatus";

    public DistributionStatusTask() {
        this.appTaskName = "AppDistribution";
    }

    public boolean performTask() throws AdminException {
        Hashtable hashtable = J2CAppUtils.getAppDocuments((String)this.scheduler.getAppName());
        if (hashtable == null || hashtable.size() == 0) {
            throw new AdminException("Error getting application documents from master repository.  The application may not be in the repository.");
        }
        List list = ((DistributionStatusSchedulerImpl)this.scheduler).get_nodes();
        for (int i = 0; i < list.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Inside the performTask for node : " + list.get(i));
            }
            String string = this.handleNode((String)list.get(i), hashtable);
            String string2 = ((DistributionStatusSchedulerImpl)this.scheduler).addCompStatus(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Status : " + string + " cs = " + string2);
            }
            Properties properties = new Properties();
            properties.put("AppDistributionNode", string);
            properties.put("AppDistributionAll", string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " nprops : " + properties + " CS = " + string2);
            }
            AppNotification appNotification = this.createTranslatedNotification("InProgress", string, null);
            appNotification.setProperties(properties);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " PROPOGATING TASK .." + appNotification.toString());
            }
            this.scheduler.propagateTaskEvent(appNotification);
        }
        return true;
    }

    private String handleNode(String string, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNode: " + string + ", app = " + this.scheduler.getAppName());
        }
        String string2 = null;
        try {
            string2 = this.scheduler.getCellContext().getName();
            ObjectName objectName = new ObjectName("WebSphere:type=AdminOperations,node=" + string + ",process=" + (AdminServiceFactory.getAdminService().getNodeName().equals(string) ? AdminServiceFactory.getAdminService().getProcessName() : "nodeagent") + ",*");
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (set == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNode: set is null");
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "No MBean on the node");
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            objectName = (ObjectName)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "on = " + objectName);
            }
            if (!this.checkForOp(objectName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Back level MBean on " + string);
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            Hashtable hashtable2 = (Hashtable)AdminServiceFactory.getAdminService().invoke(objectName, OPNAME, new Object[]{this.scheduler.getAppName(), new Hashtable()}, new String[]{String.class.getName(), Hashtable.class.getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tbl = " + hashtable2);
            }
            if (hashtable2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Table returned from node is null " + string);
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            String string3 = (String)hashtable2.get(this.scheduler.getAppName());
            if (string3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file status returned from node is null " + string);
                }
                return this.getStr(string2, string, "unknown", "unknown");
            }
            if (string3.equals("0")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file still exists " + string);
                }
                return this.getStr(string2, string, "false", "inprogress");
            }
            if (!string3.equals("-1")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Marker file contains error " + string3 + " on " + string);
                }
                return this.getStr(string2, string, "false", "error");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("uri");
            if (hashtable3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "URI Table returned from node is null " + string);
                }
                return this.getStr(string2, string, "unknown", "notprocessing");
            }
            if (hashtable.size() != hashtable3.size()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "URI Tables of different size for " + string + ", " + hashtable.size() + ", " + hashtable3.size());
                }
                return this.getStr(string2, string, "false", "notprocessing");
            }
            ConfigRepository configRepository = ConfigRepositoryFactory.getConfigRepository();
            RepositoryAdapter repositoryAdapter = RepositoryAdapter.getRepositoryAdapter((ConfigRepository)configRepository, (String)string);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                DocumentDigest documentDigest;
                String string4 = (String)enumeration.nextElement();
                if (!hashtable3.containsKey(string4)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "URI " + string4 + "does not exist on " + string);
                    }
                    return this.getStr(string2, string, "false", "notprocessing");
                }
                DocumentDigest documentDigest2 = repositoryAdapter.getDigest(string4);
                if (((Object)documentDigest2).equals(documentDigest = (DocumentDigest)hashtable3.get(string4))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Digest diff for " + string4);
                }
                return this.getStr(string2, string, "false", "notprocessing");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "All fine for " + string);
            }
            return this.getStr(string2, string, "true", "notprocessing");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.DistributionStatusScheduler.handleNode", "178", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exception thrown in handleNode: " + throwable);
            }
            return this.getStr(string2, string, "unknown", "unknown");
        }
    }

    private String getStr(String string, String string2, String string3, String string4) {
        return "WebSphere:cell=" + string + ",node=" + string2 + ",distribution=" + string3 + ",expansion=" + string4;
    }

    private boolean checkForOp(ObjectName objectName) throws Exception {
        MBeanInfo mBeanInfo = AdminServiceFactory.getAdminService().getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!OPNAME.equals(mBeanOperationInfoArray[i].getName())) continue;
            return true;
        }
        return false;
    }
}

