/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DeleteSIEntryTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(DeleteSIEntryTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    private boolean performTaskForSystemApp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTaskForSystemApp");
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTaskForSystemApp");
            }
            return AppUtils.isAnInstalledSystemApp(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties(), true);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception is " + exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTaskForSystemApp");
            }
            return false;
        }
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        Object var1_1 = null;
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        String string = "";
        try {
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            if (repositoryContext == null) {
                return this.performTaskForSystemApp();
            }
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector = new Vector();
            Vector vector2 = ConfigRepoHelper.getServersForAppDeployment(ConfigRepoHelper.getAppDeploymentForApp(repositoryContext), vector, this.scheduler.getCellContext(), this.scheduler.getWorkSpace(), false);
            if (vector.size() != 0) {
                this.scheduler.propagateTaskEvent(this.createNotification("InProgress", "ADMA5042E", new Object[]{vector}));
            }
            Hashtable hashtable = ConfigRepoHelper.updateServerIndexDocs(repositoryContext, this.scheduler.getWorkSpace(), vector2, false, this.getResourceBundle());
            string = ConfigRepoHelper.getNodeStrFromNodeSvrTable(hashtable, this.scheduler.getCellContext().getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeStr = " + string);
            }
            if (hashtable != null) {
                this.scheduler.getProperties().put("nodesvr.removed", hashtable);
            }
            AppNotification appNotification = this.createNotification("Completed", "ADMA5104I", new String[]{string});
            Properties properties = new Properties();
            properties.setProperty("nodes", string);
            appNotification.setProperties(properties);
            this.scheduler.propagateTaskEvent(appNotification);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.DeleteSIEntryTask.performTask", "124", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5105E", new String[]{string}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0061E", new Object[]{var1_1}));
        }
    }
}

