/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.ConnectorModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.serverindex.ServerindexPackage;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;

public class ConfigRepoHelper {
    private static TraceComponent tc = Tr.register(ConfigRepoHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static Object workSpaceIdLock = new Object();
    private static int workSpaceIdCounter = 0;

    public static boolean containsEList(EList eList, Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < eList.size(); ++i) {
            if (!eList.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkSpace getWorkSpace(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Init config and create workspace");
        }
        ModelMgr.initialize("ws-server");
        RepositoryMetaDataFactory.initialize();
        AppdeploymentPackageImpl.init();
        String string2 = string;
        if (string2 == null) {
            Object object = workSpaceIdLock;
            synchronized (object) {
                workSpaceIdCounter = (workSpaceIdCounter + 1) % 100;
                string2 = "" + System.currentTimeMillis() + workSpaceIdCounter;
            }
        }
        return WorkSpaceManagerFactory.getManager().getWorkSpace(string2);
    }

    public static void removeWorkSpace(boolean bl, WorkSpace workSpace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWorkSpace");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sync workspace");
            }
            workSpace.synch(new HashMap());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "remove workspace");
        }
        String string = workSpace.getUserName();
        WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWorkSpace");
        }
    }

    public static boolean isEditAllowed(ApplicationDeployment applicationDeployment) {
        return !applicationDeployment.isZeroBinaryCopy() && (!applicationDeployment.isZeroEarCopy() || !applicationDeployment.isUseMetadataFromBinaries());
    }

    public static EARFile getEarFileForApp(WorkSpace workSpace, RepositoryContext repositoryContext, ResourceBundle resourceBundle, boolean bl) throws Exception {
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
        if (applicationDeployment.isUseMetadataFromBinaries()) {
            return ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, bl);
        }
        return ConfigRepoHelper.getEarFileFromDeployment(workSpace, repositoryContext);
    }

    public static EARFile getEarFileFromDeployment(WorkSpace workSpace, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEarFileFromWorkSpace");
        }
        if (ConfigRepoHelper.getAppDeploymentForApp(repositoryContext).isZeroBinaryCopy()) {
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0144E", new Object[]{repositoryContext.getName()}));
        }
        repositoryContext.extract(false);
        EARFile eARFile = AppInstallHelper.getEarFile(repositoryContext.getPath(), false, AppUtils.getBundle(null));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromWorkSpace: " + eARFile);
        }
        if (eARFile == null) {
            throw new AdminException("Can not instantiate earfile for: " + repositoryContext.getName());
        }
        return eARFile;
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, true);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string, boolean bl) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, bl);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, boolean bl) throws Exception {
        EARFile eARFile;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEarFileFromBinaries: " + repositoryContext);
            }
            eARFile = null;
            RepositoryContext repositoryContext2 = repositoryContext.getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            try {
                String string = repositoryContext.getName() + ".ear";
                if (repositoryContext.getParent().isAvailable(string)) {
                    repositoryContext.getParent().extract(string, false);
                    eARFile = AppInstallHelper.getEarFile(repositoryContext2.getPath() + File.separator + string, false, bl, resourceBundle);
                    break block8;
                }
                if (!bl) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), applicationDeployment.isZeroBinaryCopy() ? "ADMA0145E" : "ADMA0147E", new Object[]{repositoryContext.getName()}));
                }
                String string2 = ConfigRepoHelper.getAbsoluteBinariesURL(repositoryContext, workSpace);
                if (new File(string2).exists()) {
                    EList eList = applicationDeployment.getProperties();
                    for (int i = 0; i < eList.size(); ++i) {
                        Property property = (Property)eList.get(i);
                        if (!property.getName().equals("was.loose.config")) continue;
                        LooseConfigRegister.singleton().addLooseMapping(string2, property.getValue());
                        break;
                    }
                    eARFile = AppInstallHelper.getEarFile(string2, false, bl, resourceBundle);
                    break block8;
                }
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0173E", new String[]{repositoryContext.getName(), "getEarFile"}));
            }
            catch (Throwable throwable) {
                throw new AdminException(throwable, "Can not instantiate earfile for: " + repositoryContext2.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEarFileFromBinaries: " + eARFile);
        }
        return eARFile;
    }

    public static String getAbsoluteBinariesURL(RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        Object[] objectArray;
        ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
        String string = applicationDeployment.getBinariesURL();
        String string2 = System.getProperty("was.repository.root");
        if (string2 == null) {
            string2 = System.getProperty("user.install.root") + "/config";
        }
        if ((objectArray = AppUtils.getContextArray("nodes", repositoryContext.getParent().getParent(), workSpace)).length == 1) {
            VariableMap variableMap = AppUtils.createVarMap(string2, repositoryContext.getParent().getParent().getName(), ((RepositoryContext)objectArray[0]).getName(), null);
            string = AppUtils.convert2AbsPath(string, variableMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "binURL = " + string);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "This is not base hence no varmap: " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "binURL: " + string);
        }
        return string;
    }

    public static Resource getAppDeploymentResource(RepositoryContext repositoryContext) throws Exception {
        URI uRI = URI.createURI("deployment.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        return resource;
    }

    public static ApplicationDeployment getAppDeploymentForApp(RepositoryContext repositoryContext) throws Exception {
        return ConfigRepoHelper.getAppDeploymentForApp(ConfigRepoHelper.getAppDeploymentResource(repositoryContext));
    }

    public static ApplicationDeployment getAppDeploymentForApp(Resource resource) throws Exception {
        AppdeploymentPackageImpl.init();
        Deployment deployment = (Deployment)resource.getContents().get(0);
        return (ApplicationDeployment)deployment.getDeployedObject();
    }

    public static Vector getServersForAppDeployment(ApplicationDeployment applicationDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForAppDeployment");
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < applicationDeployment.getModules().size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)applicationDeployment.getModules().get(i);
            Vector vector3 = ConfigRepoHelper.getServersForModuleDeployment(moduleDeployment, vector, repositoryContext, workSpace, bl);
            vector2.addAll(vector3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for appDepl: " + vector2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForAppDeployment");
        }
        return vector2;
    }

    public static Vector getServersForAppDeploymentModule(ApplicationDeployment applicationDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForAppDeployment");
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < applicationDeployment.getModules().size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)applicationDeployment.getModules().get(i);
            if (moduleDeployment.getUri().equals(string)) continue;
            Vector vector3 = ConfigRepoHelper.getServersForModuleDeployment(moduleDeployment, vector, repositoryContext, workSpace, bl);
            vector2.addAll(vector3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for appDepl: " + vector2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForAppDeployment");
        }
        return vector2;
    }

    public static Vector getServersForModuleDeployment(ModuleDeployment moduleDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModuleDeployment");
        }
        Vector<Object> vector2 = new Vector<Object>();
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            Object object;
            DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)eList.get(i)).getTarget();
            if (deploymentTarget == null) continue;
            if (deploymentTarget instanceof ClusteredTarget) {
                object = AppUtils.findContext("clusters", deploymentTarget.getName(), null, repositoryContext, workSpace, true);
                if (object == null) {
                    if (vector != null) {
                        if (vector.contains(deploymentTarget.getName())) continue;
                        vector.addElement(deploymentTarget.getName());
                        continue;
                    }
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5027E", new Object[]{deploymentTarget.getName()}));
                }
                if (!vector2.contains(object)) {
                    vector2.addElement(object);
                }
            }
            if (!(deploymentTarget instanceof ServerTarget)) continue;
            object = ((ServerTarget)deploymentTarget).getNodeName();
            RepositoryContext repositoryContext2 = AppUtils.findContext("servers", deploymentTarget.getName(), (String)object, repositoryContext, workSpace, false);
            if (repositoryContext2 == null) {
                if (vector != null) {
                    if (vector.contains(deploymentTarget.getName())) continue;
                    vector.addElement(deploymentTarget.getName());
                    continue;
                }
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5028E", new Object[]{deploymentTarget.getName(), object}));
            }
            if (!bl && AppUtils.getClusterFromMember(AppUtils.findContext("servers", deploymentTarget.getName(), (String)object, repositoryContext, workSpace, false), workSpace) != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignoring  cluster member: " + deploymentTarget.getName());
                continue;
            }
            if (vector2.contains(repositoryContext2)) continue;
            vector2.addElement(repositoryContext2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Server for depl: " + vector2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModuleDeployment");
        }
        return vector2;
    }

    public static boolean validateTarget(List list, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServersForModuleDeployment");
        }
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)list.get(i)).getTarget();
            if (deploymentTarget == null) continue;
            if (deploymentTarget instanceof ClusteredTarget && (object = AppUtils.findContext("clusters", deploymentTarget.getName(), null, repositoryContext, workSpace, true)) == null) {
                return bl;
            }
            if (!(deploymentTarget instanceof ServerTarget)) continue;
            object = ((ServerTarget)deploymentTarget).getNodeName();
            RepositoryContext repositoryContext2 = AppUtils.findContext("servers", deploymentTarget.getName(), (String)object, repositoryContext, workSpace, false);
            if (repositoryContext2 != null) continue;
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServersForModuleDeployment");
        }
        return true;
    }

    public static Hashtable getNodeServerRelation(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeServerRelation");
        }
        Hashtable hashtable = new Hashtable();
        Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
        for (int i = 0; i < vector2.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector2.elementAt(i);
            Vector<RepositoryContext> vector3 = (Vector<RepositoryContext>)hashtable.get(repositoryContext.getParent());
            if (vector3 == null) {
                vector3 = new Vector<RepositoryContext>();
                hashtable.put(repositoryContext.getParent(), vector3);
            }
            if (vector3.contains(repositoryContext)) continue;
            vector3.addElement(repositoryContext);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node-server relation: " + hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeServerRelation");
        }
        return hashtable;
    }

    public static Vector getAllServers(WorkSpace workSpace, Vector vector) throws Exception {
        final WorkSpace workSpace2 = workSpace;
        final Vector vector2 = vector;
        Vector vector3 = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            vector3 = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConfigRepoHelper._getAllServersAsSystem(workSpace2, vector2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AdminException(exception, "Failed to get the servers");
        }
        return vector3;
    }

    private static Vector _getAllServersAsSystem(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "orig svrs: " + vector);
        }
        if (vector.size() == 0) {
            return vector;
        }
        Vector<RepositoryContext> vector2 = new Vector<RepositoryContext>();
        for (int i = 0; i < vector.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            if (AppUtils.isServer(repositoryContext) && !vector2.contains(repositoryContext)) {
                vector2.addElement(repositoryContext);
            }
            if (!AppUtils.isCluster(repositoryContext)) continue;
            URI uRI = URI.createURI("cluster.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cluster obj: " + serverCluster);
            }
            EList eList = serverCluster.getMembers();
            for (int j = 0; j < eList.size(); ++j) {
                ClusterMember clusterMember = (ClusterMember)eList.get(j);
                RepositoryContext repositoryContext2 = AppUtils.findContext("servers", clusterMember.getMemberName(), clusterMember.getNodeName(), repositoryContext.getParent(), workSpace, false);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{clusterMember.getMemberName(), repositoryContext.getName()}));
                }
                if (vector2.contains(repositoryContext2)) continue;
                vector2.addElement(repositoryContext2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ret svrs: " + vector2);
        }
        return vector2;
    }

    public static String getSIEntryText(RepositoryContext repositoryContext) {
        return repositoryContext.getParent().getName() + "/" + "deployments" + "/" + repositoryContext.getName();
    }

    public static RepositoryContext getAppContextFromSIEntry(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppContextFromSIEntry:" + string);
        }
        int n = string.indexOf("/");
        int n2 = string.lastIndexOf("/");
        if (n == -1 || n2 == -1 || n == n2) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppContextFromSIEntry: Malformed si entry");
            }
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 1, string.length());
        RepositoryContext repositoryContext2 = AppUtils.findContext("deployments", string3, string2, repositoryContext, workSpace, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppContextFromSIEntry:" + repositoryContext2);
        }
        return repositoryContext2;
    }

    public static Hashtable updateServerIndexDocs(RepositoryContext repositoryContext, WorkSpace workSpace, Vector vector, boolean bl, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerIndexDocs: " + vector);
        }
        Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(workSpace, vector);
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6018I", new Object[]{hashtable}));
        Hashtable hashtable2 = ConfigRepoHelper.getServerIndexDocs(workSpace, hashtable.keys());
        if (hashtable2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            return new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        Hashtable hashtable3 = new Hashtable();
        String string = ConfigRepoHelper.getSIEntryText(repositoryContext);
        String string2 = "";
        try {
            while (enumeration.hasMoreElements()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable.get(repositoryContext2);
                Vector<String> vector3 = new Vector<String>();
                for (int i = 0; i < vector2.size(); ++i) {
                    vector3.addElement(((RepositoryContext)vector2.elementAt(i)).getName());
                }
                Resource resource = (Resource)hashtable2.get(repositoryContext2);
                if (resource.getContents().size() == 0) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5070E", new Object[]{repositoryContext2.getName()}));
                }
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                ArrayList<String> arrayList = new ArrayList<String>();
                hashtable3.put(repositoryContext2.getName(), arrayList);
                string2 = repositoryContext2.getName();
                EList eList = serverIndex.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + repositoryContext2.getName() + " are " + vector3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + repositoryContext2.getName() + " are " + eList);
                }
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    if (!vector3.contains(serverEntry.getServerName())) continue;
                    if (bl) {
                        EList eList2 = serverEntry.getDeployedApplications();
                        if (!eList2.contains(string)) {
                            eList2.add(string);
                            AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6020I", new Object[]{repositoryContext, serverEntry.getServerName(), repositoryContext2.getName()}));
                        }
                    } else {
                        boolean bl2 = serverEntry.getDeployedApplications().remove(string);
                        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6021I", new Object[]{string, serverEntry.getServerName(), repositoryContext2.getName(), "" + bl2}));
                    }
                    arrayList.add(serverEntry.getServerName());
                }
                HashMap hashMap = new HashMap();
                resource.save(hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerIndexDocs: " + hashtable3);
            }
            return hashtable3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.ConfigRepoHelper.updateServerIndexDocs", "124");
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "Server Index update failed at  the last node of " + string2);
        }
    }

    public static String getNodeStrFromNodeSvrTable(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = bl ? "" : "+";
            stringBuffer.append(string2 + "WebSphere:cell=" + string + ",node=" + enumeration.nextElement());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static Hashtable getServerIndexDocs(WorkSpace workSpace, Enumeration enumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerIndexDocs");
        }
        Hashtable<RepositoryContext, Resource> hashtable = new Hashtable<RepositoryContext, Resource>();
        while (enumeration.hasMoreElements()) {
            RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
            URI uRI = URI.createURI("serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            if (resource == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{"serverindex.xml", repositoryContext}));
            }
            hashtable.put(repositoryContext, resource);
        }
        Tr.debug(tc, "retVal: " + hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerIndexDocs");
        }
        return hashtable;
    }

    public static String getDDUri(ModuleRef moduleRef) throws Exception {
        if (moduleRef.getAltDeploymentDescriptor() != null && !moduleRef.getAltDeploymentDescriptor().eResource().getURI().toString().equals("")) {
            return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
        }
        if (moduleRef.isEJB()) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleRef.isWeb()) {
            return "WEB-INF/web.xml";
        }
        if (moduleRef.isConnector()) {
            return "META-INF/ra.xml";
        }
        return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
    }

    public static String getDDUri(ModuleDeployment moduleDeployment) throws Exception {
        if (moduleDeployment.getAltDD() != null && !moduleDeployment.getAltDD().equals("")) {
            return moduleDeployment.getAltDD();
        }
        if (moduleDeployment instanceof EJBModuleDeployment) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleDeployment instanceof WebModuleDeployment) {
            return "WEB-INF/web.xml";
        }
        if (moduleDeployment instanceof ConnectorModuleDeployment) {
            return "META-INF/ra.xml";
        }
        return null;
    }

    public static Hashtable getCNP(String string, ApplicationDeployment applicationDeployment, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNP");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            String string3 = ConfigRepoHelper.getDDUri(moduleDeployment);
            if (string3 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unknown module deployment: " + moduleDeployment);
                continue;
            }
            String string4 = util.createUniqueModuleName(string3, moduleDeployment.getUri());
            if (!AppUtils.isEmpty(string)) {
                if (!string.equals(string4)) continue;
                hashtable.put(string4, ConfigRepoHelper.getCNP(moduleDeployment, string2));
                return hashtable;
            }
            hashtable.put(string4, ConfigRepoHelper.getCNP(moduleDeployment, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNP: " + hashtable);
        }
        return hashtable;
    }

    public static String getCNP(ModuleDeployment moduleDeployment, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNP: " + moduleDeployment);
        }
        String string2 = "";
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
            String string3 = "";
            if (deploymentTarget instanceof ClusteredTarget) {
                string3 = "WebSphere:cell=" + string + ",cluster=" + deploymentTarget.getName();
            } else {
                if (!(deploymentTargetMapping.getTarget() instanceof ServerTarget)) continue;
                string3 = "WebSphere:cell=" + string + ",node=" + ((ServerTarget)deploymentTarget).getNodeName() + ",server=" + deploymentTarget.getName();
            }
            if (deploymentTargetMapping.getConfig() != null && !AppUtils.isEmpty(((ModuleConfig)deploymentTargetMapping.getConfig()).getName())) {
                string3 = string3 + ",config=" + ((ModuleConfig)deploymentTargetMapping.getConfig()).getName();
            }
            string2 = AppUtils.isEmpty(string2) ? string3 : string2 + "+" + string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNP: " + string2);
        }
        return string2;
    }

    public static String getTargetString(RepositoryContext repositoryContext, String string) {
        String string2 = null;
        string2 = AppUtils.isCluster(repositoryContext) ? "WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName() : "WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName();
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static String getTargetString(ObjectName objectName, String string) {
        String string2 = "WebSphere:cell=" + objectName.getKeyProperty("cell") + ",node=" + objectName.getKeyProperty("node") + ",server=" + objectName.getKeyProperty("process");
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static Vector getServerNames(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, true, repositoryContext, workSpace);
    }

    public static Vector getServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        Vector vector = ConfigRepoHelper.getAddRemoveServerNames(string, string2, bl, repositoryContext, workSpace);
        return (Vector)vector.elementAt(0);
    }

    private static boolean parseServersString(String string, Vector vector, Vector vector2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseServerString: " + string);
        }
        boolean bl = false;
        String string2 = "-WebSphere:";
        String string3 = "+WebSphere:";
        if (!string.startsWith("+") && !string.startsWith("-")) {
            bl = true;
            if (string.indexOf(string2) > -1) {
                throw new AdminException("Target string: " + string + " without any delimiter prefix is specified for replacement, should" + "contain " + "+" + " delimiters only.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
        } else {
            Object object;
            String[] stringArray;
            Vector<String> vector3 = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "WebSphere:");
            while (stringTokenizer.hasMoreTokens()) {
                stringArray = (String[])stringTokenizer.nextElement();
                object = stringArray.substring(stringArray.length() - 1);
                if (!"+".equals(object) && !"-".equals(object)) continue;
                vector3.add((String)object);
            }
            stringArray = string.split("\\" + string3 + "|" + string2);
            object = new ArrayList<String>(Arrays.asList(stringArray));
            ((ArrayList)object).remove(0);
            AppUtils.dbg(tc, "delims = " + vector3);
            AppUtils.dbg(tc, "tokens = " + object);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string4 = (String)((ArrayList)object).get(i);
                String string5 = (String)vector3.elementAt(i);
                if ("+".equals(string5)) {
                    vector.add("WebSphere:" + string4);
                    continue;
                }
                if (!"-".equals(string5)) continue;
                vector2.add("WebSphere:" + string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseServerString: addList=" + vector + " , remList =" + vector2);
        }
        return bl;
    }

    public static Vector getAddRemoveServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddRemoveServerNames");
        }
        if (AppUtils.isEmpty(string)) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getAddRemoveServerNames: null");
            }
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl2 = ConfigRepoHelper.parseServersString(string, vector, vector2);
        Iterator iterator = vector2.iterator();
        Vector<String> vector3 = new Vector<String>();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!vector.contains(string3)) continue;
            vector.remove(string3);
            vector3.add(string3);
        }
        for (int i = 0; i < vector3.size(); ++i) {
            vector2.remove(vector3.elementAt(i));
        }
        Vector<Serializable> vector4 = new Vector<Serializable>();
        Vector vector5 = ConfigRepoHelper.getServerNames(vector, string2, bl, repositoryContext, workSpace);
        Vector vector6 = ConfigRepoHelper.getServerNames(vector2, string2, bl, repositoryContext, workSpace);
        vector4.add(0, vector5);
        vector4.add(1, vector6);
        vector4.add(2, new Boolean(bl2));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddRemoveServerNames: names to add = " + vector5 + " , names to rem = " + vector6 + " , straight replacement? " + bl2);
        }
        return vector4;
    }

    public static Vector getServerNames(Vector vector, String string, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        RepositoryContext repositoryContext2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNames: " + vector);
        }
        Vector<Object> vector2 = new Vector<Object>();
        if (vector == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "getServerNames: null");
            }
            return vector2;
        }
        Iterator iterator = vector.iterator();
        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
        while (iterator.hasNext()) {
            String string2;
            String string3 = ((String)iterator.next()).trim();
            if (AppUtils.isEmpty(string3)) continue;
            object = null;
            try {
                object = new ObjectName(string3);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad token: " + string3);
                }
                throw new AdminException(malformedObjectNameException, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string3}));
            }
            repositoryContext2 = null;
            String string4 = ((ObjectName)object).getKeyProperty("cluster");
            if (!AppUtils.isEmpty(string4)) {
                repositoryContext2 = AppUtils.findContext("clusters", string4 = string4.trim(), null, repositoryContext, workSpace, true);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5022E", new Object[]{string4, string}));
                }
            } else {
                string2 = ((ObjectName)object).getKeyProperty("server");
                if (AppUtils.isEmpty(string2)) {
                    string2 = ((ObjectName)object).getKeyProperty("process");
                }
                String string5 = ((ObjectName)object).getKeyProperty("node");
                if (AppUtils.isEmpty(string2)) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string3, string}));
                }
                string2 = string2.trim();
                repositoryContext2 = AppUtils.getContextFromArray(objectArray, string2, string5, false);
            }
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string3, string}));
            }
            string2 = ((ObjectName)object).getKeyProperty("config");
            if (string2 == null) {
                string2 = "";
            }
            if (!vector2.contains(repositoryContext2)) {
                vector2.addElement(repositoryContext2);
                if (!bl) continue;
                vector2.addElement(string2);
                continue;
            }
            Tr.warning(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5032W", new Object[]{repositoryContext2.getName(), vector, string3}));
        }
        for (int i = 0; i < vector2.size(); i += 2) {
            object = (RepositoryContext)vector2.elementAt(i);
            if (AppUtils.isCluster((RepositoryContext)object) || (repositoryContext2 = AppUtils.getClusterFromMember((RepositoryContext)object, workSpace)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target has member: " + object + " which belongs to " + repositoryContext2);
            }
            if (vector2.contains(repositoryContext2)) continue;
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5033E", new Object[]{object.getName(), repositoryContext2.getName(), string}));
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getServerNames: " + vector2);
        }
        return vector2;
    }

    public static String getModuleType(Object object) {
        if (object instanceof ModuleRef) {
            ModuleRef moduleRef = (ModuleRef)object;
            if (moduleRef.isEJB()) {
                return "moduletype.ejb";
            }
            if (moduleRef.isWeb()) {
                return "moduletype.web";
            }
            if (moduleRef.isConnector()) {
                return "moduletype.connector";
            }
        } else if (object instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)object;
            if (moduleFile.isEJBJarFile()) {
                return "moduletype.ejb";
            }
            if (moduleFile.isWARFile()) {
                return "moduletype.web";
            }
            if (moduleFile.isRARFile()) {
                return "moduletype.connector";
            }
        }
        return "moduletype.unknown";
    }

    public static boolean isDeployable(Object object) {
        if (object instanceof ModuleRef) {
            ModuleRef moduleRef = (ModuleRef)object;
            return moduleRef.isEJB() || moduleRef.isWeb() || moduleRef.isConnector();
        }
        if (object instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)object;
            return moduleFile.isEJBJarFile() || moduleFile.isWARFile() || moduleFile.isRARFile();
        }
        return false;
    }

    public static String find_index(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        String string3 = string;
        while (string2 != null) {
            int n = string3.lastIndexOf("-");
            if (n == -1) {
                string3 = string + "-" + Integer.toString(1);
            } else {
                String string4 = string3.substring(n + 1);
                try {
                    int n2 = Integer.valueOf(string4);
                    string3 = string.substring(0, n) + "-" + Integer.toString(++n2);
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string + "-" + Integer.toString(999);
                }
            }
            string2 = (String)hashtable.get(string3);
        }
        return string3;
    }

    public static ObjectName getObjectName(RepositoryContext repositoryContext) throws MalformedObjectNameException {
        if (AppUtils.isServer(repositoryContext)) {
            return new ObjectName("WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName());
        }
        return new ObjectName("WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName());
    }

    public static List getServerNameForServerEntries(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerNameForServerEntries");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)list.get(i);
            String string = serverEntry.getServerName();
            arrayList.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerNameForServerEntries", new Object[]{arrayList});
        }
        return arrayList;
    }

    public static ServerEntry createServerEntry(ServerIndex serverIndex, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerEntry", new Object[]{serverIndex, string});
        }
        ServerindexFactory serverindexFactory = null;
        ServerEntry serverEntry = null;
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        serverindexFactory = serverindexPackage.getServerindexFactory();
        serverEntry = serverindexFactory.createServerEntry();
        serverEntry.setServerName(string);
        serverEntry.setServerType("APPLICATION_SERVER");
        serverEntry.setServerDisplayName(string);
        serverIndex.getServerEntries().add(serverEntry);
        serverEntry.eResource().save(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerEntry");
        }
        return serverEntry;
    }

    public static ServerIndex getReferenceToSystemAppsXML(WorkSpace workSpace, Hashtable hashtable) throws WorkSpaceException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReferenceToSystemAppsXML");
        }
        String string = (String)hashtable.get("cell.name");
        String string2 = (String)hashtable.get("node.name");
        WorkSpace workSpace2 = workSpace;
        String string3 = "/cells/" + string + "/nodes/" + string2 + "/" + "systemapps.xml";
        File file = new File(workSpace2.getPath() + string3);
        String string4 = System.getProperty("was.repository.root");
        File file2 = new File(string4 + string3);
        AppUtils.dbg(tc, "xxx systemappsXMLPath = " + file);
        AppUtils.dbg(tc, "xxx systemappsXMLPathConfig  = " + file2);
        if (file.exists() || file2.exists()) {
            RepositoryContext repositoryContext = workSpace2.findContext("cells/" + string + "/nodes/" + string2);
            repositoryContext.extract("systemapps.xml", false);
            Resource resource = repositoryContext.getResourceSet().createResource(URI.createURI("systemapps.xml"));
            resource.load(new HashMap());
            return (ServerIndex)resource.getContents().get(0);
        }
        RepositoryContext repositoryContext = workSpace2.findContext("cells/" + string + "/nodes/" + string2);
        return ConfigRepoHelper.createSystemAppsXML(repositoryContext, workSpace2, hashtable);
    }

    public static ServerIndex createSystemAppsXML(RepositoryContext repositoryContext, WorkSpace workSpace, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSystemAppsXML", new Object[]{repositoryContext});
        }
        ServerindexFactory serverindexFactory = null;
        ServerindexPackage serverindexPackage = (ServerindexPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/serverindex.xmi");
        serverindexFactory = serverindexPackage.getServerindexFactory();
        ServerIndex serverIndex = serverindexFactory.createServerIndex();
        String string = (String)hashtable.get("host.name");
        serverIndex.setHostName(string);
        String string2 = ConfigRepoHelper.makeTemporary(serverIndex);
        ServerIndex serverIndex2 = (ServerIndex)ConfigRepoHelper.getTemporaryObject(string2);
        String string3 = ConfigRepoHelper.createFileInWorkSpace(workSpace, repositoryContext.getURI(), "systemapps.xml", serverIndex2, "systemapps.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSystemAppsXML");
        }
        return serverIndex2;
    }

    private static String createFileInWorkSpace(WorkSpace workSpace, String string, String string2, EObject eObject, String string3) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFileInWorkSpace", new Object[]{workSpace, string, string2, eObject, string3});
        }
        RepositoryContext repositoryContext = null;
        Resource resource = null;
        String string4 = null;
        String string5 = ConfigRepoHelper.decodeContextUri(string);
        AppUtils.dbg(tc, "contextURI = " + string5);
        try {
            repositoryContext = workSpace.findContext(string5);
            AppUtils.dbg(tc, "context = " + repositoryContext);
        }
        catch (WorkSpaceException workSpaceException) {
            Tr.error(tc, "error in finding context " + workSpaceException.toString());
            return null;
        }
        ResourceSet resourceSet = repositoryContext.getResourceSet();
        AppUtils.dbg(tc, "resourceSet = " + resourceSet);
        URI uRI = URI.createURI(string3);
        AppUtils.dbg(tc, "resourceSet.getResource " + resourceSet.getResource(uRI, false));
        if (!repositoryContext.isAvailable(string3) || resourceSet.getResource(uRI, false) == null) {
            Tr.warning(tc, "File " + string3 + " was not available in context, " + repositoryContext.getURI());
            object = workSpace.getResourceFactoryRegistry().getFactory(URI.createURI(string3));
            resource = object.createResource(URI.createURI(string3));
            resourceSet.getResources().add(resource);
            AppUtils.dbg(tc, "resource = " + resource);
        }
        if (eObject.eResource() != null) {
            ((XMIResource)eObject.eResource()).setID(eObject, null);
        }
        object = resource.getContents();
        object.add(eObject);
        try {
            resource.save(new HashMap());
            string4 = ((XMIResource)eObject.eResource()).getID(eObject);
        }
        catch (Exception exception) {
            Tr.error(tc, "error in saving resource for root object " + exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFileInWorkSpace");
        }
        return string4;
    }

    private static String decodeContextUri(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        string2 = string.replace(':', '/');
        return string2;
    }

    private static String makeTemporary(EObject eObject) {
        String string = RefObjectHelperFactory.getRefObjectHelper().makeTemporary(eObject);
        return string;
    }

    private static EObject getTemporaryObject(String string) {
        EObject eObject = RefObjectHelperFactory.getRefObjectHelper().getTemporaryObject(string);
        return eObject;
    }
}

