/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class AppSyncUtils {
    private static TraceComponent tc = Tr.register(AppSyncUtils.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    public static final String APPSYNC_STATUS_KEY = "syncstatus";
    public static final String APPSYNC_DELTA_FILESTBL_KEY = "filestbl";
    public static final String APPSYNC_STOPPEDDEPLOYLIST_KEY = "stoppedlist";
    public static final String APPSYNC_APPNAME = "appname";
    public static final int NULLEVENT = -1;
    private static int _cellType = -1;
    private static String _cellName = null;

    public static int shouldProcess(String string, String string2, String string3, boolean bl, boolean bl2) throws Exception {
        if (string.indexOf(CELLS_CONTEXT) == -1) {
            return 0;
        }
        if (string.endsWith("/workclass.xml")) {
            return 0;
        }
        if (string.startsWith(CELLS_CONTEXT + string2 + "/applications/") && (AppSyncUtils.isPathToEar(string, string2) || AppSyncUtils.isPathToDeployments(string, string2) || AppSyncUtils.isPathToDeltaxml(string))) {
            return 1;
        }
        if (AppSyncUtils.isPathToVariablesxml(string, string2)) {
            return 2;
        }
        if (AppSyncUtils.isPathToServerindexxml(string, string2, string3, bl, bl2)) {
            return 3;
        }
        return 0;
    }

    public static Resource getResource(ConfigRepository configRepository, String string, String string2) {
        try {
            String[] stringArray = configRepository.listResourceNames(string, 1, 0);
            if (stringArray == null || stringArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string + " not in config repository");
                }
                return null;
            }
            DocumentContentSource documentContentSource = configRepository.extract(string);
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI(string2);
            Resource resource = wASResourceSetImpl.createResource(uRI);
            HashMap hashMap = new HashMap();
            if (resource != null) {
                resource.load(documentContentSource.getSource(), hashMap);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res for: " + string + " is: " + resource);
            }
            return resource;
        }
        catch (Throwable throwable) {
            if (AdminServiceFactory.getAdminService() == null) {
                throwable.printStackTrace();
            } else {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.sync.AppSyncUtils.getResource", "109");
            }
            Tr.error(tc, "ADMA7005E", new Object[]{string});
            return null;
        }
    }

    public static String normalizeBinaryPath(VariableMap variableMap, String string) {
        String string2 = variableMap.expand(string);
        string2 = string2.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    public static String getMaxFilePermissionForApps(String string, String string2, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaxFilePermissionForApps");
        }
        String string3 = null;
        string3 = AppSyncUtils.getNode(string, string2, configRepository).getMaxFilePermissionForApps();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaxFilePermissionForApps");
        }
        return string3;
    }

    public static Node getNode(String string, String string2, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNode");
        }
        Resource resource = AppSyncUtils.getResource(configRepository, CELLS_CONTEXT + string + "/" + NODES_CONTEXT + string2 + "/node.xml", "node.xml");
        Node node = (Node)resource.getContents().get(0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNode", new Object[]{node});
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable buildSIMap(String string, String string2, ConfigRepository configRepository) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildSIMap");
        }
        Resource resource = AppSyncUtils.getResource(configRepository, CELLS_CONTEXT + string + "/" + NODES_CONTEXT + string2 + "/serverindex.xml", "serverindex.xml");
        Hashtable hashtable = new Hashtable();
        if (resource == null) {
            return hashtable;
        }
        try {
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            Vector<String> vector = null;
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                EList eList2 = serverEntry.getDeployedApplications();
                for (int j = 0; j < eList2.size(); ++j) {
                    String string3;
                    String string4 = (String)eList2.get(j);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "buildSIMap: siEntry = " + string4);
                    }
                    int n = string4.indexOf(47);
                    int n2 = string4.lastIndexOf(47);
                    if (n2 <= n) {
                        Tr.warning(tc, "ADMA7003E", (Object)new Object[]{string4});
                        throw new Exception("ERROR building SIMap");
                    }
                    String string5 = string4.substring(n2 + 1);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Entry :  appName: " + string5);
                    }
                    if ((vector = (Vector<String>)hashtable.get(string5)) == null) {
                        vector = new Vector<String>();
                    }
                    if (!vector.contains(string3 = serverEntry.getServerName())) {
                        vector.addElement(serverEntry.getServerName());
                    }
                    hashtable.put(string5, vector);
                }
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMA7002E", (Object)new Object[]{throwable});
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildSIMap");
        }
        return hashtable;
    }

    public static boolean isPathToVariablesxml(String string, String string2) {
        Tr.entry(tc, "isPathToVariablesxml: uri=" + string + ", cellname=" + string2);
        try {
            if (string.indexOf(CELLS_CONTEXT + string2) == -1) {
                Tr.exit(tc, "isPathToVariablesxml, false");
                return false;
            }
            if (string.endsWith("variables.xml")) {
                Tr.exit(tc, "isPathToVariablesxml, true");
                return true;
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error parsing url " + string + " for isPathToVariablesxml : " + throwable);
        }
        Tr.exit(tc, "isPathToVariablesxml, false");
        return false;
    }

    public static boolean isPathToServerindexxml(String string, String string2, String string3, boolean bl, boolean bl2) {
        Tr.entry(tc, "isPathToServerindexxml");
        try {
            if (string.indexOf(CELLS_CONTEXT + string2) == -1) {
                Tr.exit(tc, "isPathToServerindexxml, false");
                return false;
            }
            String string4 = CELLS_CONTEXT + string2 + "/" + NODES_CONTEXT + string3 + "/serverindex.xml";
            return string.equals(string4);
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error parsing url " + string + " for isPathToServerindexxml : " + throwable);
            Tr.exit(tc, "isPathToServerindexxml, false");
            return false;
        }
    }

    public static String getAppNameFromAppDoc(String string, String string2) {
        int n;
        String string3;
        String string4 = null;
        String string5 = CELLS_CONTEXT + string2 + "/applications/";
        String string6 = string.substring(string5.length() + 1);
        int n2 = string6.indexOf("/");
        if (n2 != -1) {
            string6 = string6.substring(n2 + 1);
        }
        if (string6.startsWith("deployments/")) {
            string3 = string6.substring("deployments".length() + 1);
            n = string3.indexOf("/");
            if (n != -1) {
                string4 = string3.substring(0, n);
            }
        } else if (string6.startsWith("deltas") && (n = (string3 = string6.substring(7)).indexOf("/")) != -1) {
            string4 = string3.substring(0, n);
        }
        if (string4 == null) {
            string3 = string6;
            n = string3.indexOf("/");
            if (n != -1 && n != 0) {
                string3 = string3.substring(0, n);
            }
            if ((n = string3.lastIndexOf(".ear")) != -1) {
                string4 = string3.substring(0, n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "return appname =" + string4);
        }
        return string4;
    }

    public static String getBinName(String string, String string2) {
        Tr.entry(tc, "getBinName: " + string);
        String string3 = CELLS_CONTEXT + string2 + "/" + "applications" + "/" + EditionHelper.getAppAndEdition(string)[0] + ".ear/" + EditionHelper.getAppEarName(string, "");
        Tr.exit(tc, "getBinName: " + string3);
        return string3;
    }

    public static String getDeplURI(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeplURI:" + string);
        }
        String string3 = CELLS_CONTEXT + string2 + "/" + "applications" + "/" + EditionHelper.getAppAndEdition(string)[0] + ".ear/" + "deployments" + "/" + string + "/deployment.xml";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeplURI: deplURI = " + string3);
        }
        return string3;
    }

    public static String getAppNameFromDepURI(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromDepURI: " + string);
        }
        String string2 = "";
        try {
            int n = string.indexOf("applications") + "applications".length() + 1;
            int n2 = string.indexOf("deployments") - 1;
            string2 = string.substring(n, n2);
            string2 = string2.substring(0, string2.lastIndexOf(".ear"));
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "getAppNameFromDepURI error in parsing URI " + string + ": " + throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromDepURI: appName = " + string2);
        }
        return string2;
    }

    public static String getAppNameFromEARURI(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromEARURI: " + string);
        }
        String string2 = "";
        try {
            string2 = string.substring(string.lastIndexOf(47) + 1);
            string2 = string2.substring(0, string2.lastIndexOf(".ear"));
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "getAppNameFromEARURI error in parsing URI " + string + ": " + throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromEARURI: appName = " + string2);
        }
        return string2;
    }

    public static String getAppNameFromDeltaURI(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppNameFromDeltaURI: " + string);
        }
        String string2 = "";
        try {
            String[] stringArray = string.split("/");
            string2 = stringArray[stringArray.length - 3];
            string2 = string2.substring(0, string2.lastIndexOf(".ear"));
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "getAppNameFromDeltaURI error in parsing URI " + string + ": " + throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppNameFromDeltaURI: appName = " + string2);
        }
        return string2;
    }

    public static boolean isPathToDeltaxml(String string) {
        Tr.entry(tc, "isPathToDeltaxml: " + string);
        try {
            if (string.indexOf("delta") != -1) {
                Tr.exit(tc, "isPathToDeltaxml, true");
                return true;
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error parsing uri " + string + " for isPathToDeltaxml.");
        }
        Tr.exit(tc, "isPathToDeltaxml: " + string + " =  false");
        return false;
    }

    public static boolean isPathToDeploymentxml(String string, String string2) {
        Tr.entry(tc, "isPathToDeploymentxml: uri=" + string + ", cellname=" + string2);
        try {
            if (string.indexOf(CELLS_CONTEXT + string2) == -1) {
                Tr.exit(tc, "isPathToDeploymentxml, false");
                return false;
            }
            if (string.indexOf("applications") != -1 && string.indexOf("deployments") != -1 && string.endsWith("deployment.xml")) {
                Tr.exit(tc, "isPathToDeploymentxml, true");
                return true;
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error parsing url " + string + " for isPathToDeploymentxml : " + throwable);
        }
        Tr.exit(tc, "isPathToDeploymentxml, false");
        return false;
    }

    public static boolean isPathToDeployments(String string, String string2) {
        Tr.entry(tc, "isPathToDeployments: uri=" + string + ", cellname=" + string2);
        try {
            if (string.indexOf(CELLS_CONTEXT + string2) == -1) {
                Tr.exit(tc, "isPathToDeployments, false");
                return false;
            }
            if (string.indexOf("applications") != -1 && string.indexOf("deployments") != -1) {
                Tr.exit(tc, "isPathToDeployments, true");
                return true;
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error parsing url " + string + " for isPathToDeployments : " + throwable);
        }
        Tr.exit(tc, "isPathToDeployments, false");
        return false;
    }

    public static boolean isPathToEar(String string, String string2) {
        Tr.entry(tc, "isPathToEar: uri=" + string + ", cellname=" + string2);
        try {
            String string3;
            String string4;
            int n;
            if (string.indexOf(CELLS_CONTEXT + string2) == -1) {
                Tr.exit(tc, "isPathToEar, false");
                return false;
            }
            if (string.indexOf("applications") != -1 && string.indexOf("deployments") == -1 && (n = (string4 = string.substring(string.indexOf("applications") + "applications".length() + 1)).indexOf("/")) != -1 && string4.startsWith(string3 = string4.substring(n + 1))) {
                Tr.exit(tc, "isPathToEar, true");
                return true;
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Error parsing url " + string + " for isPathToEAR : " + throwable);
        }
        Tr.exit(tc, "isPathToEar, false");
        return false;
    }

    public static String getDmgrNodeName(ConfigRepository configRepository, String string) {
        try {
            return AppSyncUtils.getNodeNameFromServer("DEPLOYMENT_MANAGER", configRepository, string);
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Problem getting the node name for the dmgr: " + throwable.getMessage());
            return null;
        }
    }

    public static String getNodeNameFromBaseServer(ConfigRepository configRepository, String string) {
        try {
            return AppSyncUtils.getNodeNameFromServer("APPLICATION_SERVER", configRepository, string);
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Problem getting the node name for the base server: " + throwable.getMessage());
            return null;
        }
    }

    private static String getNodeNameFromServer(String string, ConfigRepository configRepository, String string2) {
        String string3 = null;
        try {
            Vector vector = AppSyncUtils.getNodes(configRepository, string2);
            for (int i = 0; i < vector.size(); ++i) {
                Resource resource = AppSyncUtils.getResource(configRepository, CELLS_CONTEXT + string2 + "/" + NODES_CONTEXT + vector.elementAt(i) + "/serverindex.xml", "serverindex.xml");
                if (resource == null) continue;
                string3 = AppSyncUtils.findServerName(resource, string);
                resource.unload();
                resource = null;
                if (string3 == null) continue;
                return (String)vector.elementAt(i);
            }
        }
        catch (Throwable throwable) {
            Tr.debug(tc, "Problem getting the node name for the server: " + throwable.getMessage());
        }
        return null;
    }

    private static String findServerName(Resource resource, String string) throws Exception {
        if (!(string.equals("APPLICATION_SERVER") || string.equals("DEPLOYMENT_MANAGER") || string.equals("NODE_AGENT") || string.equals("GENERIC_SERVER") || string.equals("WEB_SERVER") || string.equals("MESSAGE_BROKER"))) {
            throw new Exception("ERROR: Invalid server type!");
        }
        EList eList = resource.getContents();
        ServerIndex serverIndex = null;
        for (int i = 0; i < eList.size(); ++i) {
            serverIndex = (ServerIndex)eList.get(i);
            EList eList2 = serverIndex.getServerEntries();
            for (int j = 0; j < eList2.size(); ++j) {
                ServerEntry serverEntry = (ServerEntry)eList2.get(j);
                String string2 = serverEntry.getServerType();
                if (!string2.equals(string)) continue;
                return serverEntry.getServerName();
            }
        }
        return null;
    }

    public static Vector getNodes(ConfigRepository configRepository, String string) throws Exception {
        Vector<String> vector = new Vector<String>();
        String string2 = (String)configRepository.getConfig().get("was.repository.root");
        String string3 = string2 + "/cells/" + string + "/nodes";
        File file = new File(string3);
        File[] fileArray = file.listFiles();
        String string4 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string4 = fileArray[i].getName();
            vector.add(string4);
        }
        return vector;
    }

    public static void setCellInfo(String string, int n) {
        _cellName = string;
        _cellType = n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Set to cell : " + string + " cell type : " + _cellType);
        }
    }

    public static boolean isCellDistributed(String string, ConfigRepository configRepository) {
        if (_cellType == -1 || !_cellName.equals(string)) {
            Resource resource = AppSyncUtils.getResource(configRepository, CELLS_CONTEXT + string + "/" + "cell.xml", "cell.xml");
            Cell cell = (Cell)resource.getContents().get(0);
            resource.unload();
            _cellName = string;
            _cellType = cell.getCellType().getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Changed to cell : " + string + " cell type : " + _cellType);
            }
        }
        return _cellType == 1;
    }

    public static String getSyncEventFromRepoEvent(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "DOCSADDED_KEY";
                break;
            }
            case 1: {
                string = "DOCSREMOVED_KEY";
                break;
            }
            case 2: {
                string = "DOCSMODIFIED_KEY";
            }
        }
        return string;
    }
}

