/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.dfltbndngs.utils;

import com.ibm.ejs.models.base.bindings.clientbnd.ApplicationClientBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.EjbRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceEnvRefBinding;
import com.ibm.ejs.models.base.bindings.commonbnd.ResourceRefBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.CMPConnectionFactoryBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.ejs.models.base.bindings.ejbbnd.MessageDrivenBeanBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.io.PrintStream;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ShowBindingsCmd {
    EARFile ear = null;
    PrintStream out = System.out;

    public ShowBindingsCmd(EARFile eARFile) {
        this.ear = eARFile;
        this.out = System.out;
    }

    public ShowBindingsCmd(EARFile eARFile, PrintStream printStream) {
        this.ear = eARFile;
        this.out = printStream;
    }

    public void execute() {
        this.showBindings(this.ear);
    }

    protected void showBindings(EARFile eARFile) {
        try {
            Iterator iterator = eARFile.getModuleFiles().iterator();
            System.out.println("\n------------------------");
            while (iterator.hasNext()) {
                Archive archive = (Archive)iterator.next();
                if (archive.isEJBJarFile()) {
                    this.showEjbJarBindings((EJBJarFile)archive);
                } else if (archive.isWARFile()) {
                    this.showWarBindings((WARFile)archive);
                } else if (archive.isApplicationClientFile()) {
                    this.showAppClientBindings((ApplicationClientFile)archive);
                }
                this.out.println("\n------------------------\n");
            }
            this.out.println();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd.showBindings", "95", this);
            this.out.println("ERROR displaying bindings info ... continuing:" + throwable.toString());
        }
    }

    protected void showEjbJarBindings(EJBJarFile eJBJarFile) {
        try {
            EObject eObject;
            Object object;
            Object object2;
            this.out.println();
            this.out.println(eJBJarFile.getName());
            EJBJarBinding eJBJarBinding = eJBJarFile.getBindings();
            EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
            CMPConnectionFactoryBinding cMPConnectionFactoryBinding = eJBJarBinding.getDefaultCMPConnectionFactory();
            if (cMPConnectionFactoryBinding != null && (object2 = cMPConnectionFactoryBinding.getJndiName()) != null) {
                this.out.println("  Default Connection Factory --> " + (String)object2 + "," + Preferences.RES_AUTH[cMPConnectionFactoryBinding.getResAuth().getValue()]);
            }
            if ((object2 = eJBJarBinding.getDefaultDatasource()) != null && (object = object2.getJndiName()) != null) {
                eObject = object2.getDefaultAuth();
                this.out.println("  Default Data Source --> " + (String)object + " (" + object2.getClass().getName() + ")");
            }
            object = eJBJar.getEnterpriseBeans().iterator();
            while (object.hasNext()) {
                try {
                    EObject eObject2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    eObject = (EnterpriseBean)object.next();
                    EnterpriseBeanBinding enterpriseBeanBinding = eJBJarBinding.getEJBBinding((EnterpriseBean)eObject);
                    if (eObject.isMessageDriven()) {
                        this.out.println("  " + eObject.getName());
                        this.out.println("    port: " + ((MessageDrivenBeanBinding)enterpriseBeanBinding).getListenerInputPortName());
                    } else {
                        this.out.println("  " + eObject.getName() + " --> " + enterpriseBeanBinding.getJndiName());
                        if (eObject.isContainerManagedEntity()) {
                            if (eJBJar.isVersion2_0Descriptor()) {
                                object6 = enterpriseBeanBinding.getCmpConnectionFactory();
                                if (object6 != null && object6.getJndiName() != null) {
                                    this.out.println("    Connection Factory --> " + object6.getJndiName() + "," + Preferences.RES_AUTH[object6.getResAuth().getValue()]);
                                } else {
                                    this.out.println("    Connection Factory --> default");
                                }
                            }
                            if (eJBJar.isVersion1_1Descriptor()) {
                                object6 = enterpriseBeanBinding.getDatasource();
                                if (object6 != null && object6.getJndiName() != null) {
                                    this.out.println("    Data Source --> " + object6.getJndiName());
                                } else {
                                    this.out.println("    Data Source --> default");
                                }
                            }
                        }
                    }
                    object6 = eObject.getEjbRefs().iterator();
                    while (object6.hasNext()) {
                        object5 = (EjbRef)object6.next();
                        object4 = enterpriseBeanBinding.getEjbRefBinding((EjbRef)object5);
                        this.out.println("    <ejb-ref> java:comp/env/" + object5.getName() + " --> " + object4.getJndiName());
                    }
                    object5 = eObject.getEjbLocalRefs().iterator();
                    while (object5.hasNext()) {
                        object4 = (EJBLocalRef)object5.next();
                        object3 = enterpriseBeanBinding.getEjbRefBinding((EjbRef)object4);
                        this.out.println("    <ejb-local-ref> java:comp/env/" + object4.getName() + " --> " + object3.getJndiName());
                    }
                    object4 = eObject.getResourceRefs().iterator();
                    while (object4.hasNext()) {
                        object3 = (ResourceRef)object4.next();
                        eObject2 = enterpriseBeanBinding.getResRefBinding((ResourceRef)object3);
                        this.out.println("    <resource-ref> java:comp/env/" + object3.getName() + " --> " + eObject2.getJndiName());
                    }
                    object3 = eObject.getResourceEnvRefs().iterator();
                    while (object3.hasNext()) {
                        eObject2 = (ResourceEnvRef)object4.next();
                        ResourceEnvRefBinding resourceEnvRefBinding = enterpriseBeanBinding.getResEnvRefBinding((ResourceEnvRef)eObject2);
                        this.out.println("    <resource-env-ref> java:comp/env/" + eObject2.getName() + " --> " + resourceEnvRefBinding.getJndiName());
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd.showEjbJarBindings", "238", this);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.dfltbndngs.utils.ShowBindingsCmd.showEjbJarBindings", "243", this);
        }
    }

    protected void showWarBindings(WARFile wARFile) {
        Object object;
        Object object2;
        WebApp webApp = wARFile.getDeploymentDescriptor();
        WebAppBinding webAppBinding = wARFile.getBindings();
        this.out.println();
        this.out.println(wARFile.getName());
        this.out.println("  <virtual-host> --> " + webAppBinding.getVirtualHostName());
        Iterator iterator = webAppBinding.getEjbRefBindings().iterator();
        while (iterator.hasNext()) {
            object2 = (EjbRefBinding)iterator.next();
            this.out.println("  <ejb-ref> java:comp/env/" + object2.getBindingEjbRef().getName() + " --> " + object2.getJndiName());
        }
        object2 = webAppBinding.getResRefBindings().iterator();
        while (object2.hasNext()) {
            object = (ResourceRefBinding)object2.next();
            this.out.println("    <resource-ref> java:comp/env/" + object.getBindingResourceRef().getName() + " --> " + object.getJndiName());
        }
        object = webAppBinding.getResourceEnvRefBindings().iterator();
        while (object.hasNext()) {
            ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)object.next();
            this.out.println("    <resource-env-ref> java:comp/env/" + resourceEnvRefBinding.getBindingResourceEnvRef().getName() + " --> " + resourceEnvRefBinding.getJndiName());
        }
    }

    protected void showAppClientBindings(ApplicationClientFile applicationClientFile) {
        Object object;
        Object object2;
        ApplicationClient applicationClient = applicationClientFile.getDeploymentDescriptor();
        ApplicationClientBinding applicationClientBinding = applicationClientFile.getBindings();
        this.out.println();
        this.out.println(applicationClientFile.getName());
        Iterator iterator = applicationClientBinding.getEjbRefs().iterator();
        while (iterator.hasNext()) {
            object2 = (EjbRefBinding)iterator.next();
            this.out.println("  <ejb-ref> java:comp/env/" + object2.getBindingEjbRef().getName() + " --> " + object2.getJndiName());
        }
        object2 = applicationClientBinding.getResourceRefs().iterator();
        while (object2.hasNext()) {
            object = (ResourceRefBinding)object2.next();
            this.out.println("    <resource-ref> java:comp/env/" + (object.getBindingResourceRef() != null ? object.getBindingResourceRef().getName() : "???") + " --> " + object.getJndiName());
        }
        object = applicationClientBinding.getResourceEnvRefBindings().iterator();
        while (object.hasNext()) {
            ResourceEnvRefBinding resourceEnvRefBinding = (ResourceEnvRefBinding)object.next();
            this.out.println("    <resource-env-ref> java:comp/env/" + (resourceEnvRefBinding.getBindingResourceEnvRef() != null ? resourceEnvRefBinding.getBindingResourceEnvRef().getName() : "???") + " --> " + resourceEnvRefBinding.getJndiName());
        }
    }
}

