/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.http.logging.impl.LoggerThread;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.HttpLogLevel;
import java.io.FileNotFoundException;

public class BaseLogger
implements HTTPLoggingService {
    private static final TraceComponent tc = Tr.register(BaseLogger.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final byte[] CRLF = new byte[]{13, 10};
    private LoggerThread accessLogger = null;
    private LoggerThread errorLogger = null;
    private HttpLogLevel myLogLevel = HttpConstants.LOG_WARN;
    private boolean accessEnabled = false;
    private boolean errorEnabled = false;
    private int accessFormat = 0;

    public void createAccessLogger(String string) throws FileNotFoundException {
        this.accessLogger = new LoggerThread(string);
        this.accessEnabled = false;
    }

    public void createErrorLogger(String string, String string2) throws FileNotFoundException {
        this.errorLogger = new LoggerThread(string);
        this.errorEnabled = false;
        this.setLogLevel(string2);
    }

    public boolean enableAccessLogging() {
        if (null == this.accessLogger) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Enable: Access log not created yet.");
            }
            return false;
        }
        this.accessEnabled = true;
        return true;
    }

    public boolean enableErrorLogging() {
        if (null == this.errorLogger) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Enable: Error log not created yet.");
            }
            return false;
        }
        this.errorEnabled = true;
        return true;
    }

    public boolean disableAccessLogging() {
        if (!this.isAccessLoggingEnabled()) {
            return true;
        }
        this.accessEnabled = false;
        return this.accessLogger.stop();
    }

    public boolean disableErrorLogging() {
        if (!this.isErrorLoggingEnabled()) {
            return true;
        }
        this.errorEnabled = false;
        return this.errorLogger.stop();
    }

    public boolean startAccessLogging() {
        if (!this.isAccessLoggingEnabled()) {
            return false;
        }
        boolean bl = this.accessLogger.start();
        if (!bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Access logger did not start properly");
            }
            this.accessLogger.stop();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Started access logger: " + this.accessLogger);
        }
        return bl;
    }

    public boolean startErrorLogging() {
        if (!this.isErrorLoggingEnabled()) {
            return false;
        }
        boolean bl = this.errorLogger.start();
        if (!bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error logger did not start properly");
            }
            this.errorLogger.stop();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Started error logger: " + this.errorLogger);
            }
            this.logConfiguration();
        }
        return bl;
    }

    public boolean stopAccessLogging() {
        if (!this.isAccessLoggingEnabled()) {
            return true;
        }
        return this.accessLogger.stop();
    }

    public boolean stopErrorLogging() {
        if (!this.isErrorLoggingEnabled()) {
            return true;
        }
        return this.errorLogger.stop();
    }

    public boolean destroy() {
        this.errorEnabled = false;
        this.accessEnabled = false;
        boolean bl = this.accessLogger.destroy() & this.errorLogger.destroy();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logger: destroy returning " + bl);
        }
        return bl;
    }

    public void log(HttpLogLevel httpLogLevel, String string, HttpServiceContext httpServiceContext) {
        if (null != string && this.isLoggingLevelEnabled(httpLogLevel)) {
            this.logMsg(httpLogLevel, HttpChannelUtils.getEnglishBytes(string), httpServiceContext);
        }
    }

    public void log(HttpLogLevel httpLogLevel, byte[] byArray, HttpServiceContext httpServiceContext) {
        if (null != byArray && this.isLoggingLevelEnabled(httpLogLevel)) {
            this.logMsg(httpLogLevel, byArray, httpServiceContext);
        }
    }

    private void logMsg(HttpLogLevel httpLogLevel, byte[] byArray, HttpServiceContext httpServiceContext) {
        block4: {
            try {
                StringBuffer stringBuffer = new StringBuffer(125);
                stringBuffer.append("[");
                stringBuffer.append(HttpDateFormat.getRef().getRFC1123Time());
                stringBuffer.append("] [");
                stringBuffer.append(httpLogLevel.getName());
                stringBuffer.append("] [");
                if (null == httpServiceContext) {
                    stringBuffer.append("-/-");
                } else {
                    stringBuffer.append(httpServiceContext.getRemoteAddr().getHostAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(httpServiceContext.getRemotePort());
                    stringBuffer.append("/");
                    stringBuffer.append(httpServiceContext.getLocalAddr().getHostAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(httpServiceContext.getLocalPort());
                }
                stringBuffer.append("] ");
                byte[] byArray2 = HttpChannelUtils.getBytes(stringBuffer);
                WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(byArray2.length + byArray.length + 2);
                wsByteBuffer.put(byArray2);
                wsByteBuffer.put(byArray);
                wsByteBuffer.put(CRLF);
                wsByteBuffer.flip();
                this.errorLogger.log(wsByteBuffer);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".logMsg", "184", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception while writing log msg: " + exception.getMessage());
            }
        }
    }

    public void logAccess(byte[] byArray) {
        block3: {
            if (null == byArray || !this.isAccessLoggingEnabled()) {
                return;
            }
            try {
                WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(byArray.length + 2);
                wsByteBuffer.put(byArray);
                wsByteBuffer.put(CRLF);
                wsByteBuffer.flip();
                this.accessLogger.log(wsByteBuffer);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".logAccess", "220", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception while writing log msg: " + exception.getMessage());
            }
        }
    }

    public void logAccess(StringBuffer stringBuffer) {
        block3: {
            if (null == stringBuffer || !this.isAccessLoggingEnabled()) {
                return;
            }
            try {
                WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocate(stringBuffer.length() + 2);
                wsByteBuffer.put(HttpChannelUtils.getBytes(stringBuffer));
                wsByteBuffer.put(CRLF);
                wsByteBuffer.flip();
                this.accessLogger.log(wsByteBuffer);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, this.getClass().getName() + ".logAccess", "353", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception while writing log msg: " + exception.getMessage());
            }
        }
    }

    public void logAccess(int n, HttpRequestMessage httpRequestMessage, HttpResponseMessage httpResponseMessage, String string, String string2, String string3, int n2) {
        block16: {
            if (!this.isAccessLoggingEnabled()) {
                return;
            }
            try {
                String string4;
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append(string3);
                if (null == string2) {
                    stringBuffer.append(" - - [");
                } else {
                    stringBuffer.append(" - ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" [");
                }
                stringBuffer.append(HttpDateFormat.getRef().getNCSATime());
                stringBuffer.append("] \"");
                stringBuffer.append(httpRequestMessage.getMethodValue().getName());
                stringBuffer.append(" ");
                stringBuffer.append(httpRequestMessage.getRequestURI());
                String string5 = httpRequestMessage.getQueryString();
                if (null != string5) {
                    stringBuffer.append("?");
                    stringBuffer.append(GenericUtils.nullOutPasswords(string5, (byte)38));
                }
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("\" ");
                stringBuffer.append(httpResponseMessage.getStatusCodeAsInt());
                stringBuffer.append(" ");
                if (-1 != httpResponseMessage.getContentLength()) {
                    stringBuffer.append(httpResponseMessage.getContentLength());
                } else {
                    stringBuffer.append(n2);
                }
                if (1 == n) {
                    string4 = httpRequestMessage.getHeaderAsString(HttpConstants.HDR_REFERER);
                    if (null == string4) {
                        stringBuffer.append(" -");
                    } else {
                        stringBuffer.append(" \"");
                        stringBuffer.append(string4);
                        stringBuffer.append("\"");
                    }
                    string4 = httpRequestMessage.getHeaderAsString(HttpConstants.HDR_USER_AGENT);
                    if (null == string4) {
                        stringBuffer.append(" -");
                    } else {
                        stringBuffer.append(" \"");
                        stringBuffer.append(string4);
                        stringBuffer.append('\"');
                    }
                    int n3 = httpRequestMessage.getNumberOfHeaderInstances(HttpConstants.HDR_COOKIE);
                    if (0 == n3) {
                        stringBuffer.append(" -");
                    } else {
                        stringBuffer.append(" \"");
                        stringBuffer.append(httpRequestMessage.getHeaderAsString(HttpConstants.HDR_COOKIE, 0));
                        for (int i = 1; i < n3; ++i) {
                            stringBuffer.append(", ");
                            stringBuffer.append(httpRequestMessage.getHeaderAsString(HttpConstants.HDR_COOKIE, i));
                        }
                        stringBuffer.append('\"');
                    }
                }
                string4 = WsByteBufferPoolManagerImpl.getRef().allocate(stringBuffer.length() + 2);
                string4.put(HttpChannelUtils.getBytes(stringBuffer));
                string4.put(CRLF);
                string4.flip();
                this.accessLogger.log((WsByteBuffer)string4);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, this.getClass().getName() + ".logAccess", "407", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Exception while writing log msg: " + throwable.getMessage());
            }
        }
    }

    public void logAccess(HttpRequestMessage httpRequestMessage, HttpResponseMessage httpResponseMessage, String string, String string2, String string3, int n) {
        this.logAccess(this.accessFormat, httpRequestMessage, httpResponseMessage, string, string2, string3, n);
    }

    public int getAccessFormat() {
        return this.accessFormat;
    }

    public boolean setAccessFormat(int n) {
        if (0 != n && 1 != n) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring invalid access format: " + n);
            }
            return false;
        }
        this.accessFormat = n;
        return true;
    }

    public boolean setAccessLogMaximumSize(int n) {
        boolean bl = this.accessLogger.setMaximumFileSize(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logger setAccessLogMaximumSize(" + n + "): " + bl);
        }
        return bl;
    }

    public boolean setErrorLogMaximumSize(int n) {
        boolean bl = this.errorLogger.setMaximumFileSize(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logger setErrorLogMaximumSize(" + n + "): " + bl);
        }
        return bl;
    }

    public HttpLogLevel getLogLevel() {
        return this.myLogLevel;
    }

    private void setLogLevel(HttpLogLevel httpLogLevel) {
        this.myLogLevel = httpLogLevel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logger: Log level set to " + httpLogLevel.getName());
        }
    }

    private void setLogLevel(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Input log level: " + string);
        }
        if (null == string || "".equals(string)) {
            this.setLogLevel(HttpConstants.LOG_DISABLED);
        } else if (HttpConstants.LOG_CRITICAL.getName().equalsIgnoreCase(string) || "CRITICAL".equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_CRITICAL);
        } else if (HttpConstants.LOG_ERROR.getName().equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_ERROR);
        } else if (HttpConstants.LOG_WARN.getName().equalsIgnoreCase(string) || "WARNING".equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_WARN);
        } else if (HttpConstants.LOG_INFO.getName().equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_INFO);
        } else if (HttpConstants.LOG_DEBUG.getName().equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_DEBUG);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown value found, disabling logger");
            }
            this.setLogLevel(HttpConstants.LOG_DISABLED);
        }
    }

    public boolean isAccessLoggingEnabled() {
        return this.accessEnabled;
    }

    public boolean isErrorLoggingEnabled() {
        return this.errorEnabled;
    }

    public boolean isLoggingLevelEnabled(HttpLogLevel httpLogLevel) {
        if (!this.isErrorLoggingEnabled() || null == httpLogLevel) {
            return false;
        }
        return 0 <= this.getLogLevel().compareTo(httpLogLevel);
    }

    private void logConfiguration() {
        if (!this.isLoggingLevelEnabled(HttpConstants.LOG_DEBUG)) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logging configuration to error log file.");
        }
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration specifies a loglevel of " + this.getLogLevel().getName()), null);
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration has the error file name as : " + this.errorLogger.getFilePathName()), null);
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Error log maximum file size is " + this.errorLogger.getMaximumFileSize()), null);
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Error log maximum number of backup files is " + this.errorLogger.getMaximumBackupFiles()), null);
        if (this.isAccessLoggingEnabled()) {
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration has the access file name as : " + this.accessLogger.getFilePathName()), null);
            if (1 == this.accessFormat) {
                this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration specifies the NCSA combined format for the service."), null);
            } else if (0 == this.accessFormat) {
                this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration specifies the NCSA common format for the service."), null);
            }
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Access log maximum file size is " + this.accessLogger.getMaximumFileSize()), null);
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Access log maximum number of backup files is " + this.accessLogger.getMaximumBackupFiles()), null);
        } else {
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Access log is disabled by configuration."), null);
        }
    }

    public boolean setAccessLogMaximumBackupFiles(int n) {
        boolean bl = this.accessLogger.setMaxiumBackupFiles(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logger setAccessLogMaximumBackupFiles(" + n + "): " + bl);
        }
        return bl;
    }

    public boolean setErrorLogMaximumBackupFiles(int n) {
        boolean bl = this.errorLogger.setMaxiumBackupFiles(n);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Logger setErrorLogMaximumBackupFiles(" + n + "): " + bl);
        }
        return bl;
    }
}

