/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.impl.CFEndPointImpl;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import java.util.Map;

public class WSChainData
extends ChainDataImpl {
    private static final TraceComponent tc = Tr.register(WSChainData.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private static final long serialVersionUID = 6952496898547823880L;
    protected String _acceptorID;
    protected boolean _enabled;

    public WSChainData(String string, FlowType flowType, ChannelData[] channelDataArray, ChannelFrameworkImpl channelFrameworkImpl, Map map) throws IncoherentChainException {
        super(string, flowType, channelDataArray, channelFrameworkImpl, map);
    }

    public String getAcceptorID() {
        return this._acceptorID;
    }

    public void setAcceptorID(String string) {
        this._acceptorID = string;
    }

    public String toString() {
        if (this._acceptorID == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n\tacceptorID = ");
        stringBuffer.append(this._acceptorID);
        return stringBuffer.toString();
    }

    public CFEndPoint getEndPoint() throws ChainNotInboundException, NoCFEndPointException, NullCFEndPointException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPoint");
        }
        CFEndPointImpl cFEndPointImpl = null;
        try {
            if (this.getType() != FlowType.INBOUND) {
                throw new ChainNotInboundException("Chain " + this.getName() + " is an outbound chain.");
            }
            cFEndPointImpl = new CFEndPointImpl(this, (WSChannelFrameworkImpl)this.framework);
        }
        catch (NoCFEndPointException noCFEndPointException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Chain " + this.getName() + " includes non WS channel factory.");
            }
            throw noCFEndPointException;
        }
        catch (NullCFEndPointException nullCFEndPointException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unexpected exception when building CFEndPoint for chain " + this.getName(), (Object)nullCFEndPointException);
            }
            throw nullCFEndPointException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPoint");
        }
        return cFEndPointImpl;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    protected void setEnabled(boolean bl) {
        this._enabled = bl;
    }
}

