/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bootstrap;

import com.ibm.ws.bootstrap.RASDelegator;
import com.ibm.ws.bootstrap.RASWsLoggerFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class WsLogManager
extends LogManager {
    private static final String CONFIGURE_BY_SERVER_PROPERTY_NAME = "java.util.logging.configureByServer";
    private static final String CONFIGURE_BY_LOGGING_PROPERTIES_FILE = "java.util.logging.configureByLoggingPropertiesFile";
    private static final boolean CHECK_CALLING_METHOD_FOR_GETLOGGER = "false".equals(System.getProperty("com.ibm.ws.bootstrap.logmanager.createNewLogger"));
    private static RASDelegator svRASDelegator = RASDelegator.getSingleton();
    private boolean resetEnabled = true;

    public void readConfiguration() throws IOException, SecurityException {
        String string = System.getProperty(CONFIGURE_BY_SERVER_PROPERTY_NAME);
        String string2 = System.getProperty(CONFIGURE_BY_LOGGING_PROPERTIES_FILE);
        if (string == null || string.equalsIgnoreCase("false") || "true".equalsIgnoreCase(string2)) {
            super.readConfiguration();
        }
        if ("true".equalsIgnoreCase(string2)) {
            Enumeration<String> enumeration = this.getLoggerNames();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                Logger logger = this.getLogger(string3);
                Handler[] handlerArray = logger.getHandlers();
                for (int i = 0; i < handlerArray.length; ++i) {
                    if (!(handlerArray[i] instanceof ConsoleHandler)) continue;
                    logger.removeHandler(handlerArray[i]);
                }
            }
        }
    }

    public synchronized Logger getLogger(String string) {
        try {
            Class.forName("com.ibm.ejs.ras.Tr", true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Logger logger = super.getLogger(string);
        if (logger == null) {
            boolean bl = true;
            if (CHECK_CALLING_METHOD_FOR_GETLOGGER) {
                bl = false;
                boolean bl2 = false;
                Exception exception = new Exception();
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    if (bl2) {
                        if (!stackTraceElementArray[i].getClassName().equals("java.util.logging.Logger") || !stackTraceElementArray[i].getMethodName().equals("getLogger")) break;
                        bl = true;
                        break;
                    }
                    if (!stackTraceElementArray[i].getClassName().equals("com.ibm.ws.bootstrap.WsLogManager") || !stackTraceElementArray[i].getMethodName().equals("getLogger")) continue;
                    bl2 = true;
                }
            }
            if (bl && (logger = svRASDelegator.createWsLogger(string)) != null) {
                this.addLogger(logger);
            }
        }
        return logger;
    }

    public void initWsLoggerFactory(RASWsLoggerFactory rASWsLoggerFactory) {
        svRASDelegator.setRASWsLogerFactory(rASWsLoggerFactory);
    }

    public void reset() throws SecurityException {
        if (this.resetEnabled) {
            super.reset();
        }
    }

    public void enableReset() {
        this.resetEnabled = true;
    }

    public void disableReset() {
        this.resetEnabled = false;
    }

    public boolean isResetEnabled() {
        return this.resetEnabled;
    }
}

