/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandMgrInitializer;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import java.io.InputStream;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IPlatformRunnable;

public class AdminClientTest
implements IPlatformRunnable {
    private static TraceComponent tc;

    public AdminClientTest() {
        System.out.println("AdminClientTest has been constructed");
    }

    private static void doSOAP(Properties properties, String string, String string2) {
        System.out.println("\n\n===================================================");
        System.out.println("jdh -- set properties for SOAP Connector .........\n\n");
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", string);
        properties.setProperty("port", string2);
        properties.setProperty("com.ibm.SOAP.ConfigURL", "/home/jheath/XFER/tacBundled/adminClient/soap.client.props");
        properties.setProperty("securityEnabled", "false");
        properties.setProperty("location", "remote");
        System.out.println("jdh -- properties were set for SOAP Connector .........\n\n");
    }

    private static void doRMI(Properties properties, String string, String string2) {
        System.out.println("\n\n===================================================");
        System.out.println("jdh -- set properties for RMI Connector .........\n\n");
        properties.setProperty("type", "RMI");
        properties.setProperty("host", string);
        properties.setProperty("port", string2);
        properties.setProperty("securityEnabled", "false");
        properties.setProperty("location", "remote");
        System.out.println("jdh -- properties were set for RMI Connector .........\n\n");
    }

    public static void main(String[] stringArray) throws Exception {
        Tr.entry(tc, "main");
        System.out.println("jdh -- in AdminClientTest:main()");
        new AdminClientTest().executeUtility();
    }

    public Object run(Object object) throws Exception {
        Tr.entry(tc, "run");
        System.out.println("jdh -- in AdminClientTest:run()");
        new AdminClientTest().executeUtility();
        return null;
    }

    private void executeUtility() throws Exception {
        PLoader pLoader = new PLoader();
        Properties properties = pLoader.loadProperties("wsproperties");
        properties.list(System.out);
        AdminClient adminClient = null;
        Properties properties2 = new Properties();
        AdminClientTest.doSOAP(properties2, (String)properties.get("HOST_NAME"), (String)properties.get("SOAP_PORT"));
        boolean bl = false;
        try {
            adminClient = AdminClientFactory.createAdminClient(properties2);
            System.out.println("adminClient = " + adminClient);
            bl = true;
            String string = adminClient.getType();
            System.out.println("jdh -- adminClient created; connectorType = " + string);
            Integer n = new Integer(0);
            System.out.println("jdh -- try to getMBeanCount()");
            n = adminClient.getMBeanCount();
            System.out.println("jdh -- getMBeanCount() returned:  " + n);
            System.out.println("jdh -- try to geterverMBean()");
            ObjectName objectName = adminClient.getServerMBean();
            System.out.println("jdh -- getServerMBean() returned:  " + objectName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(" Exception caught = " + exception.getMessage());
            System.exit(1);
        }
        if (bl) {
            System.out.println("Connected");
        } else {
            System.out.println("Not connected");
            System.exit(1);
        }
        AdminClientTest.cfgSvcTestCode(adminClient, "Node=" + properties.get("NODE_NAME") + ":Server=" + properties.get("SERVER_NAME"));
        AdminClientTest.cmdFrameworkTest(adminClient, (String)properties.get("NODE_NAME"));
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cmdFrameworkTest(AdminClient adminClient, String string) {
        System.out.println("in  cmdFrameWorkTest()");
        Object var2_2 = null;
        try {
            CommandMgrInitializer.initializeClientMode(adminClient);
            AdminClientTest.jafter("CommandMgrInitializer.initializeClientMode()");
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminClientTest.jafter("CommandMgr.getCommandMgr()");
            AdminCommand adminCommand = null;
            adminCommand = commandMgr.createCommand("getNodeBaseProductVersion");
            AdminClientTest.jafter("cmdMgr.createCommand");
            adminCommand.setParameter("nodeName", string);
            AdminClientTest.jafter("getNodeBaseProductVersion.setParameter()");
            adminCommand.execute();
            AdminClientTest.jafter("getNodeBaseProductVersion.execute()");
            CommandResult commandResult = adminCommand.getCommandResult();
            AdminClientTest.jafter("getNodeBaseProductVersion.getCommandResult()");
            System.out.println("CmdFrameworkTest got result:" + commandResult.getResult());
        }
        catch (Throwable throwable) {
            System.out.println("caught exception in CmdFrameWorkTest()");
            throwable.printStackTrace();
        }
        finally {
            if (var2_2 != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cfgSvcTestCode(AdminClient adminClient, String string) {
        System.out.println("jdh -- enter cfgSvcTestCode()");
        ConfigServiceProxy configServiceProxy = null;
        Session session = null;
        try {
            Object object;
            Object object2;
            AttributeList attributeList;
            AdminClientTest.jbefore("ConfigServiceProxy");
            configServiceProxy = new ConfigServiceProxy(adminClient);
            AdminClientTest.jafter("ConfigServiceProxy");
            AdminClientTest.jbefore("Session");
            session = new Session();
            AdminClientTest.jafter("Session");
            AdminClientTest.jafter("resolve");
            ObjectName objectName = configServiceProxy.resolve(session, string)[0];
            AdminClientTest.jbefore("resolve");
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "HTTPTransport");
            ObjectName[] objectNameArray = configServiceProxy.queryConfigObjects(session, objectName, objectName2, null);
            AdminClientTest.jafter("queryConfigObjects");
            for (int i = 0; i < objectNameArray.length; ++i) {
                attributeList = (AttributeList)configServiceProxy.getAttribute(session, objectNameArray[i], "address");
                AdminClientTest.jafter("configService.getAttribute() #1");
                object2 = ConfigServiceHelper.getAttributeValue(attributeList, "port");
                AdminClientTest.jafter("configService.getAttribute()Value");
                object = configServiceProxy.getAttribute(session, objectNameArray[i], "sslEnabled");
                AdminClientTest.jafter("configService.getAttribute() #2");
                if (Boolean.TRUE.equals(object)) {
                    System.out.print("HTTPS transport listens on port ");
                } else {
                    System.out.print("HTTP transport listens on port ");
                }
                System.out.println(object2 + ".");
            }
            objectName2 = ConfigServiceHelper.createObjectName(null, "SOAPConnector");
            AdminClientTest.jafter("ConfigServiceHelper.createObjectName()");
            ObjectName objectName3 = configServiceProxy.queryConfigObjects(session, objectName, objectName2, null)[0];
            attributeList = (AttributeList)configServiceProxy.getAttribute(session, objectName3, "SOAP_CONNECTOR_ADDRESS");
            object2 = ConfigServiceHelper.getAttributeValue(attributeList, "port");
            System.out.println("soap connector listens on port " + object2 + ".");
            objectName2 = ConfigServiceHelper.createObjectName(null, "NameServer");
            object = configServiceProxy.queryConfigObjects(session, objectName, objectName2, null)[0];
            attributeList = (AttributeList)configServiceProxy.getAttribute(session, (ObjectName)object, "BOOTSTRAP_ADDRESS");
            object2 = ConfigServiceHelper.getAttributeValue(attributeList, "port");
            System.out.println("NameServer bootstrap port listens on port " + object2 + ".");
            if (session == null) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        try {
            configServiceProxy.discard(session);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        finally {
            if (session != null) {
                try {
                    configServiceProxy.discard(session);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static void jbefore(String string) {
        System.out.println("jdh -- before event:  " + string);
    }

    private static void jafter(String string) {
        System.out.println("jdh -- after event:  " + string);
    }

    static {
        System.out.println("jdh -- AdminClientTest v 2.1 is loaded");
        tc = Tr.register(AdminClientTest.class, "Admin", "com.ibm.ws.client");
    }

    class PLoader {
        private static final boolean THROW_ON_LOAD_FAILURE = true;
        private static final boolean LOAD_AS_RESOURCE_BUNDLE = false;
        private static final String SUFFIX = ".props";

        PLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties loadProperties(String string, ClassLoader classLoader) {
            if (string == null) {
                throw new IllegalArgumentException("null input: name");
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith(SUFFIX)) {
                string = string.substring(0, string.length() - SUFFIX.length());
            }
            Properties properties = null;
            InputStream inputStream = null;
            try {
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                if (!(string = string.replace('.', '/')).endsWith(SUFFIX)) {
                    string = string.concat(SUFFIX);
                }
                if ((inputStream = classLoader.getResourceAsStream(string)) != null) {
                    properties = new Properties();
                    properties.load(inputStream);
                }
            }
            catch (Exception exception) {
                properties = null;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (properties == null) {
                throw new IllegalArgumentException("could not load [" + string + "]" + " as " + "a classloader resource");
            }
            return properties;
        }

        public Properties loadProperties(String string) {
            return this.loadProperties(string, Thread.currentThread().getContextClassLoader());
        }
    }
}

