/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import java.lang.reflect.Array;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class SampleSAFMappingModule
implements LoginModule {
    private static final String MAPPING_MODULE_NAME = "com.ibm.websphere.security.SampleSAFMappingModule";
    private static final int MAXIMUM_NAME_LENGTH = 8;
    private boolean useWSPrincipalName = true;
    private boolean debugEnabled = false;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        String string;
        if (map2.containsKey("debug") && (string = (String)map2.get("debug")) != null && string.toLowerCase().equals("true")) {
            this.debugEnabled = true;
        }
        if (this.debugEnabled) {
            this.debug("initialize() entry");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        if (this.options.containsKey("useWSPrincipalName") && (string = (String)this.options.get("useWSPrincipalName")) != null && string.toLowerCase().equals("false")) {
            this.useWSPrincipalName = false;
        }
        if (this.debugEnabled) {
            this.debug(new Object[]{"initialize() exit", this.subject, this.callbackHandler, this.sharedState, this.options});
        }
    }

    public boolean login() throws LoginException {
        if (this.debugEnabled) {
            this.debug("login() entry");
        }
        if (this.sharedState.containsKey("com.ibm.wsspi.security.token.zos_userid")) {
            if (this.debugEnabled) {
                this.debug("ZOS_USERID already exists:  so no additional work is needed");
            }
            this.succeeded = true;
        } else if (!this.sharedState.containsKey("WSPrincipal") || !this.sharedState.containsKey("WSCredential")) {
            if (this.debugEnabled) {
                this.debug("Principal or Credential is unavailable:  skipping this Login Module");
            }
            this.succeeded = false;
        } else {
            if (this.debugEnabled) {
                this.debug("Principal and Credential are available:  continue with login");
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            WSPrincipal wSPrincipal = (WSPrincipal)this.sharedState.get("WSPrincipal");
            WSCredential wSCredential = (WSCredential)this.sharedState.get("WSCredential");
            if (this.useWSPrincipalName) {
                if (this.debugEnabled) {
                    this.debug("Using name from WSPrincipal to obtain ZOS_USERID");
                }
                string = this.createName(wSPrincipal);
                String string4 = this.getRealm(wSCredential);
                string2 = string4 + "/" + string + " MappingModule:" + MAPPING_MODULE_NAME;
                string3 = "com.ibm.websphere.security.auth.WSPrincipal";
                this.succeeded = true;
            } else {
                if (this.debugEnabled) {
                    this.debug("Using Custom logic to obtain ZOS_USERID");
                }
                this.succeeded = false;
            }
            if (this.succeeded) {
                this.sharedState.put("com.ibm.wsspi.security.token.zos_userid", string);
                this.sharedState.put("com.ibm.wsspi.security.token.zos_audit_string", string2);
                this.sharedState.put("com.ibm.wsspi.security.token.caller_principal_class", string3);
                if (this.debugEnabled) {
                    this.debug(new Object[]{"Values have been stored into the shared state", string, string2, string3});
                }
            }
        }
        if (this.debugEnabled) {
            this.debug("login() exit");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debugEnabled) {
            this.debug("commit() entry");
        }
        boolean bl = this.succeeded;
        this.cleanup();
        if (this.debugEnabled) {
            this.debug("commit() exit");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debugEnabled) {
            this.debug("abort() entry");
        }
        boolean bl = this.succeeded;
        this.cleanup();
        if (this.debugEnabled) {
            this.debug("abort() exit");
        }
        return bl;
    }

    public boolean logout() throws LoginException {
        if (this.debugEnabled) {
            this.debug("logout() entry");
        }
        if (this.debugEnabled) {
            this.debug("logout() exit");
        }
        return true;
    }

    private void cleanup() {
        if (this.debugEnabled) {
            this.debug("cleanup() entry");
        }
        this.succeeded = false;
        if (this.debugEnabled) {
            this.debug("cleanup() exit");
        }
    }

    private void debug(Object object) {
        System.out.println("Debug: com.ibm.websphere.security.SampleSAFMappingModule");
        if (object != null) {
            if (object.getClass().isArray()) {
                int n = Array.getLength(object);
                for (int i = 0; i < n; ++i) {
                    System.out.println("\t" + Array.get(object, i));
                }
            } else {
                System.out.println("\t" + object);
            }
        }
    }

    private String getRealm(WSCredential wSCredential) {
        if (this.debugEnabled) {
            this.debug("getRealm() entry");
        }
        String string = null;
        try {
            string = wSCredential.getRealmName();
            if (this.debugEnabled) {
                this.debug("Got realm='" + string + "' from credential");
            }
        }
        catch (Exception exception) {
            if (this.debugEnabled) {
                this.debug(new Object[]{"Caught exception in getRealm: ", exception});
            }
            string = "UNKNOWN_REALM";
        }
        if (this.debugEnabled) {
            this.debug("getRealm() exit");
        }
        return string;
    }

    private String createName(WSPrincipal wSPrincipal) {
        int n;
        if (this.debugEnabled) {
            this.debug("createName() entry");
        }
        String string = wSPrincipal.getName();
        if (this.debugEnabled) {
            this.debug("Using name='" + string + "' from principal");
        }
        if ((n = string.indexOf("/") + 1) >= string.length()) {
            string = string.substring(0, n - 1);
            if (this.debugEnabled) {
                this.debug("Stripping trailing / from WSPrincipal name");
            }
        } else {
            string = string.substring(n);
        }
        if (string.length() > 8) {
            string = string.substring(0, 8);
            if (this.debugEnabled) {
                this.debug("WSPrincipal name shortened to " + string);
            }
        }
        string = string.toUpperCase();
        if (this.debugEnabled) {
            this.debug("createName() exit");
        }
        return string;
    }
}

