/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product;

import com.ibm.websphere.product.WASProductFile;
import com.ibm.websphere.product.WASProductInfo;
import java.io.File;
import java.util.Vector;

public class WASDirectory {
    public static final String ID_BASE = "BASE";
    public static final String ID_ND = "ND";
    public static final String ID_PME = "PME";
    public static final String ID_WBI = "WBI";
    public static final String ID_JDK = "JDK";
    public static final String ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String ID_EXPRESS = "EXPRESS";
    public static final String ID_XD = "XD";
    public static final String ID_CLIENT = "CLIENT";
    public static final String ID_PLUGIN = "PLG";
    public static final String ID_IHS = "IHS";
    public static final String ID_WXD = "WXD";
    private String m_sWasLocation = "";
    private WASProductInfo[] m_wpiWASProductInstances = null;
    private static String RELATIVE_PATH_TO_DTD_DIRECTORY = "properties/version/dtd";
    private static String RELATIVE_PATH_TO_VERSION_DIRECTORY = "properties/version";
    private static String PRODUCT_FILE_EXTENSION = ".product";
    private static final String ID_BASETRIAL = "BASETRIAL";
    private static final String ID_EXPRESSTRIAL = "EXPRESSTRIAL";

    public WASDirectory(String string) {
        this.setWasLocation(new File(string).getAbsolutePath());
        this.m_wpiWASProductInstances = this.parse();
    }

    public WASProductInfo[] getWASProductInfoInstances() {
        return this.m_wpiWASProductInstances;
    }

    public WASProductInfo getWASProductInfo(String string) {
        string = this.normalizedProductID(string);
        for (int i = 0; this.m_wpiWASProductInstances != null && i < this.m_wpiWASProductInstances.length; ++i) {
            if (!this.m_wpiWASProductInstances[i].getId().equalsIgnoreCase(string)) continue;
            return this.m_wpiWASProductInstances[i];
        }
        return null;
    }

    public boolean isThisProductInstalled(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        return wASProductInfo != null;
    }

    public String getName(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getName();
        }
        return null;
    }

    public String getVersion(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getVersion();
        }
        return null;
    }

    public String getBuildDate(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getBuildDate();
        }
        return null;
    }

    public String getBuildLevel(String string) {
        WASProductInfo wASProductInfo = this.getWASProductInfo(string);
        if (wASProductInfo != null) {
            return wASProductInfo.getBuildLevel();
        }
        return null;
    }

    public String getWasLocation() {
        return this.m_sWasLocation;
    }

    public static boolean refreshProductInfoCache() {
        return WASProductFile.refreshCache();
    }

    private void setWasLocation(String string) {
        this.m_sWasLocation = string;
    }

    private String[] getAllProductFilesDirectlyUnderDir(String string) {
        int n;
        String[] stringArray = null;
        String[] stringArray2 = new File(string).list();
        if (stringArray2 == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>(3);
        for (n = 0; n < stringArray2.length; ++n) {
            File file;
            if (!stringArray2[n].endsWith(PRODUCT_FILE_EXTENSION) || (file = new File(stringArray2[n])) == null || file.isDirectory()) continue;
            vector.add(stringArray2[n]);
        }
        if (vector.size() >= 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        return stringArray;
    }

    private String normalizedDirectory(String string) {
        if (!(string = new File(string).getAbsolutePath()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private String normalizedProductID(String string) {
        if (ID_BASETRIAL.equalsIgnoreCase(string)) {
            return ID_BASE;
        }
        if (ID_EXPRESSTRIAL.equalsIgnoreCase(string)) {
            return ID_EXPRESS;
        }
        return string;
    }

    private Object[] vectorToArray(Vector vector) {
        Object[] objectArray = null;
        if (vector.size() >= 0) {
            objectArray = new Object[vector.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = vector.elementAt(i);
            }
        }
        return objectArray;
    }

    private WASProductInfo[] parse() {
        String string = this.normalizedDirectory(this.getWasLocation());
        String string2 = string + RELATIVE_PATH_TO_VERSION_DIRECTORY;
        String string3 = string + RELATIVE_PATH_TO_DTD_DIRECTORY;
        String[] stringArray = this.getAllProductFilesDirectlyUnderDir(string2);
        WASProductInfo[] wASProductInfoArray = null;
        if (stringArray != null) {
            int n;
            Vector<WASProductInfo> vector = new Vector<WASProductInfo>();
            for (n = 0; n < stringArray.length; ++n) {
                WASProductFile wASProductFile = WASProductFile.getWASProductFileInstance(string3, string2, stringArray[n]);
                if (wASProductFile == null) continue;
                WASProductInfo[] wASProductInfoArray2 = wASProductFile.getWASProductInfoArray();
                for (int i = 0; i < wASProductInfoArray2.length; ++i) {
                    vector.add(wASProductInfoArray2[i]);
                }
            }
            if (vector.size() >= 0) {
                wASProductInfoArray = new WASProductInfo[vector.size()];
                for (n = 0; n < wASProductInfoArray.length; ++n) {
                    wASProductInfoArray[n] = (WASProductInfo)vector.elementAt(n);
                }
            }
        }
        return wASProductInfoArray;
    }
}

