/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PmiModuleConfig
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = 9139791110927568058L;
    private String UID;
    private String description;
    private String mbeanType = null;
    private HashMap perfData;
    private String statsNLSFile;
    private int[] dependList = null;
    private boolean hasSubMod = false;
    private boolean hasSubModInit = false;

    public PmiModuleConfig(String string) {
        this.UID = string;
        this.perfData = new HashMap();
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setMbeanType(String string) {
        this.mbeanType = string;
    }

    public void setResourceBundle(String string) {
        this.statsNLSFile = string;
    }

    public synchronized void addData(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo != null) {
            this.perfData.put(new Integer(pmiDataInfo.getId()), pmiDataInfo);
        }
    }

    public synchronized void removeData(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo != null && this.perfData != null) {
            this.perfData.remove(new Integer(pmiDataInfo.getId()));
        }
    }

    public String getResourceBundle() {
        return this.statsNLSFile;
    }

    public int getNumData() {
        return this.perfData.size();
    }

    public String getUID() {
        return this.UID;
    }

    public String getShortName() {
        int n = this.UID.lastIndexOf(".");
        return this.UID.substring(n + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public String getMbeanType() {
        return this.mbeanType;
    }

    public int getDataId(String string) {
        Iterator iterator = this.perfData.values().iterator();
        while (iterator.hasNext()) {
            PmiDataInfo pmiDataInfo = (PmiDataInfo)iterator.next();
            if (!pmiDataInfo.getName().equalsIgnoreCase(string)) continue;
            return pmiDataInfo.getId();
        }
        return -1;
    }

    public PmiDataInfo getDataInfo(int n) {
        return (PmiDataInfo)this.perfData.get(new Integer(n));
    }

    public PmiDataInfo[] submoduleMembers(String string) {
        return this.submoduleMembers(string, 15);
    }

    public PmiDataInfo[] submoduleMembers(String string, int n) {
        PmiDataInfo[] pmiDataInfoArray;
        if (string == null) {
            return this.listLevelData(n);
        }
        ArrayList<PmiDataInfo[]> arrayList = new ArrayList<PmiDataInfo[]>();
        boolean bl = false;
        if (string.startsWith("ejb.")) {
            bl = true;
        }
        Iterator iterator = this.perfData.values().iterator();
        while (iterator.hasNext()) {
            pmiDataInfoArray = (PmiDataInfo[])iterator.next();
            if (bl) {
                if (!pmiDataInfoArray.getCategory().equals("all") && !this.isInCategory(string, pmiDataInfoArray.getCategory())) continue;
                arrayList.add(pmiDataInfoArray);
                continue;
            }
            if (pmiDataInfoArray.getSubmoduleName() == null || !pmiDataInfoArray.getSubmoduleName().equals(string) || pmiDataInfoArray.getLevel() > n) continue;
            arrayList.add(pmiDataInfoArray);
        }
        pmiDataInfoArray = new PmiDataInfo[arrayList.size()];
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            pmiDataInfoArray[i] = (PmiDataInfo)arrayList.get(i);
        }
        return pmiDataInfoArray;
    }

    public PmiDataInfo[] listData(String string) {
        if (string == null) {
            return this.listAllData();
        }
        return this.submoduleMembers(string);
    }

    public PmiDataInfo[] listAllData() {
        return this.listLevelData(15);
    }

    public PmiDataInfo[] listLevelData(int n) {
        PmiDataInfo[] pmiDataInfoArray;
        ArrayList<PmiDataInfo[]> arrayList = new ArrayList<PmiDataInfo[]>();
        Iterator iterator = this.perfData.values().iterator();
        while (iterator.hasNext()) {
            pmiDataInfoArray = (PmiDataInfo[])iterator.next();
            if (pmiDataInfoArray.getLevel() > n) continue;
            arrayList.add(pmiDataInfoArray);
        }
        pmiDataInfoArray = new PmiDataInfo[arrayList.size()];
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            pmiDataInfoArray[i] = (PmiDataInfo)arrayList.get(i);
        }
        return pmiDataInfoArray;
    }

    public PmiDataInfo[] listMyLevelData(int n) {
        ArrayList<PmiDataInfo> arrayList = new ArrayList<PmiDataInfo>();
        Iterator iterator = this.perfData.values().iterator();
        while (iterator.hasNext()) {
            PmiDataInfo pmiDataInfo = (PmiDataInfo)iterator.next();
            if (pmiDataInfo.getLevel() != n) continue;
            arrayList.add(pmiDataInfo);
        }
        return (PmiDataInfo[])arrayList.toArray();
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("UID:" + this.UID);
        printWriter.println("description:" + this.description);
        PmiDataInfo[] pmiDataInfoArray = this.listAllData();
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            pmiDataInfoArray[i].print(printWriter);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Stats type=").append(this.UID);
        stringBuffer.append(", Description=").append(this.description).append("\n");
        PmiDataInfo[] pmiDataInfoArray = this.listAllData();
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            stringBuffer.append("\n").append(pmiDataInfoArray[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    private boolean isInCategory(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public int[] listStatisticsWithDependents() {
        if (this.dependList == null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Iterator iterator = this.perfData.values().iterator();
            while (iterator.hasNext()) {
                PmiDataInfo pmiDataInfo = (PmiDataInfo)iterator.next();
                if (pmiDataInfo.getDependency() == null) continue;
                arrayList.add(new Integer(pmiDataInfo.getId()));
            }
            this.dependList = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.dependList[i] = (Integer)arrayList.get(i);
            }
        }
        return this.dependList;
    }

    public int[] listStatisticsBySet(String string) {
        Object object;
        if (string.equals("none") || string.equals("custom")) {
            return new int[0];
        }
        int n = 0;
        if (string.equals("basic")) {
            n = 1;
        } else if (string.equals("extended")) {
            n = 2;
        } else if (string.equals("all")) {
            n = 3;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        Iterator iterator = this.perfData.values().iterator();
        while (iterator.hasNext()) {
            object = (PmiDataInfo)iterator.next();
            String string2 = ((PmiDataInfo)object).getStatisticSet();
            if (string2.equals("basic")) {
                if (n <= 0) continue;
                arrayList.add(new Integer(((PmiDataInfo)object).getId()));
                continue;
            }
            if (string2.equals("extended")) {
                if (n <= 1) continue;
                arrayList.add(new Integer(((PmiDataInfo)object).getId()));
                continue;
            }
            if (!string2.equals("all") || n <= 2) continue;
            arrayList.add(new Integer(((PmiDataInfo)object).getId()));
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }

    public boolean hasSubModule() {
        if (!this.hasSubModInit) {
            this.hasSubModInit = true;
            if (this.perfData != null) {
                Iterator iterator = this.perfData.values().iterator();
                while (iterator.hasNext()) {
                    PmiDataInfo pmiDataInfo = (PmiDataInfo)iterator.next();
                    if (pmiDataInfo.getSubmoduleName() == null) continue;
                    this.hasSubMod = true;
                    break;
                }
            }
        }
        return this.hasSubMod;
    }

    public PmiModuleConfig copy() {
        PmiModuleConfig pmiModuleConfig = new PmiModuleConfig(this.UID);
        if (this.description != null) {
            pmiModuleConfig.description = new String(this.description);
        }
        pmiModuleConfig.mbeanType = this.mbeanType;
        pmiModuleConfig.statsNLSFile = this.statsNLSFile;
        pmiModuleConfig.hasSubMod = this.hasSubMod;
        pmiModuleConfig.dependList = this.dependList;
        if (this.perfData != null) {
            Iterator iterator = this.perfData.values().iterator();
            while (iterator.hasNext()) {
                PmiDataInfo pmiDataInfo = (PmiDataInfo)iterator.next();
                pmiModuleConfig.perfData.put(new Integer(pmiDataInfo.getId()), pmiDataInfo.copy());
            }
        }
        return pmiModuleConfig;
    }
}

