/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.util;

import commonj.sdo.DataObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeCoercionUtil {
    public static final int BUFFER_SIZE = 1024;
    public static final int OBJECT = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int STRING = 4;
    public static final int DOUBLE = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int INTEGER = 8;
    public static final int BIGDECIMAL = 9;
    public static final int DATE = 10;
    public static final int TIME = 11;
    public static final int TIMESTAMP = 12;
    public static final int BLOB = 13;
    public static final int CLOB = 14;
    public static final int JAVA_UTIL_DATE = 15;
    public static final int INTEGER_PRIMITIVE = 21;
    public static final int BYTE_PRIMITIVE = 22;
    public static final int SHORT_PRIMITIVE = 23;
    public static final int LONG_PRIMITIVE = 24;
    public static final int FLOAT_PRIMITIVE = 25;
    public static final int DOUBLE_PRIMITIVE = 26;
    public static final int CHAR_PRIMITIVE = 27;
    public static final int BOOLEAN_PRIMITIVE = 28;
    public static final int UNKNOWN = -1;
    public static final int DATA_OBJECT = 18;
    public static final int LIST = 19;
    public static final int BYTE_ARRAY = 20;
    public static final String INTEGER_NAME = "java.lang.Integer";
    public static final String BOOLEAN_NAME = "java.lang.Boolean";
    public static final String BYTE_NAME = "java.lang.Byte";
    public static final String SHORT_NAME = "java.lang.Short";
    public static final String STRING_NAME = "java.lang.String";
    public static final String DOUBLE_NAME = "java.lang.Double";
    public static final String LONG_NAME = "java.lang.Long";
    public static final String FLOAT_NAME = "java.lang.Float";
    public static final String OBJECT_NAME = "java.lang.Object";
    public static final String BIGDECIMAL_NAME = "java.math.BigDecimal";
    public static final String DATE_NAME = "java.sql.Date";
    public static final String TIME_NAME = "java.sql.Time";
    public static final String TIMESTAMP_NAME = "java.sql.Timestamp";
    public static final String BLOB_NAME = "java.sql.Blob";
    public static final String CLOB_NAME = "java.sql.Clob";
    public static final String JAVA_UTIL_DATE_NAME = "java.util.Date";
    public static final String BYTE_ARRAY_NAME = "byte[]";
    public static final String INTEGER_PRIMITIVE_NAME = "int";
    public static final String BYTE_PRIMITIVE_NAME = "byte";
    public static final String SHORT_PRIMITIVE_NAME = "short";
    public static final String LONG_PRIMITIVE_NAME = "long";
    public static final String FLOAT_PRIMITIVE_NAME = "float";
    public static final String DOUBLE_PRIMITIVE_NAME = "double";
    public static final String CHAR_PRIMITIVE_NAME = "char";
    public static final String BOOLEAN_PRIMITIVE_NAME = "boolean";
    public static final String LIST_NAME = "java.util.List";
    private static final Object fMutex = "mutex";
    private static Map fNameToIntMap;
    private static Map fIntToNameMap;

    public static Object coerceType(String string, Object object) throws ClassCastException {
        Object v = TypeCoercionUtil.getNameToIntegerMap().get(string);
        int n = -1;
        if (v instanceof Integer) {
            n = (Integer)v;
        }
        return TypeCoercionUtil.coerceType(n, object);
    }

    public static Object coerceType(int n, Object object) {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 8: 
            case 21: {
                object = TypeCoercionUtil.coerceToInteger(object);
                break;
            }
            case 1: 
            case 28: {
                object = TypeCoercionUtil.coerceToBoolean(object);
                break;
            }
            case 2: 
            case 22: {
                object = TypeCoercionUtil.coerceToByte(object);
                break;
            }
            case 3: 
            case 23: {
                object = TypeCoercionUtil.coerceToShort(object);
                break;
            }
            case 4: {
                object = TypeCoercionUtil.coerceToString(object);
                break;
            }
            case 5: 
            case 26: {
                object = TypeCoercionUtil.coerceToDouble(object);
                break;
            }
            case 6: 
            case 24: {
                object = TypeCoercionUtil.coerceToLong(object);
                break;
            }
            case 7: 
            case 25: {
                object = TypeCoercionUtil.coerceToFloat(object);
                break;
            }
            case 9: {
                object = TypeCoercionUtil.coerceToBigDecimal(object);
                break;
            }
            case 15: {
                object = TypeCoercionUtil.coerceToJavaUtilDate(object);
                break;
            }
            case 13: 
            case 20: {
                object = TypeCoercionUtil.coerceToBlob(object);
                break;
            }
            case 14: {
                object = TypeCoercionUtil.coerceToClob(object);
                break;
            }
            case 10: {
                object = TypeCoercionUtil.coerceToDate(object);
                break;
            }
            case 11: {
                object = TypeCoercionUtil.coerceToTime(object);
                break;
            }
            case 12: {
                object = TypeCoercionUtil.coerceToTimeStamp(object);
                break;
            }
            case 18: {
                object = TypeCoercionUtil.coerceToDataObject(object);
                break;
            }
            case 19: {
                object = TypeCoercionUtil.coerceToList(object);
            }
        }
        return object;
    }

    public static BigDecimal coerceToBigDecimal(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof BigDecimal ? (BigDecimal)object : (object instanceof String ? (object.equals("") ? null : new BigDecimal((String)object)) : (object instanceof Double ? new BigDecimal(object.toString()) : (object instanceof Float ? new BigDecimal(object.toString()) : (object instanceof Long ? new BigDecimal((double)((Long)object).longValue()) : (object instanceof Short ? new BigDecimal((double)((Short)object).shortValue()) : (object instanceof Integer ? new BigDecimal((double)((Integer)object).intValue()) : (object instanceof Byte ? new BigDecimal(((Byte)object).doubleValue()) : (object instanceof Boolean ? new BigDecimal((Boolean)object != false ? 1.0 : 0.0) : (object instanceof Date ? new BigDecimal((double)((Date)object).getTime()) : (object instanceof Time ? new BigDecimal((double)((Time)object).getTime()) : (object instanceof Timestamp ? new BigDecimal((double)((Timestamp)object).getTime()) : (BigDecimal)object)))))))))));
        return object2;
    }

    public static byte[] coerceToBlob(Object object) throws ClassCastException {
        byte[] byArray = null;
        if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                byArray = blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            byArray = TypeCoercionUtil.readToByteArray(inputStream);
        }
        return byArray;
    }

    private static byte[] readToByteArray(InputStream inputStream) {
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[1024];
        try {
            int n;
            do {
                if ((n = inputStream.read(byArray2)) <= 0) continue;
                byte[] byArray3 = new byte[byArray.length + n];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
                byArray = byArray3;
            } while (n != -1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public static Byte coerceToByte(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Byte ? (Byte)object : (object instanceof String ? (object.equals("") ? null : new Byte((String)object)) : (object instanceof Integer ? new Byte(((Integer)object).byteValue()) : (object instanceof Long ? new Byte(((Long)object).byteValue()) : (object instanceof Short ? new Byte(((Short)object).byteValue()) : (object instanceof Double ? new Byte(((Double)object).byteValue()) : (object instanceof Float ? new Byte(((Float)object).byteValue()) : (object instanceof Boolean ? new Byte((byte)((Boolean)object != false ? 1 : 0)) : (object instanceof BigDecimal ? new Byte(((BigDecimal)object).byteValue()) : (object instanceof Date ? new Byte((byte)((Date)object).getTime()) : (object instanceof Time ? new Byte((byte)((Time)object).getTime()) : (object instanceof Timestamp ? new Byte((byte)((Timestamp)object).getTime()) : (Byte)object)))))))))));
        return object2;
    }

    public static Boolean coerceToBoolean(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Boolean ? (Boolean)object : (object instanceof String ? (object.equals("") ? null : new Boolean((String)object)) : (object instanceof Byte ? new Boolean((Byte)object != 0) : (object instanceof Integer ? new Boolean((Integer)object != 0) : (object instanceof Short ? new Boolean((Short)object != 0) : (object instanceof Long ? new Boolean((Long)object != 0L) : (object instanceof Double ? new Boolean((Double)object != 0.0) : (object instanceof Float ? new Boolean(((Float)object).floatValue() != 0.0f) : (object instanceof BigDecimal ? new Boolean(((BigDecimal)object).doubleValue() != 0.0) : new Boolean(object != null)))))))));
        return object2;
    }

    public static Integer coerceToInteger(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Integer ? (Integer)object : (object instanceof String ? (object.equals("") ? null : new Integer((String)object)) : (object instanceof Long ? new Integer(((Long)object).intValue()) : (object instanceof Short ? new Integer(((Short)object).intValue()) : (object instanceof Double ? new Integer(((Double)object).intValue()) : (object instanceof Float ? new Integer(((Float)object).intValue()) : (object instanceof Byte ? new Integer(((Byte)object).intValue()) : (object instanceof Boolean ? new Integer((Boolean)object != false ? 1 : 0) : (object instanceof BigDecimal ? new Integer(((BigDecimal)object).intValue()) : (object instanceof Date ? new Integer((int)((Date)object).getTime()) : (object instanceof Time ? new Integer((int)((Time)object).getTime()) : (object instanceof Timestamp ? new Integer((int)((Timestamp)object).getTime()) : (Integer)object)))))))))));
        return object2;
    }

    public static java.util.Date coerceToJavaUtilDate(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof java.util.Date ? (java.util.Date)object : (object instanceof String ? (object.equals("") ? null : new java.util.Date(Long.parseLong((String)object))) : (object instanceof Long ? new java.util.Date((Long)object) : (object instanceof Time ? new java.util.Date(((Time)object).getTime()) : (object instanceof Timestamp ? new java.util.Date(((Timestamp)object).getTime()) : (object instanceof Date ? new java.util.Date(((Date)object).getTime()) : (object instanceof Integer ? new java.util.Date(((Integer)object).longValue()) : (object instanceof Short ? new java.util.Date(((Short)object).longValue()) : (object instanceof Double ? new java.util.Date(((Double)object).longValue()) : (object instanceof Float ? new java.util.Date(((Float)object).longValue()) : (object instanceof Byte ? new java.util.Date(((Byte)object).longValue()) : (object instanceof BigDecimal ? new java.util.Date(((BigDecimal)object).longValue()) : (java.util.Date)object)))))))))));
        return object2;
    }

    public static String coerceToClob(Object object) throws ClassCastException {
        String string = null;
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                string = TypeCoercionUtil.readToString(clob.getAsciiStream());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        } else {
            string = object instanceof InputStream ? TypeCoercionUtil.readToString((InputStream)object) : (object != null ? object.toString() : null);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readToString(InputStream inputStream) {
        String string;
        byte[] byArray = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                stringBuffer.append(byArray);
            } while (n != -1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            string = stringBuffer.toString();
        }
        return string;
    }

    public static DataObject coerceToDataObject(Object object) throws ClassCastException {
        DataObject dataObject = null;
        dataObject = (DataObject)object;
        return dataObject;
    }

    public static Date coerceToDate(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Date ? (Date)object : (object instanceof String ? (object.equals("") ? null : new Date(Long.parseLong((String)object))) : (object instanceof Long ? new Date((Long)object) : (object instanceof Time ? new Date(((Time)object).getTime()) : (object instanceof Timestamp ? new Date(((Timestamp)object).getTime()) : (object instanceof java.util.Date ? new Date(((java.util.Date)object).getTime()) : (object instanceof Integer ? new Date(((Integer)object).longValue()) : (object instanceof Short ? new Date(((Short)object).longValue()) : (object instanceof Double ? new Date(((Double)object).longValue()) : (object instanceof Float ? new Date(((Float)object).longValue()) : (object instanceof Byte ? new Date(((Byte)object).longValue()) : (object instanceof BigDecimal ? new Date(((BigDecimal)object).longValue()) : (Date)object)))))))))));
        return object2;
    }

    public static Double coerceToDouble(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Double ? (Double)object : (object instanceof String ? (object.equals("") ? null : new Double((String)object)) : (object instanceof Float ? new Double(((Float)object).floatValue()) : (object instanceof Long ? new Double(((Long)object).longValue()) : (object instanceof Short ? new Double(((Short)object).shortValue()) : (object instanceof Integer ? new Double(((Integer)object).intValue()) : (object instanceof Byte ? new Double(((Byte)object).doubleValue()) : (object instanceof Boolean ? new Double((Boolean)object != false ? 1.0 : 0.0) : (object instanceof BigDecimal ? new Double(((BigDecimal)object).doubleValue()) : (object instanceof Date ? new Double(((Date)object).getTime()) : (object instanceof Time ? new Double(((Time)object).getTime()) : (object instanceof Timestamp ? new Double(((Timestamp)object).getTime()) : (Double)object)))))))))));
        return object2;
    }

    public static Float coerceToFloat(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Float ? (Float)object : (object instanceof String ? (object.equals("") ? null : new Float((String)object)) : (object instanceof Double ? new Float(((Double)object).floatValue()) : (object instanceof Long ? new Float(((Long)object).longValue()) : (object instanceof Short ? new Float(((Short)object).shortValue()) : (object instanceof Integer ? new Float(((Integer)object).intValue()) : (object instanceof Byte ? new Float(((Byte)object).floatValue()) : (object instanceof Boolean ? new Float((Boolean)object != false ? 1.0f : 0.0f) : (object instanceof BigDecimal ? new Float(((BigDecimal)object).floatValue()) : (object instanceof Date ? new Float(((Date)object).getTime()) : (object instanceof Time ? new Float(((Time)object).getTime()) : (object instanceof Timestamp ? new Float(((Timestamp)object).getTime()) : (Float)object)))))))))));
        return object2;
    }

    public static List coerceToList(Object object) throws ClassCastException {
        List list = null;
        list = object instanceof List ? (List)object : (List)object;
        return list;
    }

    public static Long coerceToLong(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Long ? (Long)object : (object instanceof String ? (object.equals("") ? null : new Long((String)object)) : (object instanceof Integer ? new Long(((Integer)object).longValue()) : (object instanceof Short ? new Long(((Short)object).longValue()) : (object instanceof Double ? new Long(((Double)object).longValue()) : (object instanceof Float ? new Long(((Float)object).longValue()) : (object instanceof Byte ? new Long(((Byte)object).longValue()) : (object instanceof Boolean ? new Long((Boolean)object != false ? 1L : 0L) : (object instanceof BigDecimal ? new Long(((BigDecimal)object).longValue()) : (object instanceof Date ? new Long(((Date)object).getTime()) : (object instanceof Time ? new Long(((Time)object).getTime()) : (object instanceof Timestamp ? new Long(((Timestamp)object).getTime()) : (Long)object)))))))))));
        return object2;
    }

    public static Short coerceToShort(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Short ? (Short)object : (object instanceof String ? (object.equals("") ? null : new Short((String)object)) : (object instanceof Integer ? new Short(((Integer)object).shortValue()) : (object instanceof Long ? new Short(((Long)object).shortValue()) : (object instanceof Double ? new Short(((Double)object).shortValue()) : (object instanceof Float ? new Short(((Float)object).shortValue()) : (object instanceof Byte ? new Short(((Byte)object).shortValue()) : (object instanceof Boolean ? new Short((short)((Boolean)object != false ? 1 : 0)) : (object instanceof BigDecimal ? new Short(((BigDecimal)object).shortValue()) : (object instanceof Date ? new Short((short)((Date)object).getTime()) : (object instanceof Time ? new Short((short)((Time)object).getTime()) : (object instanceof Timestamp ? new Short((short)((Timestamp)object).getTime()) : (Short)object)))))))))));
        return object2;
    }

    public static String coerceToString(Object object) throws ClassCastException {
        String string = null;
        string = object instanceof InputStream ? TypeCoercionUtil.readToString((InputStream)object) : (object != null ? object.toString() : null);
        return string;
    }

    public static Time coerceToTime(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Time ? (Time)object : (object instanceof String ? (object.equals("") ? null : new Time(Long.parseLong((String)object))) : (object instanceof Long ? new Time((Long)object) : (object instanceof Date ? new Time(((Date)object).getTime()) : (object instanceof Timestamp ? new Time(((Timestamp)object).getTime()) : (object instanceof java.util.Date ? new Time(((java.util.Date)object).getTime()) : (object instanceof Integer ? new Time(((Integer)object).longValue()) : (object instanceof Short ? new Time(((Short)object).longValue()) : (object instanceof Double ? new Time(((Double)object).longValue()) : (object instanceof Float ? new Time(((Float)object).longValue()) : (object instanceof Byte ? new Time(((Byte)object).longValue()) : (object instanceof BigDecimal ? new Time(((BigDecimal)object).longValue()) : (Time)object)))))))))));
        return object2;
    }

    public static Timestamp coerceToTimeStamp(Object object) throws ClassCastException {
        Object object2 = null;
        object2 = object instanceof Timestamp ? (Timestamp)object : (object instanceof String ? (object.equals("") ? null : new Timestamp(Long.parseLong((String)object))) : (object instanceof Long ? new Timestamp((Long)object) : (object instanceof Date ? new Timestamp(((Date)object).getTime()) : (object instanceof Time ? new Timestamp(((Time)object).getTime()) : (object instanceof java.util.Date ? new Timestamp(((java.util.Date)object).getTime()) : (object instanceof Integer ? new Timestamp(((Integer)object).longValue()) : (object instanceof Short ? new Timestamp(((Short)object).longValue()) : (object instanceof Double ? new Timestamp(((Double)object).longValue()) : (object instanceof Float ? new Timestamp(((Float)object).longValue()) : (object instanceof Byte ? new Timestamp(((Byte)object).longValue()) : (object instanceof BigDecimal ? new Timestamp(((BigDecimal)object).longValue()) : (Timestamp)object)))))))))));
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getNameToIntegerMap() {
        if (fNameToIntMap == null) {
            Object object = fMutex;
            synchronized (object) {
                fNameToIntMap = new HashMap(48);
                fNameToIntMap.put(INTEGER_NAME, new Integer(8));
                fNameToIntMap.put(BOOLEAN_NAME, new Integer(1));
                fNameToIntMap.put(BYTE_NAME, new Integer(2));
                fNameToIntMap.put(SHORT_NAME, new Integer(3));
                fNameToIntMap.put(STRING_NAME, new Integer(4));
                fNameToIntMap.put(DOUBLE_NAME, new Integer(5));
                fNameToIntMap.put(LONG_NAME, new Integer(6));
                fNameToIntMap.put(FLOAT_NAME, new Integer(7));
                fNameToIntMap.put(INTEGER_PRIMITIVE_NAME, new Integer(21));
                fNameToIntMap.put(BOOLEAN_PRIMITIVE_NAME, new Integer(28));
                fNameToIntMap.put(BYTE_PRIMITIVE_NAME, new Integer(22));
                fNameToIntMap.put(SHORT_PRIMITIVE_NAME, new Integer(23));
                fNameToIntMap.put(DOUBLE_PRIMITIVE_NAME, new Integer(26));
                fNameToIntMap.put(LONG_PRIMITIVE_NAME, new Integer(24));
                fNameToIntMap.put(FLOAT_PRIMITIVE_NAME, new Integer(25));
                fNameToIntMap.put(OBJECT_NAME, new Integer(0));
                fNameToIntMap.put(BIGDECIMAL_NAME, new Integer(9));
                fNameToIntMap.put(DATE_NAME, new Integer(10));
                fNameToIntMap.put(TIME_NAME, new Integer(11));
                fNameToIntMap.put(TIMESTAMP_NAME, new Integer(12));
                fNameToIntMap.put(BLOB_NAME, new Integer(13));
                fNameToIntMap.put(CLOB_NAME, new Integer(14));
                fNameToIntMap.put(JAVA_UTIL_DATE_NAME, new Integer(15));
                fNameToIntMap.put(BYTE_ARRAY_NAME, new Integer(20));
            }
        }
        return fNameToIntMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getIntegerToNameMap() {
        if (fIntToNameMap == null) {
            Object object = fMutex;
            synchronized (object) {
                fIntToNameMap = new HashMap(48);
                fIntToNameMap.put(new Integer(8), INTEGER_NAME);
                fIntToNameMap.put(new Integer(1), BOOLEAN_NAME);
                fIntToNameMap.put(new Integer(2), BYTE_NAME);
                fIntToNameMap.put(new Integer(3), SHORT_NAME);
                fIntToNameMap.put(new Integer(4), STRING_NAME);
                fIntToNameMap.put(new Integer(5), DOUBLE_NAME);
                fIntToNameMap.put(new Integer(6), LONG_NAME);
                fIntToNameMap.put(new Integer(7), FLOAT_NAME);
                fIntToNameMap.put(new Integer(0), OBJECT_NAME);
                fIntToNameMap.put(new Integer(9), BIGDECIMAL_NAME);
                fIntToNameMap.put(new Integer(10), DATE_NAME);
                fIntToNameMap.put(new Integer(11), TIME_NAME);
                fIntToNameMap.put(new Integer(12), TIMESTAMP_NAME);
                fIntToNameMap.put(new Integer(13), BLOB_NAME);
                fIntToNameMap.put(new Integer(14), CLOB_NAME);
                fIntToNameMap.put(new Integer(15), JAVA_UTIL_DATE_NAME);
                fIntToNameMap.put(new Integer(20), BYTE_ARRAY_NAME);
            }
        }
        return fIntToNameMap;
    }
}

