/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.D;
import com.ibm.toad.utils.StringArrayEnumeration;
import com.ibm.toad.utils.StringEnumEnumeration;
import com.ibm.toad.utils.StringEnumUniqueEnumeration;
import com.ibm.toad.utils.StringIterEnumeration;
import com.ibm.toad.utils.StringListEnumeration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class Strings {
    private Strings() {
    }

    public static UniqueEnumeration makeUniqueEnumeration(Enumeration enumeration) {
        return new Set(enumeration).elements();
    }

    public static UniqueEnumeration castToUniqueEnumeration(Enumeration enumeration) {
        D.pre(enumeration != null);
        if (enumeration instanceof UniqueEnumeration) {
            return (UniqueEnumeration)enumeration;
        }
        return new StringEnumUniqueEnumeration(enumeration);
    }

    public static String toString(java.util.Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(List list) {
        return Strings.toString(Strings.makeEnumeration(list));
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return Strings.toString(Strings.makeEnumeration((List)null));
        }
        return Strings.toString(Strings.makeEnumeration(stringArray));
    }

    public static String[] toArray(Enumeration enumeration) {
        D.pre(enumeration != null);
        int n = 0;
        List list = null;
        while (enumeration.hasMoreElements()) {
            list = new List(enumeration.nextString(), list);
            ++n;
        }
        String[] stringArray = new String[n];
        while (list != null) {
            stringArray[--n] = list.head;
            list = list.tail;
        }
        D.azzert(n == 0);
        return stringArray;
    }

    public static String[] toArray(Set set) {
        D.pre(set != null);
        String[] stringArray = new String[set.size()];
        UniqueEnumeration uniqueEnumeration = set.elements();
        int n = 0;
        while (uniqueEnumeration.hasMoreElements()) {
            stringArray[n] = uniqueEnumeration.nextString();
            ++n;
        }
        return stringArray;
    }

    public static Enumeration toSortedEnumeration(Enumeration enumeration) {
        D.pre(enumeration != null);
        Object[] objectArray = Strings.toArray(enumeration);
        Arrays.sort(objectArray);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return Strings.makeEnumeration(arrayList.iterator());
    }

    public static Enumeration makeEnumeration(java.util.Enumeration enumeration) {
        return new StringEnumEnumeration(enumeration);
    }

    public static Enumeration makeEnumeration(Iterator iterator) {
        return new StringIterEnumeration(iterator);
    }

    public static Enumeration makeEnumeration(List list) {
        return new StringListEnumeration(list);
    }

    public static Enumeration makeEnumeration() {
        return new StringListEnumeration(null);
    }

    public static Enumeration makeEnumeration(String[] stringArray) {
        return new StringArrayEnumeration(stringArray);
    }

    public static List makeList(Enumeration enumeration) {
        List list = null;
        while (enumeration.hasMoreElements()) {
            list = new List(enumeration.nextString(), list);
        }
        return List.reverse(list);
    }

    public static void insertFrom(Set set, Enumeration enumeration) {
        D.pre(set != null);
        D.pre(enumeration != null);
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextString());
        }
    }

    public static boolean areDisjoint(Set set, Set set2) {
        if (set.size() > set2.size()) {
            return Strings.areDisjoint(set2, set);
        }
        UniqueEnumeration uniqueEnumeration = set.elements();
        while (uniqueEnumeration.hasMoreElements()) {
            if (!set2.isMember(uniqueEnumeration.nextString())) continue;
            return false;
        }
        return true;
    }

    public static Enumeration getIntersection(Set set, Set set2) {
        if (set.size() > set2.size()) {
            return Strings.getIntersection(set2, set);
        }
        List list = null;
        UniqueEnumeration uniqueEnumeration = set.elements();
        while (uniqueEnumeration.hasMoreElements()) {
            String string = uniqueEnumeration.nextString();
            if (!set2.isMember(string)) continue;
            list = new List(string, list);
        }
        return Strings.makeEnumeration(list);
    }

    public static final class List {
        public String head;
        public List tail;

        public List(String string, List list) {
            this.head = string;
            this.tail = list;
        }

        public static void concat(List list, List list2) {
            D.pre(list != null);
            List list3 = list;
            while (list3.tail != null) {
                list3 = list3.tail;
            }
            list3.tail = list2;
        }

        public static List consEnum(List list, Enumeration enumeration) {
            D.pre(enumeration != null);
            while (enumeration.hasMoreElements()) {
                list = new List((String)enumeration.nextElement(), list);
            }
            return list;
        }

        public static int length(List list) {
            int n = 0;
            while (list != null) {
                ++n;
                list = list.tail;
            }
            return n;
        }

        public static List reverse(List list) {
            List list2 = null;
            while (list != null) {
                list2 = new List(list.head, list2);
                list = list.tail;
            }
            return list2;
        }
    }

    public static final class Set {
        private HashMap set = new HashMap();
        private boolean immutable = false;

        public Set() {
        }

        public Set(Enumeration enumeration) {
            this();
            D.pre(enumeration != null);
            this.add(enumeration);
        }

        public boolean isImmutable() {
            return this.immutable;
        }

        public void makeImmutable() {
            this.immutable = true;
        }

        public boolean isMember(String string) {
            D.pre(string != null);
            return this.set.containsKey(string);
        }

        public void add(String string) {
            D.pre(!this.immutable);
            D.pre(string != null);
            this.set.put(string, null);
        }

        public void remove(String string) {
            D.pre(!this.immutable);
            D.pre(string != null);
            this.set.remove(string);
        }

        public void add(Enumeration enumeration) {
            D.pre(enumeration != null);
            while (enumeration.hasMoreElements()) {
                this.add(enumeration.nextString());
            }
        }

        public void remove(Enumeration enumeration) {
            D.pre(enumeration != null);
            while (enumeration.hasMoreElements()) {
                this.remove(enumeration.nextString());
            }
        }

        public int size() {
            return this.set.size();
        }

        public void clear() {
            D.pre(!this.immutable);
            this.set.clear();
        }

        public UniqueEnumeration elements() {
            return Strings.castToUniqueEnumeration(new StringIterEnumeration(this.set.keySet().iterator()));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{");
            UniqueEnumeration uniqueEnumeration = this.elements();
            if (uniqueEnumeration.hasMoreElements()) {
                stringBuffer.append(uniqueEnumeration.nextElement());
            }
            while (uniqueEnumeration.hasMoreElements()) {
                stringBuffer.append(", ").append(uniqueEnumeration.nextElement());
            }
            stringBuffer.append("}");
            return new String(stringBuffer);
        }
    }

    public static final class Map {
        private HashMap map = new HashMap();

        public void put(String string, String string2) {
            this.map.put(string, string2);
        }

        public String get(String string) {
            return (String)this.map.get(string);
        }

        public void remove(String string) {
            this.map.remove(string);
        }

        public int size() {
            return this.map.size();
        }

        public void clear() {
            this.map.clear();
        }

        public Enumeration keys() {
            return new StringIterEnumeration(this.map.keySet().iterator());
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public static interface UniqueEnumeration
    extends Enumeration {
    }

    public static interface Enumeration
    extends java.util.Enumeration {
        public String nextString();

        public int numElementsEnumerated();
    }
}

