/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.Lexer;
import com.ibm.toad.utils.Token;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Parser {
    private Lexer lex;
    private Hashtable db;

    void Error(String string) throws ParseError {
        this.lex.Error(string, this.lex.line, this.lex.col);
    }

    Token getTok() throws IOException, ParseError {
        return this.lex.getTok();
    }

    void eat(int n) throws IOException, ParseError {
        Token token = this.lex.getTok();
        if (token.type != n) {
            this.lex.Error("Expected token " + Token.type2string(n) + " but got " + Token.type2string(token.type), this.lex.line, this.lex.col);
        }
    }

    private Vector List() throws IOException, ParseError {
        Vector<Object> vector = new Vector<Object>();
        Token token = this.getTok();
        while (token.type != 11) {
            vector.addElement(this.Value(token));
            token = this.getTok();
            if (token.type == 16) {
                token = this.getTok();
                continue;
            }
            if (token.type == 11) continue;
            this.Error("Expecting , or ] but got: " + Token.type2string(token.type));
        }
        return vector;
    }

    private Object Value(Token token) throws IOException, ParseError {
        switch (token.type) {
            case 1: {
                return this.Record(token.strVal);
            }
            case 10: {
                return this.List();
            }
            case 2: {
                return token.strVal.toString();
            }
            case 3: {
                return new Integer(token.intVal);
            }
        }
        return null;
    }

    private Hashtable Record(StringBuffer stringBuffer) throws IOException, ParseError {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("@RECTYPE", stringBuffer.toString());
        hashtable.put("@LINE", new Integer(this.lex.line));
        hashtable.put("@COL", new Integer(this.lex.col));
        this.eat(12);
        Token token = this.getTok();
        while (token.type != 13) {
            if (token.type != 1) {
                this.Error("Expecting IDENT (for FieldName) but got: " + Token.type2string(token.type));
            }
            String string = token.strVal.toString();
            this.eat(14);
            token = this.getTok();
            Object object = this.Value(token);
            token = this.getTok();
            if (hashtable.containsKey(string)) {
                this.Error("Duplicate field.");
            }
            hashtable.put(string, object);
            if (token.type == 15) {
                token = this.getTok();
                continue;
            }
            if (token.type == 13) continue;
            this.Error("Expecting ; or ) but got: " + Token.type2string(token.type));
        }
        return hashtable;
    }

    public Hashtable Parse() throws IOException, ParseError {
        while (true) {
            Token token = this.getTok();
            if (token.type == 1) {
                Vector<Hashtable> vector = (Vector<Hashtable>)this.db.get(token.strVal.toString());
                if (vector == null) {
                    vector = new Vector<Hashtable>();
                    this.db.put(token.strVal.toString(), vector);
                }
                vector.addElement(this.Record(token.strVal));
                continue;
            }
            if (token.type == 0) break;
            this.Error("Expected identifier, received: " + Token.type2string(token.type));
        }
        if (this.lex.errorsDesc.size() > 0) {
            return null;
        }
        return this.db;
    }

    public Parser(File file) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(file)));
    }

    public Parser(InputStream inputStream) {
        this(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public Parser(Reader reader) {
        this.lex = new Lexer(reader);
        this.db = new Hashtable();
    }

    public Parser(String string) {
        this(new BufferedReader(new StringReader(string)));
    }

    public static void PrintDB(Hashtable hashtable) {
        System.out.println(">----");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            System.out.println(k + ":");
            Enumeration enumeration2 = ((Vector)hashtable.get(k)).elements();
            while (enumeration2.hasMoreElements()) {
                System.out.println(enumeration2.nextElement());
            }
            System.out.println("----");
        }
        System.out.println(">----");
    }

    public static class ParseError
    extends Exception {
        public ParseError(String string) {
            super(string);
        }
    }
}

