/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.ConsoleLogger;

public final class Log {
    public static LoggerList loggers = null;
    private static final String nullStr = "<null>";

    private Log() {
    }

    public static synchronized void addLogger(Logger logger) {
        loggers = new LoggerList(logger, loggers);
    }

    public static synchronized void setLoggers(LoggerList loggerList) {
        loggers = loggerList;
    }

    public static synchronized void print(String string) {
        if (string == null) {
            string = nullStr;
        }
        LoggerList loggerList = loggers;
        while (loggerList != null) {
            loggerList.head.print(string);
            loggerList = loggerList.tail;
        }
    }

    public static synchronized void println(String string) {
        if (string == null) {
            string = nullStr;
        }
        LoggerList loggerList = loggers;
        while (loggerList != null) {
            loggerList.head.println(string);
            loggerList = loggerList.tail;
        }
    }

    public static synchronized void debug(String string) {
        if (string == null) {
            string = nullStr;
        }
        LoggerList loggerList = loggers;
        while (loggerList != null) {
            loggerList.head.debug(string);
            loggerList = loggerList.tail;
        }
    }

    public static synchronized void debugln(String string) {
        if (string == null) {
            string = nullStr;
        }
        LoggerList loggerList = loggers;
        while (loggerList != null) {
            loggerList.head.debugln(string);
            loggerList = loggerList.tail;
        }
    }

    public static synchronized void println(Object object) {
        if (object == null) {
            Log.println(nullStr);
        } else {
            Log.println(object.toString());
        }
    }

    public static synchronized void debugln(Object object) {
        if (object == null) {
            Log.debugln(nullStr);
        } else {
            Log.debugln(object.toString());
        }
    }

    public static synchronized void print(Object object) {
        if (object == null) {
            Log.print(nullStr);
        } else {
            Log.print(object.toString());
        }
    }

    public static synchronized void debug(Object object) {
        if (object == null) {
            Log.debug(nullStr);
        } else {
            Log.debug(object.toString());
        }
    }

    public static synchronized void println(int n) {
        Log.println("" + n);
    }

    public static synchronized void debugln(int n) {
        Log.debugln("" + n);
    }

    public static synchronized void println(long l) {
        Log.println("" + l);
    }

    public static synchronized void debugln(long l) {
        Log.debugln("" + l);
    }

    public static synchronized void println(double d) {
        Log.println("" + d);
    }

    public static synchronized void debugln(double d) {
        Log.debugln("" + d);
    }

    public static synchronized void println(float f) {
        Log.println("" + f);
    }

    public static synchronized void debugln(float f) {
        Log.debugln("" + f);
    }

    public static synchronized void print(int n) {
        Log.print("" + n);
    }

    public static synchronized void debug(int n) {
        Log.debug("" + n);
    }

    public static synchronized void println() {
        Log.println("");
    }

    public static synchronized void debugln() {
        Log.debugln("");
    }

    public static synchronized void print() {
        Log.print("");
    }

    public static synchronized void debug() {
        Log.debug("");
    }

    static {
        Log.addLogger(new ConsoleLogger(false));
    }

    public static class LoggerList {
        Logger head;
        LoggerList tail;

        LoggerList(Logger logger, LoggerList loggerList) {
            this.head = logger;
            this.tail = loggerList;
        }
    }

    public static interface Logger {
        public void print(String var1);

        public void println(String var1);

        public void debug(String var1);

        public void debugln(String var1);
    }
}

