/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.D;

public final class Descriptors {
    private Descriptors() {
    }

    static int scanJavaIdentifier(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n >= n2) {
            return -1;
        }
        if (!Character.isJavaIdentifierStart(cArray[n])) {
            return -1;
        }
        while (n < n2) {
            if (!Character.isJavaIdentifierPart(cArray[n])) {
                return n;
            }
            ++n;
        }
        return n;
    }

    static int scanSpecialMethodNames(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n >= n2) {
            return -1;
        }
        String string = new String(cArray, n, n2 - n);
        if (string.startsWith("<init>")) {
            return n + 6;
        }
        if (string.startsWith("<clinit>")) {
            return n + 8;
        }
        return -1;
    }

    static int scanTypeDesc(char[] cArray, int n, boolean bl) {
        int n2 = cArray.length;
        if (n >= n2) {
            return -1;
        }
        while (n < n2 && cArray[n] == '[') {
            ++n;
        }
        if (n == n2) {
            return -1;
        }
        switch (cArray[n]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case 'V': {
                if (bl) {
                    return n + 1;
                }
                return -1;
            }
            case 'L': {
                n = Descriptors.scanClassName(cArray, n + 1, '/');
                if (n == -1 || cArray[n] != ';') {
                    return -1;
                }
                return n + 1;
            }
        }
        return -1;
    }

    static int scanClassName(char[] cArray, int n, char c) {
        int n2 = cArray.length;
        int n3 = n;
        while ((n3 = Descriptors.scanJavaIdentifier(cArray, n3)) != -1) {
            if (n3 == n2) {
                return n2;
            }
            if (cArray[n3] != c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static boolean isValidTypeDesc(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        return Descriptors.scanTypeDesc(cArray, 0, false) == cArray.length;
    }

    public static boolean isValidJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        return Descriptors.scanJavaIdentifier(cArray, 0) == cArray.length;
    }

    public static boolean isValidClassName(String string, char c) {
        D.pre(c == '.' || c == '/');
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        return Descriptors.scanClassName(cArray, 0, c) == cArray.length;
    }

    public static boolean isValidMID(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = Descriptors.scanJavaIdentifier(cArray, n3)) == n) {
                return false;
            }
            if (n4 == -1) {
                n4 = Descriptors.scanSpecialMethodNames(cArray, n3);
                if (n4 == -1) {
                    return false;
                }
                if (n4 == n || cArray[n4] != '(') {
                    return false;
                }
                bl = true;
            }
            n3 = n4;
            ++n2;
            if (cArray[n3] == '(') break;
            if (cArray[n3] != '.') {
                return false;
            }
            ++n3;
        }
        if (n2 < 2) {
            return false;
        }
        D.azzert(cArray[n3] == '(');
        if (++n3 < n && cArray[n3] != ')') {
            do {
                if ((n3 = Descriptors.scanTypeDesc(cArray, n3, false)) != -1 && n3 != n) continue;
                return false;
            } while (cArray[n3] != ')');
        }
        D.azzert(cArray[n3] == ')');
        ++n3;
        if (bl) {
            return n3 < n && cArray[n3] == 'V';
        }
        return (n3 = Descriptors.scanTypeDesc(cArray, n3, true)) != -1 && n3 == n;
    }
}

