/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.instruction.Minstr;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.cfparse.utils.CPUtils;
import com.ibm.toad.cfparse.utils.InstrUtils;
import com.ibm.toad.utils.D;

final class MipsInstruction
implements BaseInstruction {
    private int d_opCode;
    private byte[] d_code;
    private String d_tag;
    private ConstantPool d_cp;
    private TagFactory d_fac;
    private Minstr d_instr;
    private static char d_type = (char)97;
    private static int d_top = 0;

    MipsInstruction(TagFactory tagFactory, ConstantPool constantPool, byte[] byArray, int n, int n2) {
        this.d_cp = constantPool;
        this.d_code = new byte[n2];
        System.arraycopy(byArray, n, this.d_code, 0, n2);
        this.d_opCode = byArray[n] & 0xFF;
        this.d_fac = tagFactory;
        this.d_tag = null;
        this.d_instr = this.parseInstr(this.d_code);
    }

    MipsInstruction(TagFactory tagFactory, ConstantPool constantPool, String string) throws InstructionFormatException {
        throw new InstructionFormatException("Cannot create MipsInstruction from String yet...");
    }

    public void setTag(String string) {
        this.d_tag = string;
    }

    public BaseInstruction updateOffsets(int[] nArray, int n) {
        throw new D.AssertionException("Can't get bytecodes from sparcInstr yet...");
    }

    public byte[] getCode(int[] nArray, int n) {
        throw new D.AssertionException("Can't get bytecodes from sparcInstr yet...");
    }

    int getOperand(byte[] byArray, int n, char c) {
        int n2 = 0;
        switch (c) {
            case 'c': 
            case 't': 
            case 'u': 
            case 'v': {
                n2 = ByteArray.getByteAtOffset(byArray, n);
                break;
            }
            case 'C': 
            case 'V': {
                n2 = ByteArray.getShortAtOffset(byArray, n);
                break;
            }
            case '0': 
            case 'i': {
                n2 = ByteArray.getByteAtOffset(byArray, n);
                if (n2 <= 127) break;
                n2 -= 256;
                break;
            }
            case 'I': {
                n2 = ByteArray.getShortAtOffset(byArray, n);
                if (n2 <= Short.MAX_VALUE) break;
                n2 -= 65536;
                break;
            }
            case 'A': 
            case 'l': {
                n2 = ByteArray.getIntAtOffset(byArray, n);
                break;
            }
            case 'a': {
                n2 = ByteArray.getSignedShortAtOffset(byArray, n);
                break;
            }
            default: {
                throw new D.AssertionException("Unknown Operand type..");
            }
        }
        return n2;
    }

    public int getLength(int n) {
        if (this.d_opCode != 170 && this.d_opCode != 171) {
            return this.d_code.length;
        }
        int n2 = (4 - (n + 1) % 4) % 4;
        return this.d_code.length + n2;
    }

    public String getTag() {
        return this.d_tag;
    }

    public int getOpCode() {
        return this.d_code[0] & 0xFF;
    }

    static void methodInit() {
        d_type = (char)97;
        d_top = 0;
    }

    public Minstr parseInstr(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        Minstr minstr = null;
        JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[n];
        int n2 = InstrUtils.stackEffect(this.d_cp, byArray, 0);
        switch (n) {
            case 0: {
                minstr = new Minstr("nop");
                break;
            }
            case 1: {
                minstr = new Minstr("li %as" + (d_top + 1) + ", null");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int n3 = n - 3;
                minstr = new Minstr("li %is" + (d_top + 1) + ", " + n3);
                break;
            }
            case 9: 
            case 10: {
                int n4 = n - 9;
                minstr = new Minstr("li %ls" + (d_top + 1) + ", " + n4);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                int n5 = n - 11;
                minstr = new Minstr("li %fs" + (d_top + 1) + ", " + n5);
                break;
            }
            case 14: 
            case 15: {
                int n6 = n - 14;
                minstr = new Minstr("li %ds" + (d_top + 1) + ", " + n6);
                break;
            }
            case 16: {
                int n7 = this.getOperand(byArray, 1, 'i');
                minstr = new Minstr("li %is" + (d_top + 1) + ", " + n7);
                break;
            }
            case 17: {
                int n8 = this.getOperand(byArray, 1, 'I');
                minstr = new Minstr("li %is" + (d_top + 1) + ", " + n8);
                break;
            }
            case 18: {
                String string;
                int n9 = this.getOperand(byArray, 1, 'c');
                switch (this.d_cp.getType(n9)) {
                    case 3: {
                        string = "i";
                        break;
                    }
                    case 4: {
                        string = "f";
                        break;
                    }
                    case 8: {
                        string = "a";
                        break;
                    }
                    default: {
                        throw new D.AssertionException("Incorrect LDC bytecode");
                    }
                }
                minstr = new Minstr("li %" + string + "s" + (d_top + 1) + ", " + this.d_cp.getAsJava(n9));
                break;
            }
            case 19: {
                String string;
                int n10 = this.getOperand(byArray, 1, 'C');
                switch (this.d_cp.getType(n10)) {
                    case 3: {
                        string = "i";
                        break;
                    }
                    case 4: {
                        string = "f";
                        break;
                    }
                    case 8: {
                        string = "a";
                        break;
                    }
                    default: {
                        throw new D.AssertionException("Incorrect LDC bytecode");
                    }
                }
                minstr = new Minstr("li %" + string + "s" + (d_top + 1) + ", " + this.d_cp.getAsJava(n10));
                break;
            }
            case 20: {
                String string;
                int n11 = this.getOperand(byArray, 1, 'C');
                switch (this.d_cp.getType(n11)) {
                    case 5: {
                        string = "l";
                        break;
                    }
                    case 6: {
                        string = "d";
                        break;
                    }
                    default: {
                        throw new D.AssertionException("Incorrect LDC2_W bytecode");
                    }
                }
                minstr = new Minstr("li %" + string + "s" + (d_top + 1) + ", " + this.d_cp.getAsJava(n11));
                break;
            }
            case 21: {
                int n12 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %is" + (d_top + 1) + ", %il" + n12);
                break;
            }
            case 22: {
                int n13 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %ls" + (d_top + 1) + ", %ll" + n13);
                break;
            }
            case 23: {
                int n14 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %fs" + (d_top + 1) + ", %fl" + n14);
                break;
            }
            case 24: {
                int n15 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %ds" + (d_top + 1) + ", %dl" + n15);
                break;
            }
            case 25: {
                int n16 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %as" + (d_top + 1) + ", %al" + n16);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                int n17 = n - 26;
                minstr = new Minstr("mov %is" + (d_top + 1) + ", %il" + n17);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                int n18 = n - 30;
                minstr = new Minstr("mov %ls" + (d_top + 1) + ", %ll" + n18);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                int n19 = n - 34;
                minstr = new Minstr("mov %fs" + (d_top + 1) + ", %fl" + n19);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                int n20 = n - 38;
                minstr = new Minstr("mov %ds" + (d_top + 1) + ", %dl" + n20);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int n21 = n - 42;
                minstr = new Minstr("mov %as" + (d_top + 1) + ", %al" + n21);
                break;
            }
            case 46: {
                minstr = new Minstr("lw  %is" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 47: {
                minstr = new Minstr("lw  %ls" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 48: {
                minstr = new Minstr("lw  %fs" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 49: {
                minstr = new Minstr("lw  %ds" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 50: {
                minstr = new Minstr("lw  %as" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 51: {
                minstr = new Minstr("lw  %is" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 52: {
                minstr = new Minstr("lw  %is" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 53: {
                minstr = new Minstr("lw  %is" + (d_top + 1) + ",%as" + d_top + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 54: {
                int n22 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %il" + n22 + ", %is" + d_top);
                break;
            }
            case 55: {
                int n23 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %ll" + n23 + ", %ls" + d_top);
                break;
            }
            case 56: {
                int n24 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %fl" + n24 + ", %fs" + d_top);
                break;
            }
            case 57: {
                int n25 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %dl" + n25 + ", %ds" + d_top);
                break;
            }
            case 58: {
                int n26 = this.getOperand(byArray, 1, 'v');
                minstr = new Minstr("mov %al" + n26 + ", %as" + d_top);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int n27 = n - 59;
                minstr = new Minstr("mov %il" + d_top + ", %is" + n27);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int n28 = n - 63;
                minstr = new Minstr("mov %ll" + d_top + ", %ls" + n28);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int n29 = n - 67;
                minstr = new Minstr("mov %fl" + d_top + ", %fs" + n29);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int n30 = n - 71;
                minstr = new Minstr("mov %dl" + d_top + ", %ds" + n30);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int n31 = n - 75;
                minstr = new Minstr("mov %al" + d_top + ", %as" + n31);
                break;
            }
            case 79: {
                minstr = new Minstr("sw  %is" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 80: {
                minstr = new Minstr("sw  %ls" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 81: {
                minstr = new Minstr("sw  %fs" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 82: {
                minstr = new Minstr("sw  %ds" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 83: {
                minstr = new Minstr("sw  %as" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 84: {
                minstr = new Minstr("sw  %is" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 85: {
                minstr = new Minstr("sw  %is" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 86: {
                minstr = new Minstr("sw  %is" + d_top + ",%as" + (d_top - 2) + "(%is" + (d_top - 1) + ")");
                break;
            }
            case 87: 
            case 88: {
                minstr = new Minstr("");
                break;
            }
            case 89: {
                minstr = new Minstr("mov %is" + d_top + ",%is" + (d_top + 1));
                break;
            }
            case 90: {
                minstr = new Minstr("mov %is" + d_top + ",%is" + (d_top + 1), new Minstr("mov %is" + (d_top - 1) + ",%is" + d_top, new Minstr("mov %is" + (d_top + 1) + ",%is" + (d_top - 1))));
                break;
            }
            case 91: {
                minstr = new Minstr("mov %is" + d_top + ",%is" + (d_top + 1), new Minstr("mov %is" + (d_top - 1) + ",%is" + d_top, new Minstr("mov %is" + (d_top + 1) + ",%is" + (d_top - 1))));
                break;
            }
            case 92: {
                minstr = new Minstr("mov %is" + (d_top - 1) + ",%is" + (d_top + 1), new Minstr("mov %is" + d_top + ",%is" + (d_top + 2)));
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                minstr = new Minstr("add %is" + (d_top - 1) + ", %is" + d_top + ",%is" + (d_top - 1));
                break;
            }
            case 97: {
                minstr = new Minstr("add %ls" + (d_top - 1) + ", %ls" + d_top + ",%ls" + (d_top - 1));
                break;
            }
            case 98: {
                minstr = new Minstr("add %fs" + (d_top - 1) + ", %fs" + d_top + ",%fs" + (d_top - 1));
                break;
            }
            case 99: {
                minstr = new Minstr("add %ds" + (d_top - 1) + ", %ds" + d_top + ",%ds" + (d_top - 1));
                break;
            }
            case 100: {
                minstr = new Minstr("sub %is" + (d_top - 1) + ", %is" + d_top + ",%is" + (d_top - 1));
                break;
            }
            case 101: {
                minstr = new Minstr("sub %ls" + (d_top - 1) + ", %ls" + d_top + ",%ls" + (d_top - 1));
                break;
            }
            case 102: {
                minstr = new Minstr("sub %fs" + (d_top - 1) + ", %fs" + d_top + ",%fs" + (d_top - 1));
                break;
            }
            case 103: {
                minstr = new Minstr("sub %ds" + (d_top - 1) + ", %ds" + d_top + ",%ds" + (d_top - 1));
                break;
            }
            case 104: {
                minstr = new Minstr("smul %is" + (d_top - 1) + ", %is" + d_top + ",%is" + (d_top - 1));
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                break;
            }
            case 111: {
                break;
            }
            case 112: {
                break;
            }
            case 113: {
                break;
            }
            case 114: {
                break;
            }
            case 115: {
                break;
            }
            case 116: {
                break;
            }
            case 117: {
                break;
            }
            case 118: {
                break;
            }
            case 119: {
                break;
            }
            case 120: {
                break;
            }
            case 121: {
                break;
            }
            case 122: {
                break;
            }
            case 123: {
                break;
            }
            case 124: {
                break;
            }
            case 125: {
                break;
            }
            case 126: {
                break;
            }
            case 127: {
                break;
            }
            case 128: {
                break;
            }
            case 129: {
                break;
            }
            case 130: {
                break;
            }
            case 131: {
                break;
            }
            case 132: {
                break;
            }
            case 133: {
                break;
            }
            case 134: {
                break;
            }
            case 135: {
                break;
            }
            case 136: {
                break;
            }
            case 137: {
                break;
            }
            case 138: {
                break;
            }
            case 139: {
                break;
            }
            case 140: {
                break;
            }
            case 141: {
                break;
            }
            case 142: {
                break;
            }
            case 143: {
                break;
            }
            case 144: {
                break;
            }
            case 145: {
                break;
            }
            case 146: {
                break;
            }
            case 147: {
                break;
            }
            case 148: {
                break;
            }
            case 149: {
                break;
            }
            case 150: {
                break;
            }
            case 151: {
                break;
            }
            case 152: {
                break;
            }
            case 153: {
                int n32 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("cmp is" + d_top + ", 0", new Minstr("be " + this.d_fac.getTag(n32)));
                break;
            }
            case 154: {
                int n33 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("cmp is" + d_top + ", 0", new Minstr("bn " + this.d_fac.getTag(n33)));
                break;
            }
            case 155: {
                int n34 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("cmp is" + d_top + ", 0", new Minstr("bl " + this.d_fac.getTag(n34)));
                break;
            }
            case 156: {
                int n35 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("cmp is" + d_top + ", 0", new Minstr("bge " + this.d_fac.getTag(n35)));
                break;
            }
            case 157: {
                int n36 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("cmp is" + d_top + ", 0", new Minstr("bg " + this.d_fac.getTag(n36)));
                break;
            }
            case 158: {
                int n37 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("cmp is" + d_top + ", 0", new Minstr("ble " + this.d_fac.getTag(n37)));
                break;
            }
            case 159: {
                break;
            }
            case 160: {
                break;
            }
            case 161: {
                break;
            }
            case 162: {
                break;
            }
            case 163: {
                break;
            }
            case 164: {
                break;
            }
            case 165: {
                break;
            }
            case 166: {
                break;
            }
            case 167: {
                int n38 = this.getOperand(byArray, 1, 'a');
                minstr = new Minstr("jmp " + this.d_fac.getTag(n38));
                break;
            }
            case 168: {
                break;
            }
            case 169: {
                break;
            }
            case 170: {
                break;
            }
            case 171: {
                break;
            }
            case 172: {
                break;
            }
            case 173: {
                break;
            }
            case 174: {
                break;
            }
            case 175: {
                break;
            }
            case 176: {
                break;
            }
            case 177: {
                break;
            }
            case 178: {
                break;
            }
            case 179: {
                break;
            }
            case 180: {
                int n39 = this.getOperand(byArray, 1, 'C');
                String string = this.d_cp.get(n39).getAsString();
                int n40 = string.indexOf(32);
                int n41 = string.indexOf(32, n40 + 1);
                String string2 = string.substring(n40 + 1, n41);
                string = string.substring(n41 + 1);
                switch (string.charAt(0)) {
                    case 'L': 
                    case 'V': 
                    case '[': {
                        string = "a";
                        break;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        string = "i";
                        break;
                    }
                    case 'D': {
                        string = "d";
                        break;
                    }
                    case 'F': {
                        string = "f";
                        break;
                    }
                    case 'J': {
                        string = "l";
                    }
                }
                minstr = new Minstr("ld [%as" + d_top + "+delta(" + string2 + ")], %" + string + "s" + d_top + "");
                break;
            }
            case 181: {
                int n42 = this.getOperand(byArray, 1, 'C');
                String string = this.d_cp.get(n42).getAsString();
                int n43 = string.indexOf(32);
                int n44 = string.indexOf(32, n43 + 1);
                String string3 = string.substring(n43 + 1, n44);
                string = string.substring(n44 + 1);
                switch (string.charAt(0)) {
                    case 'L': 
                    case 'V': 
                    case '[': {
                        string = "a";
                        break;
                    }
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        string = "i";
                        break;
                    }
                    case 'D': {
                        string = "d";
                        break;
                    }
                    case 'F': {
                        string = "f";
                        break;
                    }
                    case 'J': {
                        string = "l";
                    }
                }
                minstr = new Minstr("st  %" + string + "s" + d_top + ", [%as" + (d_top - 1) + "+delta(" + string3 + ")]");
                break;
            }
            case 182: {
                int n45 = this.getOperand(byArray, 1, 'C');
                int n46 = -CPUtils.countArgs(this.d_cp, n45);
                String string = this.d_cp.get(n45).getAsString();
                int n47 = string.indexOf(32);
                int n48 = string.indexOf(32, n47 + 1);
                String string4 = string.substring(n47 + 1, n48);
                minstr = new Minstr("ld  [%as" + (d_top + n46) + "], %at0", new Minstr("ld  [%at0 + delta(" + string4 + ")], %at1", new Minstr("call %at1")));
                break;
            }
            case 183: {
                int n49 = this.getOperand(byArray, 1, 'C');
                int n50 = -CPUtils.countArgs(this.d_cp, n49);
                String string = this.d_cp.get(n49).getAsString();
                int n51 = string.indexOf(32);
                int n52 = string.indexOf(32, n51 + 1);
                String string5 = string.substring(n51 + 1, n52);
                String string6 = n50 == 0 ? "" : (n50 > 0 ? "+" + n50 : "" + n50);
                minstr = new Minstr("ld  [%as" + (d_top + n50) + "], %at0", new Minstr("ld  [%at0 + delta(" + string5 + ")], %at1", new Minstr("call %at1")));
                break;
            }
            case 184: {
                break;
            }
            case 185: {
                break;
            }
            case 187: {
                break;
            }
            case 188: {
                break;
            }
            case 189: {
                break;
            }
            case 190: {
                break;
            }
            case 191: {
                break;
            }
            case 192: {
                break;
            }
            case 193: {
                break;
            }
            case 194: {
                break;
            }
            case 195: {
                break;
            }
            case 196: {
                break;
            }
            case 197: {
                break;
            }
            case 198: {
                break;
            }
            case 199: {
                break;
            }
            case 200: {
                break;
            }
        }
        d_top += n2;
        if (minstr == null) {
            minstr = new Minstr("untranslated opCode " + jVMInstruction.name());
        }
        return minstr;
    }

    public String toString() {
        if (this.d_instr.d_next == null) {
            return this.d_instr.d_instr;
        }
        StringBuffer stringBuffer = new StringBuffer(this.d_instr.d_instr);
        Minstr minstr = this.d_instr.d_next;
        while (minstr != null) {
            stringBuffer.append("\n" + minstr.d_instr);
            minstr = minstr.d_next;
        }
        return stringBuffer.toString();
    }

    public String toString(int n) {
        if (this.d_instr.d_next == null) {
            return this.d_instr.d_instr;
        }
        StringBuffer stringBuffer = new StringBuffer(this.d_instr.d_instr);
        Minstr minstr = this.d_instr.d_next;
        while (minstr != null) {
            stringBuffer.append("\n" + MipsInstruction.sindent(n + 9));
            stringBuffer.append(minstr.d_instr);
            minstr = minstr.d_next;
        }
        return stringBuffer.toString();
    }

    private static String sindent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

