/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.utils.DataIOUtils;
import com.ibm.toad.utils.D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumberAttrInfo
extends AttrInfo {
    private int d_numVars = 0;
    private int[] d_varTable;

    LineNumberAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_numVars = dataInputStream.readUnsignedShort();
        D.azzert(this.d_len == 2 + this.d_numVars * 4, "d_len != 2 + (d_numVars * 4)\n" + this.d_len + " != 2 + (" + this.d_numVars + "* 4)\n");
        this.d_varTable = new int[this.d_numVars * 2];
        for (int i = 0; i < this.d_varTable.length; ++i) {
            this.d_varTable[i] = dataInputStream.readUnsignedShort();
        }
    }

    public void clear() {
        this.d_numVars = 0;
        this.d_varTable = null;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeInt(2 + this.d_numVars * 4);
        dataOutputStream.writeShort(this.d_numVars);
        for (int i = 0; i < this.d_numVars * 2; ++i) {
            dataOutputStream.writeShort(this.d_varTable[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + ": \n");
        for (int i = 0; i < this.d_numVars; ++i) {
            int n = this.d_varTable[i * 2];
            int n2 = this.d_varTable[i * 2 + 1];
            stringBuffer.append(this.sindent() + "  line " + n2 + ": " + n + "\n");
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.d_numVars;
    }

    public int getStartPC(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        return this.d_varTable[2 * n];
    }

    public void setStartPC(int n, int n2) {
        if (n < 0 || n >= this.d_numVars) {
            return;
        }
        this.d_varTable[2 * n] = n2;
    }

    public void setLineNumber(int n, int n2) {
        if (n < 0 || n >= this.d_numVars) {
            return;
        }
        this.d_varTable[2 * n + 1] = n2;
    }

    public int getLineNumber(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        return this.d_varTable[2 * n + 1];
    }

    public void add(int n, int n2) {
        for (int i = 0; i < this.d_numVars; ++i) {
            if (this.d_varTable[2 * i] != n2) continue;
            this.d_varTable[2 * i + 1] = n;
            return;
        }
        if (this.d_varTable == null || this.d_numVars * 2 >= this.d_varTable.length) {
            this.resize();
        }
        this.d_varTable[this.d_numVars * 2] = n2;
        this.d_varTable[this.d_numVars * 2 + 1] = n;
        ++this.d_numVars;
    }

    protected int size() {
        return 8 + this.d_numVars * 4;
    }

    private void resize() {
        int[] nArray = new int[this.d_numVars * 2 + 10];
        if (this.d_varTable != null) {
            System.arraycopy(this.d_varTable, 0, nArray, 0, this.d_numVars * 2);
        }
        this.d_varTable = nArray;
    }
}

