/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import com.ibm.ejs.util.deployment.utilities.UtilsTrace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static final void copyFile(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            File file = new File(string);
            File file2 = new File(string2);
            if (file.equals(file2)) {
                return;
            }
            UtilsTrace.trace("\nFileUtils: copyFile(): Copying " + string + " to " + string2);
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n = bufferedInputStream.read();
            while (n != -1) {
                fileOutputStream.write(n);
                n = bufferedInputStream.read();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw iOException;
        }
    }

    public static final void deleteDirTree(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath(), stringArray[i]);
                FileUtils.deleteDirTree(file2);
            }
        }
        file.delete();
    }
}

