/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasHeader;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.logging.LogRecord;

class TraceLogger
implements WsHandler,
LogRolloverListener {
    private boolean ivBasicFormat;
    private ByteArrayOutputStream ivHeaderBaos;
    private PrintStream ivHeaderPs;
    OutputStream ivOs;
    PrintStream ivOut;
    String ivCharEncoding = null;

    TraceLogger(OutputStream outputStream) {
        this.ivOs = outputStream;
        this.ivOut = new PrintStream(outputStream, true);
        this.ivCharEncoding = null;
        this.ivHeaderBaos = new ByteArrayOutputStream();
        this.ivHeaderPs = new PrintStream(this.ivHeaderBaos, false);
    }

    TraceLogger(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.ivOs = outputStream;
        this.ivOut = new PrintStream(outputStream, true, string);
        this.ivCharEncoding = string;
        this.ivHeaderBaos = new ByteArrayOutputStream();
        this.ivHeaderPs = new PrintStream((OutputStream)this.ivHeaderBaos, false, string);
    }

    TraceLogger(OutputStream outputStream, boolean bl) {
        this(outputStream);
        this.ivBasicFormat = bl;
    }

    TraceLogger(OutputStream outputStream, boolean bl, String string) throws UnsupportedEncodingException {
        this(outputStream, string);
        this.ivBasicFormat = bl;
    }

    public synchronized void logRolled() {
        this.printHeader();
    }

    public void processEvent(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
            return;
        }
        this.doLog(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLog(LogRecord logRecord) {
        String string = this.ivBasicFormat ? TraceLogFormatter.formatBasic(logRecord) : TraceLogFormatter.formatAdvanced(logRecord);
        TraceLogger traceLogger = this;
        synchronized (traceLogger) {
            this.ivOut.println(string);
        }
    }

    synchronized void printHeader() {
        String string;
        this.ivHeaderBaos.reset();
        this.ivHeaderPs.println("************ Start Display Current Environment ************");
        String string2 = RasHelper.getVersionId();
        if (string2 != null && !string2.equals("")) {
            this.ivHeaderPs.println(MessageFormat.format(RasHeader.server, string2, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((string = RasHelper.getVerboseVersion()) != null && !string.equals("")) {
            this.ivHeaderPs.println(MessageFormat.format("Detailed IFix information: {0}", string));
        } else {
            this.ivHeaderPs.println(MessageFormat.format("Detailed IFix information: {0}", "Error retriving APar/IFix info"));
        }
        String string3 = RasHelper.getSystemProperty("java.fullversion");
        if (string3 == null) {
            string3 = RasHelper.getSystemProperty("java.version");
        }
        String string4 = RasHelper.getSystemProperty("os.name");
        String string5 = RasHelper.getSystemProperty("os.version");
        this.ivHeaderPs.println(MessageFormat.format("Host Operating System is {0}, version {1}", string4, string5));
        string4 = RasHelper.getSystemProperty("java.compiler");
        string5 = RasHelper.getSystemProperty("java.vm.name");
        this.ivHeaderPs.println(MessageFormat.format("Java version = {0}, Java Compiler = {1}, Java VM name = {2}", string3, string4, string5));
        this.ivHeaderPs.println(MessageFormat.format("was.install.root = {0}", RasHelper.getSystemProperty("was.install.root")));
        this.ivHeaderPs.println(MessageFormat.format("user.install.root = {0}", RasHelper.getSystemProperty("user.install.root")));
        this.ivHeaderPs.println(MessageFormat.format("Java Home = {0}", RasHelper.getSystemProperty("java.home")));
        this.ivHeaderPs.println(MessageFormat.format("ws.ext.dirs = {0}", RasHelper.getSystemProperty("ws.ext.dirs")));
        this.ivHeaderPs.println(MessageFormat.format("Classpath = {0}", RasHelper.getSystemProperty("java.class.path")));
        this.ivHeaderPs.println(MessageFormat.format("Java Library path = {0}", RasHelper.getSystemProperty("java.library.path")));
        this.ivHeaderPs.println(MessageFormat.format("Current trace specification = {0}", ManagerAdmin.getTraceSpecification()));
        this.ivHeaderPs.println("************* End Display Current Environment *************");
        this.ivHeaderPs.flush();
        byte[] byArray = this.ivHeaderBaos.toByteArray();
        try {
            this.ivOs.write(byArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    synchronized void printFooter(int n) {
    }
}

