/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;

public abstract class RasEvent
implements Serializable {
    private static final long serialVersionUID = -7870724202058405481L;
    public static final int AUDIT = 1;
    public static final int DEBUG = 2;
    public static final int DUMP = 3;
    public static final int ERROR = 4;
    public static final int EVENT = 5;
    public static final int ENTRY = 6;
    public static final int EXIT = 7;
    public static final int FATAL = 8;
    public static final int SERVICE = 9;
    public static final int WARNING = 10;
    public static final int INFO = 11;
    public static final int UNCOND = 12;
    public static final int SYSOUT = 13;
    public static final int SYSERR = 14;
    public static final int UNKNOWN = 15;
    public static final int FIRST_EVENT = 1;
    public static final int LAST_EVENT = 15;
    static final String[] svTypePrefixes = new String[]{" A ", " d ", " m ", " E ", " e ", " > ", " < ", " F ", " S ", " W ", " I ", " u ", " O ", " R ", " Z "};
    static final String[] typeNames = new String[]{"AUDIT", "DEBUG", "DUMP", "ERROR", "EVENT", "ENTRY", "EXIT", "FATAL", "SERVICE", "WARNING", "INFO", "UNCOND", "SYSTEMOUT", "SYSTEMERR", "UNKNOWN"};
    static final String ibm = "IBM";
    static final String webSphere = "WebSphere";
    static final String appServer = "Application Server";
    static final String emptyString = "";
    static final String nullParamString = "<null>";
    static final String badParamString = "<malformed parameter>";
    private static final int svBasicFormatMaxNameLength = 13;
    static String svBasicPadding = "                                 ";
    static String svAdvancedPadding = "          ";
    static String lineSeparator = RasHelper.getSystemProperty("line.separator");
    String ivOrganization;
    String ivProduct;
    String ivComponent;
    String ivVersion;
    String ivEventSource;
    String ivClassName;
    String ivMethodName;
    String ivThreadId;
    String ivProcessId;
    String ivServerName;
    long ivTimeStamp;
    int ivType;
    String ivMsgKey;
    byte[] ivRawData = null;
    String ivExtendedMessage;
    String ivUnitOfWork;
    transient boolean tivIsJras = false;

    static String getTypeString(int n) {
        if (n < 1 || n > 15) {
            return new String("unknown Type");
        }
        return typeNames[n - 1];
    }

    RasEvent() {
    }

    RasEvent(int n, TraceComponent traceComponent, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this.ivType = n < 1 || n > 15 ? 15 : n;
        this.ivEventSource = traceComponent.getName();
        this.tivIsJras = bl;
        this.ivOrganization = string4;
        this.ivProduct = string5;
        this.ivComponent = string6;
        this.ivExtendedMessage = string7;
        this.ivClassName = string;
        this.ivMethodName = string2;
        this.ivMsgKey = string3 == null ? "NULL_MESSAGE_KEY_PASSED" : string3;
        this.ivVersion = RasHelper.getVersionId();
        this.ivProcessId = RasHelper.getProcessId();
        this.ivServerName = RasHelper.getServerName();
        this.ivTimeStamp = System.currentTimeMillis();
        Thread thread2 = Thread.currentThread();
        this.ivThreadId = Integer.toHexString(thread2.hashCode());
        this.ivUnitOfWork = RasContextManager.getUnitOfWork();
    }

    public final long getTimeStamp() {
        return this.ivTimeStamp;
    }

    public String getThreadId() {
        return this.ivThreadId;
    }

    private void formatTimeAndThread(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        int n;
        stringBuffer.setLength(0);
        stringBuffer.append('[');
        date.setTime(this.ivTimeStamp);
        dateFormat.format(date, stringBuffer, fieldPosition);
        stringBuffer.append("] ");
        for (int i = n = this.ivThreadId.length(); i < 8; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.ivThreadId);
        stringBuffer.append(' ');
    }

    void formatHeaderBasic(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        int n;
        this.formatTimeAndThread(stringBuffer, dateFormat, date, fieldPosition);
        String string = null;
        int n2 = this.ivEventSource.lastIndexOf(46) + 1;
        string = n2 + 13 >= this.ivEventSource.length() ? this.ivEventSource.substring(n2) : this.ivEventSource.substring(n2, n2 + 13);
        stringBuffer.append(string);
        for (int i = n = 13 - string.length(); i > 0; --i) {
            stringBuffer.append(' ');
        }
        try {
            stringBuffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuffer.append(" Z ");
        }
        if (this.tivIsJras) {
            stringBuffer.append(this.ivClassName);
            stringBuffer.append(' ');
            stringBuffer.append(this.ivMethodName);
            stringBuffer.append(' ');
        }
    }

    void formatHeaderAdvanced(StringBuffer stringBuffer, DateFormat dateFormat, Date date, FieldPosition fieldPosition) {
        this.formatTimeAndThread(stringBuffer, dateFormat, date, fieldPosition);
        try {
            stringBuffer.append(svTypePrefixes[this.ivType - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            stringBuffer.append(" Z ");
        }
        if (this.ivUnitOfWork == null) {
            stringBuffer.append("UOW= ");
        } else {
            stringBuffer.append("UOW=");
            stringBuffer.append(this.ivUnitOfWork);
        }
        stringBuffer.append(" source=");
        stringBuffer.append(this.ivEventSource);
        if (this.ivClassName != null) {
            stringBuffer.append(" class=");
            stringBuffer.append(this.ivClassName);
        }
        if (this.ivMethodName != null) {
            stringBuffer.append(" method=");
            stringBuffer.append(this.ivMethodName);
        }
        stringBuffer.append(" org=");
        stringBuffer.append(this.ivOrganization);
        stringBuffer.append(" prod=");
        stringBuffer.append(this.ivProduct);
        stringBuffer.append(" component=");
        stringBuffer.append(this.ivComponent);
    }
}

