/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSICredentialsManager;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.Connection;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ConnectionTable;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionHashTable;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionTable;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.Map;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class SessionManager
implements AlarmListener {
    private ConnectionTable serverConnTable = null;
    private ConnectionTable clientConnTable = null;
    private long context_generator = 1L;
    private SecurityConfiguration secConfig = null;
    private VaultImpl vault = null;
    private CSIUtil csiUtil = new CSIUtil();
    int sessionCleanupInterval = 300000;
    int sessionDiscardUnusedMillis = 900000;

    public SessionManager() {
        String string = "";
        String string2 = "SessionManager.init";
        this.serverConnTable = new ConnectionTable();
        this.clientConnTable = new ConnectionTable();
        VaultImpl.getInstance();
        this.secConfig = VaultImpl.getSecurityConfiguration();
        this.vault = VaultImpl.getInstance();
        this.sessionCleanupInterval = this.secConfig.getsessionGCinterval();
        this.sessionDiscardUnusedMillis = this.secConfig.getsessionGCdiscardunused();
        if (SecurityLogger.debugTraceEnabled) {
            string = "SessionManager cleanup alarm set for sessionGCinterval: " + this.sessionCleanupInterval + " milliseconds, sessionDiscardUnused: " + this.sessionDiscardUnusedMillis + " milliseconds.";
            SecurityLogger.debugMessage(string2, string);
        }
        long l = System.currentTimeMillis() + (long)this.sessionCleanupInterval;
        if (SecurityLogger.debugTraceEnabled) {
            string = "Next cleanup time: " + new Timestamp(l);
            SecurityLogger.debugMessage(string2, string);
        }
        AlarmManager.createDeferrable(this.sessionCleanupInterval, this);
    }

    public SessionEntry csi_server_session_lookup(long l, ServerConnectionKey serverConnectionKey, SASContextBody sASContextBody) {
        String string = "";
        String string2 = "SessionManager.csi_server_session_lookup";
        Connection connection = null;
        SessionEntry sessionEntry = null;
        int n = 5;
        if (SecurityLogger.debugTraceEnabled) {
            string = "Looking for unique server session with hash: " + serverConnectionKey.get_server_connection_hash() + ":" + l;
            SecurityLogger.debugMessage(string2, string);
        }
        if ((sessionEntry = this.get_server_session_from_connection(l, connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash()))) == null && sASContextBody != null && sASContextBody.discriminator() == 0) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Message is EstablishContext and session not found, adding new session entry.";
                SecurityLogger.debugMessage(string2, string);
            }
            sessionEntry = this.add_server_session_to_connection(l, connection, sASContextBody.establish_msg());
        } else {
            if (sessionEntry == null && sASContextBody != null && sASContextBody.discriminator() == 5) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Message is MessageInContext and session not found, returning null.";
                    SecurityLogger.debugMessage(string2, string);
                }
                return null;
            }
            if (sessionEntry != null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Session has been found.";
                    SecurityLogger.debugMessage(string2, string);
                }
                if ((n = sessionEntry.get_session_state()) == 7 && sASContextBody != null && sASContextBody.discriminator() == 0) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Message type is EstablishContext but session found was already SESSION_REJECTED, deleting session and creating new session.";
                        SecurityLogger.debugMessage(string2, string);
                    }
                    this.delete_server_session_from_connection(l, connection);
                    sessionEntry = this.add_server_session_to_connection(l, connection, sASContextBody.establish_msg());
                } else if (sASContextBody != null && sASContextBody.discriminator() == 0 && !sessionEntry.compare_establish_context_messages(sASContextBody.establish_msg())) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Message type is EstablishContext but session found had different tokens.  Changing state of session to SESSION_CONFLICTING_EVIDENCE";
                        SecurityLogger.debugMessage(string2, string);
                    }
                    sessionEntry.set_session_state(3);
                }
            }
        }
        if (sessionEntry != null) {
            sessionEntry.update_session_usage_timestamp();
        }
        return sessionEntry;
    }

    public SessionEntry csi_client_session_lookup(ClientSessionKey clientSessionKey) {
        String string = "";
        String string2 = "SessionManager.csi_client_session_lookup";
        Connection connection = null;
        SessionEntry sessionEntry = null;
        int n = 5;
        connection = this.client_connection_lookup(clientSessionKey.get_connection_key());
        sessionEntry = this.get_client_session_from_connection(clientSessionKey, connection);
        if (sessionEntry == null) {
            sessionEntry = this.add_client_session_to_connection(clientSessionKey, connection);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Unique client session added with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id();
                SecurityLogger.debugMessage(string2, string);
            }
        } else {
            if (sessionEntry.get_session_state() == 7) {
                this.delete_client_session_from_connection(sessionEntry.get_client_context_id(), connection);
                sessionEntry = this.add_client_session_to_connection(clientSessionKey, connection);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Previous session in SESSION_REJECTED state, adding new unique client session with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id();
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                string = "Found unique session with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id();
                SecurityLogger.debugMessage(string2, string);
            }
        }
        sessionEntry.update_session_usage_timestamp();
        return sessionEntry;
    }

    public void csi_client_session_status_update(long l, ClientSessionKey clientSessionKey, int n) {
        SessionEntry sessionEntry = null;
        String string = "";
        String string2 = "SessionManager.csi_client_session_status_update";
        if (clientSessionKey != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "ContextID: " + l + ", SessionHash: " + clientSessionKey.get_client_session_hash() + ", SessionState: " + n;
                SecurityLogger.debugMessage(string2, string);
            }
            sessionEntry = this.get_client_session_by_context_id(l, clientSessionKey);
            if (clientSessionKey != null && sessionEntry != null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Found unique session with hash: " + clientSessionKey.get_client_session_hash() + ":" + sessionEntry.get_client_context_id();
                    SecurityLogger.debugMessage(string2, string);
                }
                sessionEntry.set_session_state(n);
                this.update_client_session(clientSessionKey, sessionEntry);
            }
        }
    }

    public void csi_client_session_ecmessage_update(long l, ClientSessionKey clientSessionKey, EstablishContext establishContext) {
        String string = "";
        String string2 = "SessionManager.csi_client_session_ecmessage_update";
        if (SecurityLogger.debugTraceEnabled) {
            string = "Updating session: " + l + ", clientSessionKey: " + clientSessionKey.get_client_session_hash();
            SecurityLogger.debugMessage(string2, string);
        }
        SessionEntry sessionEntry = null;
        if (clientSessionKey != null) {
            sessionEntry = this.get_client_session_by_context_id(l, clientSessionKey);
            if (sessionEntry != null) {
                sessionEntry.set_ec_message(establishContext);
                this.update_client_session(clientSessionKey, sessionEntry);
            } else if (SecurityLogger.debugTraceEnabled) {
                string = "Did not find a sessionEntry.";
                SecurityLogger.debugMessage(string2, string);
            }
        }
    }

    private SessionEntry get_client_session_from_connection(ClientSessionKey clientSessionKey, Connection connection) {
        long l = 0L;
        SessionEntry sessionEntry = null;
        if (clientSessionKey != null) {
            SessionHashTable sessionHashTable = connection.getSessionHashTable();
            SessionTable sessionTable = connection.getClientSessionTable();
            l = sessionHashTable.get_session_hash(clientSessionKey);
            if (l != 0L) {
                sessionEntry = sessionTable.get_session(l);
            }
        }
        return sessionEntry;
    }

    private synchronized SessionEntry get_client_session_by_context_id(long l, ClientSessionKey clientSessionKey) {
        SessionEntry sessionEntry = null;
        Connection connection = null;
        if (clientSessionKey != null && (connection = this.client_connection_lookup(clientSessionKey.get_connection_key())) != null) {
            SessionTable sessionTable = connection.getClientSessionTable();
            if (l != 0L) {
                sessionEntry = sessionTable.get_session(l);
            }
        }
        return sessionEntry;
    }

    protected SessionEntry add_server_session_to_connection(long l, Connection connection, EstablishContext establishContext) {
        String string = connection.get_connection_hash() + ":" + l;
        SessionEntry sessionEntry = new SessionEntry(l, establishContext, string);
        SessionTable sessionTable = connection.getServerSessionTable();
        if (sessionEntry == null) {
            throw new OutOfMemoryError();
        }
        sessionTable.add_session(l, sessionEntry);
        return sessionEntry;
    }

    private SessionEntry add_client_session_to_connection(ClientSessionKey clientSessionKey, Connection connection) {
        SessionEntry sessionEntry = new SessionEntry(this.get_next_context_id());
        sessionEntry.set_session_state(4);
        sessionEntry.set_client_session_key(clientSessionKey);
        SessionTable sessionTable = connection.getClientSessionTable();
        SessionHashTable sessionHashTable = connection.getSessionHashTable();
        if (sessionHashTable != null && sessionTable != null) {
            sessionHashTable.add_session_hash(clientSessionKey, sessionEntry.get_client_context_id());
            sessionTable.add_session(sessionEntry.get_client_context_id(), sessionEntry);
        }
        return sessionEntry;
    }

    public void update_client_session(ClientSessionKey clientSessionKey, SessionEntry sessionEntry) {
        Connection connection = null;
        if (clientSessionKey != null && (connection = this.client_connection_lookup(clientSessionKey.get_connection_key())) != null) {
            SessionTable sessionTable = connection.getClientSessionTable();
            sessionTable.add_session(sessionEntry.get_client_context_id(), sessionEntry);
        }
    }

    public synchronized boolean csi_message_stateful_after_postinvoke(ServerRequestInfo serverRequestInfo, SecurityContextImpl securityContextImpl) {
        String string = "";
        String string2 = "SessionManager.csi_message_stateful_after_postinvoke";
        long l = 0L;
        ServerConnectionKey serverConnectionKey = null;
        SessionEntry sessionEntry = null;
        int n = 0;
        boolean bl = false;
        ConnectionInformationImpl connectionInformationImpl = null;
        connectionInformationImpl = (ConnectionInformationImpl)((ExtendedServerRequestInfo)serverRequestInfo).getConnectionData();
        if (securityContextImpl != null) {
            l = securityContextImpl.get_stateful_context_id();
        }
        if (l != 0L && (sessionEntry = this.csi_server_session_get(l, serverConnectionKey = new ServerConnectionKey(connectionInformationImpl.getConnectionCreationTime(), connectionInformationImpl.getRemoteHost(), connectionInformationImpl.getRemotePort()))) != null) {
            n = sessionEntry.get_session_state();
            switch (n) {
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public long csi_get_context_id_from_service_context(SecurityContextImpl securityContextImpl) {
        if (securityContextImpl != null) {
            return securityContextImpl.get_stateful_context_id();
        }
        return 0L;
    }

    public SessionEntry csi_server_session_get(long l, ServerConnectionKey serverConnectionKey) {
        Connection connection = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        return this.get_server_session_from_connection(l, connection);
    }

    public synchronized void csi_server_session_update(long l, ServerConnectionKey serverConnectionKey, SessionEntry sessionEntry) {
        Connection connection = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        if (sessionEntry != null && connection != null) {
            this.update_server_session_to_connection(l, connection, sessionEntry);
        }
    }

    public void csi_server_session_status_update(long l, ServerConnectionKey serverConnectionKey, int n) {
        Connection connection = null;
        SessionEntry sessionEntry = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        sessionEntry = this.get_server_session_from_connection(l, connection);
        if (sessionEntry != null) {
            sessionEntry.set_session_state(n);
            this.update_server_session_to_connection(l, connection, sessionEntry);
        }
    }

    protected Connection server_connection_lookup(String string) {
        Connection connection = null;
        connection = (Connection)this.serverConnTable.get(string);
        if (connection == null) {
            connection = new Connection();
            connection.set_connection_hash(string);
            this.serverConnTable.put(string, connection);
        }
        return connection;
    }

    protected Connection client_connection_lookup(String string) {
        Connection connection = null;
        connection = (Connection)this.clientConnTable.get(string);
        if (connection == null) {
            connection = new Connection();
            connection.set_connection_hash(string);
            this.clientConnTable.put(string, connection);
        }
        return connection;
    }

    public void csi_delete_client_connection(String string) {
        String string2 = "";
        String string3 = "SessionManager.csi_delete_client_connection";
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "A connection has been broken to " + string + ".  Removing session entries for this connection.";
            SecurityLogger.debugMessage(string3, string2);
        }
        Connection connection = null;
        connection = (Connection)this.clientConnTable.get(string);
        if (connection != null) {
            connection.getClientSessionTable().clear();
            connection.getSessionHashTable().clear();
            this.clientConnTable.remove(string);
        }
    }

    public void csi_delete_server_connection(String string) {
        String string2 = "";
        String string3 = "SessionManager.csi_delete_server_connection";
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "A connection has been broken to " + string + ".  Removing session entries for this connection.";
            SecurityLogger.debugMessage(string3, string2);
        }
        Connection connection = null;
        connection = (Connection)this.serverConnTable.get(string);
        if (connection != null) {
            connection.getServerSessionTable().clear();
            this.serverConnTable.remove(string);
        }
    }

    protected SessionEntry get_server_session_from_connection(long l, Connection connection) {
        SessionTable sessionTable = connection.getServerSessionTable();
        if (sessionTable != null) {
            return sessionTable.get_session(l);
        }
        return null;
    }

    protected void delete_server_session_from_connection(long l, Connection connection) {
        SessionTable sessionTable = connection.getServerSessionTable();
        if (sessionTable != null) {
            sessionTable.delete_session(l);
        }
    }

    protected void delete_client_session_from_connection(long l, Connection connection) {
        SessionTable sessionTable = connection.getClientSessionTable();
        if (sessionTable != null) {
            sessionTable.delete_session(l);
        }
    }

    protected void update_server_session_to_connection(long l, Connection connection, SessionEntry sessionEntry) {
        SessionTable sessionTable = connection.getServerSessionTable();
        if (sessionEntry == null) {
            throw new BAD_PARAM();
        }
        sessionTable.add_session(l, sessionEntry);
    }

    private synchronized long get_next_context_id() {
        return this.context_generator++;
    }

    public void csi_client_session_complete(SASContextBody sASContextBody, boolean bl, long l, ClientSessionKey clientSessionKey) {
        String string = "";
        String string2 = "SessionManager.csi_client_session_complete";
        if (!bl) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "In stateless mode, no client session was added.";
                SecurityLogger.debugMessage(string2, string);
            }
            return;
        }
        CompleteEstablishContext completeEstablishContext = null;
        Object var9_8 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string = "Client session key used: " + clientSessionKey;
            SecurityLogger.debugMessage(string2, string);
        }
        if (clientSessionKey == null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exiting early due to null clientSessionKey.";
                SecurityLogger.debugMessage(string2, string);
            }
            return;
        }
        if (sASContextBody != null && sASContextBody.discriminator() == 1) {
            completeEstablishContext = sASContextBody.complete_msg();
            if (completeEstablishContext.context_stateful && completeEstablishContext.client_context_id != 0L) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Marking session complete.";
                    SecurityLogger.debugMessage(string2, string);
                }
                this.csi_client_session_status_update(completeEstablishContext.client_context_id, clientSessionKey, 1);
            } else if (completeEstablishContext.client_context_id == 0L && l != 0L) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Marking client session rejected, server negotiated session as stateless.";
                    SecurityLogger.debugMessage(string2, string);
                }
                this.csi_client_session_status_update(l, clientSessionKey, 7);
            }
            if (this.secConfig.authenticationRetryEnabled()) {
                this.csiUtil.getCurrent().clear_retry_count();
            }
        }
    }

    public void csi_client_session_complete_exception(SASContextBody sASContextBody, boolean bl, ClientSessionKey clientSessionKey) throws ForwardRequest {
        String string = "";
        String string2 = "SessionManager.csi_client_session_complete_exception";
        if (!bl) {
            return;
        }
        CompleteEstablishContext completeEstablishContext = null;
        ContextError contextError = null;
        if (sASContextBody != null && sASContextBody.discriminator() == 1) {
            completeEstablishContext = sASContextBody.complete_msg();
            if (completeEstablishContext.context_stateful && completeEstablishContext.client_context_id != 0L) {
                this.csi_client_session_status_update(completeEstablishContext.client_context_id, clientSessionKey, 1);
            }
            if (this.secConfig.authenticationRetryEnabled()) {
                this.csiUtil.getCurrent().clear_retry_count();
            }
        } else if (sASContextBody != null && sASContextBody.discriminator() == 4 && (contextError = sASContextBody.error_msg()) != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Client context ID: " + contextError.client_context_id;
                SecurityLogger.debugMessage(string2, string);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string = "Marking session as rejected.";
                SecurityLogger.debugMessage(string2, string);
            }
            this.csiUtil.deserializeRootException(contextError.error_token);
            if (contextError.client_context_id != 0L) {
                this.csi_client_session_status_update(contextError.client_context_id, clientSessionKey, 7);
            }
        }
    }

    public void retry(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        String string = "";
        String string2 = "SessionManager.retry";
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (this.secConfig.authenticationRetryEnabled() && this.csiUtil.getCurrent().getAuthRetryForJAAS()) {
            int n = this.csiUtil.getCurrent().get_retry_count();
            if (SecurityLogger.debugTraceEnabled) {
                string = "Retry count is " + n;
                SecurityLogger.debugMessage(string2, string);
            }
            if (n < this.secConfig.getauthenticationRetryCount()) {
                Object object;
                this.csiUtil.getCurrent().increment_retry_count();
                long l = 0L;
                CompletionStatus completionStatus = CompletionStatus.COMPLETED_MAYBE;
                Any any = null;
                CSICredentialsManager cSICredentialsManager = new CSICredentialsManager();
                any = clientRequestInfo.received_exception();
                if (any != null && (object = ((ExtendedClientRequestInfo)clientRequestInfo).getSystemException()) != null) {
                    l = object.minor;
                }
                if (l == 1229079302L || l == 1229079301L || l == 1229079303L || l == 1229079304L || l == 1229079306L || l == 1229079305L || this.isReferenceContextErrorRetriable(clientRequestInfo) || l == 1229079296L || l == 1229079297L || l == 1229079299L || l == 1229079298L || this.isAcceptContextErrorRetriable(clientRequestInfo)) {
                    object = null;
                    WSCredential wSCredential = null;
                    try {
                        object = cSICredentialsManager.getInvocationSubject();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1123", this);
                        string = "Exception getting Subject from thread.  " + exception.toString();
                        SecurityLogger.debugMessage(string2, string);
                    }
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object);
                    if (wSCredential != null && wSCredential.isBasicAuth()) {
                        if (!(l != 1229079296L && l != 1229079297L && l != 1229079299L && l != 1229079298L && !this.isAcceptContextErrorRetriable(clientRequestInfo) || this.secConfig.getloginSource() != 1 && this.secConfig.getloginSource() != 6)) {
                            try {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string = "Setting invocation to NULL.";
                                    SecurityLogger.debugMessage(string2, string);
                                }
                                contextManager.setInvocationSubject(null);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1154", this);
                            }
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "Throwing a ForwardRequest exception to retry the request.";
                            SecurityLogger.debugMessage(string2, string);
                        }
                        throw new ForwardRequest(clientRequestInfo.target());
                    }
                    if (wSCredential != null) {
                        try {
                            if (contextManager.isServerCred(wSCredential)) {
                                try {
                                    try {
                                        final ContextManager contextManager2 = contextManager;
                                        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                                            public Object run() throws Exception {
                                                contextManager2.setInvocationSubject(contextManager2.getServerSubject());
                                                return null;
                                            }
                                        };
                                        AccessController.doPrivileged(privilegedExceptionAction);
                                    }
                                    catch (PrivilegedActionException privilegedActionException) {
                                        FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1200", this);
                                        string = "Exception refreshing server credential.";
                                        SecurityLogger.debugMessage(string2, string);
                                        throw privilegedActionException.getException();
                                    }
                                    if (SecurityLogger.debugTraceEnabled) {
                                        string = "Retrying with refreshed server cred.";
                                        SecurityLogger.debugMessage(string2, string);
                                    }
                                    throw new ForwardRequest(clientRequestInfo.target());
                                }
                                catch (Exception exception) {
                                    if (exception instanceof ForwardRequest) {
                                        throw (ForwardRequest)exception;
                                    }
                                    FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.retry", "1222", this);
                                    string = "Caught exception trying to set invocation subject. Reason: " + exception.toString();
                                    SecurityLogger.debugMessage(string2, string);
                                    SecurityLogger.logException(string2, exception, 0, 0);
                                    throw new NO_PERMISSION(string, 1229079302, CompletionStatus.COMPLETED_NO);
                                }
                            }
                            string = SecurityMessages.getMsgOrUseDefault("JSAS0202E", "JSAS0202E: Credential token expired.");
                            if (SecurityLogger.debugTraceEnabled) {
                                SecurityLogger.debugMessage(string2, string);
                            }
                            throw new NO_PERMISSION(string, 1229079302, CompletionStatus.COMPLETED_NO);
                        }
                        catch (Exception exception) {
                            if (exception instanceof ForwardRequest) {
                                throw (ForwardRequest)exception;
                            }
                            string = SecurityMessages.getMsgOrUseDefault("JSAS0202E", "JSAS0202E: Credential token expired.");
                            if (SecurityLogger.debugTraceEnabled) {
                                SecurityLogger.debugMessage(string2, string);
                            }
                            throw new NO_PERMISSION(string, 1229079302, CompletionStatus.COMPLETED_NO);
                        }
                    }
                }
            }
        }
    }

    public boolean isReferenceContextErrorRetriable(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        String string = "";
        String string2 = "SessionManager.isReferenceContextErrorRetriable";
        SASContextBody sASContextBody = null;
        ContextError contextError = null;
        ServiceContext serviceContext = this.csiUtil.get_sc_from_reply((RequestInfo)clientRequestInfo);
        if (serviceContext != null) {
            sASContextBody = this.csiUtil.get_message_from_sc(serviceContext);
        }
        if (sASContextBody != null && sASContextBody.discriminator() == 4 && (contextError = sASContextBody.error_msg()) != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Major/Minor status: " + contextError.major_status + "/" + contextError.minor_status;
                SecurityLogger.debugMessage(string2, string);
            }
            if (contextError.major_status == 4 && contextError.minor_status == 1) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Reference ContextError major/minor retriable";
                    SecurityLogger.debugMessage(string2, string);
                }
                return true;
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "ContextError major/minor not retriable or not present.";
            SecurityLogger.debugMessage(string2, string);
        }
        return false;
    }

    public boolean isAcceptContextErrorRetriable(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        String string = "";
        String string2 = "SessionManager.isAcceptContextErrorRetriable";
        SASContextBody sASContextBody = null;
        ContextError contextError = null;
        ServiceContext serviceContext = this.csiUtil.get_sc_from_reply((RequestInfo)clientRequestInfo);
        if (serviceContext != null) {
            sASContextBody = this.csiUtil.get_message_from_sc(serviceContext);
        }
        if (sASContextBody != null && sASContextBody.discriminator() == 4 && (contextError = sASContextBody.error_msg()) != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Major/Minor status: " + contextError.major_status + "/" + contextError.minor_status;
                SecurityLogger.debugMessage(string2, string);
            }
            if (contextError.major_status == 1 && contextError.minor_status == 1) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Accept ContextError major/minor retriable";
                    SecurityLogger.debugMessage(string2, string);
                }
                return true;
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "ContextError major/minor not retriable or not present.";
            SecurityLogger.debugMessage(string2, string);
        }
        return false;
    }

    public void csi_set_connection_cred(ServerConnectionKey serverConnectionKey, Subject subject) {
        Connection connection = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        connection.set_client_cert_creds_list(subject);
    }

    public Subject csi_lookup_connection_cred(ServerConnectionKey serverConnectionKey) {
        Connection connection = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        return connection.get_client_cert_creds_list();
    }

    public void csi_set_connection_propagation_token_map(ServerConnectionKey serverConnectionKey, Map map) {
        Connection connection = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        connection.set_client_cert_propagation_token_map(map);
    }

    public Map csi_lookup_connection_propagation_token_map(ServerConnectionKey serverConnectionKey) {
        Connection connection = null;
        connection = this.server_connection_lookup(serverConnectionKey.get_server_connection_hash());
        return connection.get_client_cert_propagation_token_map();
    }

    protected void clean_session_tables() {
        Long[] longArray;
        SessionTable sessionTable;
        Connection connection;
        String string = "";
        String string2 = "SessionManager.clean_session_tables";
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** BEGIN SESSION CLEANUP AT " + new Timestamp(System.currentTimeMillis()) + " ***";
            SecurityLogger.debugMessage(string2, string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.clientConnTable.keySet().toArray(new String[this.clientConnTable.size()]);
        }
        catch (ArrayStoreException arrayStoreException) {
            FFDCFilter.processException((Throwable)arrayStoreException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_session_tables", "1472", this);
        }
        if (stringArray != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Client connection table size:  " + this.clientConnTable.size();
                SecurityLogger.debugMessage(string2, string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                connection = null;
                connection = (Connection)this.clientConnTable.get(stringArray[i]);
                if (connection == null || (sessionTable = connection.getClientSessionTable()) == null) continue;
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Client session table size:  " + sessionTable.size();
                    SecurityLogger.debugMessage(string2, string);
                }
                longArray = connection.getSessionHashTable();
                Long[] longArray2 = null;
                try {
                    longArray2 = sessionTable.keySet().toArray(new Long[sessionTable.size()]);
                }
                catch (ArrayStoreException arrayStoreException) {
                    FFDCFilter.processException((Throwable)arrayStoreException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_session_tables", "1513", this);
                }
                if (longArray2 == null) continue;
                for (int j = 0; j < longArray2.length; ++j) {
                    boolean bl;
                    SessionEntry sessionEntry = (SessionEntry)sessionTable.get(longArray2[j]);
                    if (sessionEntry == null) continue;
                    long l = System.currentTimeMillis() - sessionEntry.get_session_usage_timestamp();
                    boolean bl2 = bl = l > (long)this.sessionDiscardUnusedMillis;
                    if (!bl) continue;
                    longArray.remove(sessionEntry.get_client_session_key().get_client_session_hash());
                    sessionTable.remove(longArray2[j]);
                    if (!SecurityLogger.debugTraceEnabled) continue;
                    string = "Client session deleted:  hash = " + sessionEntry.get_client_session_key().get_client_session_hash() + ":" + longArray2[j] + ", last used = " + new Timestamp(sessionEntry.get_session_usage_timestamp());
                    SecurityLogger.debugMessage(string2, string);
                }
            }
        }
        try {
            stringArray = this.serverConnTable.keySet().toArray(new String[this.serverConnTable.size()]);
        }
        catch (ArrayStoreException arrayStoreException) {
            FFDCFilter.processException((Throwable)arrayStoreException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_session_tables", "1557", this);
        }
        if (stringArray != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Server connection table size:  " + this.serverConnTable.size();
                SecurityLogger.debugMessage(string2, string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                connection = null;
                connection = (Connection)this.serverConnTable.get(stringArray[i]);
                if (connection == null || (sessionTable = connection.getServerSessionTable()) == null) continue;
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Server session table size:  " + sessionTable.size();
                    SecurityLogger.debugMessage(string2, string);
                }
                longArray = null;
                try {
                    longArray = sessionTable.keySet().toArray(new Long[0]);
                }
                catch (ArrayStoreException arrayStoreException) {
                    FFDCFilter.processException((Throwable)arrayStoreException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager.clean_session_tables", "1596", this);
                }
                if (longArray == null) continue;
                for (int j = 0; j < longArray.length; ++j) {
                    boolean bl;
                    SessionEntry sessionEntry = (SessionEntry)sessionTable.get(longArray[j]);
                    if (sessionEntry == null) continue;
                    long l = System.currentTimeMillis() - sessionEntry.get_session_usage_timestamp();
                    boolean bl3 = bl = l > (long)(this.sessionDiscardUnusedMillis + 300000);
                    if (!bl) continue;
                    sessionTable.remove(longArray[j]);
                    if (!SecurityLogger.debugTraceEnabled) continue;
                    string = "Server session deleted:  hash = " + connection.get_connection_hash() + ":" + longArray[j] + ", last used = " + new Timestamp(sessionEntry.get_session_usage_timestamp());
                    SecurityLogger.debugMessage(string2, string);
                }
            }
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "*** END SESSION CLEANUP AT " + new Timestamp(System.currentTimeMillis()) + " ***";
            SecurityLogger.debugMessage(string2, string);
        }
    }

    public void alarm(Object object) {
        this.clean_session_tables();
        AlarmManager.createDeferrable(this.sessionCleanupInterval, this);
    }
}

