/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.X509CertificateChainHelper;
import org.omg.IOP.ServiceContext;

public class SessionEntry {
    private byte[] session_entry_bytes = null;
    private int session_state = 4;
    private long session_usage_timestamp = 0L;
    private long client_context_id = 0L;
    private EstablishContext ec_message = null;
    private SecurityContextImpl sec_ctx = null;
    private int gcCount = 0;
    private String unique_server_session_hash = "";
    private String unique_client_session_hash = "";
    private ClientSessionKey client_session_key = null;
    private Map propagation_token_map = null;
    private boolean basic_auth_type = false;
    private boolean renegotiate_to_stateless = false;
    private X509Certificate[] cert_chain = null;
    private byte[] cert_chain_bytes = null;
    private byte[] in_token = null;
    private String remote_host = "";
    private int remote_port = 0;
    private String remote_connection_unique_id = "";
    private String identity_assertion_type = "";
    private byte[] identity_assertion_data = null;
    private byte[] opaque_authz_token = null;
    private CSIv2EffectivePerformPolicy effective_policy = null;
    private byte[] transport_layer_data = null;
    private byte transport_layer_data_type = 0;
    private static final String variable_data_name = "NATIVE_VARIABLE_DATA";
    private static final String ec_message_name = "ESTABLISH_CONTEXT_DATA";
    private static final String cert_chain_name = "CERT_CHAIN_DATA";
    private static final String in_token_name = "CLIENT_AUTH_TOKEN_DATA";
    private static final String identity_assertion_data_name = "IDENTITY_ASSERTION_DATA";
    private static final String opaque_authz_token_name = "OPAQUE_AUTHZ_DATA";
    private static final String effective_policy_name = "EFFECTIVE_POLICY";
    private static final String prop_token_name = "com.ibm.ws.security.token.PropagationTokenImpl";
    private static final String transport_layer_data_name = "TRANSPORT_LAYER_DATA";
    private static final CSIUtil csiUtil = new CSIUtil();

    public SessionEntry(long l, EstablishContext establishContext, String string) {
        this.client_context_id = l;
        this.ec_message = establishContext;
        this.unique_server_session_hash = string;
    }

    public SessionEntry(long l) {
        this.client_context_id = l;
    }

    public SessionEntry(byte[] byArray) throws Exception {
        String string = "";
        String string2 = "SessionEntry.<init>";
        this.constructFromBytes(byArray);
        if (SecurityLogger.debugTraceEnabled) {
            string = "Session contents after de-serialization: " + this.toString();
            SecurityLogger.debugMessage(string2, string);
        }
    }

    public int get_session_state() {
        return this.session_state;
    }

    public void set_session_state(int n) {
        this.set_session_entry_bytes(null);
        this.session_state = n;
    }

    public long get_client_context_id() {
        return this.client_context_id;
    }

    public void set_client_context_id(long l) {
        this.set_session_entry_bytes(null);
        this.client_context_id = l;
    }

    public EstablishContext get_ec_message() {
        return this.ec_message;
    }

    public void set_ec_message(EstablishContext establishContext) {
        this.set_session_entry_bytes(null);
        this.ec_message = establishContext;
    }

    public SecurityContextImpl get_security_context_holder() {
        return this.sec_ctx;
    }

    public void set_security_context_holder(SecurityContextImpl securityContextImpl) {
        this.set_session_entry_bytes(null);
        this.sec_ctx = securityContextImpl;
    }

    public void set_unique_server_session_hash(String string) {
        this.set_session_entry_bytes(null);
        this.unique_server_session_hash = string;
    }

    public String get_unique_server_session_hash() {
        return this.unique_server_session_hash;
    }

    public void set_unique_client_session_hash(String string) {
        this.set_session_entry_bytes(null);
        this.unique_client_session_hash = string;
    }

    public String get_unique_client_session_hash() {
        return this.unique_client_session_hash;
    }

    public void update_session_usage_timestamp() {
        this.session_usage_timestamp = System.currentTimeMillis();
    }

    public long get_session_usage_timestamp() {
        return this.session_usage_timestamp;
    }

    public void set_client_session_key(ClientSessionKey clientSessionKey) {
        this.set_session_entry_bytes(null);
        this.client_session_key = clientSessionKey;
        if (clientSessionKey != null) {
            this.unique_client_session_hash = clientSessionKey.get_client_session_hash();
        }
    }

    public ClientSessionKey get_client_session_key() {
        if (this.client_session_key == null && this.unique_client_session_hash != null) {
            this.client_session_key = new ClientSessionKey(this.unique_client_session_hash);
        }
        return this.client_session_key;
    }

    public Map get_propagation_token_map() {
        return this.propagation_token_map;
    }

    public void set_propagation_token_map(Map map) {
        this.set_session_entry_bytes(null);
        this.propagation_token_map = map;
    }

    public void set_basic_auth_type() {
        this.set_session_entry_bytes(null);
        this.basic_auth_type = true;
    }

    public boolean get_basic_auth_type() {
        return this.basic_auth_type;
    }

    public void set_cert_chain(X509Certificate[] x509CertificateArray) {
        this.set_session_entry_bytes(null);
        this.cert_chain_bytes = null;
        this.cert_chain = x509CertificateArray;
    }

    public byte[] get_identity_assertion_data() {
        return this.identity_assertion_data;
    }

    public void set_identity_assertion_data(byte[] byArray) {
        this.set_session_entry_bytes(null);
        this.identity_assertion_data = byArray;
    }

    public String get_identity_assertion_type() {
        return this.identity_assertion_type;
    }

    public void set_identity_assertion_type(String string) {
        this.set_session_entry_bytes(null);
        this.identity_assertion_type = string;
    }

    public X509Certificate[] get_cert_chain() {
        if (this.cert_chain == null && this.cert_chain_bytes != null) {
            try {
                this.cert_chain = SessionEntry.convertBytesToCertChain(this.cert_chain_bytes);
            }
            catch (Exception exception) {
                this.cert_chain = null;
            }
        }
        return this.cert_chain;
    }

    public void set_in_token(byte[] byArray) {
        this.set_session_entry_bytes(null);
        this.in_token = byArray;
    }

    public byte[] get_in_token() {
        return this.in_token;
    }

    public void set_remote_host(String string) {
        this.set_session_entry_bytes(null);
        this.remote_host = string;
    }

    public String get_remote_host() {
        return this.remote_host;
    }

    public void set_remote_port(int n) {
        this.set_session_entry_bytes(null);
        this.remote_port = n;
    }

    public int get_remote_port() {
        return this.remote_port;
    }

    public void set_remote_connection_unique_id(String string) {
        this.set_session_entry_bytes(null);
        this.remote_connection_unique_id = string;
    }

    public String get_remote_connection_unique_id() {
        return this.remote_connection_unique_id;
    }

    public void set_renegotiate_to_stateless() {
        this.set_session_entry_bytes(null);
        this.renegotiate_to_stateless = true;
    }

    public void reset_renegotiate_to_stateless() {
        this.set_session_entry_bytes(null);
        this.renegotiate_to_stateless = false;
    }

    public boolean get_renegotiate_to_stateless() {
        return this.renegotiate_to_stateless;
    }

    public void set_transport_layer_data_type(byte by) {
        this.transport_layer_data_type = by;
    }

    public byte get_transport_layer_data_type() {
        return this.transport_layer_data_type;
    }

    public void set_opaque_authz_token(byte[] byArray) {
        this.opaque_authz_token = byArray;
    }

    public byte[] get_opaque_authz_token() {
        return this.opaque_authz_token;
    }

    public void set_effective_policy(CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        this.effective_policy = cSIv2EffectivePerformPolicy;
    }

    public CSIv2EffectivePerformPolicy get_effective_policy() {
        return this.effective_policy;
    }

    public void set_transport_layer_data(byte[] byArray) {
        this.transport_layer_data = byArray;
    }

    public byte[] get_transport_layer_data() {
        return this.transport_layer_data;
    }

    private synchronized void set_session_entry_bytes(byte[] byArray) {
        this.session_entry_bytes = byArray;
    }

    public static X509Certificate[] convertBytesToCertChain(byte[] byArray) throws Exception {
        X509Certificate[] x509CertificateArray = null;
        if (byArray != null) {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Any any = csiUtil.getCodec().decode_value(byArray, X509CertificateChainHelper.type());
            byte[] byArray2 = X509CertificateChainHelper.extract(any);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            CertPath certPath = certificateFactory.generateCertPath(byteArrayInputStream);
            List<? extends Certificate> list = certPath.getCertificates();
            x509CertificateArray = new X509Certificate[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                x509CertificateArray[i] = (X509Certificate)list.get(i);
            }
        }
        return x509CertificateArray;
    }

    public static byte[] convertCertChainToBytes(X509Certificate[] x509CertificateArray) throws Exception {
        if (x509CertificateArray != null) {
            Object object;
            Object object2;
            ArrayList<ORB> arrayList = new ArrayList<ORB>(x509CertificateArray.length);
            HashSet<ORB> hashSet = new HashSet<ORB>(x509CertificateArray.length);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                object2 = new ByteArrayInputStream(x509CertificateArray[i].getEncoded());
                object = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                if (!hashSet.add((ORB)object)) continue;
                arrayList.add((ORB)object);
            }
            CertificateFactory certificateFactory2 = CertificateFactory.getInstance("X.509");
            object2 = certificateFactory2.generateCertPath(arrayList);
            object = VaultImpl.getInstance().getORB();
            Any any = object.create_any();
            X509CertificateChainHelper.insert(any, ((CertPath)object2).getEncoded());
            return csiUtil.getCodec().encode_value(any);
        }
        return null;
    }

    public boolean compare_establish_context_messages(EstablishContext establishContext) {
        String string = "";
        String string2 = "SessionEntry.compare_establish_context_messages";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        bl2 = Arrays.equals(this.ec_message.client_authentication_token, establishContext.client_authentication_token);
        if (establishContext.identity_token.discriminator() != this.ec_message.identity_token.discriminator()) {
            bl = false;
        } else if (establishContext.identity_token.discriminator() == 0) {
            bl = true;
        } else if (establishContext.identity_token.discriminator() == 1) {
            bl = true;
        } else if (establishContext.identity_token.discriminator() == 2) {
            bl = Arrays.equals(this.ec_message.identity_token.principal_name(), establishContext.identity_token.principal_name());
        } else if (establishContext.identity_token.discriminator() == 8) {
            bl = Arrays.equals(this.ec_message.identity_token.dn(), establishContext.identity_token.dn());
        } else if (establishContext.identity_token.discriminator() == 4) {
            bl = Arrays.equals(this.ec_message.identity_token.certificate_chain(), establishContext.identity_token.certificate_chain());
        }
        if (this.ec_message.authorization_token.length != establishContext.authorization_token.length) {
            bl3 = false;
        } else if (this.ec_message.authorization_token.length == 0) {
            bl3 = true;
        } else {
            for (int i = 0; i < establishContext.authorization_token.length; ++i) {
                if (this.ec_message.authorization_token[i] != null && establishContext.authorization_token[i] != null) {
                    bl3 = Arrays.equals(this.ec_message.authorization_token[i].the_element, establishContext.authorization_token[i].the_element);
                    boolean bl5 = bl3 = this.ec_message.authorization_token[i].the_type == establishContext.authorization_token[i].the_type;
                    if (bl3) continue;
                    break;
                }
                if (this.ec_message.authorization_token[i] == null && establishContext.authorization_token[i] == null) {
                    bl3 = true;
                    continue;
                }
                bl3 = false;
                break;
            }
        }
        boolean bl6 = bl4 = bl2 && bl && bl3;
        if (SecurityLogger.debugTraceEnabled) {
            if (bl4) {
                string = "EstablishContext compare succeeded.";
                SecurityLogger.debugMessage(string2, string);
            } else {
                string = "EstablishContext compare failed: client_auth_tokens=" + bl2 + ", identity_tokens=" + bl + ", authorization_tokens=" + bl3;
                SecurityLogger.debugMessage(string2, string);
            }
        }
        return bl4;
    }

    private void constructFromBytes(byte[] byArray) throws Exception {
        String string = "";
        String string2 = "SessionEntry.constructFromBytes";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        if (byArray != null) {
            try {
                ArrayList arrayList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray);
                for (int i = 0; i < arrayList.size(); ++i) {
                    TokenHolder tokenHolder = (TokenHolder)arrayList.get(i);
                    String string3 = tokenHolder.getName();
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Handling token name: " + string3;
                        SecurityLogger.debugMessage(string2, string);
                    }
                    if (string3 != null && string3.equals(cert_chain_name)) {
                        this.cert_chain = null;
                        this.cert_chain_bytes = tokenHolder.getBytes();
                        continue;
                    }
                    if (string3 != null && string3.equals(in_token_name)) {
                        this.in_token = tokenHolder.getBytes();
                        continue;
                    }
                    if (string3 != null && string3.equals(identity_assertion_data_name)) {
                        this.identity_assertion_data = tokenHolder.getBytes();
                        continue;
                    }
                    if (string3 != null && string3.equals(transport_layer_data_name)) {
                        this.transport_layer_data = tokenHolder.getBytes();
                        continue;
                    }
                    if (string3 != null && string3.equals(ec_message_name)) {
                        SASContextBody sASContextBody = csiUtil.get_message_from_sc(new ServiceContext(15, tokenHolder.getBytes()));
                        this.ec_message = sASContextBody.establish_msg();
                        continue;
                    }
                    if (string3 != null && string3.equals(effective_policy_name)) {
                        this.effective_policy = new CSIv2EffectivePerformPolicy(tokenHolder.getBytes());
                        continue;
                    }
                    if (string3 != null && string3.equals(opaque_authz_token_name)) {
                        this.opaque_authz_token = tokenHolder.getBytes();
                        continue;
                    }
                    if (string3 != null && string3.equals(variable_data_name)) {
                        this.deserializeVariables(tokenHolder.getBytes());
                        continue;
                    }
                    if (string3 == null || !string3.equals(prop_token_name) || !SecurityLogger.debugTraceEnabled) continue;
                    string = "TODO: Not handling the deserialization of the propagation token yet.";
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.constructFromBytes", "521", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Exception constructing private service context.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, exception, 0, 0);
                throw exception;
            }
        } else {
            throw new INTERNAL("Service context data is not found.");
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public synchronized byte[] getBytes() throws Exception {
        String string = "";
        String string2 = "SessionEntry.getBytes";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "Session contents prior to serialization: " + this.toString();
            SecurityLogger.debugMessage(string2, string);
        }
        if (this.session_entry_bytes == null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Serializing session.";
                SecurityLogger.debugMessage(string2, string);
            }
            ArrayList<TokenHolder> arrayList = new ArrayList<TokenHolder>();
            try {
                TokenHolder tokenHolder = this.serializeVariables();
                arrayList.add(tokenHolder);
                ServiceContext serviceContext = null;
                if (this.ec_message != null && (serviceContext = csiUtil.create_sc_from_ec_message(this.ec_message)) != null) {
                    arrayList.add(new TokenHolder(serviceContext.context_data, ec_message_name, 1));
                }
                if (this.in_token != null) {
                    arrayList.add(new TokenHolder(this.in_token, in_token_name, 1));
                }
                if (this.opaque_authz_token != null) {
                    arrayList.add(new TokenHolder(this.opaque_authz_token, opaque_authz_token_name, 1));
                }
                if (this.identity_assertion_data != null) {
                    arrayList.add(new TokenHolder(this.identity_assertion_data, identity_assertion_data_name, 1));
                }
                if (this.effective_policy != null) {
                    arrayList.add(new TokenHolder(this.effective_policy.getBytes(), effective_policy_name, 1));
                }
                if (this.transport_layer_data != null) {
                    arrayList.add(new TokenHolder(this.transport_layer_data, transport_layer_data_name, 1));
                }
                if (this.propagation_token_map != null) {
                    Iterator iterator = this.propagation_token_map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        PropagationToken propagationToken = (PropagationToken)this.propagation_token_map.get(string3);
                        if (propagationToken == null) continue;
                        long l = propagationToken.getExpiration();
                        long l2 = l - System.currentTimeMillis() - 900000L;
                        if (l2 < 0L) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string = "Refreshing propagation token from session.";
                                SecurityLogger.debugMessage(string2, string);
                            }
                            propagationToken = (PropagationToken)propagationToken.clone();
                        }
                        final PropagationToken propagationToken2 = propagationToken;
                        byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return propagationToken2.getBytes();
                            }
                        });
                        arrayList.add(new TokenHolder(byArray, propagationToken.getName(), propagationToken.getVersion()));
                    }
                }
                if (this.cert_chain != null && this.cert_chain_bytes == null) {
                    this.cert_chain_bytes = SessionEntry.convertCertChainToBytes(this.cert_chain);
                }
                if (this.cert_chain_bytes != null) {
                    arrayList.add(new TokenHolder(this.cert_chain_bytes, cert_chain_name, 1));
                }
                this.session_entry_bytes = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromTokenHolderList(null, arrayList);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.getBytes", "621", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Exception getting session bytes for private security context.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, exception, 0, 0);
                throw exception;
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return this.session_entry_bytes;
    }

    private TokenHolder serializeVariables() throws Exception {
        String string = "";
        String string2 = "SessionEntry.serializeVariables";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        TokenHolder tokenHolder = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(300);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeBoolean(this.basic_auth_type);
            dataOutputStream.writeBoolean(this.renegotiate_to_stateless);
            dataOutputStream.writeInt(this.session_state);
            dataOutputStream.writeInt(this.remote_port);
            dataOutputStream.writeLong(this.session_usage_timestamp);
            dataOutputStream.writeLong(this.client_context_id);
            dataOutputStream.writeByte(this.transport_layer_data_type);
            if (this.remote_connection_unique_id != null && this.remote_connection_unique_id.length() > 0) {
                dataOutputStream.writeInt(this.remote_connection_unique_id.length());
                dataOutputStream.write(this.remote_connection_unique_id.getBytes(), 0, this.remote_connection_unique_id.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.unique_server_session_hash != null && this.unique_server_session_hash.length() > 0) {
                dataOutputStream.writeInt(this.unique_server_session_hash.length());
                dataOutputStream.write(this.unique_server_session_hash.getBytes(), 0, this.unique_server_session_hash.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.unique_client_session_hash != null && this.unique_client_session_hash.length() > 0) {
                dataOutputStream.writeInt(this.unique_client_session_hash.length());
                dataOutputStream.write(this.unique_client_session_hash.getBytes(), 0, this.unique_client_session_hash.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.remote_host != null && this.remote_host.length() > 0) {
                dataOutputStream.writeInt(this.remote_host.length());
                dataOutputStream.write(this.remote_host.getBytes(), 0, this.remote_host.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            if (this.identity_assertion_type != null && this.identity_assertion_type.length() > 0) {
                dataOutputStream.writeInt(this.identity_assertion_type.length());
                dataOutputStream.write(this.identity_assertion_type.getBytes(), 0, this.identity_assertion_type.length());
            } else {
                dataOutputStream.writeInt(0);
            }
            tokenHolder = new TokenHolder(byteArrayOutputStream.toByteArray(), variable_data_name, 1);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.serializeVariables", "724", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception serializing native variables.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        finally {
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
        return tokenHolder;
    }

    private void deserializeVariables(byte[] byArray) throws Exception {
        String string = "";
        String string2 = "SessionEntry.deserializeVariables";
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugEntry(string2);
        }
        Object var4_4 = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            byte[] byArray2;
            this.basic_auth_type = dataInputStream.readBoolean();
            this.renegotiate_to_stateless = dataInputStream.readBoolean();
            this.session_state = dataInputStream.readInt();
            this.remote_port = dataInputStream.readInt();
            this.session_usage_timestamp = dataInputStream.readLong();
            this.client_context_id = dataInputStream.readLong();
            this.transport_layer_data_type = dataInputStream.readByte();
            int n = dataInputStream.readInt();
            if (n > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.remote_connection_unique_id = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.unique_server_session_hash = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.unique_client_session_hash = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.remote_host = new String(byArray2);
            }
            if ((n = dataInputStream.readInt()) > 0) {
                byArray2 = new byte[n];
                dataInputStream.read(byArray2, 0, n);
                this.identity_assertion_type = new String(byArray2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.deserializeVariables", "827", this);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception de-serializing native variables.";
                SecurityLogger.debugMessage(string2, string);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            throw exception;
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        if (SecurityLogger.debugEntryEnabled) {
            SecurityLogger.debugExit(string2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nsession_entry_bytes null? " + (this.session_entry_bytes == null));
        stringBuffer.append("\nec_message null? " + (this.ec_message == null));
        stringBuffer.append("\nsec_ctx null? " + (this.sec_ctx == null));
        stringBuffer.append("\nin_token null? " + (this.in_token == null));
        stringBuffer.append("\nopaque_authz_token null? " + (this.opaque_authz_token == null));
        stringBuffer.append("\ntransport_layer_data null? " + (this.transport_layer_data == null));
        stringBuffer.append("\ncert_chain null? " + (this.cert_chain == null && this.cert_chain_bytes == null));
        stringBuffer.append("\nclient_session_key null? " + (this.client_session_key == null));
        stringBuffer.append("\npropagation_token_map null? " + (this.propagation_token_map == null));
        stringBuffer.append("\nidentity_assertion_data null? " + (this.identity_assertion_data == null));
        stringBuffer.append("\nidentity_assertion_type: " + this.identity_assertion_type);
        stringBuffer.append("\nsession_state: " + this.session_state);
        stringBuffer.append("\nsession_usage_timestamp: " + this.session_usage_timestamp);
        stringBuffer.append("\nclient_context_id: " + this.client_context_id);
        stringBuffer.append("\ngcCount: " + this.gcCount);
        stringBuffer.append("\nunique_server_session_hash: " + this.unique_server_session_hash);
        stringBuffer.append("\nunique_client_session_hash: " + this.unique_client_session_hash);
        stringBuffer.append("\nbasic_auth_type: " + this.basic_auth_type);
        stringBuffer.append("\nrenegotiate_to_stateless: " + this.renegotiate_to_stateless);
        stringBuffer.append("\nremote_host: " + this.remote_host);
        stringBuffer.append("\nremote_port: " + this.remote_port);
        stringBuffer.append("\nremote_connection_unique_id: " + this.remote_connection_unique_id);
        return stringBuffer.toString();
    }
}

