/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.security.auth.Subject;

public final class SecurityExecutionEnvironment
implements Serializable {
    private static final TraceComponent tc = Tr.register(SecurityExecutionEnvironment.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static final long serialVersionUID = 8804343014975817029L;
    private static final int VERSION_1 = 1;
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private int _version = 1;
    private boolean _isServerCredential;
    private boolean _isUnauthenticatedCredential;
    private boolean _isBasicAuthCredential;
    private boolean _isForwardableCredential;
    private String _realm;
    private String _securityName;
    private String _accessId;
    private String _uniqueSecurityName;
    private ArrayList _groupIds;
    private String _oid;
    private byte[] _credentialToken;
    private long _expiration;
    private String _clientUniqueId;

    public SecurityExecutionEnvironment() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public SecurityExecutionEnvironment(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", subject);
        }
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        String string = contextManager.getClientUniqueIDForOutboundRequests(subject);
        this.initialize(wSCredential, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public SecurityExecutionEnvironment(WSCredential wSCredential, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{wSCredential, string});
        }
        this.initialize(wSCredential, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private void initialize(WSCredential wSCredential, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{wSCredential, string});
        }
        try {
            this._isServerCredential = contextManager.isServerCred(wSCredential);
            this._isUnauthenticatedCredential = wSCredential.isUnauthenticated();
            this._isBasicAuthCredential = wSCredential.isBasicAuth();
            this._isForwardableCredential = wSCredential.isForwardable();
            this._realm = wSCredential.getRealmName();
            this._securityName = wSCredential.getSecurityName();
            this._accessId = wSCredential.getAccessId();
            this._uniqueSecurityName = wSCredential.getUniqueSecurityName();
            this._clientUniqueId = string;
            this._groupIds = wSCredential.getGroupIds();
            this._oid = wSCredential.getOID();
            this._credentialToken = wSCredential.getCredentialToken();
            this._expiration = wSCredential.getExpiration();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SecurityExecutionEnvironment", "227", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to build SecurityExecutionEnvrionment", exception);
            }
            this._isUnauthenticatedCredential = true;
            this._credentialToken = null;
            this._expiration = 1L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Hashtable getLoginHashtable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginHashtable");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this._isBasicAuthCredential) {
            if (this._realm != null) {
                hashtable.put("com.ibm.wsspi.security.cred.realm", this._realm);
            }
            if (this._securityName != null) {
                hashtable.put("com.ibm.wsspi.security.cred.userId", this._securityName);
            }
            if (this._credentialToken != null) {
                hashtable.put("com.ibm.wsspi.security.cred.password", new String(this._credentialToken));
            }
        } else if (!this._isUnauthenticatedCredential && !this._isServerCredential) {
            if (this._uniqueSecurityName != null) {
                hashtable.put("com.ibm.wsspi.security.cred.uniqueId", this._accessId);
            }
            if (this._realm != null) {
                hashtable.put("com.ibm.wsspi.security.cred.realm", this._realm);
            }
            if (this._securityName != null) {
                hashtable.put("com.ibm.wsspi.security.cred.securityName", this._securityName);
            }
            if (this._groupIds != null) {
                hashtable.put("com.ibm.wsspi.security.cred.groups", this._groupIds);
            }
            if (this._oid != null) {
                hashtable.put("com.ibm.wsspi.security.cred.oid", this._oid);
            }
            hashtable.put("com.ibm.wsspi.security.cred.forwardable", this._isForwardableCredential ? "true" : "false");
        } else if (this._isUnauthenticatedCredential || this._isServerCredential) {
            hashtable = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginHashtable", hashtable);
        }
        return hashtable;
    }

    public boolean isServerCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServerCredential", new Boolean(this._isServerCredential));
        }
        return this._isServerCredential;
    }

    public boolean isUnauthenticatedCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnauthenticatedCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnauthenticatedCredential");
        }
        return this._isUnauthenticatedCredential;
    }

    public boolean isBasicAuthCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isBasicAuthCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isBasicAuthCredential", new Boolean(this._isBasicAuthCredential));
        }
        return this._isBasicAuthCredential;
    }

    public boolean isForwardableCredential() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isForwardableCredential");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isForwardableCredential", new Boolean(this._isForwardableCredential));
        }
        return this._isForwardableCredential;
    }

    public String getRealm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this._realm);
        }
        return this._realm;
    }

    public String getSecurityName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", this._securityName);
        }
        return this._securityName;
    }

    public String getAccessId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId", this._accessId);
        }
        return this._accessId;
    }

    public String getUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueId");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueId", this._uniqueSecurityName);
        }
        return this._uniqueSecurityName;
    }

    public String getClientUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientUniqueId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientUniqueId", this._clientUniqueId);
        }
        return this._clientUniqueId;
    }

    public ArrayList getGroupIds() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIds", this._groupIds);
        }
        return this._groupIds;
    }

    public String getOID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOID", this._oid);
        }
        return this._oid;
    }

    public byte[] getCredentialToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken", this._isBasicAuthCredential ? "secret".getBytes() : this._credentialToken);
        }
        return this._credentialToken;
    }

    public long getCredentialExpiration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredentialExpiration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialExpiration", new Long(this._expiration));
        }
        return this._expiration;
    }

    public byte[] getBytes() {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getBytes");
            }
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            try {
                object = new ObjectOutputStream(byteArrayOutputStream);
                ((ObjectOutputStream)object).writeObject(this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.getBytes", "426", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to serialize execution environment", exception);
            }
        }
        object = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", this._isBasicAuthCredential ? (Object)"secret".getBytes() : object);
        }
        return object;
    }

    public static SecurityExecutionEnvironment createFromBytes(byte[] byArray) {
        SecurityExecutionEnvironment securityExecutionEnvironment;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createFromBytes", byArray);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            securityExecutionEnvironment = null;
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                securityExecutionEnvironment = (SecurityExecutionEnvironment)objectInputStream.readObject();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.createFromBytes", "453");
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unable to deserialize the execution environment", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFromBytes", securityExecutionEnvironment);
        }
        return securityExecutionEnvironment;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject", objectOutputStream);
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("_version", this._version);
        putField.put("_isServerCredential", this._isServerCredential);
        putField.put("_isUnauthenticatedCredential", this._isUnauthenticatedCredential);
        putField.put("_isBasicAuthCredential", this._isBasicAuthCredential);
        putField.put("_isForwardableCredential", this._isForwardableCredential);
        putField.put("_realm", this._realm);
        putField.put("_securityName", this._securityName);
        putField.put("_accessId", this._accessId);
        putField.put("_uniqueSecurityName", this._uniqueSecurityName);
        putField.put("_groupIds", this._groupIds);
        putField.put("_oid", this._oid);
        putField.put("_credentialToken", this._credentialToken);
        putField.put("_expiration", this._expiration);
        putField.put("_clientUniqueId", this._clientUniqueId);
        objectOutputStream.writeFields();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject", objectInputStream);
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this._version = getField.get("_version", 1);
        this._isServerCredential = getField.get("_isServerCredential", false);
        this._isUnauthenticatedCredential = getField.get("_isUnauthenticatedCredential", true);
        this._isBasicAuthCredential = getField.get("_isBasicAuthCredential", false);
        this._isForwardableCredential = getField.get("_isForwardableCredential", false);
        this._realm = (String)getField.get("_realm", null);
        this._securityName = (String)getField.get("_securityName", null);
        this._accessId = (String)getField.get("_accessId", null);
        this._uniqueSecurityName = (String)getField.get("_uniqueSecurityName", null);
        this._groupIds = (ArrayList)getField.get("_groupIds", null);
        this._oid = (String)getField.get("_oid", null);
        this._credentialToken = (byte[])getField.get("_credentialToken", null);
        this._expiration = getField.get("_expiration", 0L);
        this._clientUniqueId = (String)getField.get("_clientUniqueId", null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(";_isServerCredential=").append(this._isServerCredential);
        stringBuffer.append(";_isUnauthenticatedCredential=").append(this._isUnauthenticatedCredential);
        stringBuffer.append(";_isBasicAuthCredential=").append(this._isBasicAuthCredential);
        stringBuffer.append(";_isForwardableCredential=").append(this._isForwardableCredential);
        stringBuffer.append(":_realm=").append(this._realm);
        stringBuffer.append(";_accessId=").append(this._accessId);
        stringBuffer.append(";_clientUniqueId=").append(this._clientUniqueId);
        stringBuffer.append(";_groupIds=").append(this._groupIds);
        stringBuffer.append(";_oid=").append(this._oid);
        stringBuffer.append(";_expiration=").append(this._expiration);
        return stringBuffer.toString();
    }
}

