/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.CSIv2Configuration;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.util.PlatformHelperFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.AS_ContextSecHolder;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechHolder;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.SAS_ContextSecHolder;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHolder;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;
import org.omg.CSIIOP.TransportAddress;
import org.omg.CSIIOP.TransportAddressHolder;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;

public final class CSIv2TaggedComponent
extends SecurityTaggedComponent {
    private static String hostname = CSIv2TaggedComponent.getHostName();
    private static List secureChainList = null;
    private static boolean secureChainListInitialized = false;
    private static List insecureChainList = null;
    private static boolean insecureChainListInitialized = false;
    private static Hashtable csiv2TagCache = new Hashtable();
    private boolean _stateful = true;
    private int transport_tagID = 0;
    private String serviceConfigList = null;
    private TLS_SEC_TRANSHolder transport_mech_TLSHolder = null;
    private SECIOP_SEC_TRANSHolder transport_mech_SECIOPHolder = null;
    private AS_ContextSecHolder as_context_mech_holder = null;
    private SAS_ContextSecHolder sas_context_mech_holder = null;
    private Profile profile = null;
    private TransportAddressHolder tAddrH = null;

    public TransportAddressHolder get_Transport_Address() {
        return this.tAddrH;
    }

    public int get_Transport_tagID() {
        return this.transport_tagID;
    }

    public String get_Service_Configuration_List() {
        return this.serviceConfigList;
    }

    private void setTransport_mech_holder(Object object, int n) {
        if (n == 36) {
            this.transport_mech_TLSHolder = (TLS_SEC_TRANSHolder)object;
        } else if (n == 35) {
            this.transport_mech_SECIOPHolder = (SECIOP_SEC_TRANSHolder)object;
        } else {
            this.transport_mech_TLSHolder = null;
            this.transport_mech_SECIOPHolder = null;
        }
    }

    private CSIv2TaggedComponent(CompoundSecMechHolder compoundSecMechHolder, boolean bl, ORB oRB, Profile profile) {
        this.initialize(compoundSecMechHolder, bl, oRB, profile);
    }

    public void initialize(CompoundSecMechHolder compoundSecMechHolder, boolean bl, ORB oRB, Profile profile) {
        String string = "CSIv2TaggedComponent.initialize";
        String string2 = null;
        Object var7_7 = null;
        VaultImpl.getInstance();
        SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
        this.profile = profile;
        CSIUtil cSIUtil = new CSIUtil();
        short s = 0;
        short s2 = 0;
        try {
            Object object;
            this.set_tagID(33);
            this._stateful = bl;
            TaggedComponent taggedComponent = compoundSecMechHolder.value.transport_mech;
            if (taggedComponent != null) {
                this.transport_tagID = taggedComponent.tag;
                if (this.transport_tagID == 36) {
                    object = null;
                    try {
                        object = cSIUtil.getCodec().decode_value(taggedComponent.component_data, TLS_SEC_TRANSHelper.type());
                    }
                    catch (MARSHAL mARSHAL) {
                        FFDCFilter.processException((Throwable)mARSHAL, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "260", this);
                        SecurityLogger.logException(string, (Exception)((Object)mARSHAL), 0, 0);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        FFDCFilter.processException((Throwable)bAD_OPERATION, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "265", this);
                        SecurityLogger.logException(string, (Exception)((Object)bAD_OPERATION), 0, 0);
                    }
                    catch (FormatMismatch formatMismatch) {
                        FFDCFilter.processException((Throwable)formatMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "270", this);
                        SecurityLogger.logException(string, (Exception)((Object)formatMismatch), 0, 0);
                    }
                    catch (TypeMismatch typeMismatch) {
                        FFDCFilter.processException((Throwable)typeMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "275", this);
                        SecurityLogger.logException(string, (Exception)((Object)typeMismatch), 0, 0);
                    }
                    this.transport_mech_TLSHolder = new TLS_SEC_TRANSHolder(TLS_SEC_TRANSHelper.extract(object));
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "CSI Security Transport values, transport layer: TLS, target requires = " + this.transport_mech_TLSHolder.value.target_requires + " target supports = " + this.transport_mech_TLSHolder.value.target_supports;
                        SecurityLogger.debugMessage(string, string2);
                    }
                    s = (short)(s | this.transport_mech_TLSHolder.value.target_requires);
                    s2 = (short)(s2 | this.transport_mech_TLSHolder.value.target_supports);
                    if (this.transport_mech_TLSHolder.value.addresses != null || this.transport_mech_TLSHolder.value.addresses.length != 0) {
                        this.tAddrH = new TransportAddressHolder(this.transport_mech_TLSHolder.value.addresses[0]);
                    }
                } else if (this.transport_tagID == 35) {
                    object = null;
                    try {
                        object = cSIUtil.getCodec().decode_value(taggedComponent.component_data, SECIOP_SEC_TRANSHelper.type());
                    }
                    catch (MARSHAL mARSHAL) {
                        FFDCFilter.processException((Throwable)mARSHAL, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "309", this);
                        SecurityLogger.logException(string, (Exception)((Object)mARSHAL), 0, 0);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        FFDCFilter.processException((Throwable)bAD_OPERATION, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "314", this);
                        SecurityLogger.logException(string, (Exception)((Object)bAD_OPERATION), 0, 0);
                    }
                    catch (FormatMismatch formatMismatch) {
                        FFDCFilter.processException((Throwable)formatMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "319", this);
                        SecurityLogger.logException(string, (Exception)((Object)formatMismatch), 0, 0);
                    }
                    catch (TypeMismatch typeMismatch) {
                        FFDCFilter.processException((Throwable)typeMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "324", this);
                        SecurityLogger.logException(string, (Exception)((Object)typeMismatch), 0, 0);
                    }
                    this.transport_mech_SECIOPHolder = new SECIOP_SEC_TRANSHolder(SECIOP_SEC_TRANSHelper.extract(object));
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "CSI Security Transport values, transport layer: SECIOP, target requires = " + this.transport_mech_SECIOPHolder.value.target_requires + " target supports = " + this.transport_mech_SECIOPHolder.value.target_supports;
                        SecurityLogger.debugMessage(string, string2);
                    }
                    s = (short)(s | this.transport_mech_SECIOPHolder.value.target_requires);
                    s2 = (short)(s2 | this.transport_mech_SECIOPHolder.value.target_supports);
                    if (this.transport_mech_SECIOPHolder.value.addresses != null && this.transport_mech_SECIOPHolder.value.addresses.length != 0) {
                        this.tAddrH = new TransportAddressHolder(this.transport_mech_SECIOPHolder.value.addresses[0]);
                    }
                } else if (SecurityLogger.debugTraceEnabled) {
                    string2 = "CSI Security Transport values, transport layer: NULL";
                    SecurityLogger.debugMessage(string, string2);
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSI Security Transport values, transport layer: NULL";
                SecurityLogger.debugMessage(string, string2);
            }
            if (compoundSecMechHolder.value.as_context_mech != null) {
                this.as_context_mech_holder = new AS_ContextSecHolder(compoundSecMechHolder.value.as_context_mech);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "CSI Client Authentication values, client auth layer: target_requires =  " + this.as_context_mech_holder.value.target_requires + " target_supports = " + this.as_context_mech_holder.value.target_supports;
                    SecurityLogger.debugMessage(string, string2);
                }
                s = (short)(s | this.as_context_mech_holder.value.target_requires);
                s2 = (short)(s2 | this.as_context_mech_holder.value.target_supports);
                if (compoundSecMechHolder.value.as_context_mech.target_name != null && compoundSecMechHolder.value.as_context_mech.client_authentication_mech != null && ((Any)(object = (Object)compoundSecMechHolder.value.as_context_mech.target_name)).length != 0) {
                    try {
                        GSSFactory gSSFactory = new GSSFactory(compoundSecMechHolder.value.as_context_mech.client_authentication_mech);
                        this.set_targetCompleteName(gSSFactory.decodeExportedTargetName((byte[])object));
                    }
                    catch (GSSEncodeDecodeException gSSEncodeDecodeException) {
                        FFDCFilter.processException((Throwable)gSSEncodeDecodeException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "406", this);
                        string2 = "security.JSAS0622E";
                        SecurityLogger.logError(string2, new Object[]{string, gSSEncodeDecodeException});
                    }
                }
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSI Client Authentication values, client auth layer: NULL";
                SecurityLogger.debugMessage(string, string2);
            }
            if (compoundSecMechHolder.value.sas_context_mech != null) {
                this.sas_context_mech_holder = new SAS_ContextSecHolder(compoundSecMechHolder.value.sas_context_mech);
                if (SecurityLogger.debugTraceEnabled) {
                    string2 = "CSI Security Attribute values, attribute layer: target_requires = " + this.sas_context_mech_holder.value.target_requires + " target_supports = " + this.sas_context_mech_holder.value.target_supports;
                    SecurityLogger.debugMessage(string, string2);
                }
                s = (short)(s | this.sas_context_mech_holder.value.target_requires);
                s2 = (short)(s2 | this.sas_context_mech_holder.value.target_supports);
            } else if (SecurityLogger.debugTraceEnabled) {
                string2 = "CSI Security Attribute values, attribute layer: NULL";
                SecurityLogger.debugMessage(string, string2);
            }
            this.set_targetCoalescedReqQOP(s);
            this.set_targetCoalescedSuppQOP(s2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "484", this);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Exception creating new CSIv2 Tagged Component.";
                SecurityLogger.debugMessage(string, string2);
            }
            SecurityLogger.logException(string, exception, 0, 0);
        }
    }

    public TLS_SEC_TRANSHolder getTLS_SEC_TRANS() {
        return this.transport_mech_TLSHolder;
    }

    public SECIOP_SEC_TRANSHolder getSECIOP_SEC_TRANS() {
        return this.transport_mech_SECIOPHolder;
    }

    private void setSAS_context_mech_holder(SAS_ContextSecHolder sAS_ContextSecHolder) {
        this.sas_context_mech_holder = sAS_ContextSecHolder;
    }

    private void setAS_context_mech_holder(AS_ContextSecHolder aS_ContextSecHolder) {
        this.as_context_mech_holder = aS_ContextSecHolder;
    }

    public static synchronized CSIv2TaggedComponent[] getCSIv2TaggedComponentList(Profile profile, IOR iOR) {
        String string = "CSIv2TaggedComponent.getCSIv2TaggedComponentList(profile)";
        Object var3_3 = null;
        byte[] byArray = profile.getTaggedComponent(33);
        if (byArray == null && iOR != null) {
            Profile profile2 = iOR.getProfile(0);
            if (profile == null && profile2 != null) {
                profile = profile2;
            }
            byArray = profile2.getTaggedComponent(33);
        }
        return CSIv2TaggedComponent.getCSIv2TaggedComponentList(byArray, profile);
    }

    public static synchronized CSIv2TaggedComponent[] getCSIv2TaggedComponentList(byte[] byArray, Profile profile) {
        CSIv2TaggedComponent[] cSIv2TaggedComponentArray;
        ByteArray byteArray;
        String string;
        String string2;
        block21: {
            string2 = "CSIv2TaggedComponent.getCSIv2TaggedComponentList(byte[])";
            string = null;
            CSIUtil cSIUtil = new CSIUtil();
            ORB oRB = VaultImpl.getInstance().getORB();
            Any any = null;
            byteArray = null;
            cSIv2TaggedComponentArray = null;
            try {
                if (byArray != null) {
                    byteArray = new ByteArray(byArray);
                    cSIv2TaggedComponentArray = (CSIv2TaggedComponent[])csiv2TagCache.get(byteArray);
                    if (cSIv2TaggedComponentArray != null) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "Returning existing CSIv2 tag list from the cache (size=" + csiv2TagCache.size() + ").";
                            SecurityLogger.debugMessage(string2, string);
                        }
                        return cSIv2TaggedComponentArray;
                    }
                    try {
                        any = cSIUtil.getCodec().decode_value(byArray, CompoundSecMechListHelper.type());
                    }
                    catch (MARSHAL mARSHAL) {
                        FFDCFilter.processException(mARSHAL, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "516");
                        SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
                    }
                    catch (BAD_OPERATION bAD_OPERATION) {
                        FFDCFilter.processException(bAD_OPERATION, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "521");
                        SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                    }
                    catch (FormatMismatch formatMismatch) {
                        FFDCFilter.processException(formatMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "526");
                        SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                    }
                    catch (TypeMismatch typeMismatch) {
                        FFDCFilter.processException(typeMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "531");
                        SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                    }
                    CompoundSecMechList compoundSecMechList = CompoundSecMechListHelper.extract(any);
                    if (compoundSecMechList.mechanism_list != null) {
                        CompoundSecMechHolder compoundSecMechHolder = new CompoundSecMechHolder();
                        cSIv2TaggedComponentArray = new CSIv2TaggedComponent[compoundSecMechList.mechanism_list.length];
                        if (SecurityLogger.debugTraceEnabled) {
                            string = compoundSecMechList.mechanism_list.length + " CompoundSecMechanism(s) in Tagged Component.";
                            SecurityLogger.debugMessage(string2, string);
                        }
                        for (int i = 0; i < compoundSecMechList.mechanism_list.length; ++i) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string = "*** READING CSIv2 TAG " + (i + 1) + " of " + compoundSecMechList.mechanism_list.length + " ***";
                                SecurityLogger.debugMessage(string2, string);
                            }
                            compoundSecMechHolder.value = compoundSecMechList.mechanism_list[i];
                            cSIv2TaggedComponentArray[i] = new CSIv2TaggedComponent(compoundSecMechHolder, compoundSecMechList.stateful, oRB, profile);
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "*** COMPLETED ADDING CSIv2 TAGS ***";
                            SecurityLogger.debugMessage(string2, string);
                        }
                    }
                    break block21;
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Tagged component is null.";
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "581");
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Java Exception getting CSIv2TaggedComponent.";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.logException(string2, exception, 0, 0);
                }
                return null;
            }
        }
        if (byteArray != null && cSIv2TaggedComponentArray != null) {
            if (csiv2TagCache.size() > 50) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Clearing CSIv2 Tag cache, larger than 50 objects.";
                    SecurityLogger.debugMessage(string2, string);
                }
                csiv2TagCache.clear();
            }
            csiv2TagCache.put(byteArray, cSIv2TaggedComponentArray);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Added CSIv2 tag to the cache (size=" + csiv2TagCache.size() + ").";
                SecurityLogger.debugMessage(string2, string);
            }
        }
        return cSIv2TaggedComponentArray;
    }

    public static final synchronized ComponentDataHolder getCSIv2ComponentData(CSIv2Configuration cSIv2Configuration, SecurityConnectionInterceptor securityConnectionInterceptor, String string, Profile profile) {
        String string2 = "CSIv2TaggedComponent.getCSIv2ComponentData";
        String string3 = null;
        try {
            int n;
            ORB oRB = VaultImpl.getInstance().getORB();
            VaultImpl.getInstance();
            SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
            Any any = null;
            CDROutputStream cDROutputStream = null;
            CSIUtil cSIUtil = new CSIUtil();
            String string4 = oRB.getProperty("com.ibm.CORBA.ServerName");
            String string5 = oRB.getProperty("com.ibm.CORBA.TransportMode");
            boolean bl = true;
            int n2 = 0;
            short s = 1;
            TransportAddress[] transportAddressArray = new TransportAddress[s];
            TLS_SEC_TRANS tLS_SEC_TRANS = null;
            TaggedComponent taggedComponent = null;
            AS_ContextSec aS_ContextSec = null;
            ServiceConfiguration[] serviceConfigurationArray = null;
            SAS_ContextSec sAS_ContextSec = null;
            CompoundSecMech compoundSecMech = null;
            CompoundSecMech[] compoundSecMechArray = null;
            boolean bl2 = true;
            CompoundSecMechList compoundSecMechList = null;
            n2 = !ConfigURLProperties.isServerSecurityEnabled() && !string4.equals("nodeagent") && !string4.equals("dmgr") && securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired() ? 1 : (securityConfiguration.getauthenticationTarget() == 6 ? 2 : (securityConfiguration.getauthenticationTarget() == 8 ? 2 : (securityConfiguration.getauthenticationTarget() == 1 ? 2 : 1)));
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                if (bl) {
                    if ((securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired() || securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSSupported()) && securityConfiguration.getCSIv2ClaimTLClientAuthenticationSupported() && !securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                        n2 *= 2;
                    }
                } else if (secureChainList != null && secureChainList.size() > 1) {
                    n = secureChainList.size();
                    n2 *= n;
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Setting configureList to " + n2;
                        SecurityLogger.debugMessage(string2, string3);
                    }
                }
            }
            compoundSecMechArray = new CompoundSecMech[n2];
            for (n = 0; n < n2; ++n) {
                short s2;
                String string6;
                Object object;
                Object object2;
                short s3;
                Object object3;
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "*** ADDING CSIv2 TAG " + (n + 1) + " of " + n2 + " ***";
                    SecurityLogger.debugMessage(string2, string3);
                }
                short s4 = 0;
                short s5 = 0;
                short s6 = 0;
                short s7 = 0;
                if (bl) {
                    if (securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired() || securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSSupported()) {
                        SSLServerConnectionData sSLServerConnectionData;
                        if (securityConfiguration.getCSIv2ClaimMessageIntegrityRequired()) {
                            s6 = (short)(s6 | 2);
                            s5 = (short)(s5 | 2);
                        }
                        if (securityConfiguration.getCSIv2ClaimMessageConfidentialityRequired()) {
                            s6 = (short)(s6 | 4);
                            s5 = (short)(s5 | 4);
                        }
                        if (securityConfiguration.getCSIv2ClaimMessageIntegritySupported()) {
                            s5 = (short)(s5 | 2);
                        }
                        if (securityConfiguration.getCSIv2ClaimMessageConfidentialitySupported()) {
                            s5 = (short)(s5 | 4);
                        }
                        s5 = (short)(s5 | 0x20);
                        if (securityConfiguration.getCSIv2ClaimTLClientAuthenticationSupported() && !securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                            if (n % 2 == 1 && !PlatformHelperFactory.getPlatformHelper().isZOS()) {
                                s6 = (short)(s6 | 0x40);
                                s5 = (short)(s5 | 0x40);
                                sSLServerConnectionData = securityConnectionInterceptor.getCSIClientCertRegisteredSSLServerConnectionDataObject();
                                if (sSLServerConnectionData != null) {
                                    s7 = (short)sSLServerConnectionData.getServerPort();
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                } else {
                                    s7 = (short)securityConfiguration.getCSIClientCertSSLPort();
                                    if (s7 == 0 && SecurityLogger.debugTraceEnabled) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                }
                            } else {
                                sSLServerConnectionData = securityConnectionInterceptor.getCSIRegisteredSSLServerConnectionDataObject();
                                if (sSLServerConnectionData != null) {
                                    s7 = (short)sSLServerConnectionData.getServerPort();
                                    if (s7 == 0) {
                                        try {
                                            object3 = oRB.getProperty("com.ibm.CSI.SSLPort");
                                            s7 = object3 == null ? (short)0 : Short.parseShort((String)object3);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                } else {
                                    s7 = (short)securityConfiguration.getCSISSLPort();
                                    if (s7 == 0) {
                                        try {
                                            object3 = oRB.getProperty("com.ibm.CSI.SSLPort");
                                            s7 = object3 == null ? (short)0 : Short.parseShort((String)object3);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                }
                            }
                        } else if (securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                            s6 = (short)(s6 | 0x40);
                            s5 = (short)(s5 | 0x40);
                            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                                sSLServerConnectionData = securityConnectionInterceptor.getCSIClientCertRegisteredSSLServerConnectionDataObject();
                                if (sSLServerConnectionData != null) {
                                    s7 = (short)sSLServerConnectionData.getServerPort();
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                } else {
                                    s7 = (short)securityConfiguration.getCSIClientCertSSLPort();
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                }
                            } else {
                                sSLServerConnectionData = securityConnectionInterceptor.getCSIRegisteredSSLServerConnectionDataObject();
                                if (sSLServerConnectionData != null) {
                                    s7 = (short)sSLServerConnectionData.getServerPort();
                                    if (s7 == 0) {
                                        try {
                                            object3 = oRB.getProperty("com.ibm.CSI.SSLPort");
                                            s7 = object3 == null ? (short)0 : Short.parseShort((String)object3);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                } else {
                                    s7 = (short)securityConfiguration.getCSISSLPort();
                                    if (s7 == 0) {
                                        try {
                                            object3 = oRB.getProperty("com.ibm.CSI.SSLPort");
                                            s7 = object3 == null ? (short)0 : Short.parseShort((String)object3);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                    }
                                    if (s7 == 0) {
                                        string3 = "security.JSAS0446E";
                                        SecurityLogger.logError(string3, new Object[]{string2});
                                    }
                                }
                            }
                        } else {
                            sSLServerConnectionData = securityConnectionInterceptor.getCSIRegisteredSSLServerConnectionDataObject();
                            if (sSLServerConnectionData != null) {
                                s7 = (short)sSLServerConnectionData.getServerPort();
                                if (s7 == 0) {
                                    try {
                                        object3 = oRB.getProperty("com.ibm.CSI.SSLPort");
                                        s7 = object3 == null ? (short)0 : Short.parseShort((String)object3);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (s7 == 0) {
                                    string3 = "security.JSAS0446E";
                                    SecurityLogger.logError(string3, new Object[]{string2});
                                }
                            } else {
                                s7 = (short)securityConfiguration.getCSISSLPort();
                                if (s7 == 0) {
                                    try {
                                        object3 = oRB.getProperty("com.ibm.CSI.SSLPort");
                                        s7 = object3 == null ? (short)0 : Short.parseShort((String)object3);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        // empty catch block
                                    }
                                }
                                if (s7 == 0 && SecurityLogger.debugTraceEnabled) {
                                    string3 = "security.JSAS0446E";
                                    SecurityLogger.logError(string3, new Object[]{string2});
                                }
                            }
                        }
                        if (securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = "Setting the TCP/IP port in the IOR profile to 0";
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            profile.setPort(0);
                        }
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Transport security target_requires for CSIv2: " + s6 + ". Transport security target_supports for CSIv2: " + s5;
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        for (short i = 0; i < s; ++i) {
                            transportAddressArray[i] = new TransportAddress(hostname, s7);
                            if (!SecurityLogger.debugTraceEnabled) continue;
                            string3 = "Configured hostname at transport layer for CSIv2: " + hostname + ". Configured port at transport layer for CSIv2: " + s7;
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        tLS_SEC_TRANS = new TLS_SEC_TRANS(s5, s6, transportAddressArray);
                        any = oRB.create_any();
                        TLS_SEC_TRANSHelper.insert(any, tLS_SEC_TRANS);
                        byte[] byArray = null;
                        try {
                            byArray = cSIUtil.getCodec().encode_value(any);
                        }
                        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                            FFDCFilter.processException(invalidTypeForEncoding, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "906");
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = "An InvalidTypeForEncoding exception occurred.";
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                        }
                        taggedComponent = new TaggedComponent(36, byArray);
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "SSL/TLS transport security mechanism exported for CSIv2.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                    } else {
                        taggedComponent = new TaggedComponent(34, new byte[0]);
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "No transport security mechanism exported for CSIv2.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                    }
                } else if (secureChainList != null && secureChainList.size() > 0) {
                    s3 = n / 2;
                    object3 = (Properties)secureChainList.get(s3);
                    String string7 = ((Properties)object3).getProperty("com.ibm.ssl.securityLevel");
                    if (string7 != null && string7.equalsIgnoreCase("high")) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Claim security level is HIGH for this transport tag.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        s6 = (short)(s6 | 2);
                        s5 = (short)(s5 | 2);
                        s6 = (short)(s6 | 4);
                        s5 = (short)(s5 | 4);
                        s5 = (short)(s5 | 0x20);
                    } else if (string7 != null && string7.equalsIgnoreCase("medium")) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Claim security level is MEDIUM for this transport tag.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        s6 = (short)(s6 | 2);
                        s5 = (short)(s5 | 2);
                        s5 = (short)(s5 | 4);
                        s5 = (short)(s5 | 0x20);
                    } else {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Claim security level is LOW for this transport tag.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        s5 = (short)(s5 | 2);
                        s5 = (short)(s5 | 4);
                        s5 = (short)(s5 | 0x20);
                    }
                    object2 = ((Properties)object3).getProperty("com.ibm.ssl.clientAuthentication");
                    object = ((Properties)object3).getProperty("com.ibm.ssl.clientAuthenticationSupported");
                    if (object2 != null && ((String)object2).equals("true")) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Claim client authentication is required for this transport tag.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        s6 = (short)(s6 | 0x40);
                        s5 = (short)(s5 | 0x40);
                    } else if (object != null && ((String)object).equals("true")) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Claim client authentication is supported for this transport tag.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        s5 = (short)(s5 | 0x40);
                    } else if (SecurityLogger.debugTraceEnabled) {
                        string3 = "Claim client authentication is disabled for this transport tag.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    string6 = ((Properties)object3).getProperty("com.ibm.CSI.SSLPort");
                    s7 = new Short(string6);
                    for (s2 = 0; s2 < s; ++s2) {
                        transportAddressArray[s2] = new TransportAddress(hostname, s7);
                        if (!SecurityLogger.debugTraceEnabled) continue;
                        string3 = "Configured hostname at transport layer for CSIv2: " + hostname + ". Configured port at transport layer for CSIv2: " + s7;
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    tLS_SEC_TRANS = new TLS_SEC_TRANS(s5, s6, transportAddressArray);
                    any = oRB.create_any();
                    TLS_SEC_TRANSHelper.insert(any, tLS_SEC_TRANS);
                    byte[] byArray = null;
                    try {
                        byArray = cSIUtil.getCodec().encode_value(any);
                    }
                    catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                        FFDCFilter.processException(invalidTypeForEncoding, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "906");
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "An InvalidTypeForEncoding exception occurred.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                    }
                    taggedComponent = new TaggedComponent(36, byArray);
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "SSL/TLS transport security mechanism exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                } else {
                    taggedComponent = new TaggedComponent(34, new byte[0]);
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "No transport security mechanism exported for CSIv2.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                }
                s3 = 0;
                object3 = null;
                short s8 = 0;
                object2 = null;
                object = null;
                string6 = null;
                if (!ConfigURLProperties.isServerSecurityEnabled() && !string4.equals("nodeagent") && !string4.equals("dmgr") && securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                    aS_ContextSec = new AS_ContextSec(0, 0, new byte[0], new byte[0]);
                } else {
                    if (securityConfiguration.getCSIv2ClaimClientAuthenticationRequired()) {
                        s3 = 64;
                        s8 = 64;
                    }
                    if (securityConfiguration.getauthenticationTarget() == 7) {
                        object3 = new GSSFactory("oid:2.23.130.1.1.1");
                    } else if (n2 == 4 && (n == 2 || n == 3) || n2 == 2 && n == 1) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "GSSUP authentication mechanism exported.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        object3 = new GSSFactory("oid:2.23.130.1.1.1");
                    } else if (securityConfiguration.getauthenticationTarget() == 6) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Kerberos authentication mechanism exported.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        object3 = new GSSFactory("oid:1.2.840.113554.1.2.2");
                    } else if (securityConfiguration.getauthenticationTarget() == 8) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "Custom authentication mechanism exported.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        object3 = new GSSFactory(securityConfiguration.getWSSecurityContextCustomOID());
                    } else if (securityConfiguration.getauthenticationTarget() == 1) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "LTPA authentication mechanism exported.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        object3 = new GSSFactory("oid:1.3.18.0.2.30.2");
                    } else {
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "GSSUP authentication mechanism exported.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        object3 = new GSSFactory("oid:2.23.130.1.1.1");
                    }
                    if (securityConfiguration.getCSIv2ClaimClientAuthenticationSupported()) {
                        s8 = 64;
                    }
                    if (securityConfiguration.getCSIv2ClaimClientAuthenticationSupported() || securityConfiguration.getCSIv2ClaimClientAuthenticationRequired()) {
                        object2 = ((GSSFactory)object3).getOID().getDER();
                        string6 = "oid:1.2.840.113554.1.2.2".endsWith(securityConfiguration.getWSSecurityContextActiveOID()) ? securityConfiguration.getprincipalName() : RealmSecurityName.getRealm(securityConfiguration.getprincipalName());
                        if (string6 == null || string6.length() == 0) {
                            string6 = securityConfiguration.getRealmName();
                        }
                        if ((object = (Object)((GSSFactory)object3).encodeExportedTargetName(string6)) == null) {
                            object = new byte[0];
                        }
                        aS_ContextSec = new AS_ContextSec(s8, s3, (byte[])object2, (byte[])object);
                    }
                    if (aS_ContextSec == null) {
                        aS_ContextSec = new AS_ContextSec(0, 0, new byte[0], new byte[0]);
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        if (s8 != 0) {
                            if (string6 != null && string6.length() != 0) {
                                string3 = "Exported target name object: " + string6;
                                SecurityLogger.debugMessage(string2, string3);
                            } else {
                                string3 = "No exported target name object exported for CSIv2.";
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            string3 = "Client auth target_requires for CSIv2: " + s3 + ". Client auth target_supports for CSIv2: " + s8;
                            SecurityLogger.debugMessage(string2, string3);
                        } else {
                            string3 = "No client auth security mechanism exported for CSIv2.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                    }
                }
                s2 = 0;
                short s9 = 0;
                boolean bl3 = false;
                byte[] byArray = null;
                serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(0, byArray)};
                Object var41_60 = null;
                byte[][] byArrayArray = new byte[][]{};
                int n3 = 0;
                if (!ConfigURLProperties.isServerSecurityEnabled() && !string4.equals("nodeagent") && !string4.equals("dmgr") && securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                    sAS_ContextSec = new SAS_ContextSec(0, 0, new ServiceConfiguration[0], new byte[0][], 0);
                } else {
                    if (securityConfiguration.getCSIv2ClaimIdentityAssertionSupported() || securityConfiguration.isRMIInboundPropagationEnabled()) {
                        if (securityConfiguration.getCSIv2ClaimIdentityAssertionSupported()) {
                            int n4 = 1;
                            byArrayArray = new byte[n4][];
                            byArrayArray[0] = ((GSSFactory)object3).getOID().getDER();
                            n3 = 15;
                            s2 = (short)(s2 | 0x400);
                        }
                        if (securityConfiguration.isRMIInboundPropagationEnabled()) {
                            cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
                            cDROutputStream.write_string(RealmSecurityName.getRealm(securityConfiguration.getprincipalName()));
                            byArray = cDROutputStream.toByteArray();
                            serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(1229066446, byArray)};
                        } else {
                            cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
                            cDROutputStream.write_string("");
                            byArray = cDROutputStream.toByteArray();
                            serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(0, byArray)};
                        }
                        sAS_ContextSec = new SAS_ContextSec(s2, s9, serviceConfigurationArray, byArrayArray, n3);
                    }
                    if (sAS_ContextSec == null) {
                        sAS_ContextSec = new SAS_ContextSec(0, 0, new ServiceConfiguration[0], new byte[0][], 0);
                    }
                    if (SecurityLogger.debugTraceEnabled) {
                        if ((s2 & 0x400) != 0) {
                            string3 = "Identity assertion exported for CSIv2.";
                            SecurityLogger.debugMessage(string2, string3);
                        } else {
                            string3 = "No identity assertion exported for CSIv2.";
                            SecurityLogger.debugMessage(string2, string3);
                        }
                    }
                }
                s4 = (short)(s6 | s3 | s9);
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "Base target_requires exported for CSIv2: " + s4;
                    SecurityLogger.debugMessage(string2, string3);
                }
                compoundSecMechArray[n] = compoundSecMech = new CompoundSecMech(s4, taggedComponent, aS_ContextSec, sAS_ContextSec);
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "*** COMPLETED ADDING CSIv2 TAGS ***";
                SecurityLogger.debugMessage(string2, string3);
            }
            compoundSecMechList = new CompoundSecMechList(securityConfiguration.getCSIv2ClaimStateful(), compoundSecMechArray);
            any = oRB.create_any();
            CompoundSecMechListHelper.insert(any, compoundSecMechList);
            byte[] byArray = null;
            try {
                byArray = cSIUtil.getCodec().encode_value(any);
            }
            catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                FFDCFilter.processException(invalidTypeForEncoding, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1164");
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "An InvalidTypeForEncoding exception occurred.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
            }
            ComponentDataHolder componentDataHolder = new ComponentDataHolder();
            componentDataHolder.value = new ComponentData(33, byArray);
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "CSI Tagged Component exported.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return componentDataHolder;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1190");
            SecurityLogger.logException(string2, exception, 0, 0);
            return null;
        }
    }

    public boolean isStateFul() {
        return this._stateful;
    }

    public AS_ContextSecHolder getAS_context_mech_holder() {
        return this.as_context_mech_holder;
    }

    public SAS_ContextSecHolder getSAS_context_mech_holder() {
        return this.sas_context_mech_holder;
    }

    public Profile getIORProfile() {
        return this.profile;
    }

    public static synchronized IOR changeSSLPortForWLM(IOR iOR, String string, short s, short s2) {
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return null;
        }
        String string2 = "CSIv2TaggedComponent.changeSSLPortForWLM";
        String string3 = null;
        byte[] byArray = null;
        CSIUtil cSIUtil = new CSIUtil();
        Object var8_8 = null;
        ORB oRB = VaultImpl.getInstance().getORB();
        Any any = null;
        Profile profile = null;
        try {
            if (iOR == null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "WLM Failover: IOR passed in is null.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                return null;
            }
            profile = iOR.getProfile(0);
            byArray = profile.getTaggedComponent(33);
            if (byArray != null) {
                Any any2;
                Object object;
                try {
                    any = cSIUtil.getCodec().decode_value(byArray, CompoundSecMechListHelper.type());
                }
                catch (MARSHAL mARSHAL) {
                    FFDCFilter.processException(mARSHAL, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1304");
                    SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
                }
                catch (BAD_OPERATION bAD_OPERATION) {
                    FFDCFilter.processException(bAD_OPERATION, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1309");
                    SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                }
                catch (FormatMismatch formatMismatch) {
                    FFDCFilter.processException(formatMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1314");
                    SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                }
                catch (TypeMismatch typeMismatch) {
                    FFDCFilter.processException(typeMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1319");
                    SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                }
                CompoundSecMechList compoundSecMechList = null;
                if (any != null) {
                    compoundSecMechList = CompoundSecMechListHelper.extract(any);
                }
                if (compoundSecMechList != null && compoundSecMechList.mechanism_list != null) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: " + compoundSecMechList.mechanism_list.length + " CompoundSecMechanism(s) in Tagged Component.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    for (int i = 0; i < compoundSecMechList.mechanism_list.length; ++i) {
                        object = compoundSecMechList.mechanism_list[i].transport_mech;
                        if (object == null || object.tag != 36) continue;
                        any2 = null;
                        try {
                            any2 = cSIUtil.getCodec().decode_value(object.component_data, TLS_SEC_TRANSHelper.type());
                        }
                        catch (MARSHAL mARSHAL) {
                            FFDCFilter.processException(mARSHAL, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "185");
                            SecurityLogger.logException(string2, (Exception)((Object)mARSHAL), 0, 0);
                        }
                        catch (BAD_OPERATION bAD_OPERATION) {
                            FFDCFilter.processException(bAD_OPERATION, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "190");
                            SecurityLogger.logException(string2, (Exception)((Object)bAD_OPERATION), 0, 0);
                        }
                        catch (FormatMismatch formatMismatch) {
                            FFDCFilter.processException(formatMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "195");
                            SecurityLogger.logException(string2, (Exception)((Object)formatMismatch), 0, 0);
                        }
                        catch (TypeMismatch typeMismatch) {
                            FFDCFilter.processException(typeMismatch, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "200");
                            SecurityLogger.logException(string2, (Exception)((Object)typeMismatch), 0, 0);
                        }
                        TLS_SEC_TRANSHolder tLS_SEC_TRANSHolder = new TLS_SEC_TRANSHolder(TLS_SEC_TRANSHelper.extract(any2));
                        if (SecurityLogger.debugTraceEnabled) {
                            string3 = "WLM Failover: CSI Security Transport values, transport layer: TLS, target requires = " + tLS_SEC_TRANSHolder.value.target_requires + " target supports = " + tLS_SEC_TRANSHolder.value.target_supports;
                            SecurityLogger.debugMessage(string2, string3);
                        }
                        if (tLS_SEC_TRANSHolder.value.addresses != null || tLS_SEC_TRANSHolder.value.addresses.length != 0) {
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = "WLM Failover: Old Host = " + tLS_SEC_TRANSHolder.value.addresses[0].host_name + ", New Host = " + string;
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            if ((tLS_SEC_TRANSHolder.value.target_requires & 0x40) != 0) {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string3 = "WLM Failover: ClientCert Req: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s2;
                                    SecurityLogger.debugMessage(string2, string3);
                                }
                                tLS_SEC_TRANSHolder.value.addresses[0].port = s2;
                                tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                            } else if ((tLS_SEC_TRANSHolder.value.target_supports & 0x40) != 0) {
                                if (i == 0) {
                                    if (SecurityLogger.debugTraceEnabled) {
                                        string3 = "WLM Failover: ClientCert Supt1: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s;
                                        SecurityLogger.debugMessage(string2, string3);
                                    }
                                    tLS_SEC_TRANSHolder.value.addresses[0].port = s;
                                    tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                                } else {
                                    if (SecurityLogger.debugTraceEnabled) {
                                        string3 = "WLM Failover: ClientCert Supt2: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s2;
                                        SecurityLogger.debugMessage(string2, string3);
                                    }
                                    tLS_SEC_TRANSHolder.value.addresses[0].port = s2;
                                    tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                                }
                            } else {
                                if (SecurityLogger.debugTraceEnabled) {
                                    string3 = "WLM Failover: ClientCert NotSupt: Old Port = " + tLS_SEC_TRANSHolder.value.addresses[0].port + ", New Port = " + s;
                                    SecurityLogger.debugMessage(string2, string3);
                                }
                                tLS_SEC_TRANSHolder.value.addresses[0].port = s;
                                tLS_SEC_TRANSHolder.value.addresses[0].host_name = string;
                            }
                        }
                        any2 = oRB.create_any();
                        TLS_SEC_TRANSHelper.insert(any2, tLS_SEC_TRANSHolder.value);
                        byte[] byArray2 = null;
                        try {
                            byArray2 = cSIUtil.getCodec().encode_value(any2);
                        }
                        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                            FFDCFilter.processException(invalidTypeForEncoding, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "906");
                            if (SecurityLogger.debugTraceEnabled) {
                                string3 = "An InvalidTypeForEncoding exception occurred.";
                                SecurityLogger.debugMessage(string2, string3);
                            }
                            SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                        }
                        compoundSecMechList.mechanism_list[i].transport_mech = new TaggedComponent(36, byArray2);
                    }
                } else {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: No CSIv2 CompoundSecMech structures in tagged component.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    return null;
                }
                any = oRB.create_any();
                try {
                    CompoundSecMechListHelper.insert(any, compoundSecMechList);
                }
                catch (SystemException systemException) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: Error inserting CSIv2 CompoundSecMech into Any.";
                        SecurityLogger.debugMessage(string2, string3);
                        SecurityLogger.logException(string2, (Exception)((Object)systemException), 0, 0);
                    }
                    return null;
                }
                byte[] byArray3 = null;
                try {
                    byArray3 = cSIUtil.getCodec().encode_value(any);
                }
                catch (InvalidTypeForEncoding invalidTypeForEncoding) {
                    FFDCFilter.processException(invalidTypeForEncoding, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1164");
                    if (SecurityLogger.debugTraceEnabled) {
                        string3 = "WLM Failover: An InvalidTypeForEncoding exception occurred.";
                        SecurityLogger.debugMessage(string2, string3);
                    }
                    SecurityLogger.logException(string2, (Exception)((Object)invalidTypeForEncoding), 0, 0);
                }
                object = new ComponentDataHolder();
                object.value = new ComponentData(33, byArray3);
                if (SecurityLogger.debugTraceEnabled) {
                    string3 = "WLM Failover: CSI Tagged Component exported.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                any2 = null;
                if (object.value != null) {
                    string3 = "WLM Failover: Adding tagged component ID: " + object.value.componentID;
                    SecurityLogger.debugMessage(string2, string3);
                    any2 = new TaggedComponent(object.value.componentID, object.value.componentBodyValue);
                } else if (SecurityLogger.debugTraceEnabled) {
                    string3 = "WLM Failover: No security tagged components applied to IOR during create.";
                    SecurityLogger.debugMessage(string2, string3);
                }
                if (any2 != null) {
                    profile.putTaggedComponent(33, any2.component_data);
                    iOR.putProfile(profile);
                    return iOR;
                }
                return null;
            }
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "WLM Failover: No CSIv2 tagged component exists in IOR.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return null;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "581");
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "WLM Failover: Java Exception getting CSIv2TaggedComponent.";
                SecurityLogger.debugMessage(string2, string3);
                SecurityLogger.logException(string2, exception, 0, 0);
            }
            return null;
        }
    }

    public static List getSecureChains() {
        block3: {
            String string = "CSIv2TaggedComponent.getSecureChains";
            String string2 = null;
            if (!secureChainListInitialized) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                    Method method2 = clazz.getMethod("getConfig", null);
                    Object object = method2.invoke(null, null);
                    Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                    Method method3 = clazz2.getMethod("getValue", String.class);
                    secureChainList = (List)method3.invoke(object, "iiop.secure.transports");
                    secureChainListInitialized = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getSecureChains", "2018");
                    if (!SecurityLogger.debugTraceEnabled) break block3;
                    string2 = "Exception getting the secure chains from the channel framework configuration.  The error message is: " + exception.getMessage();
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.logException(string, exception, 0, 0);
                }
            }
        }
        return secureChainList;
    }

    public static List getInsecureChains() {
        block3: {
            String string = "CSIv2TaggedComponent.getInsecureChains";
            String string2 = null;
            if (!insecureChainListInitialized) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                    Method method2 = clazz.getMethod("getConfig", null);
                    Object object = method2.invoke(null, null);
                    Class<?> clazz2 = Class.forName("com.ibm.ws.security.core.SecurityConfig");
                    Method method3 = clazz2.getMethod("getValue", String.class);
                    insecureChainList = (List)method3.invoke(object, "iiop.insecure.transports");
                    insecureChainListInitialized = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getInsecureChains", "2187");
                    if (!SecurityLogger.debugTraceEnabled) break block3;
                    string2 = "Exception getting the insecure chains from the channel framework configuration.  The error message is: " + exception.getMessage();
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.logException(string, exception, 0, 0);
                }
            }
        }
        return insecureChainList;
    }

    private static String getHostName() {
        String string;
        String string2 = "CSIv2TaggedComponent.getHostName";
        if (!ConfigURLProperties.isSecurityEnabled()) {
            return null;
        }
        try {
            string = VaultImpl.getInstance().getORB().getLocalHost();
            if (SecurityLogger.debugTraceEnabled) {
                SecurityLogger.debugMessage(string2, "Transport host name = " + string);
            }
            if (PlatformHelperFactory.getPlatformHelper().isZOS() && string != null) {
                return string;
            }
            try {
                final String string3 = string;
                string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        InetAddress inetAddress = InetAddress.getByName(string3);
                        return inetAddress.getHostAddress();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getHostName", "2237");
                string = "localhost";
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getHostName", "2244");
            if (SecurityLogger.debugTraceEnabled) {
                String string4 = "Exception getting hostname for transport address.";
                SecurityLogger.debugMessage(string2, string4);
            }
            SecurityLogger.logException(string2, exception, 0, 0);
            string = null;
        }
        if (string == null || string.length() == 0) {
            string = "localHost";
        }
        return string;
    }
}

