/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.IExtendedSecurityPriv.Current;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ServerConnectionKey;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionManager;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.Subject;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.SecurityLevel2.Credentials;

public class VaultImpl {
    private static Vector _vaultRegistry = new Vector();
    protected static int _authenticationTarget = 0;
    protected static String _authenticationTargetString = "unknown";
    private Hashtable effectivePolicyTable = new Hashtable();
    private CurrentImpl _current = null;
    private MechanismFactory _mechanismFactory = null;
    private ORB _orb = null;
    private static SecurityConfiguration _securityConfiguration = null;
    protected static VaultImpl _vault = null;
    private SecurityConnectionInterceptor securityConnectionInterceptor = null;
    private SessionManager sessionManager = null;
    private Hashtable gssFactoryTable = new Hashtable();
    private static AuthenticationTarget authTarget = null;
    private Codec codec = null;
    private SecurityServer securityServer = null;
    private Subject _defaultSubject = null;
    protected Hashtable basicAuthTable = new Hashtable();
    protected Hashtable basicAuthSubjectTable = new Hashtable();
    protected Hashtable basicAuthRealmHostSubjectTable = new Hashtable();

    public static VaultImpl getInstance() {
        Object object;
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && _vault == null && (object = GlobalORBFactory.globalORB()) != null) {
            _vault = new ZOSVaultImpl((ORB)object);
        }
        if (_vault == null) {
            object = "security.JSAS0010E";
            String string = "VaultImpl.getInstance";
            SecurityLogger.logError((String)object, new Object[]{string, "Init error."});
            throw new INITIALIZE();
        }
        return _vault;
    }

    protected VaultImpl(MechanismFactory mechanismFactory, SecurityConfiguration securityConfiguration, ORB oRB) {
        try {
            this._mechanismFactory = mechanismFactory;
            _securityConfiguration = securityConfiguration;
            if (oRB != null) {
                this._orb = oRB;
            }
            _vaultRegistry.addElement(this);
            _vault = this;
            this.sessionManager = new SessionManager();
            _authenticationTarget = _securityConfiguration.getauthenticationTarget();
            _authenticationTargetString = (String)AuthenticationTarget.strings.get(new Integer(_authenticationTarget));
            VaultImpl vaultImpl = this;
        }
        catch (Exception exception) {
            String string = "security.JSAS0010E";
            String string2 = "VaultImpl.constructor";
            SecurityLogger.logError(string, new Object[]{string2, exception.getMessage()});
            throw new INITIALIZE();
        }
    }

    protected VaultImpl() {
    }

    public Credentials getBasicAuthCred(String string) {
        String string2 = "VaultImpl.getBasicAuthCred";
        String string3 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "get BasicAuth Cred from cache, security name is " + string;
            SecurityLogger.debugMessage(string2, string3);
        }
        return (Credentials)this.basicAuthTable.get(string);
    }

    public void addBasicAuthCred(String string, Credentials credentials) {
        String string2 = "VaultImpl.addBasicAuthCred";
        String string3 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "cacheing BasicAuth Cred to the table, security name is " + string;
            SecurityLogger.debugMessage(string2, string3);
        }
        this.basicAuthTable.put(string, credentials);
    }

    public Subject getBasicAuthSubject(String string) {
        String string2 = "VaultImpl.getWSBasicAuthCred";
        String string3 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "get BasicAuth WSCredential from cache, security name is " + string;
            SecurityLogger.debugMessage(string2, string3);
        }
        return (Subject)this.basicAuthSubjectTable.get(string);
    }

    public void addBasicAuthSubject(String string, Subject subject) {
        String string2 = "VaultImpl.addBasicAuthCred";
        String string3 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "caching BasicAuth WSCredential to the table, security name is " + string;
            SecurityLogger.debugMessage(string2, string3);
        }
        this.basicAuthSubjectTable.put(string, subject);
    }

    public Subject getRealmHostSubject(String string) {
        String string2 = "VaultImpl.getRealmHostSubject";
        String string3 = null;
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "get BasicAuth WSCredential from cache, realm/host lookup key is " + string;
            SecurityLogger.debugMessage(string2, string3);
        }
        return (Subject)this.basicAuthRealmHostSubjectTable.get(string);
    }

    public void addRealmHostSubject(String string, Subject subject) {
        String string2 = "VaultImpl.addRealmHostSubject";
        String string3 = null;
        if (this.basicAuthRealmHostSubjectTable.get(string) != null) {
            return;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Caching BasicAuth WSCredential to the table, realm/host lookup is " + string;
            SecurityLogger.debugMessage(string2, string3);
        }
        if (SecurityLogger.debugTraceEnabled) {
            string3 = "Realm/host BasicAuth cache size: " + this.basicAuthRealmHostSubjectTable.size();
            SecurityLogger.debugMessage(string2, string3);
        }
        this.basicAuthRealmHostSubjectTable.put(string, subject);
    }

    public Current current() {
        return (Current)((Object)this.getCurrent());
    }

    public synchronized void deleteSessionsForConnection(String string) {
        String string2 = "VaultImpl.deleteSessionsForConnection";
        Object var3_3 = null;
        if (string == null) {
            return;
        }
        this.sessionManager.csi_delete_client_connection(string);
    }

    public void deleteSessionsForConnection(ServerConnectionKey serverConnectionKey) {
        String string = "VaultImpl.deleteSessionsForConnection";
        Object var3_3 = null;
        if (serverConnectionKey == null) {
            return;
        }
        this.sessionManager.csi_delete_server_connection(serverConnectionKey.get_server_connection_hash());
    }

    public void set_default_subject(Subject subject) {
        String string = "VaultImpl.set_default_subject";
        String string2 = null;
        if (ContextManagerFactory.getInstance().processIsServer() || !_securityConfiguration.useDefaultSubjectForThreads()) {
            return;
        }
        if (subject == null) {
            return;
        }
        if (this._defaultSubject == null) {
            this._defaultSubject = subject;
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Setting the default subject: " + this._defaultSubject;
                SecurityLogger.debugMessage(string, string2);
            }
        }
    }

    public Subject get_default_subject() {
        String string = "VaultImpl.get_default_subject";
        String string2 = null;
        Object var3_3 = null;
        if (ContextManagerFactory.getInstance().processIsServer() || !_securityConfiguration.useDefaultSubjectForThreads()) {
            return null;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "Getting the default subject: " + this._defaultSubject;
            SecurityLogger.debugMessage(string, string2);
        }
        return this._defaultSubject;
    }

    public MechanismFactory getMechanismFactory() {
        return this._mechanismFactory;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setMechanismFactory(MechanismFactory mechanismFactory) {
        if (mechanismFactory != null) {
            this._mechanismFactory = mechanismFactory;
        }
    }

    public ORB getORB() {
        return this._orb;
    }

    public void setORB(ORB oRB) {
        if (oRB != null) {
            this._orb = oRB;
        }
    }

    public static SecurityConfiguration getSecurityConfiguration() {
        if (_securityConfiguration == null && PlatformHelperFactory.getPlatformHelper().isZOS()) {
            ConfigURLProperties configURLProperties = ConfigURLProperties.getInstance();
            ORB oRB = GlobalORBFactory.globalORB();
            final class ZOSSecurityConfiguration
            extends SecurityConfiguration {
                ZOSSecurityConfiguration(org.omg.CORBA.ORB oRB, ConfigURLProperties configURLProperties) {
                    super(oRB, configURLProperties);
                }
            }
            _securityConfiguration = new ZOSSecurityConfiguration((org.omg.CORBA.ORB)oRB, configURLProperties);
        }
        return _securityConfiguration;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        if (securityConfiguration != null) {
            _securityConfiguration = securityConfiguration;
        }
    }

    public SecurityServer getSecurityServer() throws Exception {
        String string = "";
        String string2 = "VaultImpl.getSecurityServer";
        if (this.securityServer == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.WebSphereSecurityImpl.SecurityServerImpl");
                Object obj = clazz.newInstance();
                this.securityServer = (SecurityServer)obj;
                if (this.securityServer != null && SecurityLogger.debugTraceEnabled) {
                    string = "Security Server is initialized.";
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.getSecurityServer", "733", this);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Security Server cannot be initialized.";
                    SecurityLogger.debugMessage(string2, string);
                }
                SecurityLogger.logException(string2, exception, 0, 0);
                throw exception;
            }
        }
        return this.securityServer;
    }

    public GSSFactory getGSSFactory(String string) {
        GSSFactory gSSFactory = null;
        gSSFactory = (GSSFactory)this.gssFactoryTable.get(string);
        if (gSSFactory == null) {
            gSSFactory = new GSSFactory(string);
            this.gssFactoryTable.put(string, gSSFactory);
        }
        return gSSFactory;
    }

    public Codec getCodec() {
        String string = "";
        String string2 = "VaultImpl.getCodec";
        if (this.codec == null) {
            CodecFactory codecFactory = null;
            try {
                codecFactory = (CodecFactory)this._orb.resolve_initial_references("CodecFactory");
            }
            catch (InvalidName invalidName) {
                FFDCFilter.processException((Throwable)invalidName, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.getCodec", "785", this);
                SecurityLogger.logException(string2, (Exception)((Object)invalidName), 0, 0);
            }
            Encoding encoding = new Encoding(0, 1, 2);
            try {
                this.codec = codecFactory.create_codec(encoding);
            }
            catch (UnknownEncoding unknownEncoding) {
                FFDCFilter.processException((Throwable)unknownEncoding, "com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl.getCodec", "797", this);
                SecurityLogger.logException(string2, (Exception)((Object)unknownEncoding), 0, 0);
            }
        }
        return this.codec;
    }

    public CurrentImpl getCurrent() {
        String string = "VaultImpl.getCurrent";
        Object var2_2 = null;
        if (this._current == null) {
            this._current = new CurrentImpl(this._orb, this, this._mechanismFactory, _securityConfiguration);
        }
        return this._current;
    }

    public static synchronized AuthenticationTarget getAuthenticationTarget() {
        if (authTarget == null) {
            authTarget = new AuthenticationTarget();
        }
        return authTarget;
    }

    public SecurityConnectionInterceptor getSecurityConnectionInterceptor() {
        return this.securityConnectionInterceptor;
    }

    public void setSecurityConnectionInterceptor(SecurityConnectionInterceptor securityConnectionInterceptor) {
        if (securityConnectionInterceptor != null) {
            this.securityConnectionInterceptor = securityConnectionInterceptor;
        }
    }

    protected boolean put_effective_policy(int n, CSIv2EffectivePerformPolicy cSIv2EffectivePerformPolicy) {
        if (cSIv2EffectivePerformPolicy == null) {
            return false;
        }
        this.effectivePolicyTable.put(Integer.toString(n), cSIv2EffectivePerformPolicy);
        return true;
    }

    public CSIv2EffectivePerformPolicy get_effective_policy(int n) {
        return (CSIv2EffectivePerformPolicy)this.effectivePolicyTable.get(Integer.toString(n));
    }

    protected boolean clear_effective_policy(int n) {
        this.effectivePolicyTable.remove(Integer.toString(n));
        return true;
    }

    protected static final class ZOSVaultImpl
    extends VaultImpl {
        private static final long serialVersionUID = -5857883218773800603L;

        protected ZOSVaultImpl(ORB oRB) {
            SecurityConfiguration securityConfiguration = VaultImpl.getSecurityConfiguration();
            this.setMechanismFactory(new MechanismFactory(securityConfiguration));
            this.setORB(oRB);
            _vault = this;
            _authenticationTarget = _securityConfiguration.getauthenticationTarget();
            _authenticationTargetString = (String)AuthenticationTarget.strings.get(new Integer(_authenticationTarget));
        }
    }
}

