/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.IExtendedSecurityPriv.ObjectDoesNotExistHere;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import org.omg.CORBA.SystemException;

public final class SSLTaggedComponent
extends SecurityTaggedComponent {
    private int _SSLPort = 0;

    public int get_SSLPort() {
        return this._SSLPort;
    }

    private SSLTaggedComponent(byte[] byArray) {
        String string = "SSLTaggedComponent.SSLTaggedComponent";
        String string2 = null;
        try {
            CDRInputStream cDRInputStream = ORB.createCDRInputStream(null, (byte[])byArray, (int)byArray.length);
            cDRInputStream.consumeEndian();
            this.set_targetCoalescedSuppQOP(cDRInputStream.read_short());
            this.set_targetCoalescedReqQOP(cDRInputStream.read_short());
            this._SSLPort = cDRInputStream.read_short();
            this.set_tagID(20);
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "SSL Tag values: sslPort =  " + this._SSLPort + ", target requires  = " + this._targetCoalescedReqQOP + ", target supports = " + this._targetCoalescedSuppQOP;
                SecurityLogger.debugMessage(string, string2);
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, "com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent.SSLTaggedComponent", "112", this);
            string2 = "security.JSAS0449E";
            SecurityLogger.logError(string2, new Object[]{string, systemException});
        }
    }

    public static synchronized SSLTaggedComponent getSSLTaggedComponent(Profile profile, IOR iOR) {
        byte[] byArray = null;
        SSLTaggedComponent sSLTaggedComponent = null;
        try {
            byArray = profile.getTaggedComponent(20);
            if (iOR != null && byArray == null) {
                Profile profile2 = iOR.getProfile(0);
                byArray = profile2.getTaggedComponent(20);
            }
            if (byArray != null) {
                sSLTaggedComponent = new SSLTaggedComponent(byArray);
            }
            return sSLTaggedComponent;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent.getSSLTaggedComponent", "160");
            return null;
        }
    }

    public static final ComponentDataHolder getSSLComponentData(SecurityConfiguration securityConfiguration, SecurityConnectionInterceptor securityConnectionInterceptor) throws ObjectDoesNotExistHere {
        String string = "SSLTaggedComponent.getSSLComponentData";
        String string2 = null;
        try {
            boolean bl = true;
            short s = 0;
            if (securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSSupported() || securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                s = 32;
                s = (short)(s + 8);
                s = (short)(s + 16);
                if (securityConfiguration.getCSIv2ClaimTLClientAuthenticationSupported()) {
                    s = (short)(s + 64);
                }
                if (securityConfiguration.getCSIv2ClaimMessageIntegritySupported()) {
                    s = (short)(s + 2);
                }
                if (securityConfiguration.getCSIv2ClaimMessageConfidentialitySupported()) {
                    s = (short)(s + 4);
                }
            } else {
                s = 1;
            }
            short s2 = 0;
            if (securityConfiguration.getCSIv2ClaimTransportAssocSSLTLSRequired()) {
                s2 = 16384;
                s = (short)(s + 32);
                s = (short)(s + 8);
                s = (short)(s + 16);
                if (securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired()) {
                    s2 = (short)(s2 + 64);
                }
                if (securityConfiguration.getCSIv2ClaimMessageIntegrityRequired()) {
                    s2 = (short)(s2 + 2);
                }
                if (securityConfiguration.getCSIv2ClaimMessageConfidentialityRequired()) {
                    s2 = (short)(s2 + 4);
                }
            } else {
                s2 = 1;
            }
            int n = 0;
            SSLServerConnectionData sSLServerConnectionData = null;
            sSLServerConnectionData = securityConfiguration.getCSIv2ClaimTLClientAuthenticationRequired() || securityConfiguration.getCSIv2ClaimTLClientAuthenticationSupported() ? securityConnectionInterceptor.getCSIClientCertRegisteredSSLServerConnectionDataObject() : securityConnectionInterceptor.getCSIRegisteredSSLServerConnectionDataObject();
            if (sSLServerConnectionData != null) {
                n = sSLServerConnectionData.getServerPort();
                if (n == 0) {
                    string2 = "security.JSAS0446E";
                    SecurityLogger.logError(string2, new Object[]{string});
                }
            } else {
                n = securityConfiguration.getSSLPort();
            }
            ComponentDataHolder componentDataHolder = new ComponentDataHolder();
            CDROutputStream cDROutputStream = ORB.createCDROutputStream(null);
            cDROutputStream.putEndian();
            cDROutputStream.write_short(s);
            cDROutputStream.write_short(s2);
            cDROutputStream.write_short((short)n);
            byte[] byArray = cDROutputStream.toByteArray();
            componentDataHolder.value = new ComponentData(20, byArray);
            return componentDataHolder;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent.getSSLComponentData", "302");
            return null;
        }
    }
}

