/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityL13SupportImpl;

import com.ibm.ISecurityL13SupportImpl.BasePanel;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class LoginPanel
extends BasePanel
implements FocusListener,
ComponentListener,
Runnable {
    private static final long serialVersionUID = -1247185376229621879L;
    JPanel TopPanel = null;
    JPanel BottomPanel = null;
    JPanel EntryFieldPanel = null;
    JLabel mainlabel = null;
    JLabel id_label = null;
    JLabel cell_label = null;
    JLabel pwd_label = null;
    JTextField id_field = null;
    JTextField cell_field = null;
    JPasswordField pwd_field = null;
    int textfield_length = 15;
    JButton OKButton = null;
    JButton CancelButton = null;
    private boolean firstTimeFocus = true;

    public LoginPanel(String string, String string2, String string3, JFrame jFrame) {
        this(string, string2, string3, 60, jFrame);
    }

    public LoginPanel(String string, String string2, String string3, int n, JFrame jFrame) {
        super(SecurityMessages.getMsgOrUseDefault("LoginPanelTitle", "Login at the Target Server"), string, string2, string3, n, jFrame);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            if (actionEvent.getSource() == this.OKButton) {
                this.ok_pressed(this.id_field.getText(), this.cell_field.getText(), this.pwd_field.getText());
            } else if (actionEvent.getSource() == this.CancelButton) {
                this.cancel_pressed();
            }
        }
    }

    private void cancel_pressed() {
        String string = "LoginPanel.cancel_pressed";
        String string2 = null;
        this.selectionMade = 3;
        if (SecurityLogger.debugTraceEnabled) {
            string2 = "cancel pressed";
            SecurityLogger.debugMessage(string, string2);
        }
        super.setVisible(false);
        this.dispose();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (this.firstTimeFocus && this.cell_field != null) {
            if (this.cell_field.getText().trim().length() == 0) {
                this.cell_field.requestFocus();
            } else if (this.id_field.getText().trim().length() == 0) {
                this.id_field.requestFocus();
            } else if (this.pwd_field.getText().trim().length() == 0) {
                this.pwd_field.requestFocus();
            } else {
                this.OKButton.requestFocus();
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.firstTimeFocus && this.cell_field != null) {
            if (this.cell_field.getText().trim().length() == 0) {
                this.cell_field.requestFocus();
            } else if (this.id_field.getText().trim().length() == 0) {
                this.id_field.requestFocus();
            } else if (this.pwd_field.getText().trim().length() == 0) {
                this.pwd_field.requestFocus();
            } else {
                this.OKButton.requestFocus();
            }
        }
    }

    protected void createWindow() {
        this.TopPanel = new JPanel();
        this.BottomPanel = new JPanel();
        this.EntryFieldPanel = new JPanel();
        this.mainlabel = this.defaultCellName == null || this.defaultCellName.trim().length() == 0 ? new JLabel(SecurityMessages.getMsgOrUseDefault("GenericLoginPrompt", "Enter login information")) : new JLabel(SecurityMessages.getMsgOrUseDefault("LoginPromptForRealm", "Enter login information for") + " " + this.defaultCellName);
        this.cell_label = new JLabel(SecurityMessages.getMsgOrUseDefault("RealmName", "Realm/Cell Name"), 0);
        this.id_label = new JLabel(SecurityMessages.getMsgOrUseDefault("UserID", "User Identity"), 0);
        this.pwd_label = new JLabel(SecurityMessages.getMsgOrUseDefault("Password", "User Password"), 0);
        if (this.defaultUserID != null) {
            this.id_field = new JTextField(this.defaultUserID);
            this.id_field.setColumns(this.defaultUserID.length() / 2 + 1);
        } else {
            this.id_field = new JTextField();
        }
        if (this.defaultCellName != null) {
            this.cell_field = new JTextField(this.defaultCellName);
            this.cell_field.setColumns(this.defaultCellName.length() / 2 + 1);
            this.cell_field.setEnabled(false);
        } else {
            this.cell_field = new JTextField();
        }
        if (this.defaultPassword != null) {
            this.pwd_field = new JPasswordField(this.defaultPassword);
            this.pwd_field.setColumns(this.defaultPassword.length() / 2 + 1);
        } else {
            this.pwd_field = new JPasswordField();
        }
        this.pwd_field.setEchoChar('*');
        this.cell_field.addFocusListener(this);
        this.id_field.addFocusListener(this);
        this.pwd_field.addFocusListener(this);
        this.OKButton = new JButton(SecurityMessages.getMsgOrUseDefault("OK", "OK"));
        this.CancelButton = new JButton(SecurityMessages.getMsgOrUseDefault("Cancel", "Cancel"));
        this.TopPanel.setLayout(new FlowLayout(1));
        this.TopPanel.add(this.mainlabel);
        this.EntryFieldPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.cell_label, gridBagConstraints);
        this.EntryFieldPanel.add(this.cell_label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.id_label, gridBagConstraints);
        this.EntryFieldPanel.add(this.id_label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.pwd_label, gridBagConstraints);
        this.EntryFieldPanel.add(this.pwd_label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.cell_field, gridBagConstraints);
        this.EntryFieldPanel.add(this.cell_field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.id_field, gridBagConstraints);
        this.EntryFieldPanel.add(this.id_field);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)this.EntryFieldPanel.getLayout()).setConstraints(this.pwd_field, gridBagConstraints);
        this.EntryFieldPanel.add(this.pwd_field);
        this.BottomPanel.setLayout(new FlowLayout(1));
        this.BottomPanel.add(this.OKButton);
        this.BottomPanel.add(this.CancelButton);
        this.getContentPane().add("North", this.TopPanel);
        this.getContentPane().add("Center", this.EntryFieldPanel);
        this.getContentPane().add("South", this.BottomPanel);
        this.OKButton.addActionListener(this);
        this.CancelButton.addActionListener(this);
        this.OKButton.addKeyListener(this);
        this.CancelButton.addKeyListener(this);
        this.id_field.addKeyListener(this);
        this.cell_field.addKeyListener(this);
        this.pwd_field.addKeyListener(this);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.firstTimeFocus = true;
        this.inputThread = new Thread(this);
        this.inputThread.setDaemon(true);
        this.inputThread.start();
        super.createWindow();
    }

    public boolean done() {
        return !this.isVisible();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.firstTimeFocus && this.cell_field != null) {
            if (this.cell_field.getText().trim().length() == 0 && this.cell_field.isEnabled()) {
                this.cell_field.requestFocus();
            } else if (this.id_field.getText().trim().length() == 0) {
                this.id_field.requestFocus();
            } else if (this.pwd_field.getText().trim().length() == 0) {
                this.pwd_field.requestFocus();
            } else {
                this.OKButton.requestFocus();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public String getCell() {
        return this.cellstr;
    }

    public String getId() {
        return this.idstr;
    }

    public String getPassword() {
        return this.pwdstr;
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (keyEvent.getSource() instanceof Button && keyEvent.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, null));
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 27) {
            this.actionPerformed(new ActionEvent(this.CancelButton, 1001, null));
            keyEvent.consume();
        } else if (keyEvent.getKeyCode() == 10) {
            if (this.id_field.getText().length() > 0) {
                this.ok_pressed(this.id_field.getText(), this.cell_field.getText(), this.pwd_field.getText());
            } else {
                this.cancel_pressed();
            }
            keyEvent.consume();
        }
        this.firstTimeFocus = false;
    }

    private void ok_pressed(String string, String string2, String string3) {
        this.idstr = string != null && string.length() > 0 ? string : null;
        this.cellstr = string2 != null && string2.length() > 0 ? string2 : null;
        this.pwdstr = string3 != null && string3.length() > 0 ? string3 : null;
        this.selectionMade = 2;
        this.requestFocus();
        this.hide();
        this.setVisible(false);
        this.dispose();
    }

    public String ret_cellstr() {
        return this.cellstr;
    }

    public String ret_idstr() {
        return this.idstr;
    }

    public String ret_pwdstr() {
        return this.pwdstr;
    }

    public void run() {
        block5: {
            try {
                int n = 5000;
                for (int i = 0; i < this.timeout; i += n) {
                    Thread.sleep(n);
                    if (this.selectionMade != 0) {
                        return;
                    }
                    if ((this.id_field.hasFocus() || this.pwd_field.hasFocus()) && !this.firstTimeFocus) continue;
                    super.setVisible(true);
                    this.requestFocus();
                    this.firstTimeFocus = false;
                }
                if (this.selectionMade == 0) {
                    this.selectionMade = 1;
                    this.setVisible(false);
                    this.dispose();
                }
            }
            catch (InterruptedException interruptedException) {
                String string = "LoginPanel.run";
                String string2 = "Interrupted while sleeping.";
                SecurityLogger.debugMessage(string, string2);
                if (!SecurityLogger.traceEnabled) break block5;
                SecurityLogger.traceException(string, interruptedException, 0, 0);
            }
        }
        this.setVisible(false);
    }
}

