/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.ObjectIdentifier;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class PolicyNodeImpl
implements PolicyNode {
    private ObjectIdentifier validPolicy;
    private Set qualifiers;
    private boolean criticality;
    private Set expectedPolicySet;
    private PolicyNode parent;
    private Set children;
    private int depth;

    PolicyNodeImpl(ObjectIdentifier policyOID, Set qualifierSet, boolean indicator, Set expectedPolicy, PolicyNode parentNode) {
        this.validPolicy = policyOID;
        this.qualifiers = qualifierSet;
        this.criticality = indicator;
        this.expectedPolicySet = expectedPolicy;
        this.parent = parentNode;
        this.children = new HashSet();
        this.depth = this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public PolicyNode getParent() {
        return this.parent;
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public int getDepth() {
        return this.depth;
    }

    public String getValidPolicy() {
        return this.validPolicy.toString();
    }

    public Set getPolicyQualifiers() {
        if (this.depth == 0) {
            return new HashSet();
        }
        HashSet<PolicyQualifierInfo> set = new HashSet<PolicyQualifierInfo>();
        Iterator i = this.qualifiers.iterator();
        while (i.hasNext()) {
            set.add((PolicyQualifierInfo)i.next());
        }
        return set;
    }

    public Set getExpectedPolicies() {
        HashSet set = new HashSet(this.expectedPolicySet);
        return (Set)set.clone();
    }

    public boolean isCritical() {
        return this.criticality;
    }

    void addChild(PolicyNode child) {
        this.children.add(child);
    }

    void removeChild(PolicyNode child) {
        this.children.remove(child);
    }

    public boolean match(ObjectIdentifier oid) {
        HashSet set = new HashSet(this.expectedPolicySet);
        for (String p_oid : set) {
            if (!p_oid.equals(oid.toString())) continue;
            return true;
        }
        return false;
    }

    void setExpectedPolicySet(Set newPolicySet) {
        HashSet newset = new HashSet(newPolicySet);
        this.expectedPolicySet = new HashSet();
        this.expectedPolicySet = (HashSet)newset.clone();
    }

    public void print() {
        Iterator it;
        System.out.println("PolicyNodeImpl [");
        System.out.println("    valid policy: " + this.validPolicy.toString());
        System.out.print("    qualifier set: ");
        while ((it = this.qualifiers.iterator()).hasNext()) {
            System.out.print(it.next());
        }
        System.out.println("    criticality: " + this.criticality);
        System.out.print("    expected policy set: " + this.expectedPolicySet.size());
        System.out.println("]");
    }
}

