/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CRLReason;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.Date;

public class CertStatus {
    private int status;
    private Date revocationTime;
    private CRLReason crlReason;
    public static final int GOOD = 0;
    public static final int REVOKED = 1;
    public static final int UNKNOWN = 2;

    public CertStatus(int status, Date revocationTime, CRLReason reason) {
        this.status = status;
        if (this.status == 1) {
            if (revocationTime == null) {
                throw new IllegalArgumentException("Revocation time must be specified");
            }
            this.revocationTime = revocationTime;
            this.crlReason = reason;
        }
    }

    public CertStatus(byte[] encodedData) throws IOException {
        this(new DerValue(encodedData));
    }

    public CertStatus(DerValue der) throws IOException {
        this.status = der.getTag() & 0x1F;
        if (this.status == 1) {
            der.resetTag((byte)48);
            DerValue[] derValues = new DerInputStream(der.toByteArray()).getSequence(2);
            this.revocationTime = derValues[0].getGeneralizedTime();
            if (derValues.length == 2) {
                int reason = derValues[1].getData().getEnumerated().intValue();
                switch (reason) {
                    case 0: {
                        this.crlReason = CRLReason.UNSPECIFIED;
                        break;
                    }
                    case 1: {
                        this.crlReason = CRLReason.KEY_COMPROMISE;
                        break;
                    }
                    case 2: {
                        this.crlReason = CRLReason.CA_COMPROMISE;
                        break;
                    }
                    case 3: {
                        this.crlReason = CRLReason.AFFILIATION_CHANGED;
                        break;
                    }
                    case 4: {
                        this.crlReason = CRLReason.SUPERSEDED;
                        break;
                    }
                    case 5: {
                        this.crlReason = CRLReason.AFFILIATION_CHANGED;
                        break;
                    }
                    case 6: {
                        this.crlReason = CRLReason.CERTIFICATE_HOLD;
                        break;
                    }
                    case 8: {
                        this.crlReason = CRLReason.REMOVE_FROM_CRL;
                        break;
                    }
                    case 9: {
                        this.crlReason = CRLReason.PRIVILEGE_WITHDRAWN;
                        break;
                    }
                    case 10: {
                        this.crlReason = CRLReason.AA_COMPROMISE;
                        break;
                    }
                    default: {
                        throw new IOException("Invalid CRL reason");
                    }
                }
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public Date getRevocationTime() {
        return this.revocationTime;
    }

    public CRLReason getRevocationReason() {
        return this.crlReason;
    }

    public String toString() {
        switch (this.status) {
            case 0: {
                return "CertStatus: good";
            }
            case 1: {
                return "CertStatus: revoked";
            }
            case 2: {
                return "CertStatus: unknown";
            }
        }
        return "CertStatus:";
    }

    public byte[] encode() throws IOException {
        DerOutputStream dos = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        switch (this.status) {
            case 0: {
                dos.putNull();
                temp.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)0), dos);
                break;
            }
            case 1: {
                DerOutputStream temp2 = new DerOutputStream();
                dos.putGeneralizedTime(this.revocationTime);
                DerValue der1 = new DerValue(dos.toByteArray());
                if (this.crlReason != null) {
                    dos = new DerOutputStream();
                    dos.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.crlReason.encode());
                    DerValue der2 = new DerValue(dos.toByteArray());
                    temp2.putSequence(new DerValue[]{der1, der2});
                } else {
                    temp2.putSequence(new DerValue[]{der1});
                }
                temp.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)1), temp2);
                break;
            }
            case 2: {
                dos.putNull();
                temp.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)2), dos);
                break;
            }
            default: {
                throw new IOException("Invalid cert status code");
            }
        }
        return temp.toByteArray();
    }
}

