/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.OCSPException;
import com.ibm.security.cert.ResponderID;
import com.ibm.security.cert.SingleResponse;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class BasicOCSPResponse {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private X509Certificate[] certs = null;
    private X500Name id = null;
    private ResponderID responderid = null;
    private byte[] keyHash = null;
    private int version = 1;
    private String algID = "SHA-1";
    private byte[] sig = null;
    private Date producedAt = null;
    private SingleResponse[] responces = null;
    private Extension[] ext = null;
    private byte[] responseData = null;

    public BasicOCSPResponse(byte[] encodedData) throws IOException {
        DerInputStream dis = new DerInputStream(encodedData);
        DerValue[] ders = dis.getSequence(4);
        if (debug != null) {
            System.out.println("length of sequence: " + ders.length);
        }
        DerValue[] ders1 = new DerInputStream(ders[0].toByteArray()).getSequence(4);
        this.responseData = ders[0].toByteArray();
        this.algID = AlgorithmId.parse((DerValue)ders[1]).getName();
        this.sig = ders[2].getBitString();
        if (ders.length == 4) {
            DerInputStream temp = ders[3].getData();
            DerValue[] values = temp.getSequence(1);
            this.certs = new X509Certificate[values.length];
            for (int j = 0; j < values.length; ++j) {
                try {
                    this.certs[j] = new X509CertImpl(values[j]);
                    continue;
                }
                catch (CertificateException e) {
                    throw new IOException(e.getMessage());
                }
            }
        }
        this.responderid = new ResponderID(ders1[0]);
        this.id = this.responderid.getName();
        this.producedAt = ders1[1].getGeneralizedTime();
        DerValue[] ders2 = new DerInputStream(ders1[2].toByteArray()).getSequence(4);
        SingleResponse[] sr = new SingleResponse[ders2.length];
        for (int i = 0; i < ders2.length; ++i) {
            sr[i] = new SingleResponse(ders2[i]);
        }
        this.responces = sr;
        if (ders1.length == 5) {
            int tag = ders1[4].getTag() & 0x1F;
            switch (tag) {
                case 1: {
                    DerInputStream temp = ders1[4].getData();
                    DerValue[] values = temp.getSequence(2);
                    this.ext = new Extension[values.length];
                    for (int j = 0; j < values.length; ++j) {
                        this.ext[j] = new Extension(values[j]);
                    }
                    break;
                }
            }
        }
    }

    public BasicOCSPResponse(SingleResponse[] sr, String algID, byte[] signature, String name) {
        this.algID = algID;
        this.sig = signature;
        this.version = 1;
        this.responces = sr;
        this.producedAt = new Date();
        try {
            this.responderid = new ResponderID(name);
            this.id = this.responderid.getName();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BasicOCSPResponse(DerValue der) throws IOException {
        this(der.toByteArray());
    }

    public byte[] encode() throws IOException {
        ArrayList<DerValue> alist = new ArrayList<DerValue>();
        DerOutputStream out = new DerOutputStream();
        DerOutputStream respData = new DerOutputStream();
        respData.putInteger(this.version);
        DerValue der0 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), respData.toByteArray());
        alist.add(der0);
        alist.add(new DerValue(this.responderid.encode()));
        respData = new DerOutputStream();
        respData.putGeneralizedTime(this.producedAt);
        alist.add(new DerValue(respData.toByteArray()));
        DerValue[] ders = new DerValue[this.responces.length];
        for (int i = 0; i < this.responces.length; ++i) {
            respData = new DerOutputStream();
            respData.write(this.responces[i].encode());
            ders[i] = new DerValue(respData.toByteArray());
        }
        respData = new DerOutputStream();
        respData.putSequence(ders);
        this.responseData = respData.toByteArray();
        DerValue der4 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), respData.toByteArray());
        alist.add(der4);
        DerOutputStream out2 = new DerOutputStream();
        if (this.ext != null && this.ext.length != 0) {
            for (int i = 0; i < this.ext.length; ++i) {
                this.ext[i].encode(out2);
            }
        }
        DerValue der3 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), out2.toByteArray());
        alist.add(new DerValue(der3.toByteArray()));
        DerValue[] values = new DerValue[alist.size()];
        alist.toArray(values);
        respData = new DerOutputStream();
        respData.putSequence(values);
        alist.clear();
        der3 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), respData.toByteArray());
        alist.add(new DerValue(der3.toByteArray()));
        DerValue dval = null;
        try {
            dval = new DerValue(AlgorithmId.get((String)this.algID).encode());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        alist.add(new DerValue(dval.toByteArray()));
        respData = new DerOutputStream();
        respData.putBitString(this.sig);
        alist.add(new DerValue(respData.toByteArray()));
        if (this.certs != null) {
            out2 = new DerOutputStream();
            for (int i = 0; i < this.certs.length; ++i) {
                X509CertImpl c = (X509CertImpl)this.certs[i];
                try {
                    c.encode((OutputStream)out2);
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new IOException(e.getMessage());
                }
            }
            der3 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), out2.toByteArray());
            alist.add(new DerValue(der3.toByteArray()));
        }
        values = new DerValue[alist.size()];
        alist.toArray(values);
        respData = new DerOutputStream();
        respData.putSequence(values);
        return respData.toByteArray();
    }

    public X509Certificate[] getCertChain() {
        return this.certs;
    }

    public ResponderID getResponderID() {
        return this.responderid;
    }

    public Date getProducedTime() {
        return this.producedAt;
    }

    public SingleResponse[] getSingleResponses() {
        return this.responces;
    }

    public SingleResponse getSingleResponse(CertID id) {
        for (int i = 0; i < this.responces.length; ++i) {
            if (!id.equals(this.responces[i].getCertID())) continue;
            return this.responces[i];
        }
        return null;
    }

    public Extension[] getExtensions() {
        return this.ext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verify(Set trustAnchors) throws OCSPException {
        String classname = this.getClass().getName();
        ObjectIdentifier idpix = null;
        try {
            idpix = new ObjectIdentifier("1.3.6.1.5.5.7.3.9");
        }
        catch (IOException e) {
            throw new OCSPException(e.getMessage());
        }
        if (this.certs == null) {
            try {
                TrustAnchor ta = this.getResponderTA(trustAnchors);
                PublicKey key = ta.getTrustedCert().getPublicKey();
                if (debug != null) {
                    System.out.println("[" + classname + "]" + ":" + key.toString());
                }
                X509Certificate cert = ta.getTrustedCert();
                if (debug != null) {
                    System.out.println("[" + classname + "]" + ":" + cert.toString());
                    System.out.println("[" + classname + "]" + ":" + cert.getPublicKey().toString());
                }
                Signature sign = Signature.getInstance(this.algID);
                sign.initVerify(key);
                sign.update(this.responseData);
                boolean isGood = sign.verify(this.sig);
                if (!isGood) {
                    if (debug == null) throw new OCSPException("verify signature failed");
                    System.out.println("[" + classname + "] : verify signature failed");
                    throw new OCSPException("verify signature failed");
                }
                if (debug == null) return;
                System.out.println("[" + classname + "] : verify signature passwd");
                return;
            }
            catch (NoSuchAlgorithmException e) {
                throw new OCSPException(e.getMessage());
            }
            catch (SignatureException e) {
                throw new OCSPException(e.getMessage());
            }
            catch (InvalidKeyException e) {
                throw new OCSPException(e.getMessage());
            }
        }
        if (debug != null) {
            System.out.println("[" + classname + "]: cert chain length: " + this.certs.length);
            for (int i = 0; i < this.certs.length; ++i) {
                System.out.println("[" + classname + "]" + this.certs[i]);
            }
        }
        boolean hasCert = false;
        try {
            for (int i = 0; i < this.certs.length; ++i) {
                Iterator iter;
                X509CertImpl c = (X509CertImpl)this.certs[i];
                List ls = c.getExtendedKeyUsage();
                if (ls == null || (iter = ls.iterator()) == null) continue;
                while (iter.hasNext()) {
                    String eku = (String)iter.next();
                    if (!eku.equals("1.3.6.1.5.5.7.3.9")) continue;
                    hasCert = true;
                    if (debug == null) break;
                    System.out.println("[" + classname + "]: found responder cert");
                    break;
                }
                if (!hasCert) continue;
                PublicKey key = this.certs[i].getPublicKey();
                Signature sign = Signature.getInstance(this.algID);
                sign.initVerify(key);
                sign.update(this.responseData);
                boolean isGood = sign.verify(this.sig);
                if (!isGood) {
                    if (debug == null) throw new OCSPException("verify signature failed");
                    System.out.println("[" + classname + "]: verify signature failed");
                    throw new OCSPException("verify signature failed");
                }
                if (debug == null) return;
                System.out.println("[" + classname + "]: signature verify");
                return;
            }
            if (hasCert) return;
            TrustAnchor ta = this.getResponderTA(trustAnchors);
            X509Certificate cert = ta.getTrustedCert();
            if (cert != null) {
                for (int i = 0; i < this.certs.length; ++i) {
                    if (!this.certs[i].equals(cert)) continue;
                    if (debug == null) return;
                    System.out.println("found the signer cert match the trusted cert");
                    return;
                }
            } else {
                PublicKey pkey = ta.getCAPublicKey();
                String caName = ta.getCAName();
                for (int i = 0; i < this.certs.length; ++i) {
                    if (!this.certs[i].getSubjectX500Principal().getName("RFC2253").equals(caName) || !this.certs[i].getPublicKey().equals(pkey)) continue;
                    return;
                }
            }
            if (debug == null) throw new OCSPException("missing certificate to verify signature");
            System.out.println("[" + classname + "]: missing certificate. Not able to verify signature");
            throw new OCSPException("missing certificate to verify signature");
        }
        catch (NoSuchAlgorithmException e) {
            throw new OCSPException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new OCSPException(e.getMessage());
        }
        catch (SignatureException e) {
            throw new OCSPException(e.getMessage());
        }
        catch (CertificateParsingException e) {
            throw new OCSPException(e.getMessage());
        }
    }

    private TrustAnchor getResponderTA(Set trustAnchors) {
        X500Name respName = this.id;
        if (respName != null) {
            for (TrustAnchor ta : trustAnchors) {
                if (!(ta.getCAName() != null ? ta.getCAName().equals(respName.getRFC2253Name()) : ta.getTrustedCert() != null)) continue;
                return ta;
            }
        } else {
            byte[] keyhash = this.responderid.getKeyHash();
            for (TrustAnchor ta : trustAnchors) {
                byte[] keydata = ta.getCAPublicKey().getEncoded();
                MessageDigest sha1 = null;
                byte[] keyhash2 = new byte[20];
                try {
                    sha1 = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException ex) {
                    return null;
                }
                sha1.update(keydata);
                keyhash2 = sha1.digest();
                if (!Arrays.equals(keyhash, keyhash2)) continue;
                return ta;
            }
        }
        return null;
    }
}

