/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.robot;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Properties;
import java.util.Vector;

class ScreenCaptureProducer
implements ImageProducer {
    Rectangle captureRect;
    Vector consumers = new Vector();
    int[] pixels;

    ScreenCaptureProducer(int[] nArray, Rectangle rectangle) {
        this.captureRect = new Rectangle(rectangle.width, rectangle.height);
        this.pixels = nArray;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.consumers.addElement(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (!this.isConsumer(imageConsumer)) {
            this.addConsumer(imageConsumer);
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        imageConsumer.setDimensions(this.captureRect.width, this.captureRect.height);
        imageConsumer.setColorModel(colorModel);
        imageConsumer.setHints(24);
        Properties properties = new Properties();
        properties.setProperty("producer", ScreenCaptureProducer.class.getName());
        imageConsumer.setProperties(properties);
        imageConsumer.setPixels(0, 0, this.captureRect.width, this.captureRect.height, colorModel, this.pixels, 0, this.captureRect.width);
        imageConsumer.imageComplete(3);
        this.consumers.removeElement(imageConsumer);
    }
}

