/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.Hashtable;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.RasterListener;
import sun.awt.image.SunWritableRaster;
import sun.awt.image.SurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.security.action.GetPropertyAction;

public abstract class CachingSurfaceManager
extends SurfaceManager
implements RasterListener {
    protected BufferedImage bImg;
    protected SurfaceData sdDefault;
    protected SurfaceData sdAccel;
    protected Hashtable accelSurfaces;
    protected boolean localAccelerationEnabled = false;
    protected static boolean accelerationEnabled;
    protected static boolean allowRasterSteal;
    protected static int accelerationThreshold;

    public CachingSurfaceManager(BufferedImage bufferedImage) {
        WritableRaster writableRaster;
        this.bImg = bufferedImage;
        this.sdDefault = BufImgSurfaceData.createData(bufferedImage);
        if (accelerationEnabled && (writableRaster = bufferedImage.getRaster()) instanceof SunWritableRaster) {
            this.localAccelerationEnabled = true;
            ((SunWritableRaster)writableRaster).setRasterListener(this);
            if (this.localAccelerationEnabled) {
                this.accelSurfaces = new Hashtable();
            }
        }
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        if (this.localAccelerationEnabled && surfaceData != this.sdAccel && this.isDestSurfaceAccelerated(surfaceData) && this.isOperationSupported(surfaceData, compositeType, color, bl) && this.sdDefault.increaseNumCopies() > accelerationThreshold) {
            this.validate(surfaceData.getDeviceConfiguration());
            if (this.sdAccel != null && !this.sdAccel.isSurfaceLost()) {
                return this.sdAccel;
            }
        }
        return this.sdDefault;
    }

    public SurfaceData getDestSurfaceData() {
        return this.sdDefault;
    }

    protected abstract boolean isDestSurfaceAccelerated(SurfaceData var1);

    protected boolean isValidAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.getAccelSurface(graphicsConfiguration) != null;
    }

    protected abstract SurfaceData getAccelSurface(GraphicsConfiguration var1);

    protected abstract boolean isOperationSupported(SurfaceData var1, CompositeType var2, Color var3, boolean var4);

    protected abstract void initAcceleratedSurface(GraphicsConfiguration var1, int var2, int var3);

    protected Color getTransparentPixelColor() {
        return null;
    }

    protected void copyDefaultToAccelerated() {
        block5: {
            try {
                if (this.sdAccel != null && !this.sdAccel.isSurfaceLost()) {
                    SurfaceType surfaceType = this.sdDefault.getSurfaceType();
                    SurfaceType surfaceType2 = this.sdAccel.getSurfaceType();
                    Color color = this.getTransparentPixelColor();
                    if (color == null) {
                        Blit blit = Blit.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
                        blit.Blit(this.sdDefault, this.sdAccel, AlphaComposite.Src, null, 0, 0, 0, 0, this.bImg.getWidth(), this.bImg.getHeight());
                    } else {
                        BlitBg blitBg = BlitBg.getFromCache(surfaceType, CompositeType.SrcNoEa, surfaceType2);
                        blitBg.BlitBg(this.sdDefault, this.sdAccel, AlphaComposite.SrcOver, null, color, 0, 0, 0, 0, this.bImg.getWidth(), this.bImg.getHeight());
                    }
                    this.sdDefault.setNeedsBackup(false);
                }
            }
            catch (Exception exception) {
                if (this.sdAccel == null) break block5;
                this.sdAccel.setSurfaceLost(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(GraphicsConfiguration graphicsConfiguration) {
        if (!this.localAccelerationEnabled) return;
        boolean bl = false;
        this.sdAccel = this.getAccelSurface(graphicsConfiguration);
        if (this.sdAccel == null) {
            this.initAcceleratedSurface(graphicsConfiguration, this.bImg.getWidth(), this.bImg.getHeight());
            if (this.sdAccel == null) return;
            bl = true;
        } else if (this.sdAccel.isSurfaceLost()) {
            try {
                this.restoreAcceleratedSurface();
                bl = true;
                this.sdAccel.setSurfaceLost(false);
            }
            catch (InvalidPipeException invalidPipeException) {
                this.flush();
                return;
            }
        }
        if (!this.sdDefault.needsBackup() && !bl) return;
        this.copyDefaultToAccelerated();
    }

    public void rasterChanged() {
        this.sdDefault.setNeedsBackup(true);
    }

    public void rasterStolen() {
        if (!allowRasterSteal) {
            this.localAccelerationEnabled = false;
        }
    }

    public SurfaceData restoreContents() {
        return this.sdDefault;
    }

    protected void restoreAcceleratedSurface() {
    }

    public ImageCapabilities getCapabilities(GraphicsConfiguration graphicsConfiguration) {
        return new ImageCapabilitiesGc(graphicsConfiguration);
    }

    static {
        String string;
        String string2;
        accelerationEnabled = true;
        allowRasterSteal = false;
        accelerationThreshold = 1;
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.managedimages"));
        if (string3 != null && string3.equals("false")) {
            accelerationEnabled = false;
            System.out.println("Disabling managed images");
        }
        if ((string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.accthreshold"))) != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0) {
                    accelerationThreshold = n;
                    System.out.println("New Acceleration Threshold: " + accelerationThreshold);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error setting new threshold:" + numberFormatException);
            }
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.allowrastersteal"))) != null && string.equals("true")) {
            allowRasterSteal = true;
            System.out.println("Raster steal allowed");
        }
    }

    class ImageCapabilitiesGc
    extends ImageCapabilities {
        GraphicsConfiguration gc;

        public ImageCapabilitiesGc(GraphicsConfiguration graphicsConfiguration) {
            super(false);
            this.gc = graphicsConfiguration;
        }

        public boolean isAccelerated() {
            GraphicsConfiguration graphicsConfiguration = this.gc;
            if (graphicsConfiguration == null) {
                graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            return CachingSurfaceManager.this.isValidAccelSurface(graphicsConfiguration);
        }
    }
}

