/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class MetalRadioButtonUI
extends BasicRadioButtonUI {
    private static final MetalRadioButtonUI metalRadioButtonUI = new MetalRadioButtonUI();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalRadioButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaults_initialized = true;
        }
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Dimension dimension = jComponent.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        Rectangle rectangle = new Rectangle(dimension);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Insets insets = jComponent.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        Icon icon = abstractButton.getIcon();
        Object var15_15 = null;
        Object var16_16 = null;
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (icon != null) {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        } else {
            this.getDefaultIcon().paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                int n3 = abstractButton.getDisplayedMnemonicIndex();
                if (buttonModel.isEnabled()) {
                    graphics.setColor(abstractButton.getForeground());
                } else {
                    graphics.setColor(this.getDisabledTextColor());
                }
                SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n3, rectangle3.x, rectangle3.y + fontMetrics.getAscent());
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && rectangle3.width > 0 && rectangle3.height > 0) {
                this.paintFocus(graphics, rectangle3, dimension);
            }
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
    }
}

