/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.StringReader;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;

public class BasicHTML {
    private static final String htmlDisable = "html.disable";
    public static final String propertyKey = "html";
    public static final String documentBaseKey = "html.base";
    private static BasicEditorKit basicHTMLFactory;
    private static ViewFactory basicHTMLViewFactory;
    private static final String styleChanges = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }";

    public static View createHTMLView(JComponent jComponent, String string) {
        BasicEditorKit basicEditorKit = BasicHTML.getFactory();
        Document document = basicEditorKit.createDefaultDocument(jComponent.getFont(), jComponent.getForeground());
        Object object = jComponent.getClientProperty(documentBaseKey);
        if (object instanceof URL) {
            ((HTMLDocument)document).setBase((URL)object);
        }
        StringReader stringReader = new StringReader(string);
        try {
            basicEditorKit.read(stringReader, document, 0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ViewFactory viewFactory = basicEditorKit.getViewFactory();
        View view = viewFactory.create(document.getDefaultRootElement());
        Renderer renderer = new Renderer(jComponent, viewFactory, view);
        return renderer;
    }

    public static boolean isHTMLString(String string) {
        if (string != null && string.length() >= 6 && string.charAt(0) == '<' && string.charAt(5) == '>') {
            String string2 = string.substring(1, 5);
            return string2.equalsIgnoreCase(propertyKey);
        }
        return false;
    }

    public static void updateRenderer(JComponent jComponent, String string) {
        View view = null;
        View view2 = (View)jComponent.getClientProperty(propertyKey);
        Boolean bl = (Boolean)jComponent.getClientProperty(htmlDisable);
        if (bl != Boolean.TRUE && BasicHTML.isHTMLString(string)) {
            view = BasicHTML.createHTMLView(jComponent, string);
        }
        if (view != view2 && view2 != null) {
            for (int i = 0; i < view2.getViewCount(); ++i) {
                view2.getView(i).setParent(null);
            }
        }
        jComponent.putClientProperty(propertyKey, view);
    }

    static BasicEditorKit getFactory() {
        if (basicHTMLFactory == null) {
            basicHTMLViewFactory = new BasicHTMLViewFactory();
            basicHTMLFactory = new BasicEditorKit();
        }
        return basicHTMLFactory;
    }

    static class Renderer
    extends View {
        private int width;
        private View view;
        private ViewFactory factory;
        private JComponent host;

        Renderer(JComponent jComponent, ViewFactory viewFactory, View view) {
            super(null);
            this.host = jComponent;
            this.factory = viewFactory;
            this.view = view;
            this.view.setParent(this);
            this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n) {
            if (n == 0) {
                return this.width;
            }
            return this.view.getPreferredSpan(n);
        }

        public float getMinimumSpan(int n) {
            return this.view.getMinimumSpan(n);
        }

        public float getMaximumSpan(int n) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            this.host.revalidate();
            this.host.repaint();
        }

        public float getAlignment(int n) {
            return this.view.getAlignment(n);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            this.view.setSize(rectangle.width, rectangle.height);
            this.view.paint(graphics, shape);
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            return this.view.modelToView(n, bias, n2, bias2, shape);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        public Document getDocument() {
            return this.view.getDocument();
        }

        public int getStartOffset() {
            return this.view.getStartOffset();
        }

        public int getEndOffset() {
            return this.view.getEndOffset();
        }

        public Element getElement() {
            return this.view.getElement();
        }

        public void setSize(float f, float f2) {
            this.width = (int)f;
            this.view.setSize(f, f2);
        }

        public Container getContainer() {
            return this.host;
        }

        public ViewFactory getViewFactory() {
            return this.factory;
        }
    }

    static class BasicDocument
    extends HTMLDocument {
        BasicDocument(StyleSheet styleSheet, Font font, Color color) {
            super(styleSheet);
            this.setPreservesUnknownTags(false);
            this.setFontAndColor(font, color);
        }

        private void setFontAndColor(Font font, Color color) {
            this.getStyleSheet().addRule(SwingUtilities2.displayPropertiesToCSS(font, color));
        }
    }

    static class BasicHTMLViewFactory
    extends HTMLEditorKit.HTMLFactory {
        BasicHTMLViewFactory() {
        }

        public View create(Element element) {
            View view = super.create(element);
            if (view instanceof ImageView) {
                ((ImageView)view).setLoadsSynchronously(true);
            }
            return view;
        }
    }

    static class BasicEditorKit
    extends HTMLEditorKit {
        private static StyleSheet defaultStyles;

        BasicEditorKit() {
        }

        public StyleSheet getStyleSheet() {
            if (defaultStyles == null) {
                defaultStyles = new StyleSheet();
                StringReader stringReader = new StringReader(BasicHTML.styleChanges);
                try {
                    defaultStyles.loadRules(stringReader, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                stringReader.close();
                defaultStyles.addStyleSheet(super.getStyleSheet());
            }
            return defaultStyles;
        }

        public Document createDefaultDocument(Font font, Color color) {
            StyleSheet styleSheet = this.getStyleSheet();
            StyleSheet styleSheet2 = new StyleSheet();
            styleSheet2.addStyleSheet(styleSheet);
            BasicDocument basicDocument = new BasicDocument(styleSheet2, font, color);
            basicDocument.setAsynchronousLoadPriority(Integer.MAX_VALUE);
            basicDocument.setPreservesUnknownTags(false);
            return basicDocument;
        }

        public ViewFactory getViewFactory() {
            return basicHTMLViewFactory;
        }
    }
}

